/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.JAXBException;
import java.util.StringTokenizer;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.BindingTraverserXSLT;
import org.docx4j.model.datastorage.ValueInserterPlainText;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.relationships.ObjectFactory;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class ValueInserterPlainTextImpl
implements ValueInserterPlainText {
    private static Logger log = LoggerFactory.getLogger(ValueInserterPlainTextImpl.class);

    @Override
    public DocumentFragment toOpenXml(Xpaths.Xpath.DataBinding dataBinding, RPr rPr, boolean multiLine, BindingTraverserXSLT.BookmarkCounter bookmarkCounter, String val, JaxbXmlPart sourcePart) throws Docx4JException {
        try {
            if (val == null || val.equals("")) {
                return BindingTraverserXSLT.createPlaceholder(rPr, "p");
            }
        }
        catch (Exception e) {
            throw new Docx4JException(e.getMessage(), e);
        }
        Document docContainer = XmlUtils.neww3cDomDocument();
        DocumentFragment docfrag = docContainer.createDocumentFragment();
        StringTokenizer st = new StringTokenizer(val, "\n\r\f");
        if (multiLine) {
            boolean firsttoken = true;
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (firsttoken) {
                    firsttoken = false;
                } else {
                    this.addBrRunToDocFrag(docfrag, rPr);
                }
                this.processString(sourcePart, docfrag, line, rPr);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            while (st.hasMoreTokens()) {
                sb.append(st.nextToken());
            }
            this.processString(sourcePart, docfrag, sb.toString(), rPr);
        }
        return docfrag;
    }

    protected void addBrRunToDocFrag(DocumentFragment docfrag, RPr rPr) throws Docx4JException {
        R run = Context.getWmlObjectFactory().createR();
        if (rPr != null) {
            run.setRPr(rPr);
        }
        run.getRunContent().add(Context.getWmlObjectFactory().createBr());
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(run);
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
    }

    protected void processString(JaxbXmlPart sourcePart, DocumentFragment docfrag, String text, RPr rPr) throws Docx4JException {
        int pos = BindingHandler.getHyperlinkResolver().getIndexOfURL(text);
        if (pos == -1) {
            this.addRunToDocFrag(sourcePart, docfrag, text, rPr);
            return;
        }
        if (BindingHandler.getHyperlinkResolver().getHyperlinkStyleId() == null) {
            log.warn("No Hyperlink style set, not linking");
            this.addRunToDocFrag(sourcePart, docfrag, text, rPr);
            return;
        }
        if (pos == 0) {
            int spacePos = text.indexOf(" ");
            if (spacePos == -1) {
                this.addHyperlinkToDocFrag(sourcePart, docfrag, text);
                return;
            }
            String first = text.substring(0, spacePos);
            String rest = text.substring(spacePos);
            this.addHyperlinkToDocFrag(sourcePart, docfrag, first);
            this.processString(sourcePart, docfrag, rest, rPr);
            return;
        }
        String first = text.substring(0, pos);
        String rest = text.substring(pos);
        this.addRunToDocFrag(sourcePart, docfrag, first, rPr);
        this.processString(sourcePart, docfrag, rest, rPr);
    }

    private void addRunToDocFrag(JaxbXmlPart sourcePart, DocumentFragment docfrag, String string, RPr rPr) {
        R run = Context.getWmlObjectFactory().createR();
        if (rPr != null) {
            run.setRPr(rPr);
        }
        Text text = Context.getWmlObjectFactory().createText();
        run.getRunContent().add(text);
        if (string.startsWith(" ") || string.endsWith(" ")) {
            log.debug("setting xml:space=preserve for '" + string + "'");
            text.setSpace("preserve");
        }
        text.setValue(string);
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(run);
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
    }

    protected void addHyperlinkToDocFrag(JaxbXmlPart sourcePart, DocumentFragment docfrag, String url) throws Docx4JException {
        ObjectFactory factory = new ObjectFactory();
        Relationship rel = factory.createRelationship();
        rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
        rel.setTarget(url);
        rel.setTargetMode("External");
        sourcePart.getRelationshipsPart().addRelationship(rel);
        try {
            Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(BindingHandler.getHyperlinkResolver().generateHyperlink(rel.getId(), url));
            XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
        }
        catch (JAXBException e) {
            throw new Docx4JException(e.getMessage(), e);
        }
    }
}

