/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.styles;

import jakarta.xml.bind.JAXBException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.Tree;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.wml.DocDefaults;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleTree {
    private static Logger log = LoggerFactory.getLogger(StyleTree.class);
    private Tree<AugmentedStyle> tableTree = new Tree();
    private Tree<AugmentedStyle> pTree = new Tree();
    private Tree<AugmentedStyle> cTree = new Tree();
    String ROOT_NAME = "DocDefaults";
    Style styleDocDefaults;

    public Tree<AugmentedStyle> getTableStylesTree() {
        return this.tableTree;
    }

    public Tree<AugmentedStyle> getParagraphStylesTree() {
        return this.pTree;
    }

    public Tree<AugmentedStyle> getCharacterStylesTree() {
        return this.cTree;
    }

    private StyleTree() {
    }

    public StyleTree(Set<String> stylesInUse, Map<String, Style> allStyles, DocDefaults docDefaults, Style normal) {
        this.init(stylesInUse, allStyles, docDefaults, normal, null, null);
    }

    public StyleTree(Set<String> stylesInUse, Map<String, Style> allStyles, DocDefaults docDefaults, Style normal, Style defaultCharStyle, Style defaultTableStyle) {
        this.init(stylesInUse, allStyles, docDefaults, normal, defaultCharStyle, defaultTableStyle);
    }

    public void init(Set<String> stylesInUse, Map<String, Style> allStyles, DocDefaults docDefaults, Style normal, Style defaultCharStyle, Style defaultTableStyle) {
        Style style;
        Object as;
        if (defaultTableStyle == null) {
            this.tableTree.setRootElement(new Node<Object>(this.tableTree, "table-root", null));
        } else {
            AugmentedStyle as2 = new AugmentedStyle(defaultTableStyle);
            this.tableTree.setRootElement(new Node<Object>(this.tableTree, "table-root", as2));
        }
        for (String styleId : stylesInUse) {
            if (this.tableTree.get(styleId) != null) continue;
            Style style2 = allStyles.get(styleId);
            if (style2 == null) {
                log.warn("Couldn't find style: " + styleId);
                continue;
            }
            if (style2.getType() == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn("missing type: " + XmlUtils.marshaltoString(style2));
                continue;
            }
            if (!style2.getType().equals("table")) continue;
            this.addNode(styleId, allStyles, this.tableTree);
        }
        try {
            this.createVirtualStylesForDocDefaults(docDefaults, normal);
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), e);
            return;
        }
        Style rootStyle = this.styleDocDefaults;
        if (rootStyle == null) {
            this.pTree.setRootElement(new Node<Object>(this.pTree, "p-root", null));
        } else {
            as = new AugmentedStyle(rootStyle);
            this.pTree.setRootElement(new Node<Object>(this.pTree, this.ROOT_NAME, as));
        }
        for (String styleId : stylesInUse) {
            if (this.pTree.get(styleId) == null) {
                style = allStyles.get(styleId);
                if (style == null) {
                    log.warn("Couldn't find style: " + styleId);
                    continue;
                }
                if (style.getType() == null || !style.getType().equals("paragraph")) continue;
                log.debug("Adding '" + styleId + "' to paragraph tree");
                this.addNode(styleId, allStyles, this.pTree);
                continue;
            }
            log.debug(styleId + " is already in paragraph tree");
        }
        if (defaultCharStyle == null) {
            this.cTree.setRootElement(new Node<Object>(this.cTree, "c-root", null));
        } else {
            as = new AugmentedStyle(defaultCharStyle);
            this.cTree.setRootElement(new Node<Object>(this.cTree, "c-root", as));
        }
        for (String styleId : stylesInUse) {
            if (this.cTree.get(styleId) == null) {
                style = allStyles.get(styleId);
                if (style == null) {
                    log.warn("Couldn't find style: " + styleId);
                    continue;
                }
                if (style.getType() == null || !style.getType().equals("character")) continue;
                this.addNode(styleId, allStyles, this.cTree);
                continue;
            }
            log.debug(styleId + " is already in character tree");
        }
    }

    private Node<AugmentedStyle> addNode(String styleId, Map<String, Style> allStyles, Tree<AugmentedStyle> tree) {
        log.debug(styleId);
        Style style = allStyles.get(styleId);
        if (style == null) {
            log.error("Couldn't find style: " + styleId);
            return null;
        }
        if (style.getBasedOn() == null) {
            Style clonedStyle = XmlUtils.deepCopy(style);
            Style.BasedOn based = Context.getWmlObjectFactory().createStyleBasedOn();
            based.setVal(this.ROOT_NAME);
            clonedStyle.setBasedOn(based);
            AugmentedStyle as = new AugmentedStyle(clonedStyle);
            Node<AugmentedStyle> n = new Node<AugmentedStyle>(tree, styleId, as);
            log.debug("Style " + styleId + " is not based on anything.");
            tree.getRootElement().addChild(n);
            return n;
        }
        if (style.getBasedOn().getVal() != null) {
            AugmentedStyle as = new AugmentedStyle(style);
            Node<AugmentedStyle> n = new Node<AugmentedStyle>(tree, styleId, as);
            String basedOnStyleName = style.getBasedOn().getVal();
            log.debug("..based on " + basedOnStyleName);
            if (tree.get(basedOnStyleName) == null) {
                Node<AugmentedStyle> parent = this.addNode(basedOnStyleName, allStyles, tree);
                if (parent != null) {
                    parent.addChild(n);
                }
            } else {
                tree.get(basedOnStyleName).addChild(n);
            }
            return n;
        }
        log.error("No basedOn set for: " + style.getStyleId());
        return null;
    }

    public static String getHtmlClassAttributeValue(Tree<AugmentedStyle> tree, Node<AugmentedStyle> n) {
        if (n == null) {
            log.error("Null node passed");
            return null;
        }
        List<Node<AugmentedStyle>> classVals = tree.climb(n);
        StringBuffer sb = new StringBuffer();
        for (Node<AugmentedStyle> valNode : classVals) {
            if (valNode.getData() == null) continue;
            sb.append(valNode.name + " ");
        }
        return sb.toString();
    }

    private void createVirtualStylesForDocDefaults(DocDefaults docDefaults, Style normal) throws Docx4JException {
        RPr documentDefaultRPr;
        PPr documentDefaultPPr;
        if (this.styleDocDefaults != null) {
            return;
        }
        this.styleDocDefaults = Context.getWmlObjectFactory().createStyle();
        this.styleDocDefaults.setStyleId(this.ROOT_NAME);
        this.styleDocDefaults.setType("paragraph");
        Style.Name n = Context.getWmlObjectFactory().createStyleName();
        n.setVal(this.ROOT_NAME);
        this.styleDocDefaults.setName(n);
        if (docDefaults == null) {
            log.info("No DocDefaults present");
            try {
                docDefaults = (DocDefaults)XmlUtils.unmarshalString("<w:docDefaults xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:rPrDefault><w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"20\" /><w:szCs w:val=\"20\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr></w:rPrDefault><w:pPrDefault><w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr></w:pPrDefault></w:docDefaults>");
            }
            catch (JAXBException e) {
                throw new Docx4JException("Problem unmarshalling <w:docDefaults xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:rPrDefault><w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"20\" /><w:szCs w:val=\"20\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr></w:rPrDefault><w:pPrDefault><w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr></w:pPrDefault></w:docDefaults>", e);
            }
        }
        if (docDefaults.getPPrDefault() == null) {
            log.info("No PPrDefault present");
            try {
                documentDefaultPPr = (PPr)XmlUtils.unmarshalString("<w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr>");
            }
            catch (JAXBException e) {
                throw new Docx4JException("Problem unmarshalling <w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr>", e);
            }
        } else {
            documentDefaultPPr = docDefaults.getPPrDefault().getPPr();
            if (documentDefaultPPr == null) {
                documentDefaultPPr = Context.getWmlObjectFactory().createPPr();
            }
        }
        if (documentDefaultPPr.getSpacing() == null) {
            PPrBase.Spacing spacing = Context.getWmlObjectFactory().createPPrBaseSpacing();
            documentDefaultPPr.setSpacing(spacing);
            spacing.setBefore(BigInteger.ZERO);
            spacing.setAfter(BigInteger.ZERO);
            spacing.setLine(BigInteger.valueOf(240L));
        }
        if (docDefaults.getRPrDefault() == null) {
            log.info("No RPrDefault present");
            try {
                documentDefaultRPr = (RPr)XmlUtils.unmarshalString("<w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"20\" /><w:szCs w:val=\"20\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr>");
            }
            catch (JAXBException e) {
                throw new Docx4JException("Problem unmarshalling <w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"20\" /><w:szCs w:val=\"20\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr>", e);
            }
        } else {
            HpsMeasure s10pt;
            documentDefaultRPr = docDefaults.getRPrDefault().getRPr();
            if (documentDefaultRPr == null) {
                documentDefaultRPr = Context.getWmlObjectFactory().createRPr();
            }
            if (documentDefaultRPr.getSz() == null) {
                s10pt = Context.getWmlObjectFactory().createHpsMeasure();
                s10pt.setVal(BigInteger.valueOf(20L));
                documentDefaultRPr.setSz(s10pt);
            }
            if (documentDefaultRPr.getSzCs() == null) {
                s10pt = Context.getWmlObjectFactory().createHpsMeasure();
                s10pt.setVal(BigInteger.valueOf(20L));
                documentDefaultRPr.setSzCs(s10pt);
            }
        }
        this.styleDocDefaults.setPPr(documentDefaultPPr);
        this.styleDocDefaults.setRPr(documentDefaultRPr);
        if (normal == null) {
            log.info("No default paragraph style!!");
            normal = Context.getWmlObjectFactory().createStyle();
            normal.setType("paragraph");
            normal.setStyleId("Normal");
            n = Context.getWmlObjectFactory().createStyleName();
            n.setVal("Normal");
            normal.setName(n);
            normal.setDefault(Boolean.TRUE);
        }
        if (log.isDebugEnabled()) {
            log.debug("Set virtual style, id '" + this.styleDocDefaults.getStyleId() + "', name '" + this.styleDocDefaults.getName().getVal() + "'");
            log.debug(XmlUtils.marshaltoString((Object)this.styleDocDefaults, true, true));
        }
    }

    public class AugmentedStyle {
        private Style s;

        public AugmentedStyle(Style s2) {
            this.s = s2;
        }

        public Style getStyle() {
            return this.s;
        }
    }
}

