/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class Stats {
    public static final String ANTLRWORKS_DIR = "antlrworks";

    public static double stddev(int[] X) {
        int m4 = X.length;
        if (m4 <= 1) {
            return 0.0;
        }
        double xbar = Stats.avg(X);
        double s2 = 0.0;
        for (int i = 0; i < m4; ++i) {
            s2 += ((double)X[i] - xbar) * ((double)X[i] - xbar);
        }
        return Math.sqrt(s2 /= (double)(m4 - 1));
    }

    public static double avg(int[] X) {
        double xbar = 0.0;
        int m4 = X.length;
        if (m4 == 0) {
            return 0.0;
        }
        for (int i = 0; i < m4; ++i) {
            xbar += (double)X[i];
        }
        if (xbar >= 0.0) {
            return xbar / (double)m4;
        }
        return 0.0;
    }

    public static int min(int[] X) {
        int min2 = Integer.MAX_VALUE;
        int m4 = X.length;
        if (m4 == 0) {
            return 0;
        }
        for (int i = 0; i < m4; ++i) {
            if (X[i] >= min2) continue;
            min2 = X[i];
        }
        return min2;
    }

    public static int max(int[] X) {
        int max = Integer.MIN_VALUE;
        int m4 = X.length;
        if (m4 == 0) {
            return 0;
        }
        for (int i = 0; i < m4; ++i) {
            if (X[i] <= max) continue;
            max = X[i];
        }
        return max;
    }

    public static double avg(List<Integer> X) {
        double xbar = 0.0;
        int m4 = X.size();
        if (m4 == 0) {
            return 0.0;
        }
        for (int i = 0; i < m4; ++i) {
            xbar += (double)X.get(i).intValue();
        }
        if (xbar >= 0.0) {
            return xbar / (double)m4;
        }
        return 0.0;
    }

    public static int min(List<Integer> X) {
        int min2 = Integer.MAX_VALUE;
        int m4 = X.size();
        if (m4 == 0) {
            return 0;
        }
        for (int i = 0; i < m4; ++i) {
            if (X.get(i) >= min2) continue;
            min2 = X.get(i);
        }
        return min2;
    }

    public static int max(List<Integer> X) {
        int max = Integer.MIN_VALUE;
        int m4 = X.size();
        if (m4 == 0) {
            return 0;
        }
        for (int i = 0; i < m4; ++i) {
            if (X.get(i) <= max) continue;
            max = X.get(i);
        }
        return max;
    }

    public static int sum(int[] X) {
        int s2 = 0;
        int m4 = X.length;
        if (m4 == 0) {
            return 0;
        }
        for (int i = 0; i < m4; ++i) {
            s2 += X[i];
        }
        return s2;
    }

    public static void writeReport(String filename, String data) throws IOException {
        String absoluteFilename = Stats.getAbsoluteFileName(filename);
        File f = new File(absoluteFilename);
        File parent = f.getParentFile();
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(f, true);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintStream ps = new PrintStream(bos);
        ps.println(data);
        ps.close();
        bos.close();
        fos.close();
    }

    public static String getAbsoluteFileName(String filename) {
        return System.getProperty("user.home") + File.separator + ANTLRWORKS_DIR + File.separator + filename;
    }
}

