/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.docx4j.Docx4jProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitsOfMeasurement {
    private static final Logger log = LoggerFactory.getLogger(UnitsOfMeasurement.class);
    public static final DecimalFormat format2DP = new DecimalFormat("##.##", new DecimalFormatSymbols(Locale.ENGLISH));
    public static final int DPI = Integer.parseInt(Docx4jProperties.getProperty("docx4j.DPI", "96"));

    public static long twipToEMU(double twips) {
        return Math.round(635.0 * twips);
    }

    public static int inchToTwip(float inch) {
        return Math.round(inch * 1440.0f);
    }

    public static float twipToInch(int twip) {
        return (float)twip / 1440.0f;
    }

    public static float twipToMm(int twip) {
        return (float)twip / 56.6928f;
    }

    public static int mmToTwip(float mm4) {
        float inch = mm4 * 0.0394f;
        return UnitsOfMeasurement.inchToTwip(inch);
    }

    public static float twipToPoint(int twip) {
        return (float)twip / 20.0f;
    }

    public static int pointToTwip(float point) {
        return Math.round(20.0f * point);
    }

    public static int pxToTwip(float px) {
        float inch = px / (float)DPI;
        return UnitsOfMeasurement.inchToTwip(inch);
    }

    public static double inchToTwipDouble(double inch) {
        return inch * 1440.0;
    }

    public static double pxToTwipDouble(double px) {
        double inch = px / (double)DPI;
        return UnitsOfMeasurement.inchToTwipDouble(inch);
    }

    public static String twipToBest(int leftL) {
        float inch4f = 80.0f * UnitsOfMeasurement.twipToInch(leftL);
        float inch4fabit = inch4f + 0.49f;
        int inch4 = Math.round(inch4f);
        int inch4next = Math.round(inch4fabit);
        float inches = UnitsOfMeasurement.twipToInch(leftL);
        if (inch4 == inch4next) {
            log.debug(leftL + " twips -> " + inches + "inches");
            return format2DP.format(inches) + "in";
        }
        float mm4 = inches / 0.0394f;
        log.debug(leftL + " twips -> " + mm4 + "mm (" + format2DP.format(inches) + "inches)");
        return Math.round(mm4) + "mm";
    }

    public static String rgbTripleToHex(float red, float green, float blue) {
        return UnitsOfMeasurement.getHex(red) + UnitsOfMeasurement.getHex(green) + UnitsOfMeasurement.getHex(blue);
    }

    private static String getHex(float f) {
        int i = Math.round(f);
        String hexValue = Integer.toHexString(i);
        if (i < 16) {
            return "0" + hexValue;
        }
        return hexValue;
    }

    public static String toHexColor(int color) {
        String ret = Integer.toHexString(color).toUpperCase();
        return ret.length() < 6 ? "000000".substring(0, 6 - ret.length()) + ret : ret;
    }

    public static int combineColors(int fgColor, int bgColor, int pctFg) {
        int resColor = 0;
        if (pctFg < 1) {
            resColor = bgColor;
        } else if (pctFg == 100) {
            resColor = fgColor;
        } else {
            int pctBg = 100 - pctFg;
            resColor = ((fgColor >> 16 & 0xFF) * pctFg + (bgColor >> 16 & 0xFF) * pctBg) / 100 << 16 | ((fgColor >> 8 & 0xFF) * pctFg + (bgColor >> 8 & 0xFF) * pctBg) / 100 << 8 | ((fgColor & 0xFF) * pctFg + (bgColor & 0xFF) * pctBg) / 100;
        }
        return resColor;
    }

    private String calcHexColor(int value) {
        String ret = Integer.toHexString(value).toUpperCase();
        return ret.length() < 6 ? "000000".substring(0, 6 - ret.length()) + ret : ret;
    }
}

