/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common;

import jakarta.xml.bind.JAXBElement;
import java.util.LinkedList;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractVisitorExporterDelegate;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.dml.CTBlip;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.vml.CTShape;
import org.docx4j.vml.CTTextbox;
import org.docx4j.vml.wordprocessingDrawing.CTWrap;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.CTSimpleField;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.Pict;
import org.docx4j.wml.ProofErr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractVisitorExporterGenerator<CC extends AbstractWmlConversionContext>
extends TraversalUtil.CallbackImpl {
    private static Logger log = LoggerFactory.getLogger(AbstractVisitorExporterGenerator.class);
    protected static final String TAB_DUMMY = "\u00a0\u00a0\u00a0";
    protected static final int NODE_BLOCK = 1;
    protected static final int NODE_INLINE = 2;
    protected static final int IMAGE_E10 = 1;
    protected static final int IMAGE_E20 = 2;
    protected CC conversionContext = null;
    protected Document document = null;
    protected Node parentNode = null;
    protected Element currentP = null;
    protected Element currentSpan = null;
    protected LinkedList<Element> tr = new LinkedList();
    protected LinkedList<Element> tc = new LinkedList();
    protected PPr pPr = null;
    protected RPr rPr = null;
    protected Object anchorOrInline;

    protected AbstractVisitorExporterGenerator(CC conversionContext, Document document, Node parentNode) {
        this.conversionContext = conversionContext;
        this.document = document;
        this.parentNode = parentNode;
    }

    @Override
    public boolean shouldTraverse(Object o) {
        return !(o instanceof Tbl) && !(o instanceof P.Hyperlink) && !(o instanceof CTSimpleField) && !(o instanceof CTTextbox) && !(o instanceof FldChar);
    }

    protected Node getCurrentParent() {
        return this.currentSpan != null ? this.currentSpan : (this.currentP != null ? this.currentP : this.parentNode);
    }

    protected void convertToNode(CC conversionContext, Object unmarshalledNode, String modelId, Document document, Node parentNode) throws DOMException {
        CTTextbox textBox;
        log.debug(modelId);
        DocumentFragment childResults = null;
        if (unmarshalledNode instanceof ContentAccessor) {
            childResults = document.createDocumentFragment();
            AbstractVisitorExporterGenerator<CC> generator = this.getFactory().createInstance(conversionContext, document, childResults);
            new TraversalUtil(((ContentAccessor)unmarshalledNode).getContent(), generator);
        } else if (unmarshalledNode instanceof Pict && (textBox = this.getTextBox((Pict)unmarshalledNode)) != null) {
            childResults = document.createDocumentFragment();
            AbstractVisitorExporterGenerator<CC> generator = this.getFactory().createInstance(conversionContext, document, childResults);
            new TraversalUtil(textBox.getTxbxContent().getContent(), generator);
        }
        Node resultNode = ((AbstractWmlConversionContext)conversionContext).getWriterRegistry().toNode((AbstractWmlConversionContext)conversionContext, unmarshalledNode, modelId, childResults, document);
        if (resultNode != null) {
            log.debug("Appending " + XmlUtils.w3CDomNodeToString(resultNode));
            parentNode.appendChild(resultNode);
        }
    }

    protected void rtlAwareAppendChildToCurrentP(Element child) {
        this.parentNode.appendChild(child);
    }

    @Override
    public void walkJAXBElements(Object o) {
        Node existingParentNode = this.parentNode;
        if (o instanceof Tr) {
            this.tr.push(this.document.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tr"));
            this.parentNode.appendChild(this.tr.peek());
        } else if (o instanceof Tc) {
            this.tc.push(this.document.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tc"));
            this.tr.peek().appendChild(this.tc.peek());
            this.parentNode = this.tc.peek();
        }
        super.walkJAXBElements(o);
        if (o instanceof Tr) {
            this.tr.pop();
        } else if (o instanceof Tc) {
            this.tc.pop();
            this.parentNode = existingParentNode;
        }
    }

    @Override
    public List<Object> apply(Object o) {
        if (o instanceof P) {
            this.currentP = this.createNode(this.document, 1);
            this.currentSpan = null;
            if (this.tc.peek() != null) {
                this.tc.peek().appendChild(this.currentP);
            } else {
                this.parentNode.appendChild(this.currentP);
            }
            this.pPr = ((P)o).getPPr();
            this.currentP = this.handlePPr(this.conversionContext, this.pPr, false, this.currentP);
        } else if (o instanceof R) {
            if (!((AbstractWmlConversionContext)this.conversionContext).isInComplexFieldDefinition()) {
                Element spanEl;
                this.currentSpan = spanEl = this.createNode(this.document, 2);
                this.rPr = ((R)o).getRPr();
                if (this.rPr != null) {
                    this.handleRPr(this.conversionContext, this.pPr, this.rPr, this.currentSpan);
                }
                if (this.currentP == null) {
                    this.parentNode.appendChild(spanEl);
                } else {
                    this.rtlAwareAppendChildToCurrentP(spanEl);
                }
            }
        } else if (o instanceof FldChar) {
            ((AbstractWmlConversionContext)this.conversionContext).updateComplexFieldDefinition(((FldChar)o).getFldCharType());
        } else if (o instanceof Text) {
            if (!((AbstractWmlConversionContext)this.conversionContext).isInComplexFieldDefinition()) {
                if (this.currentSpan == null) {
                    log.error("null currentSpan! " + ((Text)o).getValue());
                    Element spanEl = this.createNode(this.document, 2);
                    if (this.currentP == null) {
                        this.parentNode.appendChild(spanEl);
                    } else {
                        this.currentP.appendChild(spanEl);
                    }
                    this.currentSpan = spanEl;
                }
                log.debug(((Text)o).getValue());
                DocumentFragment df = (DocumentFragment)((AbstractWmlConversionContext)this.conversionContext).getRunFontSelector().fontSelector(this.pPr, this.rPr, (Text)o);
                XmlUtils.treeCopy(df, (Node)this.currentSpan);
            }
        } else if (o instanceof R.Tab) {
            this.convertTabToNode(this.conversionContext, this.document);
        } else if (o instanceof CTSimpleField) {
            this.convertToNode(this.conversionContext, o, "w:fldSimple", this.document, this.getCurrentParent());
        } else if (o instanceof P.Hyperlink) {
            this.convertToNode(this.conversionContext, o, "w:hyperlink", this.document, this.getCurrentParent());
        } else if (o instanceof CTBookmark) {
            this.convertToNode(this.conversionContext, o, "w:bookmarkStart", this.document, this.getCurrentParent());
        } else if (o instanceof Tbl) {
            this.convertToNode(this.conversionContext, o, "w:tbl", this.document, this.currentP != null ? this.currentP : this.parentNode);
            this.currentP = null;
            this.currentSpan = null;
        } else if (!(o instanceof Tr) && !(o instanceof Tc)) {
            if (o instanceof Inline || o instanceof Anchor) {
                this.anchorOrInline = o;
            } else if (o instanceof CTBlip) {
                DocumentFragment foreignFragment = this.createImage(2, this.conversionContext, this.anchorOrInline);
                this.anchorOrInline = null;
                this.currentP.appendChild(this.document.importNode(foreignFragment, true));
            } else if (o instanceof Pict) {
                CTTextbox textBox = this.getTextBox((Pict)o);
                if (textBox == null) {
                    DocumentFragment foreignFragment = this.createImage(1, this.conversionContext, o);
                    this.currentP.appendChild(this.document.importNode(foreignFragment, true));
                } else {
                    this.convertToNode(this.conversionContext, o, "w:pict", this.document, this.getCurrentParent());
                }
            } else if (o instanceof Br) {
                this.handleBr((Br)o);
            } else if (o instanceof R.Sym) {
                this.convertToNode(this.conversionContext, o, "w:sym", this.document, this.getCurrentParent());
            } else if (!(o instanceof ProofErr || o instanceof R.LastRenderedPageBreak || o instanceof CTMarkupRange)) {
                log.warn("Need to handle " + o.getClass().getName());
                if (log.isDebugEnabled()) {
                    log.debug(XmlUtils.marshaltoString(o));
                }
            }
        }
        return null;
    }

    protected abstract void handleBr(Br var1);

    protected int getPos(List list, Object wanted) {
        int index = 0;
        for (Object o : list) {
            if (o == wanted) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected void convertTabToNode(CC conversionContext, Document document) throws DOMException {
        if (!((AbstractWmlConversionContext)conversionContext).isInComplexFieldDefinition()) {
            this.getCurrentParent().appendChild(document.createTextNode(TAB_DUMMY));
        }
    }

    private CTTextbox getTextBox(Pict pict) {
        CTShape shape = null;
        for (Object o2 : pict.getAnyAndAny()) {
            if (!((o2 = XmlUtils.unwrap(o2)) instanceof CTShape)) continue;
            shape = (CTShape)o2;
            break;
        }
        if (shape == null) {
            log.warn("no shape in pict ");
            return null;
        }
        CTTextbox textBox = null;
        CTWrap w10Wrap = null;
        for (JAXBElement<?> jAXBElement : shape.getPathOrFormulasOrHandles()) {
            Object object = XmlUtils.unwrap(jAXBElement);
            if (object instanceof CTTextbox) {
                textBox = (CTTextbox)object;
            }
            if (!(object instanceof CTWrap)) continue;
            w10Wrap = (CTWrap)object;
        }
        return textBox;
    }

    protected abstract Element handlePPr(CC var1, PPr var2, boolean var3, Element var4);

    protected abstract void handleRPr(CC var1, PPr var2, RPr var3, Element var4);

    protected abstract AbstractVisitorExporterDelegate.AbstractVisitorExporterGeneratorFactory<CC> getFactory();

    protected abstract DocumentFragment createImage(int var1, CC var2, Object var3);

    protected abstract Element createNode(Document var1, int var2);

    protected Logger getLog() {
        return log;
    }
}

