/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.AltChunkType;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlternativeFormatInputPart
extends BinaryPart {
    protected static Logger log = LoggerFactory.getLogger(AlternativeFormatInputPart.class);
    AltChunkType altChunkType;

    public AlternativeFormatInputPart(PartName partName) throws InvalidFormatException {
        super(partName);
        String extension = partName.getExtension().toLowerCase();
        if (extension.equals("htm")) {
            this.setAltChunkType(AltChunkType.Html);
        } else {
            for (AltChunkType type : AltChunkType.values()) {
                if (!extension.equals(type.getExtension())) continue;
                this.setAltChunkType(type);
            }
        }
        if (this.altChunkType == null) {
            log.warn("Unrecognized type: " + extension);
        }
        this.init();
    }

    public AlternativeFormatInputPart(AltChunkType type) throws InvalidFormatException {
        super(new PartName(AlternativeFormatInputPart.generatePartName(type)));
        this.setAltChunkType(type);
        this.init();
    }

    private static String generatePartName(AltChunkType type) {
        return "/chunk." + type.getExtension();
    }

    private void init() {
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/aFChunk");
    }

    public void setAltChunkType(AltChunkType altChunkType) {
        this.altChunkType = altChunkType;
        this.setContentType(new ContentType(altChunkType.getContentType()));
    }

    public AltChunkType getAltChunkType() {
        return this.altChunkType;
    }

    public void registerInContentTypeManager() {
        ContentTypeManager ctm = this.getPackage().getContentTypeManager();
        if (this.altChunkType != null) {
            ctm.addDefaultContentType(this.altChunkType.getExtension(), this.altChunkType.getContentType());
        }
    }
}

