/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import jakarta.xml.bind.JAXBElement;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.McIgnorableNamespaceDeclarator;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.org.apache.poi.EncryptedDocumentException;
import org.docx4j.org.apache.poi.poifs.crypt.CryptoFunctions;
import org.docx4j.org.apache.poi.poifs.crypt.HashAlgorithm;
import org.docx4j.relationships.ObjectFactory;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTCompat;
import org.docx4j.wml.CTCompatSetting;
import org.docx4j.wml.CTDocProtect;
import org.docx4j.wml.CTRel;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.STAlgClass;
import org.docx4j.wml.STAlgType;
import org.docx4j.wml.STCryptProv;
import org.docx4j.wml.STDocProtect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocumentSettingsPart
extends JaxbXmlPartXPathAware<CTSettings> {
    private static final Logger log = LoggerFactory.getLogger(DocumentSettingsPart.class);

    public DocumentSettingsPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public DocumentSettingsPart() throws InvalidFormatException {
        super(new PartName("/word/settings.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/settings");
    }

    @Override
    protected void setMceIgnorable(McIgnorableNamespaceDeclarator namespacePrefixMapper) {
        boolean needW14 = false;
        if (((CTSettings)this.jaxbElement).getDocId14() != null) {
            needW14 = true;
        } else if (((CTSettings)this.jaxbElement).getConflictMode() != null) {
            needW14 = true;
        } else if (((CTSettings)this.jaxbElement).getDiscardImageEditingData() != null) {
            needW14 = true;
        } else if (((CTSettings)this.jaxbElement).getDefaultImageDpi() != null) {
            needW14 = true;
        }
        boolean needW15 = false;
        if (((CTSettings)this.jaxbElement).getChartTrackingRefBased() != null) {
            needW15 = true;
        } else if (((CTSettings)this.jaxbElement).getDocId15() != null) {
            needW15 = true;
        }
        Object mceIgnorableVal = "";
        if (needW14) {
            mceIgnorableVal = "w14";
        }
        if (needW15) {
            mceIgnorableVal = (String)mceIgnorableVal + " w15";
        }
        log.debug((String)mceIgnorableVal);
        namespacePrefixMapper.setMcIgnorable((String)mceIgnorableVal);
        ((CTSettings)this.jaxbElement).setIgnorable((String)mceIgnorableVal);
    }

    @Override
    public String getMceIgnorable() {
        return ((CTSettings)this.getJaxbElement()).getIgnorable();
    }

    public CTCompatSetting getWordCompatSetting(String name) {
        CTCompat compat = ((CTSettings)this.getJaxbElement()).getCompat();
        if (compat == null) {
            log.warn("No w:settings/w:compat element");
            return null;
        }
        CTCompatSetting theSetting = null;
        for (CTCompatSetting setting : compat.getCompatSetting()) {
            if (!setting.getUri().equals("http://schemas.microsoft.com/office/word") || !setting.getName().equals(name)) continue;
            theSetting = setting;
            break;
        }
        return theSetting;
    }

    public void setWordCompatSetting(String name, String val) {
        CTCompat compat = ((CTSettings)this.getJaxbElement()).getCompat();
        if (compat == null) {
            log.debug("No w:settings/w:compat element; creating..");
        }
        compat = Context.getWmlObjectFactory().createCTCompat();
        ((CTSettings)this.getJaxbElement()).setCompat(compat);
        CTCompatSetting theSetting = null;
        for (CTCompatSetting setting : compat.getCompatSetting()) {
            if (!setting.getUri().equals("http://schemas.microsoft.com/office/word") || !setting.getName().equals(name)) continue;
            theSetting = setting;
            break;
        }
        if (theSetting == null) {
            theSetting = Context.getWmlObjectFactory().createCTCompatSetting();
            theSetting.setUri("http://schemas.microsoft.com/office/word");
            theSetting.setName(name);
            compat.getCompatSetting().add(theSetting);
        }
        theSetting.setVal(val);
    }

    public boolean overrideTableStyleFontSizeAndJustification() {
        CTCompatSetting overrideTableStyleFontSizeAndJustification = this.getWordCompatSetting("overrideTableStyleFontSizeAndJustification");
        if (overrideTableStyleFontSizeAndJustification == null || overrideTableStyleFontSizeAndJustification.getVal() == null) {
            return false;
        }
        return overrideTableStyleFontSizeAndJustification.getVal().equals("1") || overrideTableStyleFontSizeAndJustification.getVal().toLowerCase().equals("true") || overrideTableStyleFontSizeAndJustification.getVal().toLowerCase().equals("yes");
    }

    public void setOverrideTableStyleFontSizeAndJustification(boolean val) {
        if (val) {
            this.setWordCompatSetting("overrideTableStyleFontSizeAndJustification", "1");
        } else {
            this.setWordCompatSetting("overrideTableStyleFontSizeAndJustification", "0");
        }
    }

    public void protectRestrictFormatting(boolean autoFormatOverride, boolean styleLockTheme, boolean styleLockQFSet, String password, HashAlgorithm hashAlgo) throws Docx4JException {
        if (password == null && hashAlgo != null) {
            throw new IllegalArgumentException("Unless you set a password, a HashAlgorithm makes no sense");
        }
        if (password != null && hashAlgo == null) {
            throw new IllegalArgumentException("If you set a password, a HashAlgorithm must be specified");
        }
        this.safeGetDocumentProtection().setFormatting(true);
        this.safeGetDocumentProtection().setEnforcement(true);
        if (autoFormatOverride && ((CTSettings)this.jaxbElement).getAutoFormatOverride() == null) {
            ((CTSettings)this.jaxbElement).setAutoFormatOverride(new BooleanDefaultTrue());
        }
        if (styleLockTheme && ((CTSettings)this.jaxbElement).getStyleLockTheme() == null) {
            ((CTSettings)this.jaxbElement).setStyleLockTheme(new BooleanDefaultTrue());
        }
        if (styleLockQFSet && ((CTSettings)this.jaxbElement).getStyleLockQFSet() == null) {
            ((CTSettings)this.jaxbElement).setStyleLockQFSet(new BooleanDefaultTrue());
        }
        if (password != null) {
            this.setProtectionPassword(password, hashAlgo);
        }
    }

    public boolean isRestrictEditingWith(STDocProtect editValue) {
        CTDocProtect ctDocProtect = ((CTSettings)this.jaxbElement).getDocumentProtection();
        if (ctDocProtect == null) {
            return false;
        }
        return ctDocProtect.isEnforcement() && ctDocProtect.getEdit().equals((Object)editValue);
    }

    public void protectRestrictEditing(STDocProtect editValue, String password, HashAlgorithm hashAlgo) {
        this.safeGetDocumentProtection().setEnforcement(true);
        this.safeGetDocumentProtection().setEdit(editValue);
        if (editValue == STDocProtect.TRACKED_CHANGES && ((CTSettings)this.jaxbElement).getTrackRevisions() == null) {
            ((CTSettings)this.jaxbElement).setTrackRevisions(new BooleanDefaultTrue());
        }
        this.setProtectionPassword(password, hashAlgo);
    }

    private void setProtectionPassword(String password, HashAlgorithm hashAlgo) {
        int sid;
        STCryptProv providerType;
        if (password == null) {
            this.safeGetDocumentProtection().setCryptProviderType(null);
            this.safeGetDocumentProtection().setCryptAlgorithmClass(null);
            this.safeGetDocumentProtection().setCryptAlgorithmType(null);
            this.safeGetDocumentProtection().setCryptAlgorithmSid(null);
            this.safeGetDocumentProtection().setSalt(null);
            this.safeGetDocumentProtection().setCryptSpinCount(null);
            this.safeGetDocumentProtection().setHash(null);
            return;
        }
        switch (hashAlgo) {
            case md2: {
                providerType = STCryptProv.RSA_FULL;
                sid = 1;
                break;
            }
            case md4: {
                providerType = STCryptProv.RSA_FULL;
                sid = 2;
                break;
            }
            case md5: {
                providerType = STCryptProv.RSA_FULL;
                sid = 3;
                break;
            }
            case sha1: {
                providerType = STCryptProv.RSA_FULL;
                sid = 4;
                break;
            }
            case sha256: {
                providerType = STCryptProv.RSA_AES;
                sid = 12;
                break;
            }
            case sha384: {
                providerType = STCryptProv.RSA_AES;
                sid = 13;
                break;
            }
            case sha512: {
                providerType = STCryptProv.RSA_AES;
                sid = 14;
                break;
            }
            default: {
                throw new EncryptedDocumentException("Hash algorithm '" + hashAlgo + "' is not supported for document write protection.");
            }
        }
        SecureRandom random = new SecureRandom();
        byte[] salt = random.generateSeed(16);
        int spinCount = 100000;
        if (hashAlgo == null) {
            hashAlgo = HashAlgorithm.sha512;
        }
        String legacyHash = CryptoFunctions.xorHashPasswordReversed(password);
        byte[] hash = CryptoFunctions.hashPassword(legacyHash, hashAlgo, salt, spinCount, false);
        this.safeGetDocumentProtection().setSalt(salt);
        this.safeGetDocumentProtection().setHash(hash);
        this.safeGetDocumentProtection().setCryptSpinCount(BigInteger.valueOf(spinCount));
        this.safeGetDocumentProtection().setCryptAlgorithmType(STAlgType.TYPE_ANY);
        this.safeGetDocumentProtection().setCryptAlgorithmClass(STAlgClass.HASH);
        this.safeGetDocumentProtection().setCryptProviderType(providerType);
        this.safeGetDocumentProtection().setCryptAlgorithmSid(BigInteger.valueOf(sid));
    }

    public boolean validateProtectionPassword(String password) {
        HashAlgorithm hashAlgo;
        BigInteger sid = this.safeGetDocumentProtection().getCryptAlgorithmSid();
        byte[] hash = this.safeGetDocumentProtection().getHash();
        byte[] salt = this.safeGetDocumentProtection().getSalt();
        BigInteger spinCount = this.safeGetDocumentProtection().getCryptSpinCount();
        if (sid == null || hash == null || salt == null || spinCount == null) {
            return false;
        }
        switch (sid.intValue()) {
            case 1: {
                hashAlgo = HashAlgorithm.md2;
                break;
            }
            case 2: {
                hashAlgo = HashAlgorithm.md4;
                break;
            }
            case 3: {
                hashAlgo = HashAlgorithm.md5;
                break;
            }
            case 4: {
                hashAlgo = HashAlgorithm.sha1;
                break;
            }
            case 12: {
                hashAlgo = HashAlgorithm.sha256;
                break;
            }
            case 13: {
                hashAlgo = HashAlgorithm.sha384;
                break;
            }
            case 14: {
                hashAlgo = HashAlgorithm.sha512;
                break;
            }
            default: {
                return false;
            }
        }
        String legacyHash = CryptoFunctions.xorHashPasswordReversed(password);
        byte[] hash2 = CryptoFunctions.hashPassword(legacyHash, hashAlgo, salt, spinCount.intValue(), false);
        return Arrays.equals(hash, hash2);
    }

    public void removeEnforcement() {
        this.safeGetDocumentProtection().setEnforcement(false);
    }

    private CTDocProtect safeGetDocumentProtection() {
        CTDocProtect documentProtection;
        if (this.getJaxbElement() == null) {
            this.jaxbElement = new CTSettings();
        }
        if ((documentProtection = ((CTSettings)this.jaxbElement).getDocumentProtection()) == null) {
            documentProtection = Context.getWmlObjectFactory().createCTDocProtect();
            ((CTSettings)this.jaxbElement).setDocumentProtection(documentProtection);
        }
        return ((CTSettings)this.jaxbElement).getDocumentProtection();
    }

    public void attachTemplate(String templatePath) {
        if (this.getJaxbElement() == null) {
            this.jaxbElement = new CTSettings();
        }
        RelationshipsPart rp = this.getRelationshipsPart(true);
        CTRel relId = ((CTSettings)this.getJaxbElement()).getAttachedTemplate();
        if (relId == null) {
            relId = Context.getWmlObjectFactory().createCTRel();
            JAXBElement<CTRel> je = new JAXBElement<CTRel>(new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "attachedTemplate"), CTRel.class, null, relId);
            ((CTSettings)this.getJaxbElement()).setAttachedTemplate(je.getValue());
        } else {
            rp.removeRelationship(rp.getRelationshipByID(relId.getId()));
        }
        Relationship rel = new ObjectFactory().createRelationship();
        rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/attachedTemplate");
        rel.setTarget(templatePath);
        rel.setTargetMode("External");
        rp.addRelationship(rel);
        relId.setId(rel.getId());
    }
}

