/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.toc.TocException;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TocStyles {
    private static Logger log = LoggerFactory.getLogger(TocStyles.class);
    protected static final String TOC_STYLE_MASK = "toc %s";
    private static Map<String, Style> defaultToCStyles = new HashMap<String, Style>();
    private Map<String, String> styleNameToID = new HashMap<String, String>();
    private Styles stylesPartStyles;
    public static final String TOC_HEADING = "TOC Heading";
    public static final String HEADING_1 = "heading 1";
    private String defaultPStyleId = null;

    public static TocStyles getTocStyles(MainDocumentPart documentPart) throws TocException {
        if (documentPart.getStyleDefinitionsPart() == null || documentPart.getStyleDefinitionsPart().getJaxbElement() == null) {
            throw new TocException("No StyleDefinitions present in package");
        }
        return new TocStyles(documentPart.getStyleDefinitionsPart());
    }

    private static InputStream getResourceViaProperty(String propName, String defaultPath) throws IOException {
        String resourcePath = Docx4jProperties.getProperty(propName, defaultPath);
        log.debug(propName + " resolved to " + resourcePath);
        InputStream resourceIS = null;
        try {
            resourceIS = ResourceUtils.getResource(resourcePath);
        }
        catch (IOException ioe) {
            log.warn(resourcePath + ": " + ioe.getMessage());
        }
        if (resourceIS == null) {
            log.warn("Property " + propName + " resolved to missing resource " + resourcePath + "; using " + defaultPath);
            return ResourceUtils.getResource(defaultPath);
        }
        return resourceIS;
    }

    protected TocStyles(StyleDefinitionsPart sdp) {
        this.stylesPartStyles = (Styles)sdp.getJaxbElement();
        String defaultPStyleName = null;
        if (sdp.getDefaultParagraphStyle() != null) {
            defaultPStyleName = sdp.getDefaultParagraphStyle().getName().getVal();
            this.defaultPStyleId = sdp.getDefaultParagraphStyle().getStyleId();
        }
        for (Style s2 : this.stylesPartStyles.getStyle()) {
            if (!s2.getName().getVal().startsWith("toc") && !s2.getName().getVal().equals(defaultPStyleName) && !s2.getName().getVal().equals(TOC_HEADING) && !s2.getName().getVal().equals(HEADING_1)) continue;
            this.styleNameToID.put(s2.getName().getVal(), s2.getStyleId());
        }
        for (int i = 1; i <= 9; ++i) {
            this.getStyleIdForName("toc " + i);
        }
        this.getStyleIdForName("Hyperlink");
    }

    protected String getStyleIdForName(String name) {
        String id = this.styleNameToID.get(name);
        log.debug(name + " --> " + id);
        if (id != null) {
            return id;
        }
        log.info(name + " style not defined in styles part; falling back to configured default");
        Style s2 = defaultToCStyles.get(name);
        if (s2 == null) {
            log.warn("No default style defined with name " + name);
            return null;
        }
        Style clone = XmlUtils.deepCopy(s2);
        this.stylesPartStyles.getStyle().add(clone);
        this.styleNameToID.put(name, clone.getStyleId());
        log.info("Added a styles definition for " + name);
        if (clone.getBasedOn() != null && clone.getBasedOn().getVal().equals("Normal") && this.defaultPStyleId != null && !this.defaultPStyleId.equals("Normal")) {
            clone.getBasedOn().setVal(this.defaultPStyleId);
        }
        return this.styleNameToID.get(name);
    }

    static {
        try {
            InputStream is = TocStyles.getResourceViaProperty("docx4j.toc.TocStyles.xml", "org/docx4j/toc/TocStyles.xml");
            Styles defaultStyles = (Styles)XmlUtils.unmarshal(is);
            for (Style s2 : defaultStyles.getStyle()) {
                defaultToCStyles.put(s2.getName().getVal(), s2);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }
}

