/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import org.docx4j.Docx4J;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.HTMLSettings;
import org.docx4j.convert.out.common.AbstractVisitorExporterGenerator;
import org.docx4j.convert.out.html.HTMLConversionContext;
import org.docx4j.convert.out.html.HTMLConversionImageHandler;
import org.docx4j.convert.out.html.HTMLExporterVisitorGenerator;
import org.docx4j.convert.out.html.HtmlCssHelper;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class HtmlExporterNonXSLT {
    protected static final int DEFAULT_OUTPUT_SIZE = 102400;
    private static Logger log = LoggerFactory.getLogger(HtmlExporterNonXSLT.class);
    protected static String inputfilepath;
    protected static String outputfilepath;
    protected HTMLSettings htmlSettings = new HTMLSettings();

    public HtmlExporterNonXSLT(WordprocessingMLPackage wordMLPackage, ConversionImageHandler conversionImageHandler) {
        try {
            this.htmlSettings.setOpcPackage(wordMLPackage);
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), e);
        }
        this.htmlSettings.setImageHandler(conversionImageHandler);
    }

    public Document export() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(102400);
        Document ret = null;
        try {
            Docx4J.toHTML(this.htmlSettings, outStream, 2);
            ret = XmlUtils.getNewDocumentBuilder().parse(new ByteArrayInputStream(outStream.toByteArray()));
        }
        catch (Docx4JException e) {
            log.error("Exception exporting document: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            log.error("Exception parsing document: " + e.getMessage(), e);
        }
        catch (IOException e) {
            log.error("Exception parsing document: " + e.getMessage(), e);
        }
        return ret;
    }

    public String getCss() {
        WordprocessingMLPackage wmlPackage = (WordprocessingMLPackage)this.htmlSettings.getOpcPackage();
        StringBuilder buffer = new StringBuilder();
        HtmlCssHelper.createCssForStyles(wmlPackage, wmlPackage.getMainDocumentPart().getStyleTree(), buffer);
        return buffer.toString();
    }

    public Document export(Object blockLevelContent, String cssClass, String cssId) {
        HTMLConversionContext conversionContext = new HTMLConversionContext(this.htmlSettings, null, null);
        Document document = XmlUtils.neww3cDomDocument();
        Element parentNode = document.createElement("div");
        AbstractVisitorExporterGenerator<HTMLConversionContext> generator = null;
        if (cssClass != null) {
            parentNode.setAttribute("class", cssClass);
        }
        if (cssId != null) {
            parentNode.setAttribute("id", cssId);
        }
        document.appendChild(parentNode);
        generator = HTMLExporterVisitorGenerator.GENERATOR_FACTORY.createInstance(conversionContext, document, parentNode);
        new TraversalUtil(blockLevelContent, generator);
        return document;
    }

    public static void main(String[] args) throws Exception {
        inputfilepath = System.getProperty("user.dir") + "/hlink.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        HtmlExporterNonXSLT withoutXSLT = new HtmlExporterNonXSLT(wordMLPackage, new HTMLConversionImageHandler("c:\\temp", "/bar", true));
        log.info(XmlUtils.w3CDomNodeToString(withoutXSLT.export()));
    }
}

