/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.docx4j.fonts.fop.apps.FOPException;
import org.docx4j.fonts.fop.apps.io.InternalResourceResolver;
import org.docx4j.fonts.fop.fonts.CIDFontType;
import org.docx4j.fonts.fop.fonts.CMapSegment;
import org.docx4j.fonts.fop.fonts.CustomFont;
import org.docx4j.fonts.fop.fonts.EmbeddingMode;
import org.docx4j.fonts.fop.fonts.FontType;
import org.docx4j.fonts.fop.fonts.MultiByteFont;
import org.docx4j.fonts.fop.fonts.SingleByteFont;
import org.docx4j.fonts.fop.fonts.Typeface;
import org.docx4j.fonts.fop.fonts.apps.TTFReader;
import org.docx4j.org.apache.poi.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
public class XMLFontMetricsReader
extends DefaultHandler {
    private boolean isCID;
    private CustomFont returnFont;
    private MultiByteFont multiFont;
    private SingleByteFont singleFont;
    private final InternalResourceResolver resourceResolver;
    private StringBuffer text = new StringBuffer();
    private List<Integer> cidWidths;
    private Map<Integer, Integer> currentKerning;
    private List<CMapSegment> bfranges;

    public XMLFontMetricsReader(InputSource source, InternalResourceResolver resourceResolver) throws FOPException {
        this.resourceResolver = resourceResolver;
        this.createFont(source);
    }

    private void createFont(InputSource source) throws FOPException {
        XMLReader parser = null;
        try {
            parser = XMLHelper.newXMLReader();
        }
        catch (Exception e) {
            throw new FOPException(e);
        }
        if (parser == null) {
            throw new FOPException("Unable to create SAX parser");
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXException e) {
            throw new FOPException("You need a SAX parser which supports SAX version 2", e);
        }
        parser.setContentHandler(this);
        try {
            parser.parse(source);
        }
        catch (SAXException e) {
            throw new FOPException(e);
        }
        catch (IOException e) {
            throw new FOPException(e);
        }
    }

    public void setFontEmbedURI(URI path) {
        this.returnFont.setEmbedURI(path);
    }

    public void setKerningEnabled(boolean enabled) {
        this.returnFont.setKerningEnabled(enabled);
    }

    public void setAdvancedEnabled(boolean enabled) {
        this.returnFont.setAdvancedEnabled(enabled);
    }

    public Typeface getFont() {
        return this.returnFont;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("font-metrics")) {
            if ("TYPE0".equals(attributes.getValue("type"))) {
                this.multiFont = new MultiByteFont(this.resourceResolver, EmbeddingMode.AUTO);
                this.returnFont = this.multiFont;
                this.isCID = true;
                TTFReader.checkMetricsVersion(attributes);
            } else if ("TRUETYPE".equals(attributes.getValue("type"))) {
                this.singleFont = new SingleByteFont(this.resourceResolver, EmbeddingMode.AUTO);
                this.singleFont.setFontType(FontType.TRUETYPE);
                this.returnFont = this.singleFont;
                this.isCID = false;
                TTFReader.checkMetricsVersion(attributes);
            } else {
                this.singleFont = new SingleByteFont(this.resourceResolver, EmbeddingMode.AUTO);
                this.singleFont.setFontType(FontType.TYPE1);
                this.returnFont = this.singleFont;
                this.isCID = false;
            }
        } else if ("embed".equals(localName)) {
            try {
                this.returnFont.setEmbedURI(InternalResourceResolver.cleanURI(attributes.getValue("file")));
            }
            catch (URISyntaxException e) {
                throw new SAXException("URI syntax error in metrics file: " + e.getMessage(), e);
            }
            this.returnFont.setEmbedResourceName(attributes.getValue("class"));
        } else if ("cid-widths".equals(localName)) {
            this.cidWidths = new ArrayList<Integer>();
        } else if ("kerning".equals(localName)) {
            this.currentKerning = new HashMap<Integer, Integer>();
            this.returnFont.putKerningEntry(this.getInt(attributes.getValue("kpx1")), this.currentKerning);
        } else if ("bfranges".equals(localName)) {
            this.bfranges = new ArrayList<CMapSegment>();
        } else if ("bf".equals(localName)) {
            CMapSegment entry = new CMapSegment(this.getInt(attributes.getValue("us")), this.getInt(attributes.getValue("ue")), this.getInt(attributes.getValue("gi")));
            this.bfranges.add(entry);
        } else if ("wx".equals(localName)) {
            this.cidWidths.add(this.getInt(attributes.getValue("w")));
        } else if ("char".equals(localName)) {
            try {
                this.singleFont.setWidth(this.getInt(attributes.getValue("idx")), this.getInt(attributes.getValue("wdt")));
            }
            catch (NumberFormatException ne) {
                throw new SAXException("Malformed width in metric file: " + ne.getMessage(), ne);
            }
        } else if ("pair".equals(localName)) {
            this.currentKerning.put(this.getInt(attributes.getValue("kpx2")), this.getInt(attributes.getValue("kern")));
        }
    }

    private int getInt(String str) throws SAXException {
        int ret = 0;
        try {
            ret = Integer.parseInt(str);
        }
        catch (Exception e) {
            throw new SAXException("Error while parsing integer value: " + str, e);
        }
        return ret;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String content = this.text.toString().trim();
        if ("font-name".equals(localName)) {
            this.returnFont.setFontName(content);
        } else if ("full-name".equals(localName)) {
            this.returnFont.setFullName(content);
        } else if ("family-name".equals(localName)) {
            HashSet<String> s2 = new HashSet<String>();
            s2.add(content);
            this.returnFont.setFamilyNames(s2);
        } else if ("ttc-name".equals(localName) && this.isCID) {
            this.multiFont.setTTCName(content);
        } else if ("encoding".equals(localName)) {
            if (this.singleFont != null && this.singleFont.getFontType() == FontType.TYPE1) {
                this.singleFont.setEncoding(content);
            }
        } else if ("cap-height".equals(localName)) {
            this.returnFont.setCapHeight(this.getInt(content));
        } else if ("x-height".equals(localName)) {
            this.returnFont.setXHeight(this.getInt(content));
        } else if ("ascender".equals(localName)) {
            this.returnFont.setAscender(this.getInt(content));
        } else if ("descender".equals(localName)) {
            this.returnFont.setDescender(this.getInt(content));
        } else if ("left".equals(localName)) {
            int[] bbox = this.returnFont.getFontBBox();
            bbox[0] = this.getInt(content);
            this.returnFont.setFontBBox(bbox);
        } else if ("bottom".equals(localName)) {
            int[] bbox = this.returnFont.getFontBBox();
            bbox[1] = this.getInt(content);
            this.returnFont.setFontBBox(bbox);
        } else if ("right".equals(localName)) {
            int[] bbox = this.returnFont.getFontBBox();
            bbox[2] = this.getInt(content);
            this.returnFont.setFontBBox(bbox);
        } else if ("top".equals(localName)) {
            int[] bbox = this.returnFont.getFontBBox();
            bbox[3] = this.getInt(content);
            this.returnFont.setFontBBox(bbox);
        } else if ("first-char".equals(localName)) {
            this.returnFont.setFirstChar(this.getInt(content));
        } else if ("last-char".equals(localName)) {
            this.returnFont.setLastChar(this.getInt(content));
        } else if ("flags".equals(localName)) {
            this.returnFont.setFlags(this.getInt(content));
        } else if ("stemv".equals(localName)) {
            this.returnFont.setStemV(this.getInt(content));
        } else if ("italic-angle".equals(localName)) {
            this.returnFont.setItalicAngle(this.getInt(content));
        } else if ("missing-width".equals(localName)) {
            this.returnFont.setMissingWidth(this.getInt(content));
        } else if ("cid-type".equals(localName)) {
            this.multiFont.setCIDType(CIDFontType.byName(content));
        } else if ("default-width".equals(localName)) {
            this.multiFont.setDefaultWidth(this.getInt(content));
        } else if ("cid-widths".equals(localName)) {
            int[] wds = new int[this.cidWidths.size()];
            int j = 0;
            for (Integer cidWidth : this.cidWidths) {
                wds[j++] = cidWidth;
            }
            this.multiFont.setWidthArray(wds);
        } else if ("bfranges".equals(localName)) {
            this.multiFont.setCMap(this.bfranges.toArray(new CMapSegment[this.bfranges.size()]));
        }
        this.text.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.text.append(ch, start, length);
    }
}

