/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.render.ps;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.fontbox.cff.CharStringCommand;

public class Type1CharStringFormatter {
    private ByteArrayOutputStream output;

    public byte[] format(List<Object> sequence) {
        this.output = new ByteArrayOutputStream();
        for (Object object : sequence) {
            if (object instanceof CharStringCommand) {
                this.writeCommand((CharStringCommand)object);
                continue;
            }
            if (object instanceof Number) {
                this.writeNumber(((Number)object).intValue());
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this.output.toByteArray();
    }

    private void writeCommand(CharStringCommand command) {
        int[] value;
        for (int aValue : value = this.getValue(command)) {
            this.output.write(aValue);
        }
    }

    private int[] getValue(CharStringCommand command) {
        CharStringCommand.Type1KeyWord keyWord = command.getType1KeyWord();
        if (keyWord == null) {
            return new int[0];
        }
        CharStringCommand.Key key = CharStringCommand.Key.valueOf(keyWord.name());
        try {
            Field f = ((Object)((Object)key)).getClass().getDeclaredField("hashValue");
            f.setAccessible(true);
            int value = (Integer)f.get((Object)key);
            return new int[]{value};
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeNumber(Integer number) {
        int value = number;
        if (value >= -107 && value <= 107) {
            this.output.write(value + 139);
        } else if (value >= 108 && value <= 1131) {
            int b1 = (value - 108) % 256;
            int b0 = (value - 108 - b1) / 256 + 247;
            this.output.write(b0);
            this.output.write(b1);
        } else if (value >= -1131 && value <= -108) {
            int b1 = -((value + 108) % 256);
            int b0 = -((value + 108 + b1) / 256 - 251);
            this.output.write(b0);
            this.output.write(b1);
        } else {
            int b1 = value >>> 24 & 0xFF;
            int b2 = value >>> 16 & 0xFF;
            int b3 = value >>> 8 & 0xFF;
            int b4 = value >>> 0 & 0xFF;
            this.output.write(255);
            this.output.write(b1);
            this.output.write(b2);
            this.output.write(b3);
            this.output.write(b4);
        }
    }
}

