/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.BindingTraverserCommonImpl;
import org.docx4j.model.datastorage.BindingTraverserNonXSLT;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.SdtStAXHandler;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTDataBinding;
import org.docx4j.wml.CTSdtText;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Tag;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingTraverserStAX
extends BindingTraverserCommonImpl {
    private static Logger log = LoggerFactory.getLogger(BindingTraverserStAX.class);
    JaxbXmlPart part;
    OpcPackage pkg;
    Map<String, Xpaths.Xpath> xpathsMap;
    public static JAXBContext context = Context.jc;

    @Override
    public Object traverseToBind(JaxbXmlPart part, OpcPackage pkg, Map<String, Xpaths.Xpath> xpathsMap) throws Docx4JException {
        throw new Docx4JException("Not implemented; use streamToBind instead.");
    }

    public void streamToBind(JaxbXmlPart part, OpcPackage pkg, Map<String, Xpaths.Xpath> xpathsMap) throws Docx4JException {
        log.info("Using BindingTraverserStAX");
        this.part = part;
        this.pkg = pkg;
        this.xpathsMap = xpathsMap;
        try {
            part.pipe(new StaXBindingHandler(), null);
        }
        catch (Exception e) {
            throw new Docx4JException(e.getMessage(), e);
        }
    }

    private class StaXBindingHandler
    extends SdtStAXHandler {
        private StaXBindingHandler() {
        }

        @Override
        protected List<Object> handleSdt(SdtElement sdt) throws Docx4JException {
            ArrayList<Object> results = new ArrayList<Object>();
            results.add(sdt);
            SdtPr sdtPr = sdt.getSdtPr();
            log.debug(XmlUtils.marshaltoString(sdtPr));
            Tag tag = sdtPr.getTag();
            HashMap<String, String> map = null;
            if (tag != null) {
                map = QueryString.parseQueryString(tag.getVal(), true);
            }
            SdtPr.Picture pic = this.getPicture(sdtPr);
            if (sdtPr.getDataBinding() != null && pic != null) {
                log.debug("pic handling");
                sdt.getSdtContent().getContent().clear();
                StaXBindingHandler staXBindingHandler = this;
                sdt.getSdtContent().getContent().add(this.xpathInjectImage((WordprocessingMLPackage)BindingTraverserStAX.this.pkg, BindingTraverserStAX.this.part, sdtPr.getDataBinding(), sdt, staXBindingHandler.stack.peek()));
            } else if (map != null && map.containsKey("od:ContentType") && map.get("od:ContentType").equals("application/xhtml+xml")) {
                log.error("TODO: add HTML import support");
            } else if (map != null && map.containsKey("od:condition")) {
                BindingTraverserNonXSLT traverser = new BindingTraverserNonXSLT();
                traverser.traverseToBind(BindingTraverserStAX.this.part, sdt, BindingTraverserStAX.this.xpathsMap);
            } else if (map != null && map.containsKey("od:rptd")) {
                BindingTraverserNonXSLT traverser = new BindingTraverserNonXSLT();
                traverser.traverseToBind(BindingTraverserStAX.this.part, sdt, BindingTraverserStAX.this.xpathsMap);
            } else if (map == null || !map.containsKey("od:RptPosCon")) {
                if (map != null && map.containsKey("od:xpath")) {
                    log.debug("OpenDoPEHandler.BINDING_ROLE_XPATH, " + sdtPr.getDataBinding().getXpath());
                    if (log.isDebugEnabled()) {
                        log.debug(XmlUtils.marshaltoString(sdt));
                    }
                    boolean isMultiline = this.isMultiline(sdtPr);
                    Object o = null;
                    if (sdt.getSdtContent().getContent().size() > 0) {
                        o = sdt.getSdtContent().getContent().get(0);
                        o = XmlUtils.unwrap(o);
                        log.debug(o.getClass().getName());
                    }
                    if (o != null) {
                        if (o instanceof P) {
                            P p = (P)o;
                            p.getContent().clear();
                            p.getContent().addAll(this.xpathGenerateRuns((WordprocessingMLPackage)BindingTraverserStAX.this.pkg, BindingTraverserStAX.this.part, sdtPr, sdtPr.getDataBinding(), null, isMultiline));
                        } else if (o instanceof Tc) {
                            Tc tc = (Tc)o;
                            P p = null;
                            if (tc.getContent().size() > 0) {
                                Object o2 = tc.getContent().get(0);
                                log.debug(o2.getClass().getName());
                                if (o2 instanceof P) {
                                    p = (P)o2;
                                    p.getContent().clear();
                                }
                            }
                            if (p == null) {
                                p = new P();
                                tc.getContent().add(p);
                            }
                            p.getContent().addAll(this.xpathGenerateRuns((WordprocessingMLPackage)BindingTraverserStAX.this.pkg, BindingTraverserStAX.this.part, sdtPr, sdtPr.getDataBinding(), null, isMultiline));
                        }
                    } else {
                        sdt.getSdtContent().getContent().clear();
                        sdt.getSdtContent().getContent().addAll(this.xpathGenerateRuns((WordprocessingMLPackage)BindingTraverserStAX.this.pkg, BindingTraverserStAX.this.part, sdtPr, sdtPr.getDataBinding(), null, isMultiline));
                    }
                } else if (sdtPr.getDataBinding() != null && !this.isRichText(sdtPr)) {
                    log.debug("not rich text, " + sdtPr.getDataBinding());
                    sdt.getSdtContent().getContent().clear();
                    sdt.getSdtContent().getContent().addAll(this.xpathGenerateRuns((WordprocessingMLPackage)BindingTraverserStAX.this.pkg, BindingTraverserStAX.this.part, sdtPr, sdtPr.getDataBinding(), null, false));
                } else {
                    log.info("Found an SDT without binding information; traversing for nested...");
                    if (log.isDebugEnabled()) {
                        log.debug(XmlUtils.marshaltoString(sdtPr));
                    }
                    BindingTraverserNonXSLT traverser = new BindingTraverserNonXSLT();
                    traverser.traverseToBind(BindingTraverserStAX.this.part, sdt, BindingTraverserStAX.this.xpathsMap);
                }
            }
            return results;
        }

        private Object xpathInjectImage(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, CTDataBinding dataBinding, SdtElement sdt, String sdtParent) {
            ExtentFinder ef = new ExtentFinder();
            new TraversalUtil(sdt.getSdtContent().getContent(), ef);
            HashMap<String, CustomXmlPart> customXmlDataStorageParts = BindingTraverserStAX.this.pkg.getCustomXmlDataStorageParts();
            CustomXmlPart part = (CustomXmlPart)customXmlDataStorageParts.get(dataBinding.getStoreItemID().toLowerCase());
            if (part == null) {
                log.error("Couldn't locate part by storeItemId " + dataBinding.getStoreItemID());
                return null;
            }
            try {
                String r = part.xpathGetString(dataBinding.getXpath(), dataBinding.getPrefixMappings());
                log.debug(dataBinding.getXpath() + " yielded result " + r);
                byte[] bytes = Base64.decodeBase64(r.getBytes("UTF8"));
                BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)wmlPackage, (Part)sourcePart, bytes);
                String filenameHint = null;
                String altText = null;
                int id1 = 0;
                int id2 = 1;
                Inline inline = null;
                long cxl = 0L;
                long cyl = 0L;
                try {
                    cxl = ef.getExtent().getCx();
                    cyl = ef.getExtent().getCy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (cxl == 0L || cyl == 0L) {
                    log.debug("image size - from image");
                    inline = imagePart.createImageInline(filenameHint, altText, (long)id1, id2, false);
                } else {
                    log.debug("image size - from content control size");
                    ImageSize size = imagePart.getImageInfo().getSize();
                    double ratio = (double)size.getHeightPx() / (double)size.getWidthPx();
                    log.debug("fit ratio: " + ratio);
                    if (ratio > 1.0) {
                        cxl = (long)((double)cyl / ratio);
                    } else {
                        cyl = (long)((double)cxl * ratio);
                    }
                    inline = imagePart.createImageInline(filenameHint, altText, id1, id2, cxl, cyl, false);
                }
                ObjectFactory factory = new ObjectFactory();
                Tc tc = factory.createTc();
                P p = factory.createP();
                if (sdtParent.equals("tr")) {
                    tc.getContent().add(p);
                }
                R run = factory.createR();
                if (sdtParent.equals("body") || sdtParent.equals("tr") || sdtParent.equals("tc")) {
                    p.getContent().add(run);
                }
                Drawing drawing = factory.createDrawing();
                run.getContent().add(drawing);
                drawing.getAnchorOrInline().add(inline);
                if (sdtParent.equals("body") || sdtParent.equals("tc") || sdtParent.equals("SdtContentBlock")) {
                    return p;
                }
                if (sdtParent.equals("tr")) {
                    return tc;
                }
                if (sdtParent.equals("p")) {
                    return run;
                }
                if (sdtParent.equals("SdtElement")) {
                    List<Object> sdtContent = sdt.getSdtContent().getContent();
                    if (sdtContent.size() == 0) {
                        if (sdtParent.equals("SdtRun")) {
                            return run;
                        }
                        if (log.isErrorEnabled()) {
                            log.error("empty image template in sdt: " + XmlUtils.marshaltoString((Object)sdt.getSdtPr(), true) + sdtParent.getClass().getName());
                        }
                    } else {
                        Object contentChild = sdtContent.get(0);
                        log.info("contentChild: " + contentChild.getClass().getName());
                        if (contentChild instanceof P) {
                            p.getContent().add(run);
                            return p;
                        }
                        if (contentChild instanceof R) {
                            return r;
                        }
                        log.error("how to inject image for unexpected sdt's content: " + contentChild.getClass().getName());
                    }
                } else {
                    log.error("how to inject image for unexpected sdt's parent: " + sdtParent.getClass().getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private SdtPr.Picture getPicture(SdtPr sdtPr) {
            for (Object o : sdtPr.getRPrOrAliasOrLock()) {
                if (!((o = XmlUtils.unwrap(o)) instanceof SdtPr.Picture)) continue;
                return (SdtPr.Picture)o;
            }
            return null;
        }

        private boolean isRichText(SdtPr sdtPr) {
            for (Object o : sdtPr.getRPrOrAliasOrLock()) {
                if (!((o = XmlUtils.unwrap(o)) instanceof SdtPr.RichText)) continue;
                return true;
            }
            return false;
        }

        private boolean isMultiline(SdtPr sdtPr) {
            for (Object o : sdtPr.getRPrOrAliasOrLock()) {
                if (!((o = XmlUtils.unwrap(o)) instanceof CTSdtText)) continue;
                return ((CTSdtText)o).isMultiLine();
            }
            return false;
        }

        public List<Object> xpathGenerateRuns(WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, SdtPr sdtPr, CTDataBinding dataBinding, RPr rPr, boolean multiLine) {
            HashMap<String, CustomXmlPart> customXmlDataStorageParts = pkg.getCustomXmlDataStorageParts();
            String r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, dataBinding);
            if (r == null) {
                return null;
            }
            ArrayList<Object> contents = new ArrayList<Object>();
            try {
                log.info(dataBinding.getXpath() + " yielded result " + r);
                ObjectFactory factory = new ObjectFactory();
                StringTokenizer st = new StringTokenizer(r, "\n\r\f");
                if (multiLine) {
                    boolean firsttoken = true;
                    while (st.hasMoreTokens()) {
                        String line = st.nextToken();
                        if (firsttoken) {
                            firsttoken = false;
                        } else {
                            this.addBrRunToDocFrag(contents, rPr);
                        }
                        this.processString(sourcePart, contents, line, sdtPr, rPr);
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    while (st.hasMoreTokens()) {
                        sb.append(st.nextToken());
                    }
                    this.processString(sourcePart, contents, sb.toString(), sdtPr, rPr);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
                return null;
            }
            return contents;
        }

        private void addBrRunToDocFrag(List<Object> contents, RPr rPr) throws JAXBException {
            R run = Context.getWmlObjectFactory().createR();
            if (rPr != null) {
                run.setRPr(rPr);
            }
            run.getRunContent().add(Context.getWmlObjectFactory().createBr());
            contents.add(run);
        }

        private void processString(JaxbXmlPart sourcePart, List<Object> contents, String text, SdtPr sdtPr, RPr rPr) throws JAXBException {
            int pos = BindingHandler.getHyperlinkResolver().getIndexOfURL(text);
            if (pos == -1 || BindingHandler.getHyperlinkStyleId() == null) {
                log.debug("No hyperlink");
                this.addRunToDocFrag(sourcePart, contents, text, rPr);
                return;
            }
            sdtPr.setDataBinding(null);
            Object sdtPrText = null;
            for (Object o : sdtPr.getRPrOrAliasOrLock()) {
                Object unwrapped = XmlUtils.unwrap(o);
                if (!(unwrapped instanceof CTSdtText)) continue;
                sdtPrText = o;
                break;
            }
            if (sdtPrText != null) {
                sdtPr.getRPrOrAliasOrLock().remove(sdtPrText);
            }
            if (pos == 0) {
                int spacePos = text.indexOf(" ");
                if (spacePos == -1) {
                    this.addHyperlinkToDocFrag(sourcePart, contents, text);
                    return;
                }
                String first = text.substring(0, spacePos);
                String rest = text.substring(spacePos);
                this.addHyperlinkToDocFrag(sourcePart, contents, first);
                this.processString(sourcePart, contents, rest, sdtPr, rPr);
                return;
            }
            String first = text.substring(0, pos);
            String rest = text.substring(pos);
            this.addRunToDocFrag(sourcePart, contents, first, rPr);
            this.processString(sourcePart, contents, rest, sdtPr, rPr);
        }

        private void addRunToDocFrag(JaxbXmlPart sourcePart, List<Object> contents, String string, RPr rPr) {
            R run = Context.getWmlObjectFactory().createR();
            if (rPr != null) {
                run.setRPr(rPr);
            }
            Text text = Context.getWmlObjectFactory().createText();
            run.getRunContent().add(text);
            if (string.startsWith(" ") || string.endsWith(" ")) {
                text.setSpace("preserve");
            }
            text.setValue(string);
            contents.add(run);
        }

        private void addHyperlinkToDocFrag(JaxbXmlPart sourcePart, List<Object> contents, String url) throws JAXBException {
            org.docx4j.relationships.ObjectFactory factory = new org.docx4j.relationships.ObjectFactory();
            Relationship rel = factory.createRelationship();
            rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
            rel.setTarget(url);
            rel.setTargetMode("External");
            sourcePart.getRelationshipsPart().addRelationship(rel);
            String hpl = "<w:hyperlink r:id=\"" + rel.getId() + "\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" ><w:r><w:rPr><w:rStyle w:val=\"" + BindingHandler.getHyperlinkStyleId() + "\" /></w:rPr><w:t>" + url + "</w:t></w:r></w:hyperlink>";
            contents.add((P.Hyperlink)XmlUtils.unmarshalString(hpl));
        }
    }

    static class ExtentFinder
    extends TraversalUtil.CallbackImpl {
        private CTPositiveSize2D extent;

        ExtentFinder() {
        }

        public CTPositiveSize2D getExtent() {
            return this.extent;
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof Drawing) {
                Object o2 = ((Drawing)o).getAnchorOrInline().get(0);
                if (o2 instanceof Anchor) {
                    this.extent = ((Anchor)o2).getExtent();
                    return null;
                }
                if (o2 instanceof Inline) {
                    this.extent = ((Inline)o2).getExtent();
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return this.extent == null;
        }
    }
}

