/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.JAXBElement;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.finders.RangeFinder;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BookmarkHandlerStAX;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkup;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.CTPerm;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RangePermissionStart;
import org.docx4j.wml.Text;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarkRenumber {
    protected static Logger log = LoggerFactory.getLogger(BookmarkRenumber.class);
    private WordprocessingMLPackage wordMLPackage;
    private AtomicInteger bookmarkId = null;

    private BookmarkRenumber() {
    }

    BookmarkRenumber(WordprocessingMLPackage wordMLPackage) {
        this.wordMLPackage = wordMLPackage;
    }

    protected AtomicInteger getBookmarkId() {
        if (this.bookmarkId == null) {
            this.bookmarkId = new AtomicInteger(this.initBookmarkIdStart());
        }
        return this.bookmarkId;
    }

    private int initBookmarkIdStart() {
        int highestId = 0;
        if (this.wordMLPackage.getMainDocumentPart().isUnmarshalled()) {
            log.debug(" MDP already unmarshalled.");
            RangeFinder rt = new RangeFinder();
            new TraversalUtil(this.wordMLPackage.getMainDocumentPart().getContent(), rt);
            for (CTBookmark bm : rt.getStarts()) {
                BigInteger id = bm.getId();
                if (id == null || id.intValue() <= highestId) continue;
                highestId = id.intValue();
            }
        } else {
            log.debug(" MDP not unmarshalled so can usefully use StAX.");
            BookmarkHandlerStAX bh = new BookmarkHandlerStAX();
            try {
                this.wordMLPackage.getMainDocumentPart().pipe(bh, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            highestId = bh.getHighestId();
        }
        return highestId + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fixRange(List<Object> paragraphs, String startElement, String endElement, String refElement, long global, int instanceNumber) throws Exception {
        String tmpId;
        BigInteger tmpId2;
        Method setIdMethod;
        Child mr;
        Object id;
        RangeTraverser rt = new RangeTraverser(startElement, endElement, refElement);
        new TraversalUtil(paragraphs, rt);
        Method startIdMethod = null;
        Method endIdMethod = null;
        if (startElement.equals("CTBookmark")) {
            block12: for (CTBookmark bm : rt.deletes) {
                BigInteger unwantedId = bm.getId();
                try {
                    List<Object> theList = null;
                    theList = bm.getParent() instanceof List ? (List<Object>)bm.getParent() : ((ContentAccessor)bm.getParent()).getContent();
                    Object deleteMe = null;
                    for (Object ox : theList) {
                        if (!XmlUtils.unwrap(ox).equals(bm)) continue;
                        deleteMe = ox;
                        break;
                    }
                    if (deleteMe != null) {
                        theList.remove(deleteMe);
                    }
                }
                catch (ClassCastException e) {
                    log.error(e.getMessage(), e);
                }
                for (Object o : rt.ends) {
                    if (endIdMethod == null) {
                        endIdMethod = this.findGetIdMethod(o);
                    }
                    id = null;
                    try {
                        id = this.getId(endIdMethod, o);
                        if (unwantedId.compareTo((BigInteger)id) != 0) continue;
                        try {
                            CTMarkupRange mr2 = (CTMarkupRange)o;
                            List<Object> theList = null;
                            theList = mr2.getParent() instanceof List ? (List<Object>)mr2.getParent() : ((ContentAccessor)mr2.getParent()).getContent();
                            Object deleteMe = null;
                            for (Object ox : theList) {
                                if (!XmlUtils.unwrap(ox).equals(mr2)) continue;
                                deleteMe = ox;
                                break;
                            }
                            if (deleteMe != null) {
                                theList.remove(deleteMe);
                            }
                        }
                        catch (ClassCastException e) {
                            log.error(e.getMessage(), e);
                        }
                        rt.ends.remove(o);
                    }
                    catch (ClassCastException cce) {
                        id = BookmarkRenumber.getIdString(endIdMethod, o);
                        if (!unwantedId.toString().equals(id)) continue;
                        try {
                            Object ox;
                            mr = (CTMarkupRange)o;
                            List<Object> theList = null;
                            theList = ((CTMarkup)mr).getParent() instanceof List ? (List<Object>)((CTMarkup)mr).getParent() : ((ContentAccessor)((CTMarkup)mr).getParent()).getContent();
                            Object deleteMe = null;
                            ox = theList.iterator();
                            while (ox.hasNext()) {
                                Object ox2 = ox.next();
                                if (!XmlUtils.unwrap(ox2).equals(mr)) continue;
                                deleteMe = ox2;
                            }
                            if (deleteMe != null) {
                                theList.remove(deleteMe);
                            }
                        }
                        catch (ClassCastException e) {
                            log.error(e.getMessage(), e);
                        }
                        rt.ends.remove(o);
                    }
                    continue block12;
                }
            }
        }
        int counter = 0;
        for (Object o : rt.starts) {
            ++counter;
            long newId = this.getBookmarkId().getAndIncrement();
            if (startIdMethod == null) {
                startIdMethod = this.findGetIdMethod(o);
            }
            id = null;
            boolean matched = false;
            try {
                id = this.getId(startIdMethod, o);
                if (startElement.equals("CTBookmark")) {
                    setIdMethod = this.findSetIdMethod(o);
                    if (id instanceof BigInteger) {
                        setIdMethod.invoke(o, BigInteger.valueOf(newId));
                    }
                    String oldName = ((CTBookmark)o).getName();
                    String newName = (String)oldName + "_" + instanceNumber;
                    ((CTBookmark)o).setName(newName);
                    for (Object ref : rt.refs) {
                        Text fieldInstr = (Text)ref;
                        String fieldVal = fieldInstr.getValue();
                        if (!fieldVal.contains("REF ") || !fieldVal.contains(" " + (String)oldName + " ")) continue;
                        fieldInstr.setValue(fieldVal.replace(oldName, newName));
                    }
                }
                for (Object end : rt.ends) {
                    if (endIdMethod == null) {
                        endIdMethod = this.findGetIdMethod(end);
                    }
                    if ((tmpId2 = this.getId(endIdMethod, end)) == null || !tmpId2.equals(id)) continue;
                    matched = true;
                    if (!endElement.equals("CTMarkupRange")) break;
                    Method setIdMethod2 = this.findSetIdMethod(end);
                    if (id instanceof BigInteger) {
                        setIdMethod2.invoke(end, BigInteger.valueOf(newId));
                    }
                    break;
                }
            }
            catch (ClassCastException cce) {
                Object end;
                id = BookmarkRenumber.getIdString(startIdMethod, o);
                end = rt.ends.iterator();
                while (end.hasNext()) {
                    Object end2 = end.next();
                    if (endIdMethod == null) {
                        endIdMethod = this.findGetIdMethod(end2);
                    }
                    if ((tmpId = BookmarkRenumber.getIdString(endIdMethod, end2)) == null || !tmpId.equals(id)) continue;
                    matched = true;
                    break;
                }
            }
            if (matched) continue;
            if (endElement.equals("CTMarkupRange")) {
                mr = Context.getWmlObjectFactory().createCTMarkupRange();
                ((CTMarkup)mr).setId(BigInteger.valueOf(newId));
                JAXBElement<CTMarkupRange> bmEnd = Context.getWmlObjectFactory().createBodyBookmarkEnd((CTMarkupRange)mr);
                paragraphs.add(bmEnd);
            } else if (endElement.equals("CTPerm")) {
                mr = Context.getWmlObjectFactory().createCTPerm();
                ((CTPerm)mr).setId((String)id);
                JAXBElement<CTPerm> rEnd = Context.getWmlObjectFactory().createBodyPermEnd((CTPerm)mr);
                paragraphs.add(rEnd);
            } else {
                paragraphs.add(this.createObject(endElement, id));
            }
            if (refElement == null) continue;
            P p = Context.getWmlObjectFactory().createP();
            R r = Context.getWmlObjectFactory().createR();
            p.getParagraphContent().add(r);
            R.CommentReference cr = Context.getWmlObjectFactory().createRCommentReference();
            cr.setId((BigInteger)id);
            r.getRunContent().add(cr);
            paragraphs.add(p);
        }
        Iterator<Object> iterator = rt.ends.iterator();
        while (iterator.hasNext()) {
            Object o;
            o = iterator.next();
            ++counter;
            long newId = this.getBookmarkId().getAndIncrement();
            if (endIdMethod == null) {
                endIdMethod = this.findGetIdMethod(o);
            }
            id = null;
            boolean matched = false;
            try {
                id = this.getId(endIdMethod, o);
                for (Object start : rt.starts) {
                    if (startIdMethod == null) {
                        startIdMethod = this.findGetIdMethod(start);
                    }
                    if ((tmpId2 = this.getId(startIdMethod, start)) == null || !tmpId2.equals(id)) continue;
                    matched = true;
                }
            }
            catch (ClassCastException cce) {
                id = BookmarkRenumber.getIdString(endIdMethod, o);
                for (Object start : rt.starts) {
                    if (startIdMethod == null) {
                        startIdMethod = this.findGetIdMethod(start);
                    }
                    if ((tmpId = BookmarkRenumber.getIdString(startIdMethod, start)) == null || !tmpId.equals(id)) continue;
                    matched = true;
                    break;
                }
            }
            if (matched) continue;
            if (endElement.equals("CTMarkupRange")) {
                setIdMethod = this.findSetIdMethod(o);
                if (id instanceof BigInteger) {
                    setIdMethod.invoke(o, BigInteger.valueOf(newId));
                }
            }
            if (endElement.equals("CTPerm")) {
                mr = Context.getWmlObjectFactory().createRangePermissionStart();
                ((CTPerm)mr).setId((String)id);
                JAXBElement<RangePermissionStart> rs = Context.getWmlObjectFactory().createBodyPermStart((RangePermissionStart)mr);
                paragraphs.add(rs);
                continue;
            }
            if (startElement.equals("CTBookmark")) {
                log.debug("Add w:bookmarkStart");
                Object newObject = this.createObject(startElement, newId);
                paragraphs.add(0, newObject);
                if (!(newObject instanceof CTBookmark)) continue;
                String newName = global + "_bookmark" + counter;
                ((CTBookmark)newObject).setName(newName);
                log.info(".. " + newName);
                continue;
            }
            paragraphs.add(0, this.createObject(startElement, id));
        }
        return;
    }

    private Method findGetIdMethod(Object o) throws Exception {
        Method[] methods = o.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("getId")) continue;
            return methods[i];
        }
        log.error("Couldn't find getId for " + o.getClass().getName());
        return null;
    }

    private Method findSetIdMethod(Object o) throws Exception {
        Method[] methods = o.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("setId")) continue;
            return methods[i];
        }
        log.error("Couldn't find setId for " + o.getClass().getName());
        return null;
    }

    private BigInteger getId(Method idMethod, Object o) throws Exception {
        if (idMethod != null) {
            return (BigInteger)idMethod.invoke(o, new Object[0]);
        }
        return null;
    }

    private static String getIdString(Method idMethod, Object o) throws Exception {
        if (idMethod != null) {
            return (String)idMethod.invoke(o, new Object[0]);
        }
        return null;
    }

    private Object createObject(String name, Object id) throws Exception {
        ObjectFactory factory = Context.getWmlObjectFactory();
        log.debug("Looking for method create" + name);
        Method method = factory.getClass().getDeclaredMethod("create" + name, new Class[0]);
        Object newObject = method.invoke((Object)factory, new Object[0]);
        Method setIdMethod = this.findSetIdMethod(newObject);
        if (setIdMethod == null) {
            log.error("Couldn't findSetIdMethod for " + newObject.getClass().getName());
        } else {
            log.debug("FOund findSetIdMethod for " + newObject.getClass().getName());
        }
        Class<?> param = setIdMethod.getParameterTypes()[0];
        setIdMethod.invoke(newObject, this.convertObject(id, param));
        return newObject;
    }

    private Object convertObject(Object id, Class c) throws Docx4JException {
        if (c.isAssignableFrom(id.getClass())) {
            return id;
        }
        if (c == BigInteger.class && id instanceof Long) {
            return BigInteger.valueOf((Long)id);
        }
        throw new Docx4JException("TODO: Convert " + id.getClass().getName() + " to " + c.getName());
    }

    static class RangeTraverser
    extends TraversalUtil.CallbackImpl {
        List<Object> starts = new ArrayList<Object>();
        List<Object> ends = new ArrayList<Object>();
        List<Object> refs = new ArrayList<Object>();
        List<CTBookmark> deletes = new ArrayList<CTBookmark>();
        String startElement;
        String endElement;
        String refElement;

        RangeTraverser(String startElement, String endElement, String refElement) {
            this.startElement = "org.docx4j.wml." + startElement;
            this.endElement = "org.docx4j.wml." + endElement;
            this.refElement = "org.docx4j.wml." + refElement;
        }

        @Override
        public List<Object> apply(Object o) {
            if (o.getClass().getName().equals(this.startElement)) {
                if (o instanceof CTBookmark) {
                    CTBookmark bookmark = (CTBookmark)o;
                    if (bookmark.getName().equals("_GoBack")) {
                        this.deletes.add(bookmark);
                    } else {
                        this.starts.add(o);
                    }
                } else {
                    this.starts.add(o);
                }
            }
            if (o.getClass().getName().equals(this.endElement)) {
                this.ends.add(o);
            }
            if (o.getClass().getName().equals(this.refElement)) {
                this.refs.add(o);
            } else if (this.startElement.equals("org.docx4j.wml.CTBookmark") && o instanceof JAXBElement && ((JAXBElement)o).getName().getLocalPart().equals("instrText")) {
                this.refs.add(XmlUtils.unwrap(o));
            }
            return null;
        }
    }
}

