/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.util.JAXBResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class OpenDoPEIntegrityAfterBinding {
    private static Logger log = LoggerFactory.getLogger(OpenDoPEIntegrityAfterBinding.class);
    static Templates xslt;

    public static void log(String message) {
        log.info(message);
    }

    public void process(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        this.process(wordMLPackage.getMainDocumentPart());
        RelationshipsPart rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                this.process((HeaderPart)rp.getPart(r));
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            this.process((FooterPart)rp.getPart(r));
        }
    }

    private void process(JaxbXmlPart part) throws Docx4JException {
        block14: {
            log.info("/n Processing " + part.getPartName().getName());
            OpcPackage pkg = part.getPackage();
            Source source = null;
            Result result = null;
            XMLStreamReader xmlReader = null;
            ByteArrayOutputStream baos = null;
            Document doc = null;
            if (part.isUnmarshalled()) {
                log.debug(part.getPartName().getName() + " already unmarshalled.");
                doc = XmlUtils.marshaltoW3CDomDocument(part.getJaxbElement());
                source = new DOMSource(doc);
                result = XmlUtils.prepareJAXBResult(Context.jc);
            } else {
                log.debug(part.getPartName().getName() + " not yet unmarshalled.");
                try {
                    xmlReader = part.getXMLStreamReader(null);
                    source = new StAXSource(xmlReader);
                    baos = new ByteArrayOutputStream();
                    result = new StreamResult(baos);
                }
                catch (Exception e) {
                    throw new Docx4JException(e.getMessage(), e);
                }
            }
            HashMap<String, Object> transformParameters = new HashMap<String, Object>();
            transformParameters.put("OpenDoPEIntegrityAfterBinding", this);
            try {
                XmlUtils.transform(source, xslt, transformParameters, result);
                if (result instanceof JAXBResult) {
                    try {
                        part.setJaxbElement(((JAXBResult)result).getResult());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                        log.error("Input in question:" + XmlUtils.w3CDomNodeToString(doc));
                        log.error("Now trying DOMResult..");
                        result = new DOMResult();
                        XmlUtils.transform(doc, xslt, transformParameters, result);
                        if (log.isDebugEnabled()) {
                            Document docResult = (Document)((DOMResult)result).getNode();
                            Object o = XmlUtils.unmarshal((Document)((DOMResult)result).getNode());
                            part.setJaxbElement(o);
                            break block14;
                        }
                        Object o = XmlUtils.unmarshal((Document)((DOMResult)result).getNode());
                        part.setJaxbElement(o);
                    }
                    break block14;
                }
                try {
                    xmlReader.close();
                    baos.flush();
                    if (log.isDebugEnabled()) {
                        byte[] bytes = baos.toByteArray();
                        log.debug(new String(bytes));
                        part.replacePartContent(bytes);
                    } else {
                        part.replacePartContent(baos.toByteArray());
                    }
                    baos.close();
                }
                catch (Exception e) {
                    throw new Docx4JException(e.getMessage(), e);
                }
            }
            catch (Exception e) {
                throw new Docx4JException("Problems ensuring integrity", e);
            }
        }
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/model/datastorage/OpenDoPEIntegrityAfterBinding.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
    }
}

