/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.docx4j.Docx4jProperties;

public class NumberExtractor {
    static String regex = "([\\+-]?(\\.\\d+))|([\\+-]?[0](\\.\\d+))|([\\+-]?(\\d+)(\\.\\d*)?)";
    static String decimalSymbolFallback;
    static String groupingSeparator;
    static Pattern pattern;
    private String decimalSymbol;

    public NumberExtractor(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol == null ? decimalSymbolFallback : decimalSymbol;
    }

    private String prepare(String string) {
        string = ".".equals(groupingSeparator) ? string.replaceAll("\\" + groupingSeparator, "") : string.replaceAll(groupingSeparator, "");
        if (this.decimalSymbol.equals(".")) {
            return string;
        }
        return string.replace(this.decimalSymbol, ".");
    }

    public String extractNumber(String string) throws IllegalStateException {
        try {
            Matcher makeMatch = pattern.matcher(this.prepare(string));
            if (makeMatch.find()) {
                String matchingSubstring = makeMatch.group();
                return matchingSubstring;
            }
            throw new IllegalStateException(string + " does not contain a number");
        }
        catch (IllegalStateException noMatch) {
            return string;
        }
    }

    public static void main(String[] args) {
        NumberExtractor nex = new NumberExtractor(".");
        System.out.println(nex.extractNumber("\u20ac HEH EUR"));
    }

    static {
        pattern = Pattern.compile(regex);
        decimalSymbolFallback = Docx4jProperties.getProperty("docx4j.Fields.Numbers.DecimalSymbol", ".");
        groupingSeparator = Docx4jProperties.getProperty("docx4j.Fields.Numbers.GroupingSeparator", ",");
    }
}

