/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.table;

import org.docx4j.UnitsOfMeasurement;
import org.docx4j.model.properties.table.AbstractTableProperty;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.TcPrInner;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractBorder
extends AbstractTableProperty {
    public String CSS_NAME_BASE;
    public String CSS_NAME__STYLE;
    public String CSS_NAME__WIDTH;
    public String CSS_NAME__COLOR;

    public AbstractBorder(CTBorder val, String css_name) {
        this.init(css_name);
        this.setObject(val);
    }

    private void init(String css_name) {
        this.CSS_NAME_BASE = css_name;
        this.CSS_NAME__STYLE = this.CSS_NAME_BASE + "-style";
        this.CSS_NAME__WIDTH = this.CSS_NAME_BASE + "-width";
        this.CSS_NAME__COLOR = this.CSS_NAME_BASE + "-color";
    }

    public AbstractBorder(CSSValue value, String css_name) {
        this.init(css_name);
    }

    @Override
    public String getCssProperty() {
        CTBorder border = (CTBorder)this.getObject();
        if (border == null) {
            return "";
        }
        String val = "";
        if (border.getVal() != null) {
            STBorder stBorder = border.getVal();
            log.debug("border: " + stBorder);
            if (stBorder.equals((Object)STBorder.NIL) || stBorder == STBorder.NONE) {
                val = AbstractBorder.composeCss(this.CSS_NAME__STYLE, "none");
            } else if (stBorder == STBorder.SINGLE) {
                val = AbstractBorder.composeCss(this.CSS_NAME__STYLE, "solid");
            } else if (stBorder == STBorder.DOUBLE || stBorder == STBorder.DOTTED || stBorder == STBorder.DASHED || stBorder == STBorder.OUTSET || stBorder == STBorder.INSET) {
                val = AbstractBorder.composeCss(this.CSS_NAME__STYLE, stBorder.value());
            } else {
                log.warn("Falling back to solid");
                val = AbstractBorder.composeCss(this.CSS_NAME__STYLE, "solid");
            }
        }
        String sz = "";
        if (border.getSz() != null) {
            float mm4 = this.eighthsToMM(border.getSz().intValue());
            sz = (double)mm4 < 0.262 ? AbstractBorder.composeCss(this.CSS_NAME__WIDTH, "1px") : AbstractBorder.composeCss(this.CSS_NAME__WIDTH, UnitsOfMeasurement.format2DP.format(mm4) + "mm");
        }
        String color = "";
        if (border.getColor() != null) {
            color = border.getColor().equals("auto") ? AbstractBorder.composeCss(this.CSS_NAME__COLOR, "#000000") : AbstractBorder.composeCss(this.CSS_NAME__COLOR, "#" + border.getColor());
        }
        return val + sz + color;
    }

    public float eighthsToMM(int eighths) {
        float inches = (float)eighths / 576.0f;
        return inches / 0.0394f;
    }

    @Override
    public void setXslFO(Element foElement) {
        CTBorder border = (CTBorder)this.getObject();
        if (border == null) {
            return;
        }
        if (border.getVal() != null) {
            STBorder stBorder = border.getVal();
            log.debug("border: " + stBorder);
            if (stBorder.equals((Object)STBorder.NIL) || stBorder == STBorder.NONE) {
                foElement.setAttribute(this.CSS_NAME__STYLE, "none");
            } else if (stBorder == STBorder.SINGLE) {
                foElement.setAttribute(this.CSS_NAME__STYLE, "solid");
            } else if (stBorder == STBorder.DOUBLE || stBorder == STBorder.DOTTED || stBorder == STBorder.DASHED || stBorder == STBorder.OUTSET || stBorder == STBorder.INSET) {
                foElement.setAttribute(this.CSS_NAME__STYLE, stBorder.value());
            } else {
                log.warn("Falling back to solid");
                foElement.setAttribute(this.CSS_NAME__STYLE, "solid");
            }
        }
        if (border.getSz() != null) {
            float pt = (float)border.getSz().intValue() / 8.0f;
            foElement.setAttribute(this.CSS_NAME__WIDTH, UnitsOfMeasurement.format2DP.format(pt) + "pt");
        }
        if (border.getColor() != null) {
            if (border.getColor().equals("auto")) {
                foElement.setAttribute(this.CSS_NAME__COLOR, "#000000");
            } else {
                foElement.setAttribute(this.CSS_NAME__COLOR, "#" + border.getColor());
            }
        }
    }

    public abstract void set(TcPrInner var1);
}

