/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.styles;

import jakarta.xml.bind.JAXBElement;
import java.math.BigInteger;
import java.util.List;
import javax.xml.namespace.QName;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.sharedtypes.STOnOff;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTCnf;
import org.docx4j.wml.CTEm;
import org.docx4j.wml.CTFramePr;
import org.docx4j.wml.CTHeight;
import org.docx4j.wml.CTLanguage;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTShortHexNumber;
import org.docx4j.wml.CTSignedHpsMeasure;
import org.docx4j.wml.CTSignedTwipsMeasure;
import org.docx4j.wml.CTTabStop;
import org.docx4j.wml.CTTblCellMar;
import org.docx4j.wml.CTTblLayoutType;
import org.docx4j.wml.CTTblLook;
import org.docx4j.wml.CTTblOverlap;
import org.docx4j.wml.CTTblPPr;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.CTTblStylePr;
import org.docx4j.wml.CTTextEffect;
import org.docx4j.wml.CTTextScale;
import org.docx4j.wml.CTTextboxTightWrap;
import org.docx4j.wml.CTTrPrBase;
import org.docx4j.wml.CTVerticalAlignRun;
import org.docx4j.wml.CTVerticalJc;
import org.docx4j.wml.Color;
import org.docx4j.wml.Highlight;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.Jc;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STDropCap;
import org.docx4j.wml.STEm;
import org.docx4j.wml.STHAnchor;
import org.docx4j.wml.STHeightRule;
import org.docx4j.wml.STHint;
import org.docx4j.wml.STLineSpacingRule;
import org.docx4j.wml.STShd;
import org.docx4j.wml.STTblLayoutType;
import org.docx4j.wml.STTblOverlap;
import org.docx4j.wml.STTblStyleOverrideType;
import org.docx4j.wml.STTextEffect;
import org.docx4j.wml.STTheme;
import org.docx4j.wml.STThemeColor;
import org.docx4j.wml.STVAnchor;
import org.docx4j.wml.STVerticalAlignRun;
import org.docx4j.wml.STVerticalJc;
import org.docx4j.wml.STWrap;
import org.docx4j.wml.STXAlign;
import org.docx4j.wml.STYAlign;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tabs;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.TcMar;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.TextDirection;
import org.docx4j.wml.TrPr;
import org.docx4j.wml.U;
import org.docx4j.wml.UnderlineEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleUtil {
    protected static Logger log = LoggerFactory.getLogger(StyleUtil.class);
    public static final String CHARACTER_STYLE = "character";
    public static final String PARAGRAPH_STYLE = "paragraph";
    public static final String TABLE_STYLE = "table";
    public static final String NUMBERING_STYLE = "numbering";

    public static boolean areEqual(Style style1, Style style2, boolean compareIDs) {
        if (style1 == style2) {
            return true;
        }
        if (style1 != null && style2 == null || style1 == null && style2 != null) {
            return false;
        }
        if (compareIDs && !StyleUtil.areEqual(style1.getStyleId(), style2.getStyleId()) || !StyleUtil.areEqual(style1.getType(), style2.getType())) {
            return false;
        }
        if (CHARACTER_STYLE.equals(style1.getType())) {
            return StyleUtil.areEqual(style1.getBasedOn(), style2.getBasedOn()) && StyleUtil.areEqual(style1.getRPr(), style2.getRPr());
        }
        if (PARAGRAPH_STYLE.equals(style1.getType()) || NUMBERING_STYLE.equals(style1.getType())) {
            return StyleUtil.areEqual(style1.getBasedOn(), style2.getBasedOn()) && StyleUtil.areEqual(style1.getRPr(), style2.getRPr()) && StyleUtil.areEqual(style1.getPPr(), style2.getPPr());
        }
        if (TABLE_STYLE.equals(style1.getType())) {
            return StyleUtil.areEqual(style1.getBasedOn(), style2.getBasedOn()) && StyleUtil.areEqual(style1.getTblPr(), style2.getTblPr()) && StyleUtil.areEqual(style1.getTcPr(), style2.getTcPr()) && StyleUtil.areEqual(style1.getTblStylePr(), style2.getTblStylePr());
        }
        throw new IllegalArgumentException("Invalid style type: " + style1.getType());
    }

    public static boolean areEqual(PPr pPr1, PPr pPr2) {
        return pPr1 == pPr2 || pPr1 != null && pPr2 != null && StyleUtil.areEqual((PPrBase)pPr1, (PPrBase)pPr2) && StyleUtil.areEqual(pPr1.getRPr(), pPr2.getRPr()) && StyleUtil.areEqual(pPr1.getSectPr(), pPr2.getSectPr());
    }

    public static boolean areEqual(SectPr sectPr1, SectPr sectPr2) {
        log.warn("TODO: implementation for SectPr is incomplete; contributions welcome");
        return sectPr1 == sectPr2 || sectPr1 != null && sectPr2 != null && StyleUtil.areEqual(sectPr1.getFormProt(), sectPr2.getFormProt()) && StyleUtil.areEqual(sectPr1.getVAlign(), sectPr2.getVAlign()) && StyleUtil.areEqual(sectPr1.getNoEndnote(), sectPr2.getNoEndnote()) && StyleUtil.areEqual(sectPr1.getTitlePg(), sectPr2.getTitlePg()) && StyleUtil.areEqual(sectPr1.getTextDirection(), sectPr2.getTextDirection()) && StyleUtil.areEqual(sectPr1.getBidi(), sectPr2.getBidi()) && StyleUtil.areEqual(sectPr1.getRtlGutter(), sectPr2.getRtlGutter());
    }

    public static boolean areEqual(PPrBase pPrBase1, PPrBase pPrBase2) {
        return pPrBase1 == pPrBase2 || pPrBase1 != null && pPrBase2 != null && StyleUtil.areEqual(pPrBase1.getPStyle(), pPrBase2.getPStyle()) && StyleUtil.areEqual(pPrBase1.getKeepNext(), pPrBase2.getKeepNext()) && StyleUtil.areEqual(pPrBase1.getKeepLines(), pPrBase2.getKeepLines()) && StyleUtil.areEqual(pPrBase1.getPageBreakBefore(), pPrBase2.getPageBreakBefore()) && StyleUtil.areEqual(pPrBase1.getFramePr(), pPrBase2.getFramePr()) && StyleUtil.areEqual(pPrBase1.getWidowControl(), pPrBase2.getWidowControl()) && StyleUtil.areEqual(pPrBase1.getNumPr(), pPrBase2.getNumPr()) && StyleUtil.areEqual(pPrBase1.getSuppressLineNumbers(), pPrBase2.getSuppressLineNumbers()) && StyleUtil.areEqual(pPrBase1.getPBdr(), pPrBase2.getPBdr()) && StyleUtil.areEqual(pPrBase1.getShd(), pPrBase2.getShd()) && StyleUtil.areEqual(pPrBase1.getTabs(), pPrBase2.getTabs()) && StyleUtil.areEqual(pPrBase1.getSuppressAutoHyphens(), pPrBase2.getSuppressAutoHyphens()) && StyleUtil.areEqual(pPrBase1.getKinsoku(), pPrBase2.getKinsoku()) && StyleUtil.areEqual(pPrBase1.getWordWrap(), pPrBase2.getWordWrap()) && StyleUtil.areEqual(pPrBase1.getOverflowPunct(), pPrBase2.getOverflowPunct()) && StyleUtil.areEqual(pPrBase1.getTopLinePunct(), pPrBase2.getTopLinePunct()) && StyleUtil.areEqual(pPrBase1.getAutoSpaceDE(), pPrBase2.getAutoSpaceDE()) && StyleUtil.areEqual(pPrBase1.getAutoSpaceDN(), pPrBase2.getAutoSpaceDN()) && StyleUtil.areEqual(pPrBase1.getBidi(), pPrBase2.getBidi()) && StyleUtil.areEqual(pPrBase1.getAdjustRightInd(), pPrBase2.getAdjustRightInd()) && StyleUtil.areEqual(pPrBase1.getSnapToGrid(), pPrBase2.getSnapToGrid()) && StyleUtil.areEqual(pPrBase1.getSpacing(), pPrBase2.getSpacing()) && StyleUtil.areEqual(pPrBase1.getInd(), pPrBase2.getInd()) && StyleUtil.areEqual(pPrBase1.getContextualSpacing(), pPrBase2.getContextualSpacing()) && StyleUtil.areEqual(pPrBase1.getMirrorIndents(), pPrBase2.getMirrorIndents()) && StyleUtil.areEqual(pPrBase1.getSuppressOverlap(), pPrBase2.getSuppressOverlap()) && StyleUtil.areEqual(pPrBase1.getJc(), pPrBase2.getJc()) && StyleUtil.areEqual(pPrBase1.getTextDirection(), pPrBase2.getTextDirection()) && StyleUtil.areEqual(pPrBase1.getTextAlignment(), pPrBase2.getTextAlignment()) && StyleUtil.areEqual(pPrBase1.getTextboxTightWrap(), pPrBase2.getTextboxTightWrap()) && StyleUtil.areEqual(pPrBase1.getOutlineLvl(), pPrBase2.getOutlineLvl()) && StyleUtil.areEqual(pPrBase1.getCnfStyle(), pPrBase2.getCnfStyle());
    }

    public static boolean areEqual(RPr rPr1, RPr rPr2) {
        return rPr1 == rPr2 || rPr1 != null && rPr2 != null && StyleUtil.areEqual(rPr1.getRStyle(), rPr2.getRStyle()) && StyleUtil.areEqual(rPr1.getRFonts(), rPr2.getRFonts()) && StyleUtil.areEqual(rPr1.getB(), rPr2.getB()) && StyleUtil.areEqual(rPr1.getBCs(), rPr2.getBCs()) && StyleUtil.areEqual(rPr1.getI(), rPr2.getI()) && StyleUtil.areEqual(rPr1.getICs(), rPr2.getICs()) && StyleUtil.areEqual(rPr1.getCaps(), rPr2.getCaps()) && StyleUtil.areEqual(rPr1.getSmallCaps(), rPr2.getSmallCaps()) && StyleUtil.areEqual(rPr1.getStrike(), rPr2.getStrike()) && StyleUtil.areEqual(rPr1.getDstrike(), rPr2.getDstrike()) && StyleUtil.areEqual(rPr1.getOutline(), rPr2.getOutline()) && StyleUtil.areEqual(rPr1.getShadow(), rPr2.getShadow()) && StyleUtil.areEqual(rPr1.getEmboss(), rPr2.getEmboss()) && StyleUtil.areEqual(rPr1.getImprint(), rPr2.getImprint()) && StyleUtil.areEqual(rPr1.getSnapToGrid(), rPr2.getSnapToGrid()) && StyleUtil.areEqual(rPr1.getVanish(), rPr2.getVanish()) && StyleUtil.areEqual(rPr1.getColor(), rPr2.getColor()) && StyleUtil.areEqual(rPr1.getSpacing(), rPr2.getSpacing()) && StyleUtil.areEqual(rPr1.getW(), rPr2.getW()) && StyleUtil.areEqual(rPr1.getKern(), rPr2.getKern()) && StyleUtil.areEqual(rPr1.getPosition(), rPr2.getPosition()) && StyleUtil.areEqual(rPr1.getSz(), rPr2.getSz()) && StyleUtil.areEqual(rPr1.getSzCs(), rPr2.getSzCs()) && StyleUtil.areEqual(rPr1.getHighlight(), rPr2.getHighlight()) && StyleUtil.areEqual(rPr1.getU(), rPr2.getU()) && StyleUtil.areEqual(rPr1.getEffect(), rPr2.getEffect()) && StyleUtil.areEqual(rPr1.getBdr(), rPr2.getBdr()) && StyleUtil.areEqual(rPr1.getShd(), rPr2.getShd()) && StyleUtil.areEqual(rPr1.getVertAlign(), rPr2.getVertAlign()) && StyleUtil.areEqual(rPr1.getRtl(), rPr2.getRtl()) && StyleUtil.areEqual(rPr1.getCs(), rPr2.getCs()) && StyleUtil.areEqual(rPr1.getEm(), rPr2.getEm()) && StyleUtil.areEqual(rPr1.getSpecVanish(), rPr2.getSpecVanish()) && StyleUtil.areEqual(rPr1.getOMath(), rPr2.getOMath());
    }

    public static boolean areEqual(ParaRPr rPr1, ParaRPr rPr2) {
        return rPr1 == rPr2 || rPr1 != null && rPr2 != null && StyleUtil.areEqual(rPr1.getRStyle(), rPr2.getRStyle()) && StyleUtil.areEqual(rPr1.getRFonts(), rPr2.getRFonts()) && StyleUtil.areEqual(rPr1.getB(), rPr2.getB()) && StyleUtil.areEqual(rPr1.getBCs(), rPr2.getBCs()) && StyleUtil.areEqual(rPr1.getI(), rPr2.getI()) && StyleUtil.areEqual(rPr1.getICs(), rPr2.getICs()) && StyleUtil.areEqual(rPr1.getCaps(), rPr2.getCaps()) && StyleUtil.areEqual(rPr1.getSmallCaps(), rPr2.getSmallCaps()) && StyleUtil.areEqual(rPr1.getStrike(), rPr2.getStrike()) && StyleUtil.areEqual(rPr1.getDstrike(), rPr2.getDstrike()) && StyleUtil.areEqual(rPr1.getOutline(), rPr2.getOutline()) && StyleUtil.areEqual(rPr1.getShadow(), rPr2.getShadow()) && StyleUtil.areEqual(rPr1.getEmboss(), rPr2.getEmboss()) && StyleUtil.areEqual(rPr1.getImprint(), rPr2.getImprint()) && StyleUtil.areEqual(rPr1.getSnapToGrid(), rPr2.getSnapToGrid()) && StyleUtil.areEqual(rPr1.getVanish(), rPr2.getVanish()) && StyleUtil.areEqual(rPr1.getColor(), rPr2.getColor()) && StyleUtil.areEqual(rPr1.getSpacing(), rPr2.getSpacing()) && StyleUtil.areEqual(rPr1.getW(), rPr2.getW()) && StyleUtil.areEqual(rPr1.getKern(), rPr2.getKern()) && StyleUtil.areEqual(rPr1.getPosition(), rPr2.getPosition()) && StyleUtil.areEqual(rPr1.getSz(), rPr2.getSz()) && StyleUtil.areEqual(rPr1.getSzCs(), rPr2.getSzCs()) && StyleUtil.areEqual(rPr1.getHighlight(), rPr2.getHighlight()) && StyleUtil.areEqual(rPr1.getU(), rPr2.getU()) && StyleUtil.areEqual(rPr1.getEffect(), rPr2.getEffect()) && StyleUtil.areEqual(rPr1.getBdr(), rPr2.getBdr()) && StyleUtil.areEqual(rPr1.getShd(), rPr2.getShd()) && StyleUtil.areEqual(rPr1.getVertAlign(), rPr2.getVertAlign()) && StyleUtil.areEqual(rPr1.getRtl(), rPr2.getRtl()) && StyleUtil.areEqual(rPr1.getCs(), rPr2.getCs()) && StyleUtil.areEqual(rPr1.getEm(), rPr2.getEm()) && StyleUtil.areEqual(rPr1.getSpecVanish(), rPr2.getSpecVanish()) && StyleUtil.areEqual(rPr1.getOMath(), rPr2.getOMath());
    }

    public static boolean areEqual(CTTblPrBase tblPr1, CTTblPrBase tblPr2) {
        return tblPr1 == tblPr2 || tblPr1 != null && tblPr2 != null && StyleUtil.areEqual(tblPr1.getTblStyle(), tblPr2.getTblStyle()) && StyleUtil.areEqual(tblPr1.getTblpPr(), tblPr2.getTblpPr()) && StyleUtil.areEqual(tblPr1.getTblOverlap(), tblPr2.getTblOverlap()) && StyleUtil.areEqual(tblPr1.getTblStyleRowBandSize(), tblPr2.getTblStyleRowBandSize()) && StyleUtil.areEqual(tblPr1.getTblStyleColBandSize(), tblPr2.getTblStyleColBandSize()) && StyleUtil.areEqual(tblPr1.getTblW(), tblPr2.getTblW()) && StyleUtil.areEqual(tblPr1.getJc(), tblPr2.getJc()) && StyleUtil.areEqual(tblPr1.getTblCellSpacing(), tblPr2.getTblCellSpacing()) && StyleUtil.areEqual(tblPr1.getTblInd(), tblPr2.getTblInd()) && StyleUtil.areEqual(tblPr1.getTblBorders(), tblPr2.getTblBorders()) && StyleUtil.areEqual(tblPr1.getShd(), tblPr2.getShd()) && StyleUtil.areEqual(tblPr1.getTblLayout(), tblPr2.getTblLayout()) && StyleUtil.areEqual(tblPr1.getTblCellMar(), tblPr2.getTblCellMar()) && StyleUtil.areEqual(tblPr1.getTblLook(), tblPr2.getTblLook());
    }

    public static boolean areEqual(CTTblLook tblLook1, CTTblLook tblLook2) {
        return tblLook1 == tblLook2 || tblLook1 != null && tblLook2 != null && StyleUtil.areEqual(tblLook1.getVal(), tblLook2.getVal()) && StyleUtil.areEqual(tblLook1.getFirstColumn(), tblLook2.getFirstColumn()) && StyleUtil.areEqual(tblLook1.getFirstRow(), tblLook2.getFirstRow()) && StyleUtil.areEqual(tblLook1.getLastColumn(), tblLook2.getLastColumn()) && StyleUtil.areEqual(tblLook1.getLastRow(), tblLook2.getLastRow()) && StyleUtil.areEqual(tblLook1.getNoHBand(), tblLook2.getNoHBand()) && StyleUtil.areEqual(tblLook1.getNoVBand(), tblLook2.getNoVBand());
    }

    private static boolean areEqual(STOnOff oo1, STOnOff oo2) {
        return oo1 == oo2;
    }

    public static boolean areEqual(TcPr tcPr1, TcPr tcPr2) {
        return tcPr1 == tcPr2 || tcPr1 != null && tcPr2 != null && StyleUtil.areEqual(tcPr1.getCnfStyle(), tcPr2.getCnfStyle()) && StyleUtil.areEqual(tcPr1.getTcW(), tcPr2.getTcW()) && StyleUtil.areEqual(tcPr1.getGridSpan(), tcPr2.getGridSpan()) && StyleUtil.areEqual(tcPr1.getHMerge(), tcPr2.getHMerge()) && StyleUtil.areEqual(tcPr1.getVMerge(), tcPr2.getVMerge()) && StyleUtil.areEqual(tcPr1.getTcBorders(), tcPr2.getTcBorders()) && StyleUtil.areEqual(tcPr1.getShd(), tcPr2.getShd()) && StyleUtil.areEqual(tcPr1.getNoWrap(), tcPr2.getNoWrap()) && StyleUtil.areEqual(tcPr1.getTcMar(), tcPr2.getTcMar()) && StyleUtil.areEqual(tcPr1.getTextDirection(), tcPr2.getTextDirection()) && StyleUtil.areEqual(tcPr1.getTcFitText(), tcPr2.getTcFitText()) && StyleUtil.areEqual(tcPr1.getVAlign(), tcPr2.getVAlign()) && StyleUtil.areEqual(tcPr1.getHideMark(), tcPr2.getHideMark());
    }

    public static boolean areEqual(List<CTTblStylePr> tblStylePrList1, List<CTTblStylePr> tblStylePrList2) {
        if (tblStylePrList1 == tblStylePrList2) {
            return true;
        }
        if (tblStylePrList1 == null && tblStylePrList2 != null || tblStylePrList1 != null && tblStylePrList2 == null) {
            return false;
        }
        if (tblStylePrList1.size() != tblStylePrList2.size()) {
            return false;
        }
        for (int i = 0; i < tblStylePrList1.size(); ++i) {
            if (StyleUtil.areEqual(tblStylePrList1.get(i), tblStylePrList2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(CTTblStylePr ctTblStylePr1, CTTblStylePr ctTblStylePr2) {
        return ctTblStylePr1 == ctTblStylePr2 || ctTblStylePr1 != null && ctTblStylePr2 != null && StyleUtil.areEqual(ctTblStylePr1.getPPr(), ctTblStylePr2.getPPr()) && StyleUtil.areEqual(ctTblStylePr1.getRPr(), ctTblStylePr2.getRPr()) && StyleUtil.areEqual(ctTblStylePr1.getTblPr(), ctTblStylePr2.getTblPr()) && StyleUtil.areEqual(ctTblStylePr1.getTrPr(), ctTblStylePr2.getTrPr()) && StyleUtil.areEqual(ctTblStylePr1.getType(), ctTblStylePr2.getType());
    }

    public static boolean areEqual(PPrBase.OutlineLvl outlineLvl1, PPrBase.OutlineLvl outlineLvl2) {
        return outlineLvl1 == outlineLvl2 || outlineLvl1 != null && outlineLvl2 != null && StyleUtil.areEqual(outlineLvl1.getVal(), outlineLvl2.getVal());
    }

    public static boolean areEqual(CTTextboxTightWrap textboxTightWrap1, CTTextboxTightWrap textboxTightWrap2) {
        return textboxTightWrap1 == textboxTightWrap2 || textboxTightWrap1 != null && textboxTightWrap2 != null && (textboxTightWrap1.getVal() == textboxTightWrap2.getVal() || textboxTightWrap1.getVal() != null && textboxTightWrap1.getVal().equals((Object)textboxTightWrap2.getVal()));
    }

    public static boolean areEqual(PPrBase.TextAlignment textAlignment1, PPrBase.TextAlignment textAlignment2) {
        return textAlignment1 == textAlignment2 || textAlignment1 != null && textAlignment2 != null && (textAlignment1.getVal() == textAlignment2.getVal() || textAlignment1.getVal() != null && textAlignment1.getVal().equals(textAlignment2.getVal()));
    }

    public static boolean areEqual(TextDirection textDirection1, TextDirection textDirection2) {
        return textDirection1 == textDirection2 || textDirection1 != null && textDirection2 != null && StyleUtil.areEqual(textDirection1.getVal(), textDirection2.getVal());
    }

    public static boolean areEqual(Jc jc1, Jc jc2) {
        return jc1 == jc2 || jc1 != null && jc2 != null && (jc1.getVal() == jc2.getVal() || jc1.getVal() != null && jc1.getVal().equals((Object)jc2.getVal()));
    }

    public static boolean areEqual(PPrBase.Ind ind1, PPrBase.Ind ind2) {
        return ind1 == ind2 || ind1 != null && ind2 != null && StyleUtil.areEqual(ind1.getFirstLine(), ind2.getFirstLine()) && StyleUtil.areEqual(ind1.getFirstLineChars(), ind2.getFirstLineChars()) && StyleUtil.areEqual(ind1.getHanging(), ind2.getHanging()) && StyleUtil.areEqual(ind1.getHangingChars(), ind2.getHangingChars()) && StyleUtil.areEqual(ind1.getLeft(), ind2.getLeft()) && StyleUtil.areEqual(ind1.getLeftChars(), ind2.getLeftChars()) && StyleUtil.areEqual(ind1.getRight(), ind2.getRight()) && StyleUtil.areEqual(ind1.getRightChars(), ind2.getRightChars());
    }

    public static boolean areEqual(PPrBase.Spacing spacing1, PPrBase.Spacing spacing2) {
        return spacing1 == spacing2 || spacing1 != null && spacing2 != null && StyleUtil.areEqual(spacing1.getAfter(), spacing2.getAfter()) && StyleUtil.areEqual(spacing1.getAfterLines(), spacing2.getAfterLines()) && StyleUtil.areEqual(spacing1.getBefore(), spacing2.getBefore()) && StyleUtil.areEqual(spacing1.getBeforeLines(), spacing2.getBeforeLines()) && StyleUtil.areEqual(spacing1.getLine(), spacing2.getLine()) && (spacing1.getLineRule() == spacing2.getLineRule() || spacing1.getLineRule() != null && spacing1.getLineRule().equals((Object)spacing2.getLineRule()));
    }

    public static boolean areEqual(Tabs tabs1, Tabs tabs2) {
        if (tabs1 == tabs2) {
            return true;
        }
        if (tabs1 != null && tabs2 == null || tabs1 == null && tabs2 != null) {
            return false;
        }
        if (tabs1.getTab() == tabs2.getTab()) {
            return true;
        }
        if (tabs1.getTab().size() != tabs2.getTab().size()) {
            return false;
        }
        for (int i = 0; i < tabs1.getTab().size(); ++i) {
            if (StyleUtil.areEqual(tabs1.getTab().get(i), tabs2.getTab().get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(CTTabStop ctTabStop1, CTTabStop ctTabStop2) {
        return ctTabStop1 == ctTabStop2 || ctTabStop1 != null && ctTabStop2 != null && StyleUtil.areEqual(ctTabStop1.getPos(), ctTabStop2.getPos()) && (ctTabStop1.getVal() == ctTabStop2.getVal() || ctTabStop1.getVal() != null && ctTabStop1.getVal().equals((Object)ctTabStop2.getVal())) && (ctTabStop1.getLeader() == ctTabStop2.getLeader() || ctTabStop1.getLeader() != null && ctTabStop1.getLeader().equals((Object)ctTabStop2.getLeader()));
    }

    public static boolean areEqual(CTShd shd1, CTShd shd2) {
        return shd1 == shd2 || shd1 != null && shd2 != null && StyleUtil.areEqual(shd1.getColor(), shd2.getColor()) && StyleUtil.areEqual(shd1.getThemeTint(), shd2.getThemeTint()) && StyleUtil.areEqual(shd1.getThemeShade(), shd2.getThemeShade()) && StyleUtil.areEqual(shd1.getFill(), shd2.getFill()) && StyleUtil.areEqual(shd1.getThemeFillTint(), shd2.getThemeFillTint()) && StyleUtil.areEqual(shd1.getThemeFillShade(), shd2.getThemeFillShade()) && StyleUtil.areEqual(shd1.getThemeColor(), shd2.getThemeColor()) && StyleUtil.areEqual(shd1.getThemeFill(), shd2.getThemeFill()) && (shd1.getVal() == shd2.getVal() || shd1.getVal() != null && shd1.getVal().equals((Object)shd2.getVal()));
    }

    public static boolean areEqual(PPrBase.PBdr pBdr1, PPrBase.PBdr pBdr2) {
        return pBdr1 == pBdr2 || pBdr1 != null && pBdr2 != null && StyleUtil.areEqual(pBdr1.getTop(), pBdr2.getTop()) && StyleUtil.areEqual(pBdr1.getLeft(), pBdr2.getLeft()) && StyleUtil.areEqual(pBdr1.getBottom(), pBdr2.getBottom()) && StyleUtil.areEqual(pBdr1.getRight(), pBdr2.getRight()) && StyleUtil.areEqual(pBdr1.getBetween(), pBdr2.getBetween()) && StyleUtil.areEqual(pBdr1.getBar(), pBdr2.getBar());
    }

    public static boolean areEqual(CTBorder border1, CTBorder border2) {
        return border1 == border2 || border1 != null && border2 != null && StyleUtil.areEqual(border1.getColor(), border2.getColor()) && StyleUtil.areEqual(border1.getSpace(), border2.getSpace()) && StyleUtil.areEqual(border1.getSz(), border2.getSz()) && StyleUtil.areEqual(border1.getThemeColor(), border2.getThemeColor()) && StyleUtil.areEqual(border1.getThemeShade(), border2.getThemeShade()) && StyleUtil.areEqual(border1.getThemeTint(), border2.getThemeTint()) && (border1.getVal() == border2.getVal() || border1.getVal() != null && border1.getVal().equals((Object)border2.getVal()));
    }

    public static boolean areEqual(PPrBase.NumPr numPr1, PPrBase.NumPr numPr2) {
        return numPr1 == numPr2 || numPr1 != null && numPr2 != null && (numPr1.getNumId() == numPr2.getNumId() || numPr1.getNumId() != null && numPr2.getNumId() != null && StyleUtil.areEqual(numPr1.getNumId().getVal(), numPr2.getNumId().getVal()));
    }

    public static boolean areEqual(CTFramePr framePr1, CTFramePr framePr2) {
        return framePr1 == framePr2 || framePr1 != null && framePr2 != null && StyleUtil.areEqual(framePr1.getDropCap(), framePr2.getDropCap()) && StyleUtil.areEqual(framePr1.getLines(), framePr2.getLines()) && StyleUtil.areEqual(framePr1.getW(), framePr2.getW()) && StyleUtil.areEqual(framePr1.getH(), framePr2.getH()) && StyleUtil.areEqual(framePr1.getVSpace(), framePr2.getVSpace()) && StyleUtil.areEqual(framePr1.getHSpace(), framePr2.getHSpace()) && StyleUtil.areEqual(framePr1.getWrap(), framePr2.getWrap()) && StyleUtil.areEqual(framePr1.getHAnchor(), framePr2.getHAnchor()) && StyleUtil.areEqual(framePr1.getVAnchor(), framePr2.getVAnchor()) && StyleUtil.areEqual(framePr1.getX(), framePr2.getX()) && StyleUtil.areEqual(framePr1.getXAlign(), framePr2.getXAlign()) && StyleUtil.areEqual(framePr1.getY(), framePr2.getY()) && StyleUtil.areEqual(framePr1.getYAlign(), framePr2.getYAlign()) && StyleUtil.areEqual(framePr1.getHRule(), framePr2.getHRule()) && framePr1.isAnchorLock() == framePr2.isAnchorLock();
    }

    public static boolean areEqual(CTCnf cnfStyle1, CTCnf cnfStyle2) {
        return cnfStyle1 == cnfStyle2 || cnfStyle1 != null && cnfStyle2 != null && StyleUtil.areEqual(cnfStyle1.getVal(), cnfStyle2.getVal());
    }

    public static boolean areEqual(STHeightRule hRule1, STHeightRule hRule2) {
        return hRule1 == hRule2 || hRule1 != null && hRule1.equals((Object)hRule2);
    }

    public static boolean areEqual(STYAlign yAlign1, STYAlign yAlign2) {
        return yAlign1 == yAlign2 || yAlign1 != null && yAlign1.equals((Object)yAlign2);
    }

    public static boolean areEqual(STXAlign xAlign1, STXAlign xAlign2) {
        return xAlign1 == xAlign2 || xAlign1 != null && xAlign1.equals((Object)xAlign2);
    }

    public static boolean areEqual(STVAnchor vAnchor1, STVAnchor vAnchor2) {
        return vAnchor1 == vAnchor2 || vAnchor1 != null && vAnchor1.equals((Object)vAnchor2);
    }

    public static boolean areEqual(STHAnchor hAnchor1, STHAnchor hAnchor2) {
        return hAnchor1 == hAnchor2 || hAnchor1 != null && hAnchor1.equals((Object)hAnchor2);
    }

    public static boolean areEqual(STWrap wrap1, STWrap wrap2) {
        return wrap1 == wrap2 || wrap1 != null && wrap1.equals((Object)wrap2);
    }

    public static boolean areEqual(STDropCap dropCap1, STDropCap dropCap2) {
        return dropCap1 == dropCap2 || dropCap1 != null && dropCap1.equals((Object)dropCap2);
    }

    public static boolean areEqual(PPrBase.PStyle pStyle1, PPrBase.PStyle pStyle2) {
        return pStyle1 == pStyle2 || pStyle1 != null && pStyle2 != null && StyleUtil.areEqual(pStyle1.getVal(), pStyle2.getVal());
    }

    public static boolean areEqual(Style.BasedOn basedOn1, Style.BasedOn basedOn2) {
        return basedOn1 == basedOn2 || basedOn1 != null && basedOn2 != null && StyleUtil.areEqual(basedOn1.getVal(), basedOn2.getVal());
    }

    public static boolean areEqual(RFonts rFonts1, RFonts rFonts2) {
        return rFonts1 == rFonts2 || rFonts1 != null && rFonts2 != null && StyleUtil.areEqual(rFonts1.getAscii(), rFonts2.getAscii());
    }

    public static boolean areEqual(RStyle rStyle1, RStyle rStyle2) {
        return rStyle1 == rStyle2 || rStyle1 != null && rStyle2 != null && StyleUtil.areEqual(rStyle1.getVal(), rStyle2.getVal());
    }

    public static boolean areEqual(CTEm em1, CTEm em2) {
        return em1 == em2 || em1 != null && em2 != null && StyleUtil.areEqual(em1.getVal(), em2.getVal());
    }

    public static boolean areEqual(CTVerticalAlignRun vertAlign1, CTVerticalAlignRun vertAlign2) {
        return vertAlign1 == vertAlign2 || vertAlign1 != null && vertAlign2 != null && StyleUtil.areEqual(vertAlign1.getVal(), vertAlign2.getVal());
    }

    public static boolean areEqual(CTTextEffect effect1, CTTextEffect effect2) {
        return effect1 == effect2 || effect1 != null && effect2 != null && StyleUtil.areEqual(effect1.getVal(), effect2.getVal());
    }

    public static boolean areEqual(U u1, U u2) {
        return u1 == u2 || u1 != null && u2 != null && StyleUtil.areEqual(u1.getVal(), u2.getVal()) && StyleUtil.areEqual(u1.getColor(), u2.getColor());
    }

    public static boolean areEqual(Highlight highlight1, Highlight highlight2) {
        return highlight1 == highlight2 || highlight1 != null && highlight2 != null && StyleUtil.areEqual(highlight1.getVal(), highlight2.getVal());
    }

    public static boolean areEqual(CTSignedHpsMeasure measure1, CTSignedHpsMeasure measure2) {
        return measure1 == measure2 || measure1 != null && measure2 != null && StyleUtil.areEqual(measure1.getVal(), measure2.getVal());
    }

    public static boolean areEqual(HpsMeasure measure1, HpsMeasure measure2) {
        return measure1 == measure2 || measure1 != null && measure2 != null && StyleUtil.areEqual(measure1.getVal(), measure2.getVal());
    }

    public static boolean areEqual(CTTextScale scale1, CTTextScale scale2) {
        return scale1 == scale2 || scale1 != null && scale2 != null && StyleUtil.areEqual(scale1.getVal(), scale2.getVal());
    }

    public static boolean areEqual(CTSignedTwipsMeasure measure1, CTSignedTwipsMeasure measure2) {
        return measure1 == measure2 || measure1 != null && measure2 != null && StyleUtil.areEqual(measure1.getVal(), measure2.getVal());
    }

    public static boolean areEqual(Color color1, Color color2) {
        return color1 == color2 || color1 != null && color2 != null && StyleUtil.areEqual(color1.getVal(), color2.getVal());
    }

    public static boolean areEqual(CTTblLayoutType tblLayout1, CTTblLayoutType tblLayout2) {
        return tblLayout1 == tblLayout2 || tblLayout1 != null && tblLayout2 != null && StyleUtil.areEqual(tblLayout1.getType(), tblLayout2.getType());
    }

    public static boolean areEqual(CTTblCellMar margin1, CTTblCellMar margin2) {
        return margin1 == margin2 || margin1 != null && margin2 != null && StyleUtil.areEqual(margin1.getBottom(), margin2.getBottom()) && StyleUtil.areEqual(margin1.getLeft(), margin2.getLeft()) && StyleUtil.areEqual(margin1.getRight(), margin2.getRight()) && StyleUtil.areEqual(margin1.getTop(), margin2.getTop());
    }

    public static boolean areEqual(TblBorders borders1, TblBorders borders2) {
        return borders1 == borders2 || borders1 != null && borders2 != null && StyleUtil.areEqual(borders1.getBottom(), borders2.getBottom()) && StyleUtil.areEqual(borders1.getLeft(), borders2.getLeft()) && StyleUtil.areEqual(borders1.getRight(), borders2.getRight()) && StyleUtil.areEqual(borders1.getTop(), borders2.getTop()) && StyleUtil.areEqual(borders1.getInsideH(), borders2.getInsideH()) && StyleUtil.areEqual(borders1.getInsideV(), borders2.getInsideV());
    }

    public static boolean areEqual(CTTblPrBase.TblStyleColBandSize bandSize1, CTTblPrBase.TblStyleColBandSize bandSize2) {
        return bandSize1 == bandSize2 || bandSize1 != null && bandSize2 != null && StyleUtil.areEqual(bandSize1.getVal(), bandSize2.getVal());
    }

    public static boolean areEqual(CTTblPrBase.TblStyleRowBandSize bandSize1, CTTblPrBase.TblStyleRowBandSize bandSize2) {
        return bandSize1 == bandSize2 || bandSize1 != null && bandSize2 != null && StyleUtil.areEqual(bandSize1.getVal(), bandSize2.getVal());
    }

    public static boolean areEqual(CTTblOverlap overlap1, CTTblOverlap overlap2) {
        return overlap1 == overlap2 || overlap1 != null && overlap2 != null && StyleUtil.areEqual(overlap1.getVal(), overlap2.getVal());
    }

    public static boolean areEqual(CTTblPPr tblpPr1, CTTblPPr tblpPr2) {
        return tblpPr1 == tblpPr2 || tblpPr1 != null && tblpPr2 != null && StyleUtil.areEqual(tblpPr1.getLeftFromText(), tblpPr2.getLeftFromText()) && StyleUtil.areEqual(tblpPr1.getRightFromText(), tblpPr2.getRightFromText()) && StyleUtil.areEqual(tblpPr1.getTopFromText(), tblpPr2.getTopFromText()) && StyleUtil.areEqual(tblpPr1.getBottomFromText(), tblpPr2.getBottomFromText()) && StyleUtil.areEqual(tblpPr1.getVertAnchor(), tblpPr2.getVertAnchor()) && StyleUtil.areEqual(tblpPr1.getHorzAnchor(), tblpPr2.getHorzAnchor()) && StyleUtil.areEqual(tblpPr1.getTblpXSpec(), tblpPr2.getTblpXSpec()) && StyleUtil.areEqual(tblpPr1.getTblpX(), tblpPr2.getTblpX()) && StyleUtil.areEqual(tblpPr1.getTblpYSpec(), tblpPr2.getTblpYSpec()) && StyleUtil.areEqual(tblpPr1.getTblpY(), tblpPr2.getTblpY());
    }

    public static boolean areEqual(CTTblPrBase.TblStyle style1, CTTblPrBase.TblStyle style2) {
        return style1 == style2 || style1 != null && style2 != null && StyleUtil.areEqual(style1.getVal(), style2.getVal());
    }

    public static boolean areEqual(CTVerticalJc vAlign1, CTVerticalJc vAlign2) {
        return vAlign1 == vAlign2 || vAlign1 != null && vAlign2 != null && StyleUtil.areEqual(vAlign1.getVal(), vAlign2.getVal());
    }

    public static boolean areEqual(TcMar margin1, TcMar margin2) {
        return margin1 == margin2 || margin1 != null && margin2 != null && StyleUtil.areEqual(margin1.getBottom(), margin2.getBottom()) && StyleUtil.areEqual(margin1.getLeft(), margin2.getLeft()) && StyleUtil.areEqual(margin1.getRight(), margin2.getRight()) && StyleUtil.areEqual(margin1.getTop(), margin2.getTop());
    }

    public static boolean areEqual(TcPrInner.TcBorders borders1, TcPrInner.TcBorders borders2) {
        return borders1 == borders2 || borders1 != null && borders2 != null && StyleUtil.areEqual(borders1.getBottom(), borders2.getBottom()) && StyleUtil.areEqual(borders1.getLeft(), borders2.getLeft()) && StyleUtil.areEqual(borders1.getRight(), borders2.getRight()) && StyleUtil.areEqual(borders1.getTop(), borders2.getTop()) && StyleUtil.areEqual(borders1.getInsideH(), borders2.getInsideH()) && StyleUtil.areEqual(borders1.getInsideV(), borders2.getInsideV()) && StyleUtil.areEqual(borders1.getTl2Br(), borders2.getTl2Br()) && StyleUtil.areEqual(borders1.getTr2Bl(), borders2.getTr2Bl());
    }

    public static boolean areEqual(TcPrInner.VMerge merge1, TcPrInner.VMerge merge2) {
        return merge1 == merge2 || merge1 != null && merge2 != null && StyleUtil.areEqual(merge1.getVal(), merge2.getVal());
    }

    public static boolean areEqual(TcPrInner.HMerge merge1, TcPrInner.HMerge merge2) {
        return merge1 == merge2 || merge1 != null && merge2 != null && StyleUtil.areEqual(merge1.getVal(), merge2.getVal());
    }

    public static boolean areEqual(TcPrInner.GridSpan gridSpan1, TcPrInner.GridSpan gridSpan2) {
        return gridSpan1 == gridSpan2 || gridSpan1 != null && gridSpan2 != null && StyleUtil.areEqual(gridSpan1.getVal(), gridSpan2.getVal());
    }

    public static boolean areEqual(TrPr trPr1, TrPr trPr2) {
        List<JAXBElement<?>> defs1 = null;
        List<JAXBElement<?>> defs2 = null;
        JAXBElement<?> defs1element = null;
        Object defs2value = null;
        QName qName = null;
        String qNameLocal = null;
        if (trPr1 == trPr2) {
            return true;
        }
        if (trPr1 != null && trPr2 == null || trPr1 == null && trPr2 != null) {
            return false;
        }
        defs1 = trPr1.getCnfStyleOrDivIdOrGridBefore();
        if (defs1 == (defs2 = trPr2.getCnfStyleOrDivIdOrGridBefore())) {
            return true;
        }
        if (defs1.size() != defs2.size()) {
            return false;
        }
        if (defs1.isEmpty()) {
            return true;
        }
        for (int i = 0; i < defs1.size(); ++i) {
            defs1element = defs1.get(i);
            qName = defs1element.getName();
            defs2value = StyleUtil.findTrValue(defs2, qName);
            if (defs2value == null) {
                return false;
            }
            qNameLocal = qName.getLocalPart();
            if (!("gridAfter".equals(qNameLocal) ? !StyleUtil.areEqual((CTTrPrBase.GridAfter)defs1element.getValue(), (CTTrPrBase.GridAfter)defs2value) : ("cantSplit".equals(qNameLocal) ? !StyleUtil.areEqual((BooleanDefaultTrue)defs1element.getValue(), (BooleanDefaultTrue)defs2value) : ("wBefore".equals(qNameLocal) ? !StyleUtil.areEqual((TblWidth)defs1element.getValue(), (TblWidth)defs2value) : ("jc".equals(qNameLocal) ? !StyleUtil.areEqual((Jc)defs1element.getValue(), (Jc)defs2value) : ("cnfStyle".equals(qNameLocal) ? !StyleUtil.areEqual((CTCnf)defs1element.getValue(), (CTCnf)defs2value) : ("gridBefore".equals(qNameLocal) ? !StyleUtil.areEqual((CTTrPrBase.GridBefore)defs1element.getValue(), (CTTrPrBase.GridBefore)defs2value) : ("hidden".equals(qNameLocal) ? !StyleUtil.areEqual((BooleanDefaultTrue)defs1element.getValue(), (BooleanDefaultTrue)defs2value) : ("trHeight".equals(qNameLocal) ? !StyleUtil.areEqual((CTHeight)defs1element.getValue(), (CTHeight)defs2value) : ("wAfter".equals(qNameLocal) ? !StyleUtil.areEqual((TblWidth)defs1element.getValue(), (TblWidth)defs2value) : ("tblHeader".equals(qNameLocal) ? !StyleUtil.areEqual((BooleanDefaultTrue)defs1element.getValue(), (BooleanDefaultTrue)defs2value) : "tblCellSpacing".equals(qNameLocal) && !StyleUtil.areEqual((TblWidth)defs1element.getValue(), (TblWidth)defs2value)))))))))))) continue;
            return false;
        }
        return true;
    }

    private static Object findTrValue(List<JAXBElement<?>> defs, QName qName) {
        for (int i = 0; i < defs.size(); ++i) {
            if (!qName.equals(defs.get(i).getName())) continue;
            return defs.get(i).getValue();
        }
        return null;
    }

    public static boolean areEqual(CTTrPrBase.GridBefore value1, CTTrPrBase.GridBefore value2) {
        return value1 == value2 || value1 != null && value2 != null && StyleUtil.areEqual(value1.getVal(), value2.getVal());
    }

    public static boolean areEqual(CTTrPrBase.GridAfter value1, CTTrPrBase.GridAfter value2) {
        return value1 == value2 || value1 != null && value2 != null && StyleUtil.areEqual(value1.getVal(), value2.getVal());
    }

    public static boolean areEqual(CTHeight height1, CTHeight height2) {
        return height1 == height2 || height1 != null && height2 != null && StyleUtil.areEqual(height1.getVal(), height2.getVal()) && StyleUtil.areEqual(height1.getHRule(), height2.getHRule());
    }

    public static boolean areEqual(TblWidth width1, TblWidth width2) {
        return width1 == width2 || width1 != null && width2 != null && StyleUtil.areEqual(width1.getW(), width2.getW()) && StyleUtil.areEqual(width1.getType(), width2.getType());
    }

    public static boolean areEqual(CTShortHexNumber number1, CTShortHexNumber number2) {
        return number1 == number2 || number1 != null && number2 != null && StyleUtil.areEqual(number1.getVal(), number2.getVal());
    }

    public static boolean areEqual(STTblOverlap val1, STTblOverlap val2) {
        return val1 == val2 || val1 != null && val1.equals((Object)val2);
    }

    public static boolean areEqual(STTblStyleOverrideType val1, STTblStyleOverrideType val2) {
        return val1 == val2 || val1 != null && val1.equals((Object)val2);
    }

    public static boolean areEqual(STTblLayoutType val1, STTblLayoutType val2) {
        return val1 == val2 || val1 != null && val1.equals((Object)val2);
    }

    public static boolean areEqual(UnderlineEnumeration val1, UnderlineEnumeration val2) {
        return val1 == val2 || val1 != null && val1.equals((Object)val2);
    }

    public static boolean areEqual(STTextEffect val1, STTextEffect val2) {
        return val1 == val2 || val1 != null && val1.equals((Object)val2);
    }

    public static boolean areEqual(STEm val1, STEm val2) {
        return val1 == val2 || val1 != null && val1.equals((Object)val2);
    }

    public static boolean areEqual(STVerticalAlignRun val1, STVerticalAlignRun val2) {
        return val1 == val2 || val1 != null && val1.equals((Object)val2);
    }

    public static boolean areEqual(STVerticalJc val1, STVerticalJc val2) {
        return val1 == val2 || val1 != null && val1.equals((Object)val2);
    }

    public static boolean areEqual(STThemeColor themeColor1, STThemeColor themeColor2) {
        return themeColor1 == themeColor2 || themeColor1 != null && themeColor1.equals((Object)themeColor2);
    }

    public static boolean areEqual(BooleanDefaultTrue booleanDefaultTrue1, BooleanDefaultTrue booleanDefaultTrue2) {
        return (booleanDefaultTrue1 != null ? booleanDefaultTrue1.isVal() : false) == (booleanDefaultTrue2 != null ? booleanDefaultTrue2.isVal() : false);
    }

    public static boolean areEqual(Boolean bool1, Boolean bool2) {
        return (bool1 != null ? bool1 : false) == (bool2 != null ? bool2 : false);
    }

    public static boolean areEqual(BigInteger val1, BigInteger val2) {
        return val1 == val2 || val1 != null && val1.equals(val2);
    }

    protected static boolean areEqual(Integer val1, Integer val2) {
        return val1 == val2 || val1 != null && val1.equals(val2);
    }

    protected static boolean areEqual(String val1, String val2) {
        return val1 == val2 || val1 != null && val1.equals(val2);
    }

    public static boolean isEmpty(Style style) {
        if (style == null) {
            return true;
        }
        if (StyleUtil.isEmpty(style.getStyleId())) {
            log.warn("style currently has no id");
        }
        if (CHARACTER_STYLE.equals(style.getType())) {
            return StyleUtil.isEmpty(style.getRPr());
        }
        if (PARAGRAPH_STYLE.equals(style.getType()) || NUMBERING_STYLE.equals(style.getType())) {
            return StyleUtil.isEmpty(style.getPPr()) && StyleUtil.isEmpty(style.getRPr());
        }
        if (TABLE_STYLE.equals(style.getType())) {
            return StyleUtil.isEmpty(style.getPPr()) && StyleUtil.isEmpty(style.getRPr()) && StyleUtil.isEmpty(style.getTblPr()) && StyleUtil.isEmpty(style.getTcPr()) && StyleUtil.isEmpty(style.getTblStylePr());
        }
        log.warn("style type is currently unknown or null");
        if (log.isDebugEnabled()) {
            log.debug(XmlUtils.marshaltoString(style));
        }
        return StyleUtil.isEmpty(style.getPPr()) && StyleUtil.isEmpty(style.getRPr()) && StyleUtil.isEmpty(style.getTblPr()) && StyleUtil.isEmpty(style.getTcPr()) && StyleUtil.isEmpty(style.getTblStylePr());
    }

    public static boolean isEmpty(PPr pPr) {
        return pPr == null || StyleUtil.isEmpty((PPrBase)pPr) && StyleUtil.isEmpty(pPr.getRPr()) && StyleUtil.isEmpty(pPr.getSectPr());
    }

    public static boolean isEmpty(PPrBase pPrBase) {
        return pPrBase == null || StyleUtil.isEmpty(pPrBase.getPStyle()) && StyleUtil.isEmpty(pPrBase.getKeepNext()) && StyleUtil.isEmpty(pPrBase.getKeepLines()) && StyleUtil.isEmpty(pPrBase.getPageBreakBefore()) && StyleUtil.isEmpty(pPrBase.getFramePr()) && StyleUtil.isEmpty(pPrBase.getWidowControl()) && StyleUtil.isEmpty(pPrBase.getNumPr()) && StyleUtil.isEmpty(pPrBase.getSuppressLineNumbers()) && StyleUtil.isEmpty(pPrBase.getPBdr()) && StyleUtil.isEmpty(pPrBase.getShd()) && StyleUtil.isEmpty(pPrBase.getTabs()) && StyleUtil.isEmpty(pPrBase.getSuppressAutoHyphens()) && StyleUtil.isEmpty(pPrBase.getKinsoku()) && StyleUtil.isEmpty(pPrBase.getWordWrap()) && StyleUtil.isEmpty(pPrBase.getOverflowPunct()) && StyleUtil.isEmpty(pPrBase.getTopLinePunct()) && StyleUtil.isEmpty(pPrBase.getAutoSpaceDE()) && StyleUtil.isEmpty(pPrBase.getAutoSpaceDN()) && StyleUtil.isEmpty(pPrBase.getBidi()) && StyleUtil.isEmpty(pPrBase.getAdjustRightInd()) && StyleUtil.isEmpty(pPrBase.getSnapToGrid()) && StyleUtil.isEmpty(pPrBase.getSpacing()) && StyleUtil.isEmpty(pPrBase.getInd()) && StyleUtil.isEmpty(pPrBase.getContextualSpacing()) && StyleUtil.isEmpty(pPrBase.getMirrorIndents()) && StyleUtil.isEmpty(pPrBase.getSuppressOverlap()) && StyleUtil.isEmpty(pPrBase.getJc()) && StyleUtil.isEmpty(pPrBase.getTextDirection()) && StyleUtil.isEmpty(pPrBase.getTextAlignment()) && StyleUtil.isEmpty(pPrBase.getTextboxTightWrap()) && StyleUtil.isEmpty(pPrBase.getOutlineLvl()) && StyleUtil.isEmpty(pPrBase.getCnfStyle());
    }

    public static boolean isEmpty(RPr rPr) {
        return rPr == null || StyleUtil.isEmpty(rPr.getRStyle()) && StyleUtil.isEmpty(rPr.getRFonts()) && StyleUtil.isEmpty(rPr.getB()) && StyleUtil.isEmpty(rPr.getBCs()) && StyleUtil.isEmpty(rPr.getI()) && StyleUtil.isEmpty(rPr.getICs()) && StyleUtil.isEmpty(rPr.getCaps()) && StyleUtil.isEmpty(rPr.getSmallCaps()) && StyleUtil.isEmpty(rPr.getStrike()) && StyleUtil.isEmpty(rPr.getDstrike()) && StyleUtil.isEmpty(rPr.getOutline()) && StyleUtil.isEmpty(rPr.getShadow()) && StyleUtil.isEmpty(rPr.getEmboss()) && StyleUtil.isEmpty(rPr.getImprint()) && StyleUtil.isEmpty(rPr.getSnapToGrid()) && StyleUtil.isEmpty(rPr.getVanish()) && StyleUtil.isEmpty(rPr.getColor()) && StyleUtil.isEmpty(rPr.getSpacing()) && StyleUtil.isEmpty(rPr.getW()) && StyleUtil.isEmpty(rPr.getKern()) && StyleUtil.isEmpty(rPr.getPosition()) && StyleUtil.isEmpty(rPr.getSz()) && StyleUtil.isEmpty(rPr.getSzCs()) && StyleUtil.isEmpty(rPr.getHighlight()) && StyleUtil.isEmpty(rPr.getU()) && StyleUtil.isEmpty(rPr.getEffect()) && StyleUtil.isEmpty(rPr.getBdr()) && StyleUtil.isEmpty(rPr.getShd()) && StyleUtil.isEmpty(rPr.getVertAlign()) && StyleUtil.isEmpty(rPr.getRtl()) && StyleUtil.isEmpty(rPr.getCs()) && StyleUtil.isEmpty(rPr.getEm()) && StyleUtil.isEmpty(rPr.getSpecVanish()) && StyleUtil.isEmpty(rPr.getOMath());
    }

    public static boolean isEmpty(ParaRPr rPr) {
        return rPr == null || StyleUtil.isEmpty(rPr.getRStyle()) && StyleUtil.isEmpty(rPr.getRFonts()) && StyleUtil.isEmpty(rPr.getB()) && StyleUtil.isEmpty(rPr.getBCs()) && StyleUtil.isEmpty(rPr.getI()) && StyleUtil.isEmpty(rPr.getICs()) && StyleUtil.isEmpty(rPr.getCaps()) && StyleUtil.isEmpty(rPr.getSmallCaps()) && StyleUtil.isEmpty(rPr.getStrike()) && StyleUtil.isEmpty(rPr.getDstrike()) && StyleUtil.isEmpty(rPr.getOutline()) && StyleUtil.isEmpty(rPr.getShadow()) && StyleUtil.isEmpty(rPr.getEmboss()) && StyleUtil.isEmpty(rPr.getImprint()) && StyleUtil.isEmpty(rPr.getSnapToGrid()) && StyleUtil.isEmpty(rPr.getVanish()) && StyleUtil.isEmpty(rPr.getColor()) && StyleUtil.isEmpty(rPr.getSpacing()) && StyleUtil.isEmpty(rPr.getW()) && StyleUtil.isEmpty(rPr.getKern()) && StyleUtil.isEmpty(rPr.getPosition()) && StyleUtil.isEmpty(rPr.getSz()) && StyleUtil.isEmpty(rPr.getSzCs()) && StyleUtil.isEmpty(rPr.getHighlight()) && StyleUtil.isEmpty(rPr.getU()) && StyleUtil.isEmpty(rPr.getEffect()) && StyleUtil.isEmpty(rPr.getBdr()) && StyleUtil.isEmpty(rPr.getShd()) && StyleUtil.isEmpty(rPr.getVertAlign()) && StyleUtil.isEmpty(rPr.getRtl()) && StyleUtil.isEmpty(rPr.getCs()) && StyleUtil.isEmpty(rPr.getEm()) && StyleUtil.isEmpty(rPr.getSpecVanish()) && StyleUtil.isEmpty(rPr.getOMath());
    }

    public static boolean isEmpty(CTTblPrBase tblPr) {
        return tblPr == null || StyleUtil.isEmpty(tblPr.getTblStyle()) && StyleUtil.isEmpty(tblPr.getTblpPr()) && StyleUtil.isEmpty(tblPr.getTblOverlap()) && StyleUtil.isEmpty(tblPr.getTblStyleRowBandSize()) && StyleUtil.isEmpty(tblPr.getTblStyleColBandSize()) && StyleUtil.isEmpty(tblPr.getTblW()) && StyleUtil.isEmpty(tblPr.getJc()) && StyleUtil.isEmpty(tblPr.getTblCellSpacing()) && StyleUtil.isEmpty(tblPr.getTblInd()) && StyleUtil.isEmpty(tblPr.getTblBorders()) && StyleUtil.isEmpty(tblPr.getShd()) && StyleUtil.isEmpty(tblPr.getTblLayout()) && StyleUtil.isEmpty(tblPr.getTblCellMar()) && StyleUtil.isEmpty(tblPr.getTblLook());
    }

    public static boolean isEmpty(TcPr tcPr) {
        return tcPr == null || StyleUtil.isEmpty(tcPr.getCnfStyle()) && StyleUtil.isEmpty(tcPr.getTcW()) && StyleUtil.isEmpty(tcPr.getGridSpan()) && StyleUtil.isEmpty(tcPr.getHMerge()) && StyleUtil.isEmpty(tcPr.getVMerge()) && StyleUtil.isEmpty(tcPr.getTcBorders()) && StyleUtil.isEmpty(tcPr.getShd()) && StyleUtil.isEmpty(tcPr.getNoWrap()) && StyleUtil.isEmpty(tcPr.getTcMar()) && StyleUtil.isEmpty(tcPr.getTextDirection()) && StyleUtil.isEmpty(tcPr.getTcFitText()) && StyleUtil.isEmpty(tcPr.getVAlign()) && StyleUtil.isEmpty(tcPr.getHideMark());
    }

    public static boolean isEmpty(List<CTTblStylePr> tblStylePrList) {
        if (tblStylePrList == null || tblStylePrList.isEmpty()) {
            return true;
        }
        for (int i = 0; i < tblStylePrList.size(); ++i) {
            if (StyleUtil.isEmpty(tblStylePrList.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CTTblStylePr ctTblStylePr) {
        return ctTblStylePr == null || StyleUtil.isEmpty(ctTblStylePr.getPPr()) && StyleUtil.isEmpty(ctTblStylePr.getRPr()) && StyleUtil.isEmpty(ctTblStylePr.getTblPr()) && StyleUtil.isEmpty(ctTblStylePr.getTrPr()) && ctTblStylePr.getType() == null;
    }

    public static boolean isEmpty(PPrBase.OutlineLvl outlineLvl) {
        return outlineLvl == null || outlineLvl.getVal() == null;
    }

    public static boolean isEmpty(CTTextboxTightWrap textboxTightWrap) {
        return textboxTightWrap == null || textboxTightWrap.getVal() == null;
    }

    public static boolean isEmpty(PPrBase.TextAlignment textAlignment) {
        return textAlignment == null || textAlignment.getVal() == null;
    }

    public static boolean isEmpty(TextDirection textDirection) {
        return textDirection == null || textDirection.getVal() == null;
    }

    public static boolean isEmpty(Jc jc) {
        return jc == null || jc.getVal() == null;
    }

    public static boolean isEmpty(PPrBase.Ind ind) {
        return ind == null || StyleUtil.isEmpty(ind.getFirstLine()) && StyleUtil.isEmpty(ind.getFirstLineChars()) && StyleUtil.isEmpty(ind.getHanging()) && StyleUtil.isEmpty(ind.getHangingChars()) && StyleUtil.isEmpty(ind.getLeft()) && StyleUtil.isEmpty(ind.getLeftChars()) && StyleUtil.isEmpty(ind.getRight()) && StyleUtil.isEmpty(ind.getRightChars());
    }

    public static boolean isEmpty(PPrBase.Spacing spacing) {
        return spacing == null || StyleUtil.isEmpty(spacing.getAfter()) && StyleUtil.isEmpty(spacing.getAfterLines()) && StyleUtil.isEmpty(spacing.getBefore()) && StyleUtil.isEmpty(spacing.getBeforeLines()) && StyleUtil.isEmpty(spacing.getLine()) && spacing.getLineRule() == null;
    }

    public static boolean isEmpty(Tabs tabs) {
        if (tabs == null || tabs.getTab() == null || tabs.getTab().isEmpty()) {
            return true;
        }
        for (int i = 0; i < tabs.getTab().size(); ++i) {
            if (StyleUtil.isEmpty(tabs.getTab().get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CTTabStop ctTabStop) {
        return ctTabStop == null || StyleUtil.isEmpty(ctTabStop.getPos()) && ctTabStop.getVal() == null && ctTabStop.getLeader() == null;
    }

    public static boolean isEmpty(CTShd shd) {
        return shd == null || StyleUtil.isEmpty(shd.getColor()) && StyleUtil.isEmpty(shd.getThemeTint()) && StyleUtil.isEmpty(shd.getThemeShade()) && StyleUtil.isEmpty(shd.getFill()) && StyleUtil.isEmpty(shd.getThemeFillTint()) && StyleUtil.isEmpty(shd.getThemeFillShade()) && shd.getThemeColor() == null && shd.getThemeFill() == null && shd.getVal() == null;
    }

    public static boolean isEmpty(PPrBase.PBdr pBdr) {
        return pBdr == null || StyleUtil.isEmpty(pBdr.getTop()) && StyleUtil.isEmpty(pBdr.getLeft()) && StyleUtil.isEmpty(pBdr.getBottom()) && StyleUtil.isEmpty(pBdr.getRight()) && StyleUtil.isEmpty(pBdr.getBetween()) && StyleUtil.isEmpty(pBdr.getBar());
    }

    public static boolean isEmpty(CTBorder border) {
        return border == null || StyleUtil.isEmpty(border.getColor()) && StyleUtil.isEmpty(border.getSpace()) && StyleUtil.isEmpty(border.getSz()) && border.getThemeColor() == null && StyleUtil.isEmpty(border.getThemeShade()) && StyleUtil.isEmpty(border.getThemeTint()) && border.getVal() == null;
    }

    public static boolean isEmpty(PPrBase.NumPr numPr) {
        return numPr == null || numPr.getNumId() == null || StyleUtil.isEmpty(numPr.getNumId().getVal());
    }

    public static boolean isEmpty(CTFramePr framePr) {
        return framePr == null || framePr.getDropCap() == null && StyleUtil.isEmpty(framePr.getLines()) && StyleUtil.isEmpty(framePr.getW()) && StyleUtil.isEmpty(framePr.getH()) && StyleUtil.isEmpty(framePr.getVSpace()) && StyleUtil.isEmpty(framePr.getHSpace()) && framePr.getWrap() == null && framePr.getHAnchor() == null && framePr.getVAnchor() == null && StyleUtil.isEmpty(framePr.getX()) && framePr.getXAlign() == null && StyleUtil.isEmpty(framePr.getY()) && framePr.getYAlign() == null && framePr.getHRule() == null && framePr.isAnchorLock();
    }

    public static boolean isEmpty(CTCnf cnfStyle) {
        return cnfStyle == null || StyleUtil.isEmpty(cnfStyle.getVal());
    }

    public static boolean isEmpty(PPrBase.PStyle pStyle) {
        return pStyle == null || StyleUtil.isEmpty(pStyle.getVal());
    }

    public static boolean isEmpty(RFonts rFonts) {
        return rFonts == null || StyleUtil.isEmpty(rFonts.getAscii()) && StyleUtil.isEmpty(rFonts.getAsciiTheme()) && StyleUtil.isEmpty(rFonts.getCs()) && StyleUtil.isEmpty(rFonts.getCstheme()) && StyleUtil.isEmpty(rFonts.getEastAsia()) && StyleUtil.isEmpty(rFonts.getEastAsiaTheme()) && StyleUtil.isEmpty(rFonts.getHAnsi()) && StyleUtil.isEmpty(rFonts.getHAnsiTheme());
    }

    public static boolean isEmpty(STHint stHint) {
        return stHint == null;
    }

    public static boolean isEmpty(STTheme stTheme) {
        return stTheme == null;
    }

    public static boolean isEmpty(RStyle rStyle) {
        return rStyle == null || StyleUtil.isEmpty(rStyle.getVal());
    }

    public static boolean isEmpty(CTEm em) {
        return em == null || em.getVal() == null;
    }

    public static boolean isEmpty(CTVerticalAlignRun vertAlign) {
        return vertAlign == null || vertAlign.getVal() == null;
    }

    public static boolean isEmpty(CTTextEffect effect) {
        return effect == null || effect.getVal() == null;
    }

    public static boolean isEmpty(U u) {
        return u == null || u.getVal() == null && StyleUtil.isEmpty(u.getColor());
    }

    public static boolean isEmpty(Highlight highlight) {
        return highlight == null || StyleUtil.isEmpty(highlight.getVal());
    }

    public static boolean isEmpty(CTSignedHpsMeasure measure) {
        return measure == null || StyleUtil.isEmpty(measure.getVal());
    }

    public static boolean isEmpty(HpsMeasure measure) {
        return measure == null || StyleUtil.isEmpty(measure.getVal());
    }

    public static boolean isEmpty(CTTextScale scale) {
        return scale == null || StyleUtil.isEmpty(scale.getVal());
    }

    public static boolean isEmpty(CTSignedTwipsMeasure measure) {
        return measure == null || StyleUtil.isEmpty(measure.getVal());
    }

    public static boolean isEmpty(Color color) {
        return color == null || StyleUtil.isEmpty(color.getVal());
    }

    public static boolean isEmpty(CTTblLook tblLook) {
        return tblLook == null || tblLook.getFirstColumn() == null && tblLook.getFirstRow() == null && tblLook.getLastColumn() == null && tblLook.getLastRow() == null && tblLook.getNoHBand() == null && tblLook.getNoVBand() == null && tblLook.getVal() == null;
    }

    public static boolean isEmpty(CTTblLayoutType tblLayout) {
        return tblLayout == null || tblLayout.getType() == null;
    }

    public static boolean isEmpty(CTTblCellMar margin) {
        return margin == null || StyleUtil.isEmpty(margin.getBottom()) && StyleUtil.isEmpty(margin.getLeft()) && StyleUtil.isEmpty(margin.getRight()) && StyleUtil.isEmpty(margin.getTop());
    }

    public static boolean isEmpty(TblBorders borders) {
        return borders == null || StyleUtil.isEmpty(borders.getBottom()) && StyleUtil.isEmpty(borders.getLeft()) && StyleUtil.isEmpty(borders.getRight()) && StyleUtil.isEmpty(borders.getTop()) && StyleUtil.isEmpty(borders.getInsideH()) && StyleUtil.isEmpty(borders.getInsideV());
    }

    public static boolean isEmpty(CTTblPrBase.TblStyleColBandSize bandSize) {
        return bandSize == null || StyleUtil.isEmpty(bandSize.getVal());
    }

    public static boolean isEmpty(CTTblPrBase.TblStyleRowBandSize bandSize) {
        return bandSize == null || StyleUtil.isEmpty(bandSize.getVal());
    }

    public static boolean isEmpty(CTTblOverlap overlap) {
        return overlap == null || overlap.getVal() == null;
    }

    public static boolean isEmpty(CTTblPPr tblpPr) {
        return tblpPr == null || StyleUtil.isEmpty(tblpPr.getLeftFromText()) && StyleUtil.isEmpty(tblpPr.getRightFromText()) && StyleUtil.isEmpty(tblpPr.getTopFromText()) && StyleUtil.isEmpty(tblpPr.getBottomFromText()) && StyleUtil.isEmpty(tblpPr.getVertAnchor() == null) && StyleUtil.isEmpty(tblpPr.getHorzAnchor() == null) && StyleUtil.isEmpty(tblpPr.getTblpXSpec() == null) && StyleUtil.isEmpty(tblpPr.getTblpX()) && StyleUtil.isEmpty(tblpPr.getTblpYSpec() == null) && StyleUtil.isEmpty(tblpPr.getTblpY());
    }

    public static boolean isEmpty(CTTblPrBase.TblStyle style) {
        return style == null || StyleUtil.isEmpty(style.getVal());
    }

    public static boolean isEmpty(CTVerticalJc vAlign) {
        return vAlign == null || vAlign.getVal() == null;
    }

    public static boolean isEmpty(TcMar margin) {
        return margin == null || StyleUtil.isEmpty(margin.getBottom()) && StyleUtil.isEmpty(margin.getLeft()) && StyleUtil.isEmpty(margin.getRight()) && StyleUtil.isEmpty(margin.getTop());
    }

    public static boolean isEmpty(TcPrInner.TcBorders borders) {
        return borders == null || StyleUtil.isEmpty(borders.getBottom()) && StyleUtil.isEmpty(borders.getLeft()) && StyleUtil.isEmpty(borders.getRight()) && StyleUtil.isEmpty(borders.getTop()) && StyleUtil.isEmpty(borders.getInsideH()) && StyleUtil.isEmpty(borders.getInsideV()) && StyleUtil.isEmpty(borders.getTl2Br()) && StyleUtil.isEmpty(borders.getTr2Bl());
    }

    public static boolean isEmpty(TcPrInner.VMerge merge) {
        return merge == null || StyleUtil.isEmpty(merge.getVal());
    }

    public static boolean isEmpty(TcPrInner.HMerge merge) {
        return merge == null || StyleUtil.isEmpty(merge.getVal());
    }

    public static boolean isEmpty(TcPrInner.GridSpan gridSpan) {
        return gridSpan == null || StyleUtil.isEmpty(gridSpan.getVal());
    }

    public static boolean isEmpty(TrPr trPr) {
        return trPr == null || trPr.getCnfStyleOrDivIdOrGridBefore() == null || trPr.getCnfStyleOrDivIdOrGridBefore().isEmpty();
    }

    public static boolean isEmpty(CTHeight height) {
        return height == null || StyleUtil.isEmpty(height.getVal());
    }

    public static boolean isEmpty(TblWidth width) {
        return width == null || StyleUtil.isEmpty(width.getW());
    }

    public static boolean isEmpty(CTShortHexNumber number) {
        return number == null || StyleUtil.isEmpty(number.getVal());
    }

    public static boolean isEmpty(BooleanDefaultTrue booleanDefaultTrue) {
        return booleanDefaultTrue == null;
    }

    public static boolean isEmpty(Boolean bool) {
        return bool == null || bool == false;
    }

    protected static boolean isEmpty(BigInteger val) {
        return val == null;
    }

    protected static boolean isEmpty(Integer val) {
        return val == null;
    }

    protected static boolean isEmpty(String val) {
        return val == null || val.length() == 0;
    }

    protected static boolean isEmpty(STThemeColor val) {
        return val == null || val.equals((Object)STThemeColor.NONE);
    }

    protected static boolean isEmpty(SectPr val) {
        if (val == null) {
            return true;
        }
        log.debug("TODO: isEmpty(SectPr) implementation is quite basic");
        return false;
    }

    public static Style apply(PPr source, Style destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createStyle();
            }
            if (CHARACTER_STYLE.equals(destination.getType())) {
                log.warn("Can't apply PPr to a character style!");
            } else {
                destination.setPPr(StyleUtil.apply(source, destination.getPPr()));
            }
        }
        return destination;
    }

    public static Style apply(RPr source, Style destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createStyle();
            }
            destination.setRPr(StyleUtil.apply(source, destination.getRPr()));
        }
        return destination;
    }

    public static Style apply(Style source, Style destination) {
        if (StyleUtil.isEmpty(source)) {
            log.debug("empty source style");
        } else {
            if (destination == null) {
                log.debug("new destination style");
                destination = Context.getWmlObjectFactory().createStyle();
                if (source.getType() != null) {
                    destination.setType(source.getType());
                }
            } else if (!StyleUtil.areEqual(source.getType(), destination.getType())) {
                if (destination.getType() == null) {
                    log.warn("Setting destination style type from source type " + source.getType());
                    destination.setType(source.getType());
                } else {
                    throw new RuntimeException("Source style type " + source.getType() + " does not match destination type " + destination.getType());
                }
            }
            if (CHARACTER_STYLE.equals(source.getType())) {
                destination.setRPr(StyleUtil.apply(source.getRPr(), destination.getRPr()));
            } else if (PARAGRAPH_STYLE.equals(source.getType()) || NUMBERING_STYLE.equals(source.getType())) {
                destination.setPPr(StyleUtil.apply(source.getPPr(), destination.getPPr()));
                destination.setRPr(StyleUtil.apply(source.getRPr(), destination.getRPr()));
            } else if (TABLE_STYLE.equals(source.getType())) {
                destination.setTblPr(StyleUtil.apply(source.getTblPr(), destination.getTblPr()));
                destination.setTcPr(StyleUtil.apply(source.getTcPr(), destination.getTcPr()));
                StyleUtil.apply(source.getTblStylePr(), destination.getTblStylePr());
                destination.setPPr(StyleUtil.apply(source.getPPr(), destination.getPPr()));
                destination.setRPr(StyleUtil.apply(source.getRPr(), destination.getRPr()));
            } else {
                log.warn("source style type is currently unknown or null");
                destination.setTblPr(StyleUtil.apply(source.getTblPr(), destination.getTblPr()));
                destination.setTcPr(StyleUtil.apply(source.getTcPr(), destination.getTcPr()));
                StyleUtil.apply(source.getTblStylePr(), destination.getTblStylePr());
                destination.setPPr(StyleUtil.apply(source.getPPr(), destination.getPPr()));
                destination.setRPr(StyleUtil.apply(source.getRPr(), destination.getRPr()));
            }
        }
        return destination;
    }

    public static PPr apply(PPr source, PPr destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createPPr();
            }
            StyleUtil.apply((PPrBase)source, (PPrBase)destination);
            destination.setRPr(StyleUtil.apply(source.getRPr(), destination.getRPr()));
            destination.setSectPr(StyleUtil.apply(source.getSectPr(), destination.getSectPr()));
        }
        return destination;
    }

    public static PPr apply(PPr source, PPr destination, NumberingDefinitionsPart numberingDefinitionsPart) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createPPr();
            }
            StyleUtil.apply((PPrBase)source, (PPrBase)destination, numberingDefinitionsPart);
            destination.setRPr(StyleUtil.apply(source.getRPr(), destination.getRPr()));
            destination.setSectPr(StyleUtil.apply(source.getSectPr(), destination.getSectPr()));
        }
        return destination;
    }

    public static void apply(PPrBase source, PPrBase destination) {
        StyleUtil.apply(source, destination, null);
    }

    public static void apply(PPrBase source, PPrBase destination, NumberingDefinitionsPart numberingDefinitionsPart) {
        if (!StyleUtil.isEmpty(source)) {
            PPrBase.Ind numInd;
            destination.setPStyle(StyleUtil.apply(source.getPStyle(), destination.getPStyle()));
            destination.setKeepNext(StyleUtil.apply(source.getKeepNext(), destination.getKeepNext()));
            destination.setKeepLines(StyleUtil.apply(source.getKeepLines(), destination.getKeepLines()));
            destination.setPageBreakBefore(StyleUtil.apply(source.getPageBreakBefore(), destination.getPageBreakBefore()));
            destination.setFramePr(StyleUtil.apply(source.getFramePr(), destination.getFramePr()));
            destination.setWidowControl(StyleUtil.apply(source.getWidowControl(), destination.getWidowControl()));
            destination.setNumPr(StyleUtil.apply(source.getNumPr(), destination.getNumPr()));
            if (numberingDefinitionsPart != null && source.getNumPr() != null && (numInd = numberingDefinitionsPart.getInd(source.getNumPr())) != null) {
                destination.setInd(StyleUtil.apply(numInd, destination.getInd()));
            }
            destination.setInd(StyleUtil.apply(source.getInd(), destination.getInd()));
            destination.setSuppressLineNumbers(StyleUtil.apply(source.getSuppressLineNumbers(), destination.getSuppressLineNumbers()));
            destination.setPBdr(StyleUtil.apply(source.getPBdr(), destination.getPBdr()));
            destination.setShd(StyleUtil.apply(source.getShd(), destination.getShd()));
            destination.setTabs(StyleUtil.apply(source.getTabs(), destination.getTabs()));
            destination.setSuppressAutoHyphens(StyleUtil.apply(source.getSuppressAutoHyphens(), destination.getSuppressAutoHyphens()));
            destination.setKinsoku(StyleUtil.apply(source.getKinsoku(), destination.getKinsoku()));
            destination.setWordWrap(StyleUtil.apply(source.getWordWrap(), destination.getWordWrap()));
            destination.setOverflowPunct(StyleUtil.apply(source.getOverflowPunct(), destination.getOverflowPunct()));
            destination.setTopLinePunct(StyleUtil.apply(source.getTopLinePunct(), destination.getTopLinePunct()));
            destination.setAutoSpaceDE(StyleUtil.apply(source.getAutoSpaceDE(), destination.getAutoSpaceDE()));
            destination.setAutoSpaceDN(StyleUtil.apply(source.getAutoSpaceDN(), destination.getAutoSpaceDN()));
            destination.setBidi(StyleUtil.apply(source.getBidi(), destination.getBidi()));
            destination.setAdjustRightInd(StyleUtil.apply(source.getAdjustRightInd(), destination.getAdjustRightInd()));
            destination.setSnapToGrid(StyleUtil.apply(source.getSnapToGrid(), destination.getSnapToGrid()));
            destination.setSpacing(StyleUtil.apply(source.getSpacing(), destination.getSpacing()));
            destination.setContextualSpacing(StyleUtil.apply(source.getContextualSpacing(), destination.getContextualSpacing()));
            destination.setMirrorIndents(StyleUtil.apply(source.getMirrorIndents(), destination.getMirrorIndents()));
            destination.setSuppressOverlap(StyleUtil.apply(source.getSuppressOverlap(), destination.getSuppressOverlap()));
            destination.setJc(StyleUtil.apply(source.getJc(), destination.getJc()));
            destination.setTextDirection(StyleUtil.apply(source.getTextDirection(), destination.getTextDirection()));
            destination.setTextAlignment(StyleUtil.apply(source.getTextAlignment(), destination.getTextAlignment()));
            destination.setTextboxTightWrap(StyleUtil.apply(source.getTextboxTightWrap(), destination.getTextboxTightWrap()));
            destination.setOutlineLvl(StyleUtil.apply(source.getOutlineLvl(), destination.getOutlineLvl()));
            destination.setCnfStyle(StyleUtil.apply(source.getCnfStyle(), destination.getCnfStyle()));
        }
    }

    public static SectPr apply(SectPr source, SectPr destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createSectPr();
            }
            destination.setFormProt(StyleUtil.apply(source.getFormProt(), destination.getFormProt()));
            destination.setVAlign(StyleUtil.apply(source.getVAlign(), destination.getVAlign()));
            destination.setNoEndnote(StyleUtil.apply(source.getNoEndnote(), destination.getNoEndnote()));
            destination.setTitlePg(StyleUtil.apply(source.getTitlePg(), destination.getTitlePg()));
            destination.setTextDirection(StyleUtil.apply(source.getTextDirection(), destination.getTextDirection()));
            destination.setBidi(StyleUtil.apply(source.getBidi(), destination.getBidi()));
            destination.setRtlGutter(StyleUtil.apply(source.getRtlGutter(), destination.getRtlGutter()));
            log.warn("TODO: implementation is incomplete");
        }
        return destination;
    }

    public static RPr apply(RPr source, RPr destination) {
        boolean hint = false;
        if (source != null && source.getRFonts() != null && !StyleUtil.isEmpty(source.getRFonts().getHint())) {
            hint = true;
            log.debug("source rPr contains rFonts with hint");
        }
        if (StyleUtil.isEmpty(source) && !hint) {
            log.debug("no source rPr to apply");
        } else {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createRPr();
            }
            destination.setLang(StyleUtil.apply(source.getLang(), destination.getLang()));
            destination.setRStyle(StyleUtil.apply(source.getRStyle(), destination.getRStyle()));
            destination.setRFonts(StyleUtil.apply(source.getRFonts(), destination.getRFonts()));
            destination.setB(StyleUtil.apply(source.getB(), destination.getB()));
            destination.setBCs(StyleUtil.apply(source.getBCs(), destination.getBCs()));
            destination.setI(StyleUtil.apply(source.getI(), destination.getI()));
            destination.setICs(StyleUtil.apply(source.getICs(), destination.getICs()));
            destination.setCaps(StyleUtil.apply(source.getCaps(), destination.getCaps()));
            destination.setSmallCaps(StyleUtil.apply(source.getSmallCaps(), destination.getSmallCaps()));
            destination.setStrike(StyleUtil.apply(source.getStrike(), destination.getStrike()));
            destination.setDstrike(StyleUtil.apply(source.getDstrike(), destination.getDstrike()));
            destination.setOutline(StyleUtil.apply(source.getOutline(), destination.getOutline()));
            destination.setShadow(StyleUtil.apply(source.getShadow(), destination.getShadow()));
            destination.setEmboss(StyleUtil.apply(source.getEmboss(), destination.getEmboss()));
            destination.setImprint(StyleUtil.apply(source.getImprint(), destination.getImprint()));
            destination.setSnapToGrid(StyleUtil.apply(source.getSnapToGrid(), destination.getSnapToGrid()));
            destination.setVanish(StyleUtil.apply(source.getVanish(), destination.getVanish()));
            destination.setColor(StyleUtil.apply(source.getColor(), destination.getColor()));
            destination.setSpacing(StyleUtil.apply(source.getSpacing(), destination.getSpacing()));
            destination.setW(StyleUtil.apply(source.getW(), destination.getW()));
            destination.setKern(StyleUtil.apply(source.getKern(), destination.getKern()));
            destination.setPosition(StyleUtil.apply(source.getPosition(), destination.getPosition()));
            destination.setSz(StyleUtil.apply(source.getSz(), destination.getSz()));
            destination.setSzCs(StyleUtil.apply(source.getSzCs(), destination.getSzCs()));
            destination.setHighlight(StyleUtil.apply(source.getHighlight(), destination.getHighlight()));
            destination.setU(StyleUtil.apply(source.getU(), destination.getU()));
            destination.setEffect(StyleUtil.apply(source.getEffect(), destination.getEffect()));
            destination.setBdr(StyleUtil.apply(source.getBdr(), destination.getBdr()));
            destination.setShd(StyleUtil.apply(source.getShd(), destination.getShd()));
            destination.setVertAlign(StyleUtil.apply(source.getVertAlign(), destination.getVertAlign()));
            destination.setRtl(StyleUtil.apply(source.getRtl(), destination.getRtl()));
            destination.setCs(StyleUtil.apply(source.getCs(), destination.getCs()));
            destination.setEm(StyleUtil.apply(source.getEm(), destination.getEm()));
            destination.setSpecVanish(StyleUtil.apply(source.getSpecVanish(), destination.getSpecVanish()));
            destination.setOMath(StyleUtil.apply(source.getOMath(), destination.getOMath()));
        }
        return destination;
    }

    public static CTLanguage apply(CTLanguage source, CTLanguage destination) {
        return source == null ? destination : source;
    }

    public static RPr apply(ParaRPr source, RPr destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createRPr();
            }
            destination.setRStyle(StyleUtil.apply(source.getRStyle(), destination.getRStyle()));
            destination.setRFonts(StyleUtil.apply(source.getRFonts(), destination.getRFonts()));
            destination.setB(StyleUtil.apply(source.getB(), destination.getB()));
            destination.setBCs(StyleUtil.apply(source.getBCs(), destination.getBCs()));
            destination.setI(StyleUtil.apply(source.getI(), destination.getI()));
            destination.setICs(StyleUtil.apply(source.getICs(), destination.getICs()));
            destination.setCaps(StyleUtil.apply(source.getCaps(), destination.getCaps()));
            destination.setSmallCaps(StyleUtil.apply(source.getSmallCaps(), destination.getSmallCaps()));
            destination.setStrike(StyleUtil.apply(source.getStrike(), destination.getStrike()));
            destination.setDstrike(StyleUtil.apply(source.getDstrike(), destination.getDstrike()));
            destination.setOutline(StyleUtil.apply(source.getOutline(), destination.getOutline()));
            destination.setShadow(StyleUtil.apply(source.getShadow(), destination.getShadow()));
            destination.setEmboss(StyleUtil.apply(source.getEmboss(), destination.getEmboss()));
            destination.setImprint(StyleUtil.apply(source.getImprint(), destination.getImprint()));
            destination.setSnapToGrid(StyleUtil.apply(source.getSnapToGrid(), destination.getSnapToGrid()));
            destination.setVanish(StyleUtil.apply(source.getVanish(), destination.getVanish()));
            destination.setColor(StyleUtil.apply(source.getColor(), destination.getColor()));
            destination.setSpacing(StyleUtil.apply(source.getSpacing(), destination.getSpacing()));
            destination.setW(StyleUtil.apply(source.getW(), destination.getW()));
            destination.setKern(StyleUtil.apply(source.getKern(), destination.getKern()));
            destination.setPosition(StyleUtil.apply(source.getPosition(), destination.getPosition()));
            destination.setSz(StyleUtil.apply(source.getSz(), destination.getSz()));
            destination.setSzCs(StyleUtil.apply(source.getSzCs(), destination.getSzCs()));
            destination.setHighlight(StyleUtil.apply(source.getHighlight(), destination.getHighlight()));
            destination.setU(StyleUtil.apply(source.getU(), destination.getU()));
            destination.setEffect(StyleUtil.apply(source.getEffect(), destination.getEffect()));
            destination.setBdr(StyleUtil.apply(source.getBdr(), destination.getBdr()));
            destination.setShd(StyleUtil.apply(source.getShd(), destination.getShd()));
            destination.setVertAlign(StyleUtil.apply(source.getVertAlign(), destination.getVertAlign()));
            destination.setRtl(StyleUtil.apply(source.getRtl(), destination.getRtl()));
            destination.setCs(StyleUtil.apply(source.getCs(), destination.getCs()));
            destination.setEm(StyleUtil.apply(source.getEm(), destination.getEm()));
            destination.setSpecVanish(StyleUtil.apply(source.getSpecVanish(), destination.getSpecVanish()));
            destination.setOMath(StyleUtil.apply(source.getOMath(), destination.getOMath()));
        }
        return destination;
    }

    public static ParaRPr apply(RPr source, ParaRPr destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createParaRPr();
            }
            destination.setRStyle(StyleUtil.apply(source.getRStyle(), destination.getRStyle()));
            destination.setRFonts(StyleUtil.apply(source.getRFonts(), destination.getRFonts()));
            destination.setB(StyleUtil.apply(source.getB(), destination.getB()));
            destination.setBCs(StyleUtil.apply(source.getBCs(), destination.getBCs()));
            destination.setI(StyleUtil.apply(source.getI(), destination.getI()));
            destination.setICs(StyleUtil.apply(source.getICs(), destination.getICs()));
            destination.setCaps(StyleUtil.apply(source.getCaps(), destination.getCaps()));
            destination.setSmallCaps(StyleUtil.apply(source.getSmallCaps(), destination.getSmallCaps()));
            destination.setStrike(StyleUtil.apply(source.getStrike(), destination.getStrike()));
            destination.setDstrike(StyleUtil.apply(source.getDstrike(), destination.getDstrike()));
            destination.setOutline(StyleUtil.apply(source.getOutline(), destination.getOutline()));
            destination.setShadow(StyleUtil.apply(source.getShadow(), destination.getShadow()));
            destination.setEmboss(StyleUtil.apply(source.getEmboss(), destination.getEmboss()));
            destination.setImprint(StyleUtil.apply(source.getImprint(), destination.getImprint()));
            destination.setSnapToGrid(StyleUtil.apply(source.getSnapToGrid(), destination.getSnapToGrid()));
            destination.setVanish(StyleUtil.apply(source.getVanish(), destination.getVanish()));
            destination.setColor(StyleUtil.apply(source.getColor(), destination.getColor()));
            destination.setSpacing(StyleUtil.apply(source.getSpacing(), destination.getSpacing()));
            destination.setW(StyleUtil.apply(source.getW(), destination.getW()));
            destination.setKern(StyleUtil.apply(source.getKern(), destination.getKern()));
            destination.setPosition(StyleUtil.apply(source.getPosition(), destination.getPosition()));
            destination.setSz(StyleUtil.apply(source.getSz(), destination.getSz()));
            destination.setSzCs(StyleUtil.apply(source.getSzCs(), destination.getSzCs()));
            destination.setHighlight(StyleUtil.apply(source.getHighlight(), destination.getHighlight()));
            destination.setU(StyleUtil.apply(source.getU(), destination.getU()));
            destination.setEffect(StyleUtil.apply(source.getEffect(), destination.getEffect()));
            destination.setBdr(StyleUtil.apply(source.getBdr(), destination.getBdr()));
            destination.setShd(StyleUtil.apply(source.getShd(), destination.getShd()));
            destination.setVertAlign(StyleUtil.apply(source.getVertAlign(), destination.getVertAlign()));
            destination.setRtl(StyleUtil.apply(source.getRtl(), destination.getRtl()));
            destination.setCs(StyleUtil.apply(source.getCs(), destination.getCs()));
            destination.setEm(StyleUtil.apply(source.getEm(), destination.getEm()));
            destination.setSpecVanish(StyleUtil.apply(source.getSpecVanish(), destination.getSpecVanish()));
            destination.setOMath(StyleUtil.apply(source.getOMath(), destination.getOMath()));
        }
        return destination;
    }

    public static ParaRPr apply(ParaRPr source, ParaRPr destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createParaRPr();
            }
            destination.setRStyle(StyleUtil.apply(source.getRStyle(), destination.getRStyle()));
            destination.setRFonts(StyleUtil.apply(source.getRFonts(), destination.getRFonts()));
            destination.setB(StyleUtil.apply(source.getB(), destination.getB()));
            destination.setBCs(StyleUtil.apply(source.getBCs(), destination.getBCs()));
            destination.setI(StyleUtil.apply(source.getI(), destination.getI()));
            destination.setICs(StyleUtil.apply(source.getICs(), destination.getICs()));
            destination.setCaps(StyleUtil.apply(source.getCaps(), destination.getCaps()));
            destination.setSmallCaps(StyleUtil.apply(source.getSmallCaps(), destination.getSmallCaps()));
            destination.setStrike(StyleUtil.apply(source.getStrike(), destination.getStrike()));
            destination.setDstrike(StyleUtil.apply(source.getDstrike(), destination.getDstrike()));
            destination.setOutline(StyleUtil.apply(source.getOutline(), destination.getOutline()));
            destination.setShadow(StyleUtil.apply(source.getShadow(), destination.getShadow()));
            destination.setEmboss(StyleUtil.apply(source.getEmboss(), destination.getEmboss()));
            destination.setImprint(StyleUtil.apply(source.getImprint(), destination.getImprint()));
            destination.setSnapToGrid(StyleUtil.apply(source.getSnapToGrid(), destination.getSnapToGrid()));
            destination.setVanish(StyleUtil.apply(source.getVanish(), destination.getVanish()));
            destination.setColor(StyleUtil.apply(source.getColor(), destination.getColor()));
            destination.setSpacing(StyleUtil.apply(source.getSpacing(), destination.getSpacing()));
            destination.setW(StyleUtil.apply(source.getW(), destination.getW()));
            destination.setKern(StyleUtil.apply(source.getKern(), destination.getKern()));
            destination.setPosition(StyleUtil.apply(source.getPosition(), destination.getPosition()));
            destination.setSz(StyleUtil.apply(source.getSz(), destination.getSz()));
            destination.setSzCs(StyleUtil.apply(source.getSzCs(), destination.getSzCs()));
            destination.setHighlight(StyleUtil.apply(source.getHighlight(), destination.getHighlight()));
            destination.setU(StyleUtil.apply(source.getU(), destination.getU()));
            destination.setEffect(StyleUtil.apply(source.getEffect(), destination.getEffect()));
            destination.setBdr(StyleUtil.apply(source.getBdr(), destination.getBdr()));
            destination.setShd(StyleUtil.apply(source.getShd(), destination.getShd()));
            destination.setVertAlign(StyleUtil.apply(source.getVertAlign(), destination.getVertAlign()));
            destination.setRtl(StyleUtil.apply(source.getRtl(), destination.getRtl()));
            destination.setCs(StyleUtil.apply(source.getCs(), destination.getCs()));
            destination.setEm(StyleUtil.apply(source.getEm(), destination.getEm()));
            destination.setSpecVanish(StyleUtil.apply(source.getSpecVanish(), destination.getSpecVanish()));
            destination.setOMath(StyleUtil.apply(source.getOMath(), destination.getOMath()));
        }
        return destination;
    }

    public static CTTblPrBase apply(CTTblPrBase source, CTTblPrBase destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createTblPr();
            }
            destination.setBidiVisual(StyleUtil.apply(source.getBidiVisual(), destination.getBidiVisual()));
            destination.setTblStyle(StyleUtil.apply(source.getTblStyle(), destination.getTblStyle()));
            destination.setTblpPr(StyleUtil.apply(source.getTblpPr(), destination.getTblpPr()));
            destination.setTblOverlap(StyleUtil.apply(source.getTblOverlap(), destination.getTblOverlap()));
            destination.setTblStyleRowBandSize(StyleUtil.apply(source.getTblStyleRowBandSize(), destination.getTblStyleRowBandSize()));
            destination.setTblStyleColBandSize(StyleUtil.apply(source.getTblStyleColBandSize(), destination.getTblStyleColBandSize()));
            destination.setTblW(StyleUtil.apply(source.getTblW(), destination.getTblW()));
            destination.setJc(StyleUtil.apply(source.getJc(), destination.getJc()));
            destination.setTblCellSpacing(StyleUtil.apply(source.getTblCellSpacing(), destination.getTblCellSpacing()));
            destination.setTblInd(StyleUtil.apply(source.getTblInd(), destination.getTblInd()));
            destination.setTblBorders(StyleUtil.apply(source.getTblBorders(), destination.getTblBorders()));
            destination.setShd(StyleUtil.apply(source.getShd(), destination.getShd()));
            destination.setTblLayout(StyleUtil.apply(source.getTblLayout(), destination.getTblLayout()));
            destination.setTblCellMar(StyleUtil.apply(source.getTblCellMar(), destination.getTblCellMar()));
            destination.setTblLook(StyleUtil.apply(source.getTblLook(), destination.getTblLook()));
        }
        return destination;
    }

    public static TcPr apply(TcPr source, TcPr destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createTcPr();
            }
            destination.setCnfStyle(StyleUtil.apply(source.getCnfStyle(), destination.getCnfStyle()));
            destination.setTcW(StyleUtil.apply(source.getTcW(), destination.getTcW()));
            destination.setGridSpan(StyleUtil.apply(source.getGridSpan(), destination.getGridSpan()));
            destination.setHMerge(StyleUtil.apply(source.getHMerge(), destination.getHMerge()));
            destination.setVMerge(StyleUtil.apply(source.getVMerge(), destination.getVMerge()));
            destination.setTcBorders(StyleUtil.apply(source.getTcBorders(), destination.getTcBorders()));
            destination.setShd(StyleUtil.apply(source.getShd(), destination.getShd()));
            destination.setNoWrap(StyleUtil.apply(source.getNoWrap(), destination.getNoWrap()));
            destination.setTcMar(StyleUtil.apply(source.getTcMar(), destination.getTcMar()));
            destination.setTextDirection(StyleUtil.apply(source.getTextDirection(), destination.getTextDirection()));
            destination.setTcFitText(StyleUtil.apply(source.getTcFitText(), destination.getTcFitText()));
            destination.setVAlign(StyleUtil.apply(source.getVAlign(), destination.getVAlign()));
            destination.setHideMark(StyleUtil.apply(source.getHideMark(), destination.getHideMark()));
        }
        return destination;
    }

    public static void apply(List<CTTblStylePr> source, List<CTTblStylePr> destination) {
        CTTblStylePr destinationTblStylePr = null;
        if (!StyleUtil.isEmpty(source)) {
            destination.clear();
            for (int i = 0; i < source.size(); ++i) {
                destinationTblStylePr = StyleUtil.apply(source.get(i), null);
                if (destinationTblStylePr == null) continue;
                destination.add(destinationTblStylePr);
            }
        }
    }

    public static CTTblLook apply(CTTblLook source, CTTblLook destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTTblLook();
            }
            destination.setFirstColumn(StyleUtil.apply(source.getFirstColumn(), destination.getFirstColumn()));
            destination.setFirstRow(StyleUtil.apply(source.getFirstRow(), destination.getFirstRow()));
            destination.setLastColumn(StyleUtil.apply(source.getLastColumn(), destination.getLastColumn()));
            destination.setLastRow(StyleUtil.apply(source.getLastRow(), destination.getLastRow()));
            destination.setNoHBand(StyleUtil.apply(source.getNoHBand(), destination.getNoHBand()));
            destination.setNoVBand(StyleUtil.apply(source.getNoVBand(), destination.getNoVBand()));
            destination.setVal(StyleUtil.apply(source.getVal(), destination.getVal()));
        }
        return destination;
    }

    private static STOnOff apply(STOnOff source, STOnOff destination) {
        return source == null ? destination : source;
    }

    public static CTTblStylePr apply(CTTblStylePr source, CTTblStylePr destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTTblStylePr();
            }
            destination.setPPr(StyleUtil.apply(source.getPPr(), destination.getPPr()));
            destination.setRPr(StyleUtil.apply(source.getRPr(), destination.getRPr()));
            destination.setTblPr(StyleUtil.apply(source.getTblPr(), destination.getTblPr()));
            destination.setTcPr(StyleUtil.apply(source.getTcPr(), destination.getTcPr()));
            destination.setTrPr(StyleUtil.apply(source.getTrPr(), destination.getTrPr()));
            destination.setType(source.getType());
        }
        return destination;
    }

    public static PPrBase.OutlineLvl apply(PPrBase.OutlineLvl source, PPrBase.OutlineLvl destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createPPrBaseOutlineLvl();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static CTTextboxTightWrap apply(CTTextboxTightWrap source, CTTextboxTightWrap destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTTextboxTightWrap();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static PPrBase.TextAlignment apply(PPrBase.TextAlignment source, PPrBase.TextAlignment destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createPPrBaseTextAlignment();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static TextDirection apply(TextDirection source, TextDirection destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createTextDirection();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static Jc apply(Jc source, Jc destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createJc();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static PPrBase.Ind apply(PPrBase.Ind source, PPrBase.Ind destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createPPrBaseInd();
            }
            destination.setFirstLine(StyleUtil.apply(source.getFirstLine(), destination.getFirstLine()));
            destination.setFirstLineChars(StyleUtil.apply(source.getFirstLineChars(), destination.getFirstLineChars()));
            destination.setHanging(StyleUtil.apply(source.getHanging(), destination.getHanging()));
            destination.setHangingChars(StyleUtil.apply(source.getHangingChars(), destination.getHangingChars()));
            destination.setLeft(StyleUtil.apply(source.getLeft(), destination.getLeft()));
            destination.setLeftChars(StyleUtil.apply(source.getLeftChars(), destination.getLeftChars()));
            destination.setRight(StyleUtil.apply(source.getRight(), destination.getRight()));
            destination.setRightChars(StyleUtil.apply(source.getRightChars(), destination.getRightChars()));
        }
        return destination;
    }

    public static PPrBase.Spacing apply(PPrBase.Spacing source, PPrBase.Spacing destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createPPrBaseSpacing();
            }
            destination.setAfter(StyleUtil.apply(source.getAfter(), destination.getAfter()));
            destination.setAfterLines(StyleUtil.apply(source.getAfterLines(), destination.getAfterLines()));
            destination.setBefore(StyleUtil.apply(source.getBefore(), destination.getBefore()));
            destination.setBeforeLines(StyleUtil.apply(source.getBeforeLines(), destination.getBeforeLines()));
            destination.setLine(StyleUtil.apply(source.getLine(), destination.getLine()));
            destination.setLineRule(StyleUtil.apply(source.getLineRule(), destination.getLineRule()));
        }
        return destination;
    }

    public static STLineSpacingRule apply(STLineSpacingRule source, STLineSpacingRule destination) {
        return source == null ? STLineSpacingRule.AUTO : source;
    }

    public static Tabs apply(Tabs source, Tabs destination) {
        CTTabStop sourceTabStop = null;
        CTTabStop destinationTabStop = null;
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createTabs();
            }
            destination.getTab().clear();
            for (int i = 0; i < source.getTab().size(); ++i) {
                sourceTabStop = source.getTab().get(i);
                destinationTabStop = Context.getWmlObjectFactory().createCTTabStop();
                destinationTabStop.setLeader(sourceTabStop.getLeader());
                destinationTabStop.setPos(sourceTabStop.getPos());
                destinationTabStop.setVal(sourceTabStop.getVal());
                if (destinationTabStop == null) continue;
                destination.getTab().add(destinationTabStop);
            }
        }
        return destination;
    }

    public static CTShd apply(CTShd source, CTShd destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTShd();
            }
            destination.setColor(StyleUtil.apply(source.getColor(), destination.getColor()));
            destination.setFill(StyleUtil.apply(source.getFill(), destination.getFill()));
            destination.setVal(StyleUtil.apply(source.getVal(), destination.getVal()));
            destination.setThemeTint(StyleUtil.apply(source.getThemeTint(), destination.getThemeTint()));
            destination.setThemeShade(StyleUtil.apply(source.getThemeShade(), destination.getThemeShade()));
            destination.setThemeFillTint(StyleUtil.apply(source.getThemeFillTint(), destination.getThemeFillTint()));
            destination.setThemeFillShade(StyleUtil.apply(source.getThemeFillShade(), destination.getThemeFillShade()));
            destination.setThemeColor(source.getThemeColor());
            destination.setThemeFill(source.getThemeFill());
        }
        return destination;
    }

    public static PPrBase.PBdr apply(PPrBase.PBdr source, PPrBase.PBdr destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createPPrBasePBdr();
            }
            destination.setTop(StyleUtil.apply(source.getTop(), destination.getTop()));
            destination.setLeft(StyleUtil.apply(source.getLeft(), destination.getLeft()));
            destination.setBottom(StyleUtil.apply(source.getBottom(), destination.getBottom()));
            destination.setRight(StyleUtil.apply(source.getRight(), destination.getRight()));
            destination.setBetween(StyleUtil.apply(source.getBetween(), destination.getBetween()));
            destination.setBar(StyleUtil.apply(source.getBar(), destination.getBar()));
        }
        return destination;
    }

    public static CTBorder apply(CTBorder source, CTBorder destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTBorder();
            }
            destination.setColor(StyleUtil.apply(source.getColor(), destination.getColor()));
            destination.setSpace(StyleUtil.apply(source.getSpace(), destination.getSpace()));
            destination.setSz(StyleUtil.apply(source.getSz(), destination.getSz()));
            destination.setThemeColor(source.getThemeColor());
            destination.setThemeShade(StyleUtil.apply(source.getThemeShade(), destination.getThemeShade()));
            destination.setThemeTint(StyleUtil.apply(source.getThemeTint(), destination.getThemeTint()));
            destination.setVal(StyleUtil.apply(source.getVal(), destination.getVal()));
        }
        return destination;
    }

    public static PPrBase.NumPr apply(PPrBase.NumPr source, PPrBase.NumPr destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createPPrBaseNumPr();
            }
            if (source.getNumId() != null || source.getIlvl() != null) {
                destination.setNumId(source.getNumId());
                destination.setIlvl(source.getIlvl());
            }
        }
        return destination;
    }

    public static CTFramePr apply(CTFramePr source, CTFramePr destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTFramePr();
            }
            destination.setDropCap(source.getDropCap());
            destination.setLines(StyleUtil.apply(source.getLines(), destination.getLines()));
            destination.setW(StyleUtil.apply(source.getW(), destination.getW()));
            destination.setH(StyleUtil.apply(source.getH(), destination.getH()));
            destination.setVSpace(StyleUtil.apply(source.getVSpace(), destination.getVSpace()));
            destination.setHSpace(StyleUtil.apply(source.getHSpace(), destination.getHSpace()));
            destination.setWrap(source.getWrap());
            destination.setHAnchor(source.getHAnchor());
            destination.setVAnchor(source.getVAnchor());
            destination.setX(StyleUtil.apply(source.getX(), destination.getX()));
            destination.setXAlign(source.getXAlign());
            destination.setY(StyleUtil.apply(source.getY(), destination.getY()));
            destination.setYAlign(source.getYAlign());
            destination.setHRule(source.getHRule());
            destination.setAnchorLock(source.isAnchorLock());
        }
        return destination;
    }

    public static CTCnf apply(CTCnf source, CTCnf destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTCnf();
            }
            destination.setVal(StyleUtil.apply(source.getVal(), destination.getVal()));
        }
        return destination;
    }

    public static PPrBase.PStyle apply(PPrBase.PStyle source, PPrBase.PStyle destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createPPrBasePStyle();
            }
            log.debug("Applying " + source.getVal());
            destination.setVal(StyleUtil.apply(source.getVal(), destination.getVal()));
        }
        return destination;
    }

    public static RFonts apply(RFonts source, RFonts destination) {
        if (destination == null) {
            destination = Context.getWmlObjectFactory().createRFonts();
        }
        if (StyleUtil.isEmpty(source)) {
            if (source != null && source.getHint() != null) {
                destination.setHint(source.getHint());
            }
        } else {
            if (source.getAscii() != null) {
                destination.setAscii(source.getAscii());
                destination.setAsciiTheme(null);
            }
            if (source.getCs() != null) {
                destination.setCs(source.getCs());
                destination.setCstheme(null);
            }
            if (source.getEastAsia() != null) {
                destination.setEastAsia(source.getEastAsia());
                destination.setEastAsiaTheme(null);
            }
            if (source.getHAnsi() != null) {
                destination.setHAnsi(source.getHAnsi());
                destination.setHAnsiTheme(null);
            }
            if (source.getAsciiTheme() != null) {
                destination.setAsciiTheme(source.getAsciiTheme());
                destination.setAscii(null);
            }
            if (source.getCstheme() != null) {
                destination.setCstheme(source.getCstheme());
                destination.setCs(null);
            }
            if (source.getEastAsiaTheme() != null) {
                destination.setEastAsiaTheme(source.getEastAsiaTheme());
                destination.setEastAsia(null);
            }
            if (source.getHAnsiTheme() != null) {
                destination.setHAnsiTheme(source.getHAnsiTheme());
                destination.setHAnsi(null);
            }
            if (source.getHint() != null) {
                destination.setHint(source.getHint());
            }
        }
        return destination;
    }

    public static RStyle apply(RStyle source, RStyle destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createRStyle();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static CTEm apply(CTEm source, CTEm destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTEm();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static CTVerticalAlignRun apply(CTVerticalAlignRun source, CTVerticalAlignRun destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTVerticalAlignRun();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static CTTextEffect apply(CTTextEffect source, CTTextEffect destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTTextEffect();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static U apply(U source, U destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createU();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static Highlight apply(Highlight source, Highlight destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createHighlight();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static CTSignedHpsMeasure apply(CTSignedHpsMeasure source, CTSignedHpsMeasure destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTSignedHpsMeasure();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static HpsMeasure apply(HpsMeasure source, HpsMeasure destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createHpsMeasure();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static CTTextScale apply(CTTextScale source, CTTextScale destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTTextScale();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static CTSignedTwipsMeasure apply(CTSignedTwipsMeasure source, CTSignedTwipsMeasure destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTSignedTwipsMeasure();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static Color apply(Color source, Color destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createColor();
            }
            destination.setThemeColor(StyleUtil.apply(source.getThemeColor(), destination.getThemeColor()));
            destination.setThemeShade(StyleUtil.apply(source.getThemeShade(), destination.getThemeShade()));
            destination.setThemeTint(StyleUtil.apply(source.getThemeTint(), destination.getThemeTint()));
            destination.setVal(StyleUtil.apply(source.getVal(), destination.getVal()));
        }
        return destination;
    }

    private static STThemeColor apply(STThemeColor source, STThemeColor destination) {
        return StyleUtil.isEmpty(source) ? destination : source;
    }

    public static CTTblLayoutType apply(CTTblLayoutType source, CTTblLayoutType destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTTblLayoutType();
            }
            destination.setType(source.getType());
        }
        return destination;
    }

    public static CTTblCellMar apply(CTTblCellMar source, CTTblCellMar destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTTblCellMar();
            }
            destination.setBottom(StyleUtil.apply(source.getBottom(), destination.getBottom()));
            destination.setLeft(StyleUtil.apply(source.getLeft(), destination.getLeft()));
            destination.setRight(StyleUtil.apply(source.getRight(), destination.getRight()));
            destination.setTop(StyleUtil.apply(source.getTop(), destination.getTop()));
        }
        return destination;
    }

    public static TblBorders apply(TblBorders source, TblBorders destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createTblBorders();
            }
            destination.setBottom(StyleUtil.apply(source.getBottom(), destination.getBottom()));
            destination.setLeft(StyleUtil.apply(source.getLeft(), destination.getLeft()));
            destination.setRight(StyleUtil.apply(source.getRight(), destination.getRight()));
            destination.setTop(StyleUtil.apply(source.getTop(), destination.getTop()));
            destination.setInsideH(StyleUtil.apply(source.getInsideH(), destination.getInsideH()));
            destination.setInsideV(StyleUtil.apply(source.getInsideV(), destination.getInsideV()));
        }
        return destination;
    }

    public static CTTblPrBase.TblStyleColBandSize apply(CTTblPrBase.TblStyleColBandSize source, CTTblPrBase.TblStyleColBandSize destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTTblPrBaseTblStyleColBandSize();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static CTTblPrBase.TblStyleRowBandSize apply(CTTblPrBase.TblStyleRowBandSize source, CTTblPrBase.TblStyleRowBandSize destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTTblPrBaseTblStyleRowBandSize();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static CTTblOverlap apply(CTTblOverlap source, CTTblOverlap destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTTblOverlap();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static CTTblPPr apply(CTTblPPr source, CTTblPPr destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTTblPPr();
            }
            destination.setLeftFromText(StyleUtil.apply(source.getLeftFromText(), destination.getLeftFromText()));
            destination.setRightFromText(StyleUtil.apply(source.getRightFromText(), destination.getRightFromText()));
            destination.setTopFromText(StyleUtil.apply(source.getTopFromText(), destination.getTopFromText()));
            destination.setBottomFromText(StyleUtil.apply(source.getBottomFromText(), destination.getBottomFromText()));
            destination.setVertAnchor(source.getVertAnchor());
            destination.setHorzAnchor(source.getHorzAnchor());
            destination.setTblpXSpec(source.getTblpXSpec());
            destination.setTblpX(StyleUtil.apply(source.getTblpX(), destination.getTblpX()));
            destination.setTblpYSpec(source.getTblpYSpec());
            destination.setTblpY(StyleUtil.apply(source.getTblpY(), destination.getTblpY()));
        }
        return destination;
    }

    public static CTTblPrBase.TblStyle apply(CTTblPrBase.TblStyle source, CTTblPrBase.TblStyle destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTTblPrBaseTblStyle();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static CTVerticalJc apply(CTVerticalJc source, CTVerticalJc destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTVerticalJc();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static TcMar apply(TcMar source, TcMar destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createTcMar();
            }
            destination.setBottom(StyleUtil.apply(source.getBottom(), destination.getBottom()));
            destination.setLeft(StyleUtil.apply(source.getLeft(), destination.getLeft()));
            destination.setRight(StyleUtil.apply(source.getRight(), destination.getRight()));
            destination.setTop(StyleUtil.apply(source.getTop(), destination.getTop()));
        }
        return destination;
    }

    public static TcPrInner.TcBorders apply(TcPrInner.TcBorders source, TcPrInner.TcBorders destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createTcPrInnerTcBorders();
            }
            destination.setBottom(StyleUtil.apply(source.getBottom(), destination.getBottom()));
            destination.setLeft(StyleUtil.apply(source.getLeft(), destination.getLeft()));
            destination.setRight(StyleUtil.apply(source.getRight(), destination.getRight()));
            destination.setTop(StyleUtil.apply(source.getTop(), destination.getTop()));
            destination.setInsideH(StyleUtil.apply(source.getInsideH(), destination.getInsideH()));
            destination.setInsideV(StyleUtil.apply(source.getInsideV(), destination.getInsideV()));
            destination.setTl2Br(StyleUtil.apply(source.getTl2Br(), destination.getTl2Br()));
            destination.setTr2Bl(StyleUtil.apply(source.getTr2Bl(), destination.getTr2Bl()));
        }
        return destination;
    }

    public static TcPrInner.VMerge apply(TcPrInner.VMerge source, TcPrInner.VMerge destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createTcPrInnerVMerge();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static TcPrInner.HMerge apply(TcPrInner.HMerge source, TcPrInner.HMerge destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createTcPrInnerHMerge();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static TcPrInner.GridSpan apply(TcPrInner.GridSpan source, TcPrInner.GridSpan destination) {
        if (!StyleUtil.isEmpty(source)) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createTcPrInnerGridSpan();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    public static TrPr apply(TrPr source, TrPr destination) {
        List<JAXBElement<?>> defsSource = null;
        List<JAXBElement<?>> defsDestination = null;
        JAXBElement<?> defsSourceElement = null;
        if (StyleUtil.isEmpty(source)) {
            return destination;
        }
        if (!StyleUtil.isEmpty(destination)) {
            defsSource = source.getCnfStyleOrDivIdOrGridBefore();
            defsDestination = destination.getCnfStyleOrDivIdOrGridBefore();
            for (int i = 0; i < defsSource.size(); ++i) {
                defsSourceElement = defsSource.get(i);
                for (int j = 0; j < defsDestination.size(); ++j) {
                    if (!defsSourceElement.getName().equals(defsDestination.get(j).getName())) continue;
                    defsDestination.remove(j);
                    break;
                }
                defsDestination.add(XmlUtils.deepCopy(defsSourceElement));
            }
        }
        return destination;
    }

    public static TblWidth apply(TblWidth source, TblWidth destination) {
        if (source != null && !StyleUtil.isEmpty(source.getW())) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createTblWidth();
            }
            destination.setW(source.getW());
            destination.setType(source.getType());
        }
        return destination;
    }

    public static CTShortHexNumber apply(CTShortHexNumber source, CTShortHexNumber destination) {
        if (source != null && !StyleUtil.isEmpty(source.getVal())) {
            if (destination == null) {
                destination = Context.getWmlObjectFactory().createCTShortHexNumber();
            }
            destination.setVal(source.getVal());
        }
        return destination;
    }

    private static STBorder apply(STBorder source, STBorder destination) {
        return source == null ? destination : source;
    }

    public static STShd apply(STShd source, STShd destination) {
        return source == null ? destination : source;
    }

    public static STTblOverlap apply(STTblOverlap source, STTblOverlap destination) {
        return source == null ? destination : source;
    }

    public static STTblLayoutType apply(STTblLayoutType source, STTblLayoutType destination) {
        return source == null ? destination : source;
    }

    public static UnderlineEnumeration apply(UnderlineEnumeration source, UnderlineEnumeration destination) {
        return source == null ? destination : source;
    }

    public static STTextEffect apply(STTextEffect source, STTextEffect destination) {
        return source == null ? destination : source;
    }

    public static STEm apply(STEm source, STEm destination) {
        return source == null ? destination : source;
    }

    public static STVerticalAlignRun apply(STVerticalAlignRun source, STVerticalAlignRun destination) {
        return source == null ? destination : source;
    }

    public static STVerticalJc apply(STVerticalJc source, STVerticalJc destination) {
        return source == null ? destination : source;
    }

    public static BooleanDefaultTrue apply(BooleanDefaultTrue source, BooleanDefaultTrue destination) {
        return source == null ? destination : source;
    }

    public static Boolean apply(Boolean source, Boolean destination) {
        return source == null ? destination : source;
    }

    protected static BigInteger apply(BigInteger source, BigInteger destination) {
        return source == null ? destination : source;
    }

    protected static String apply(String source, String destination) {
        return source == null ? destination : source;
    }
}

