/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.LocationAwareXMLStreamException;
import org.docx4j.openpackaging.parts.StAXHandlerAbstract;
import org.docx4j.wml.CTSdtCell;
import org.docx4j.wml.CTSdtRow;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SdtStAXHandler
extends StAXHandlerAbstract {
    private static Logger log = LoggerFactory.getLogger(SdtStAXHandler.class);
    public static JAXBContext context = Context.jc;
    protected Stack stack = new Stack();

    protected abstract List<Object> handleSdt(SdtElement var1) throws Docx4JException;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(XMLStreamReader xsr, XMLStreamWriter xmlWriter) throws LocationAwareXMLStreamException, XMLStreamException {
        boolean mustMove = true;
        while (true) {
            int eventType;
            block19: {
                String localName;
                block20: {
                    void var7_13;
                    block18: {
                        if (!xsr.hasNext()) {
                            return;
                        }
                        if (mustMove) {
                            xsr.next();
                        }
                        if ((eventType = xsr.getEventType()) != 1) break block19;
                        localName = xsr.getLocalName();
                        log.debug("START_ELEMENT " + localName);
                        if (!xsr.getLocalName().equals("sdt")) break block20;
                        Object var7_8 = null;
                        try {
                            Unmarshaller unmarshaller;
                            block22: {
                                block21: {
                                    unmarshaller = context.createUnmarshaller();
                                    SdtStAXHandler sdtStAXHandler = this;
                                    if (sdtStAXHandler.stack.peek().equals("body")) break block21;
                                    SdtStAXHandler sdtStAXHandler2 = this;
                                    if (!sdtStAXHandler2.stack.peek().equals("tc")) break block22;
                                }
                                JAXBElement<SdtBlock> jAXBElement = unmarshaller.unmarshal(xsr, SdtBlock.class);
                                break block18;
                            }
                            SdtStAXHandler sdtStAXHandler = this;
                            if (sdtStAXHandler.stack.peek().equals("tbl")) {
                                JAXBElement<CTSdtRow> jAXBElement = unmarshaller.unmarshal(xsr, CTSdtRow.class);
                                break block18;
                            }
                            SdtStAXHandler sdtStAXHandler3 = this;
                            if (sdtStAXHandler3.stack.peek().equals("tr")) {
                                JAXBElement<CTSdtCell> jAXBElement = unmarshaller.unmarshal(xsr, CTSdtCell.class);
                                break block18;
                            }
                            SdtStAXHandler sdtStAXHandler4 = this;
                            if (sdtStAXHandler4.stack.peek().equals("p")) {
                                JAXBElement<SdtRun> jAXBElement = unmarshaller.unmarshal(xsr, SdtRun.class);
                            } else {
                                SdtStAXHandler sdtStAXHandler5 = this;
                                log.error("TODO stack.peek() " + sdtStAXHandler5.stack.peek());
                            }
                        }
                        catch (JAXBException e) {
                            throw new XMLStreamException(e.getMessage(), e);
                        }
                    }
                    Object object = XmlUtils.unwrap(var7_13);
                    log.debug(object.getClass().getName());
                    if (object instanceof SdtElement) {
                        List<Object> results;
                        SdtElement sdt = (SdtElement)object;
                        try {
                            results = this.handleSdt(sdt);
                        }
                        catch (Docx4JException e1) {
                            throw new XMLStreamException(e1.getMessage(), e1);
                        }
                        try {
                            Marshaller m4 = context.createMarshaller();
                            m4.setProperty("jaxb.fragment", true);
                            for (Object oo : results) {
                                m4.marshal(oo, xmlWriter);
                            }
                        }
                        catch (JAXBException e) {
                            throw new XMLStreamException(e);
                        }
                        mustMove = false;
                        continue;
                    }
                    log.error("Unexpected " + object.getClass().getName());
                    continue;
                }
                this.write(xsr, xmlWriter);
                mustMove = true;
                Stack.push(localName);
                continue;
            }
            if (eventType == 2) {
                SdtStAXHandler sdtStAXHandler = this;
                sdtStAXHandler.stack.pop();
                this.write(xsr, xmlWriter);
                mustMove = true;
                continue;
            }
            this.write(xsr, xmlWriter);
            mustMove = true;
        }
    }

    @Override
    public void handleCharacters(XMLStreamReader xmlr, XMLStreamWriter writer) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        sb.append(xmlr.getTextCharacters(), xmlr.getTextStart(), xmlr.getTextLength());
        writer.writeCharacters(sb.toString());
    }

    public static class Stack {
        static ArrayList<String> list = new ArrayList();

        public static boolean isEmpty() {
            return list.size() == 0;
        }

        public static void push(String data) {
            list.add(data);
        }

        public static String pop() {
            if (Stack.isEmpty()) {
                return null;
            }
            return list.remove(list.size() - 1);
        }

        public static String peek() {
            if (Stack.isEmpty()) {
                return null;
            }
            return list.get(list.size() - 1);
        }
    }
}

