/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc;

import org.docx4j.model.PropertyResolver;
import org.docx4j.wml.Style;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleBasedOnHelper {
    private static Logger log = LoggerFactory.getLogger(StyleBasedOnHelper.class);
    private PropertyResolver propertyResolver;
    private static final String HEADING_STYLE = "Heading";

    public StyleBasedOnHelper(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    private String normaliseHeadingName(String tocInstructionName) {
        if (!tocInstructionName.startsWith("Heading ")) {
            return tocInstructionName;
        }
        if (tocInstructionName.length() < 8) {
            return tocInstructionName;
        }
        String headingLevel = null;
        try {
            headingLevel = tocInstructionName.substring(8);
            int level = Integer.parseInt(headingLevel);
            if (level > 0 && level <= 9) {
                return "heading " + level;
            }
            return tocInstructionName;
        }
        catch (NumberFormatException ex) {
            log.info("Couldn't Parse " + headingLevel);
            return tocInstructionName;
        }
    }

    public boolean isBasedOn(Style thisStyle, String baseStyleName) {
        if (thisStyle.getName().getVal().equals(this.normaliseHeadingName(baseStyleName))) {
            return true;
        }
        if (thisStyle.getBasedOn() == null) {
            return false;
        }
        Style baseStyle = this.propertyResolver.getStyle(thisStyle.getBasedOn().getVal());
        if (baseStyle == null) {
            log.error(thisStyle.getStyleId() + " is based on missing " + thisStyle.getBasedOn().getVal());
            return false;
        }
        return this.isBasedOn(baseStyle, baseStyleName);
    }

    public int getBasedOnHeading(Style s2) {
        int level = -1;
        if (s2.getStyleId().startsWith(HEADING_STYLE)) {
            level = this.getLvlFromHeadingStyle(s2.getStyleId());
        } else if (s2.getName() != null && s2.getName().getVal() != null && s2.getName().getVal().startsWith(HEADING_STYLE.toLowerCase())) {
            level = this.getLvlFromHeadingStyle(s2.getName().getVal());
        }
        if (level == -1) {
            if (s2.getBasedOn() == null) {
                return -1;
            }
            return this.getBasedOnHeading(this.propertyResolver.getStyle(s2.getBasedOn().getVal()));
        }
        return level;
    }

    private int getLvlFromHeadingStyle(String style) {
        int level = -1;
        try {
            level = Integer.parseInt(style.substring(HEADING_STYLE.length(), style.length()).trim());
            if (level < 1 || level > 9) {
                level = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return level;
    }
}

