/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.xml.bind.Unmarshaller;
import org.docx4j.Docx4jProperties;
import org.docx4j.convert.out.fopconf.Fonts;
import org.docx4j.convert.out.fopconf.Fop;
import org.docx4j.convert.out.fopconf.ObjectFactory;
import org.docx4j.convert.out.fopconf.Substitutions;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FopConfigUtil {
    protected static Logger log = LoggerFactory.getLogger(FopConfigUtil.class);
    private static Substitutions substitutions = null;
    private static ObjectFactory factory = null;

    public static Fop createConfigurationObject(Mapper fontMapper, Set<String> fontsInUse) throws Docx4JException {
        log.debug("Config object");
        Fop fopConfig = factory.createFop();
        fopConfig.setVersion("1.0");
        fopConfig.setStrictConfiguration(true);
        if (substitutions != null) {
            Fop.Fonts fonts = factory.createFopFonts();
            fopConfig.setFonts(fonts);
            fonts.setSubstitutions(substitutions);
        } else {
            log.debug("No font substitutions provided at " + Docx4jProperties.getProperty("docx4j.fonts.fop.util.FopConfigUtil.substitutions"));
        }
        Fop.Renderers renderers = factory.createFopRenderers();
        fopConfig.setRenderers(renderers);
        Fop.Renderers.Renderer renderer = factory.createFopRenderersRenderer();
        renderers.setRenderer(renderer);
        renderer.setMime("application/pdf");
        renderer.setFonts(FopConfigUtil.declareRendererFonts(fontMapper, fontsInUse));
        return fopConfig;
    }

    protected static Fonts declareRendererFonts(Mapper fontMapper, Set<String> fontsInUse) {
        Fonts rendererFonts = factory.createFonts();
        if (fontsInUse.size() == 0) {
            log.error("No fonts detected in document!");
            return rendererFonts;
        }
        boolean haveSomeMappedPhysicalFonts = false;
        if (Docx4jProperties.getProperty("docx4j.fonts.fop.util.FopConfigUtil.simulate-style", false)) {
            for (String fontName : fontsInUse) {
                PhysicalFont pf = fontMapper.get(fontName);
                if (pf == null) {
                    log.warn("Document font " + fontName + " is not mapped to a physical font!");
                    continue;
                }
                haveSomeMappedPhysicalFonts = true;
                Fonts.Font rendererFont = factory.createFontsFont();
                rendererFont.setSimulateStyle(true);
                rendererFonts.getFont().add(rendererFont);
                if (pf.getEmbedFontInfo().getSubFontName() != null) {
                    rendererFont.setSubFont(pf.getEmbedFontInfo().getSubFontName());
                }
                if (fontMapper.getBoldForm(fontName, pf) == null || fontMapper.getItalicForm(fontName, pf) == null) {
                    rendererFont.setSimulateStyle(true);
                    rendererFont.setEmbedUrl(pf.getEmbeddedURI().toString());
                    rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(pf.getName(), "normal", "normal"));
                    rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(pf.getName(), "italic", "normal"));
                    rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(pf.getName(), "normal", "bold"));
                    rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(pf.getName(), "italic", "bold"));
                    continue;
                }
                rendererFont.setEmbedUrl(pf.getEmbeddedURI().toString());
                FontTriplet fontTriplet = pf.getEmbedFontInfo().getFontTriplets().get(0);
                rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(fontTriplet.getName(), fontTriplet.getStyle(), FopConfigUtil.weightToCSS2FontWeight(fontTriplet.getWeight())));
                FopConfigUtil.addVariations(fontMapper, rendererFonts, fontName, pf, rendererFont.getSubFont());
            }
        } else {
            for (String fontName : fontsInUse) {
                PhysicalFont pf = fontMapper.get(fontName);
                if (pf == null) {
                    log.warn("Document font " + fontName + " is not mapped to a physical font!");
                    continue;
                }
                haveSomeMappedPhysicalFonts = true;
                Fonts.Font rendererFont = factory.createFontsFont();
                rendererFont.setSimulateStyle(false);
                rendererFonts.getFont().add(rendererFont);
                if (pf.getEmbedFontInfo().getSubFontName() != null) {
                    rendererFont.setSubFont(pf.getEmbedFontInfo().getSubFontName());
                }
                rendererFont.setEmbedUrl(pf.getEmbeddedURI().toString());
                FontTriplet fontTriplet = pf.getEmbedFontInfo().getFontTriplets().get(0);
                rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(fontTriplet.getName(), fontTriplet.getStyle(), FopConfigUtil.weightToCSS2FontWeight(fontTriplet.getWeight())));
                FopConfigUtil.addVariations(fontMapper, rendererFonts, fontName, pf, pf.getEmbedFontInfo().getSubFontName());
            }
        }
        if (!haveSomeMappedPhysicalFonts) {
            log.warn("No fonts configured!");
        }
        return rendererFonts;
    }

    private static Fonts.Font.FontTriplet createFontTriplet(String name, String style, String weight) {
        Fonts.Font.FontTriplet triplet = factory.createFontsFontFontTriplet();
        triplet.setName(name);
        triplet.setStyle(style);
        triplet.setWeight(weight);
        return triplet;
    }

    private static void addVariations(Mapper fontMapper, Fonts rendererFonts, String fontName, PhysicalFont pf, String subFontAtt) {
        PhysicalFont pfVariation = fontMapper.getBoldForm(fontName, pf);
        if (pfVariation == null) {
            log.debug(fontName + " no bold form");
        } else {
            rendererFonts.getFont().add(FopConfigUtil.createVariant(pf, pfVariation, subFontAtt, "normal", "bold"));
        }
        pfVariation = fontMapper.getBoldItalicForm(fontName, pf);
        if (pfVariation == null) {
            log.debug(fontName + " no bold italic form");
        } else {
            rendererFonts.getFont().add(FopConfigUtil.createVariant(pf, pfVariation, subFontAtt, "italic", "bold"));
        }
        pfVariation = fontMapper.getItalicForm(fontName, pf);
        if (pfVariation == null) {
            log.debug(fontName + " no italic form");
        } else {
            rendererFonts.getFont().add(FopConfigUtil.createVariant(pf, pfVariation, subFontAtt, "italic", "normal"));
        }
    }

    private static Fonts.Font createVariant(PhysicalFont pf, PhysicalFont pfVariation, String subFontAtt, String style, String weight) {
        Fonts.Font rendererFont = factory.createFontsFont();
        rendererFont.setSimulateStyle(Docx4jProperties.getProperty("docx4j.fonts.fop.util.FopConfigUtil.simulate-style", false));
        rendererFont.setEmbedUrl(pfVariation.getEmbeddedURI().toString());
        rendererFont.setSubFont(subFontAtt);
        rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(pf.getName(), style, weight));
        return rendererFont;
    }

    protected static void addFontTriplet(StringBuilder result, String familyName, String style, String weight) {
        result.append("<font-triplet name=\"");
        result.append(familyName);
        result.append('\"');
        result.append(" style=\"");
        result.append(style);
        result.append('\"');
        result.append(" weight=\"");
        result.append(weight);
        result.append("\"/>");
    }

    protected static String weightToCSS2FontWeight(int i) {
        return i >= 700 ? "bold" : "normal";
    }

    static {
        factory = new ObjectFactory();
        String substitutionsPath = Docx4jProperties.getProperty("docx4j.fonts.fop.util.FopConfigUtil.substitutions");
        if (substitutionsPath != null) {
            InputStream is = null;
            try {
                is = ResourceUtils.getResource(substitutionsPath);
                Unmarshaller u = Context.getFopConfigContext().createUnmarshaller();
                Object o = u.unmarshal(is);
                System.out.println(o.getClass().getName());
                substitutions = (Substitutions)o;
            }
            catch (IOException e) {
                log.error("Problems with class path resource " + substitutionsPath);
                log.error(e.getMessage(), e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

