/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields.merge;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.docx4j.Docx4jProperties;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.fields.ComplexFieldLocator;
import org.docx4j.model.fields.FieldRef;
import org.docx4j.model.fields.FieldsPreprocessor;
import org.docx4j.model.fields.FldSimpleModel;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.model.fields.merge.DataFieldName;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.PageSizePaper;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPartAltChunkHost;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.relationships.Relationships;
import org.docx4j.vml.CTTextbox;
import org.docx4j.wml.Body;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTFFData;
import org.docx4j.wml.CTFFName;
import org.docx4j.wml.CTFFTextInput;
import org.docx4j.wml.CTFFTextType;
import org.docx4j.wml.CTLanguage;
import org.docx4j.wml.CTPageNumber;
import org.docx4j.wml.CTRel;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Document;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STFFTextType;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailMerger {
    private static Logger log = LoggerFactory.getLogger(MailMerger.class);
    protected static OutputField fieldFate = OutputField.REMOVED;

    public static WordprocessingMLPackage getConsolidatedResultCrude(WordprocessingMLPackage input, List<Map<DataFieldName, String>> data) throws Docx4JException {
        return MailMerger.getConsolidatedResultCrude(input, data, false);
    }

    public static WordprocessingMLPackage getConsolidatedResultCrude(WordprocessingMLPackage input, List<Map<DataFieldName, String>> data, boolean processHeadersAndFooters) throws Docx4JException {
        FormTextFieldNames formTextFieldNames = new FormTextFieldNames();
        FieldsPreprocessor.complexifyFields(input.getMainDocumentPart());
        if (log.isDebugEnabled()) {
            log.debug("complexified: " + XmlUtils.marshaltoString(input.getMainDocumentPart().getJaxbElement(), true));
        }
        List<List<Object>> mdpResults = MailMerger.performOverList(input, input.getMainDocumentPart().getContent(), data, formTextFieldNames);
        HashMap<CTRel, JaxbXmlPart> hfTemplates = null;
        BooleanDefaultTrue titlePage = null;
        if (processHeadersAndFooters) {
            hfTemplates = new HashMap<CTRel, JaxbXmlPart>();
            SectionWrapper sw = input.getDocumentModel().getSections().get(0);
            SectPr sectPr = sw.getSectPr();
            List<CTRel> hdrFtrRefs = sectPr.getEGHdrFtrReferences();
            titlePage = sectPr.getTitlePg();
            for (CTRel rel : hdrFtrRefs) {
                String relId = rel.getId();
                log.debug("for h|f relId: " + relId);
                JaxbXmlPart part = (JaxbXmlPart)input.getMainDocumentPart().getRelationshipsPart().getPart(relId);
                FieldsPreprocessor.complexifyFields(part);
                if (log.isDebugEnabled()) {
                    log.debug("complexified: " + XmlUtils.marshaltoString(part.getJaxbElement(), true));
                }
                hfTemplates.put(rel, part);
            }
        }
        Object result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SaveToZipFile saver = new SaveToZipFile(input);
        saver.save(baos);
        byte[] template = baos.toByteArray();
        WordprocessingMLPackage target = WordprocessingMLPackage.load(new ByteArrayInputStream(template));
        SectPr documentSeparator = MailMerger.getDocumentSeparator(target);
        if (processHeadersAndFooters) {
            if (titlePage != null && titlePage.isVal()) {
                documentSeparator.setTitlePg(titlePage);
            }
            documentSeparator.getEGHdrFtrReferences().clear();
        }
        target.getMainDocumentPart().getContent().clear();
        int i = 0;
        for (List<Object> content : mdpResults) {
            target.getMainDocumentPart().getContent().addAll(content);
            if (log.isDebugEnabled()) {
                log.debug(XmlUtils.marshaltoString(target.getMainDocumentPart().getJaxbElement(), true, true));
            }
            Object last = content.get(content.size() - 1);
            P lastP = null;
            if (last instanceof P) {
                lastP = (P)last;
            } else {
                lastP = Context.getWmlObjectFactory().createP();
                target.getMainDocumentPart().getContent().add(lastP);
            }
            if (lastP.getPPr() == null) {
                lastP.setPPr(Context.getWmlObjectFactory().createPPr());
            }
            SectPr thisSection = XmlUtils.deepCopy(documentSeparator);
            lastP.getPPr().setSectPr(thisSection);
            if (processHeadersAndFooters) {
                for (CTRel ctRel : hfTemplates.keySet()) {
                    JaxbXmlPart part = (JaxbXmlPart)hfTemplates.get(ctRel);
                    JaxbXmlPartAltChunkHost clonedPart = null;
                    if (part instanceof HeaderPart) {
                        clonedPart = new HeaderPart();
                        ((JaxbXmlPart)clonedPart).setJaxbElement(Context.getWmlObjectFactory().createHdr());
                    } else if (part instanceof FooterPart) {
                        clonedPart = new FooterPart();
                        ((JaxbXmlPart)clonedPart).setJaxbElement(Context.getWmlObjectFactory().createFtr());
                    }
                    List<Object> newContent = MailMerger.performOnInstance(input, ((ContentAccessor)((Object)part)).getContent(), data.get(i), formTextFieldNames);
                    ((ContentAccessor)((Object)clonedPart)).getContent().addAll(newContent);
                    Relationship rel = target.getMainDocumentPart().addTargetPart((Part)clonedPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
                    CTRel newHfRef = XmlUtils.deepCopy(ctRel);
                    newHfRef.setId(rel.getId());
                    thisSection.getEGHdrFtrReferences().add(newHfRef);
                }
            }
            ++i;
        }
        return target;
    }

    private static SectPr getDocumentSeparator(WordprocessingMLPackage template) {
        CTPageNumber pageNumber;
        List<Object> all;
        Object last;
        SectPr sectPr = ((Document)template.getMainDocumentPart().getJaxbElement()).getBody().getSectPr();
        if (sectPr == null && (last = (all = template.getMainDocumentPart().getContent()).get(all.size() - 1)) instanceof P && ((P)last).getPPr() != null && ((P)last).getPPr().getSectPr() != null) {
            sectPr = ((P)last).getPPr().getSectPr();
        }
        if (sectPr == null) {
            String papersize = Docx4jProperties.getProperties().getProperty("docx4j.PageSize", "A4");
            log.info("Using paper size: " + papersize);
            String landscapeString = Docx4jProperties.getProperties().getProperty("docx4j.PageOrientationLandscape", "false");
            boolean landscape = Boolean.parseBoolean(landscapeString);
            log.info("Landscape orientation: " + landscape);
            PageDimensions page = new PageDimensions();
            page.setPgSize(PageSizePaper.valueOf(papersize), landscape);
            sectPr = Context.getWmlObjectFactory().createSectPr();
            sectPr.setPgSz(page.getPgSz());
            sectPr.setPgMar(page.getPgMar());
        }
        if ((pageNumber = sectPr.getPgNumType()) == null) {
            pageNumber = Context.getWmlObjectFactory().createCTPageNumber();
            sectPr.setPgNumType(pageNumber);
        }
        pageNumber.setStart(BigInteger.ONE);
        return sectPr;
    }

    public static void performMerge(WordprocessingMLPackage input, Map<DataFieldName, String> data, boolean processHeadersAndFooters) throws Docx4JException {
        FormTextFieldNames formTextFieldNames = new FormTextFieldNames();
        FieldsPreprocessor.complexifyFields(input.getMainDocumentPart());
        List<Object> mdpResults = MailMerger.performOnInstance(input, input.getMainDocumentPart().getContent(), data, formTextFieldNames);
        input.getMainDocumentPart().getContent().clear();
        input.getMainDocumentPart().getContent().addAll(mdpResults);
        if (processHeadersAndFooters) {
            RelationshipsPart rp = input.getMainDocumentPart().getRelationshipsPart();
            for (Relationship r : ((Relationships)rp.getJaxbElement()).getRelationship()) {
                if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header") && !r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
                JaxbXmlPart part = (JaxbXmlPart)rp.getPart(r);
                if (log.isDebugEnabled()) {
                    log.debug("\n\n BEFORE " + part.getPartName().getName() + "\n\n" + XmlUtils.marshaltoString(part.getJaxbElement(), true, true) + "\n");
                }
                FieldsPreprocessor.complexifyFields(part);
                if (log.isDebugEnabled()) {
                    log.debug("\n\n COMPLEXIFIED " + part.getPartName().getName() + "\n\n" + XmlUtils.marshaltoString(part.getJaxbElement(), true, true) + "\n");
                }
                List<Object> results = MailMerger.performOnInstance(input, ((ContentAccessor)((Object)part)).getContent(), data, formTextFieldNames);
                ((ContentAccessor)((Object)part)).getContent().clear();
                ((ContentAccessor)((Object)part)).getContent().addAll(results);
                if (!log.isDebugEnabled()) continue;
                log.debug("\n\n AFTER " + part.getPartName().getName() + "\n\n" + XmlUtils.marshaltoString(part.getJaxbElement(), true, true) + "\n");
            }
        }
    }

    private static List<List<Object>> performOverList(WordprocessingMLPackage input, List<Object> contentList, List<Map<DataFieldName, String>> data, FormTextFieldNames formTextFieldNames) throws Docx4JException {
        ArrayList<List<Object>> results = new ArrayList<List<Object>>();
        for (Map<DataFieldName, String> datamap : data) {
            results.add(MailMerger.performOnInstance(input, contentList, datamap, formTextFieldNames));
        }
        return results;
    }

    private static List<Object> performOnInstance(WordprocessingMLPackage input, List<Object> contentList, Map<DataFieldName, String> datamap, FormTextFieldNames formTextFieldNames) throws Docx4JException {
        Body shell = Context.getWmlObjectFactory().createBody();
        shell.getContent().addAll(contentList);
        Body shellClone = XmlUtils.deepCopy(shell);
        ComplexFieldLocator fl = new ComplexFieldLocator();
        new TraversalUtil(shellClone, fl);
        log.info("Found " + fl.getStarts().size() + " fields ");
        ArrayList<FieldRef> fieldRefs = new ArrayList<FieldRef>();
        MailMerger.canonicaliseStarts(fl, fieldRefs);
        for (FieldRef fr : fieldRefs) {
            if (!fr.getFldName().equals("MERGEFIELD")) continue;
            String instr = MailMerger.extractInstr(fr.getInstructions());
            if (instr == null) {
                log.warn("No instructions found in this field");
                continue;
            }
            String lang = MailMerger.extractLang(fr.getResultsSlot());
            String datafieldName = MailMerger.getDatafieldNameFromInstr(instr);
            String val = datamap.get(new DataFieldName(datafieldName));
            String gFormat = null;
            if (StringUtils.isBlank(val)) {
                log.warn("Couldn't find value for key: '" + datafieldName + "'");
                if (fieldFate.equals((Object)OutputField.REMOVED)) {
                    MailMerger.removeSimpleField(fr);
                    String text = MailMerger.getTextInsideContent(fr.getParent());
                    if (StringUtils.isBlank(text)) {
                        MailMerger.recursiveRemove(shellClone, fr.getParent());
                    }
                }
            } else {
                FldSimpleModel fsm = new FldSimpleModel();
                try {
                    fsm.build(instr);
                    val = FormattingSwitchHelper.applyFormattingSwitch(input, fsm, val, lang);
                    gFormat = FormattingSwitchHelper.findFirstSwitchValue("\\*", fsm.getFldParameters(), true);
                }
                catch (TransformerException e) {
                    log.warn("Can't format the field", e);
                }
                fr.setResult(val);
            }
            if (fieldFate.equals((Object)OutputField.AS_FORMTEXT_REGULAR)) {
                log.debug(gFormat);
                List<Object> instructions = fr.getInstructions();
                if (instructions.size() != 1) {
                    log.error("TODO MERGEFIELD field contained complex instruction");
                    continue;
                }
                Object o = XmlUtils.unwrap(instructions.get(0));
                if (!(o instanceof Text)) {
                    if (!log.isErrorEnabled()) continue;
                    log.error("TODO: set FORMTEXT in" + o.getClass().getName());
                    log.error(XmlUtils.marshaltoString(instructions.get(0), true, true));
                    continue;
                }
                ((Text)o).setValue("FORMTEXT");
                String fieldName = formTextFieldNames.generateName(datafieldName);
                log.debug("Field name normalisation: " + datafieldName + " -> " + fieldName);
                MailMerger.setFormFieldProperties(fr, fieldName, null);
                R resultR = fr.getResultsSlot();
                if (resultR.getRPr() == null || resultR.getRPr().getHighlight() == null) continue;
                resultR.getRPr().setHighlight(null);
                continue;
            }
            if (fieldFate.equals((Object)OutputField.KEEP_MERGEFIELD)) continue;
            fr.getParent().getContent().remove(fr.getBeginRun());
            fr.getParent().getContent().remove(fr.getEndRun());
        }
        return shellClone.getContent();
    }

    private static String extractLang(R resultsSlot) {
        CTLanguage lang;
        RPr rPr = resultsSlot.getRPr();
        if (rPr != null && (lang = rPr.getLang()) != null) {
            return lang.getVal();
        }
        return null;
    }

    protected static void canonicaliseStarts(ComplexFieldLocator fl, List<FieldRef> fieldRefs) throws Docx4JException {
        for (P p : fl.getStarts()) {
            P newP;
            int index;
            if (p.getParent() instanceof ContentAccessor) {
                index = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
                newP = FieldsPreprocessor.canonicalise(p, fieldRefs);
                newP.setParent(p.getParent());
                if (log.isDebugEnabled()) {
                    log.debug("Canonicalised: " + XmlUtils.marshaltoString((Object)newP, true, true));
                }
                ((ContentAccessor)p.getParent()).getContent().set(index, newP);
                continue;
            }
            if (p.getParent() instanceof List) {
                index = ((List)p.getParent()).indexOf(p);
                newP = FieldsPreprocessor.canonicalise(p, fieldRefs);
                newP.setParent(p.getParent());
                log.debug("NewP length: " + newP.getContent().size());
                ((List)p.getParent()).set(index, newP);
                continue;
            }
            if (p.getParent() instanceof CTTextbox) {
                index = ((CTTextbox)p.getParent()).getTxbxContent().getContent().indexOf(p);
                newP = FieldsPreprocessor.canonicalise(p, fieldRefs);
                newP.setParent(p.getParent());
                if (log.isDebugEnabled()) {
                    log.debug("Canonicalised: " + XmlUtils.marshaltoString((Object)newP, true, true));
                }
                ((CTTextbox)p.getParent()).getTxbxContent().getContent().set(index, newP);
                continue;
            }
            throw new Docx4JException("Unexpected parent: " + p.getParent().getClass().getName());
        }
    }

    protected static String getDatafieldNameFromInstr(String instr) {
        String tmp = instr.substring(instr.indexOf("MERGEFIELD") + 10);
        tmp = tmp.trim();
        String datafieldName = null;
        if (tmp.startsWith("\"")) {
            if (tmp.indexOf("\"", 1) > -1) {
                datafieldName = tmp.substring(1, tmp.indexOf("\"", 1));
            } else {
                log.warn("Quote mismatch in " + instr);
                datafieldName = tmp.indexOf(" ") > -1 ? tmp.substring(1, tmp.indexOf(" ")) : tmp.substring(1);
            }
        } else {
            datafieldName = tmp.indexOf(" ") > -1 ? tmp.substring(0, tmp.indexOf(" ")) : tmp;
        }
        log.info("Key: '" + datafieldName + "'");
        return datafieldName;
    }

    protected static String extractInstr(List<Object> instructions) {
        if (instructions.size() != 1) {
            log.warn("MERGEFIELD field contained complex instruction; attempting to process");
            StringBuffer sb = new StringBuffer();
            for (Object i : instructions) {
                if ((i = XmlUtils.unwrap(i)) instanceof Text) {
                    String t = ((Text)i).getValue();
                    log.debug(t);
                    sb.append(t);
                    continue;
                }
                log.warn("Failed: non Text object encountered.");
                log.debug(XmlUtils.marshaltoString(i, true, true));
                return null;
            }
            return sb.toString();
        }
        Object o = XmlUtils.unwrap(instructions.get(0));
        if (o instanceof Text) {
            return ((Text)o).getValue();
        }
        if (log.isErrorEnabled()) {
            log.error("TODO: extract field name from " + o.getClass().getName());
            log.error(XmlUtils.marshaltoString(instructions.get(0), true, true));
        }
        return null;
    }

    protected static void removeSimpleField(FieldRef fr) {
        int end = fr.getParent().getContent().indexOf(fr.getEndRun());
        int begin = fr.getParent().getContent().indexOf(fr.getBeginRun());
        for (int i = end; i >= begin; --i) {
            fr.getParent().getContent().remove(i);
        }
    }

    protected static String getTextInsideContent(ContentAccessor paragraph) {
        StringBuilder result = new StringBuilder();
        for (Object content : paragraph.getContent()) {
            if (!(content instanceof R)) continue;
            R run = (R)content;
            List<Object> runContent = run.getContent();
            for (Object o2 : runContent) {
                Text t;
                if (o2 instanceof JAXBElement) {
                    if (!((JAXBElement)o2).getDeclaredType().getName().equals("org.docx4j.wml.Text")) continue;
                    t = (Text)((JAXBElement)o2).getValue();
                    result.append(t.getValue());
                    continue;
                }
                if (!(o2 instanceof Text)) continue;
                t = (Text)o2;
                result.append(t.getValue());
            }
        }
        return result.toString();
    }

    protected static void recursiveRemove(ContentAccessor content, Object needToBeRemoved) {
        if (needToBeRemoved instanceof P) {
            Object parent = ((Child)needToBeRemoved).getParent();
            if (parent == null) {
                log.debug("Unknown parent");
            } else if (parent instanceof Tc && ((Tc)parent).getContent().size() == 1) {
                log.debug("preserving p in tc");
                return;
            }
            log.debug("parent: " + ((Child)needToBeRemoved).getParent().getClass().getName());
        }
        if (content.getContent().contains(needToBeRemoved)) {
            content.getContent().remove(needToBeRemoved);
            log.debug(".. removed");
            return;
        }
        for (Object object : content.getContent()) {
            JAXBElement element;
            if (object instanceof ContentAccessor) {
                MailMerger.recursiveRemove((ContentAccessor)object, needToBeRemoved);
                continue;
            }
            if (!(object instanceof JAXBElement) || !((element = (JAXBElement)object).getValue() instanceof ContentAccessor)) continue;
            MailMerger.recursiveRemove((ContentAccessor)element.getValue(), needToBeRemoved);
        }
    }

    public static void setMERGEFIELDInOutput(OutputField fieldFate) {
        MailMerger.fieldFate = fieldFate;
    }

    protected static void setFormFieldProperties(FieldRef fr, String ffName, String ffTextInputFormat) {
        ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();
        CTFFData ffdata = wmlObjectFactory.createCTFFData();
        fr.setFormFieldProperties(ffdata);
        CTFFName ffname = wmlObjectFactory.createCTFFName();
        JAXBElement<CTFFName> ffnameWrapped = wmlObjectFactory.createCTFFDataName(ffname);
        ffdata.getNameOrEnabledOrCalcOnExit().add(ffnameWrapped);
        ffname.setVal(ffName);
        BooleanDefaultTrue booleandefaulttrue = wmlObjectFactory.createBooleanDefaultTrue();
        JAXBElement<BooleanDefaultTrue> booleandefaulttrueWrapped = wmlObjectFactory.createCTFFDataEnabled(booleandefaulttrue);
        ffdata.getNameOrEnabledOrCalcOnExit().add(booleandefaulttrueWrapped);
        BooleanDefaultTrue booleandefaulttrue2 = wmlObjectFactory.createBooleanDefaultTrue();
        JAXBElement<BooleanDefaultTrue> booleandefaulttrueWrapped2 = wmlObjectFactory.createCTFFDataCalcOnExit(booleandefaulttrue2);
        ffdata.getNameOrEnabledOrCalcOnExit().add(booleandefaulttrueWrapped2);
        CTFFTextInput fftextinput = wmlObjectFactory.createCTFFTextInput();
        JAXBElement<CTFFTextInput> fftextinputWrapped = wmlObjectFactory.createCTFFDataTextInput(fftextinput);
        ffdata.getNameOrEnabledOrCalcOnExit().add(fftextinputWrapped);
        CTFFTextType ffTextType = wmlObjectFactory.createCTFFTextType();
        ffTextType.setVal(STFFTextType.REGULAR);
        fftextinput.setType(ffTextType);
        if (ffTextInputFormat != null) {
            CTFFTextInput.Format fftextinputformat = wmlObjectFactory.createCTFFTextInputFormat();
            fftextinput.setFormat(fftextinputformat);
            fftextinputformat.setVal(ffTextInputFormat);
        }
    }

    protected static class FormTextFieldNames {
        Pattern pattern = Pattern.compile("[^a-zA-Z0-9]");
        private FormTextFieldNameSet names = new FormTextFieldNameSet();

        protected FormTextFieldNames() {
        }

        public String generateName(String input) {
            String unpunctuated = this.pattern.matcher(input).replaceAll("_");
            char c = unpunctuated.charAt(0);
            if ('0' <= c && c <= '9') {
                unpunctuated = "z" + unpunctuated;
            } else if (c == '_') {
                unpunctuated = "z" + unpunctuated;
            }
            if (this.names.contains(unpunctuated)) {
                int i = 2;
                String newName = null;
                do {
                    newName = unpunctuated + i;
                    ++i;
                } while (this.names.contains(newName));
                unpunctuated = newName;
            }
            this.names.add(unpunctuated);
            return unpunctuated;
        }

        private static class FormTextFieldNameSet
        extends HashSet<String> {
            private FormTextFieldNameSet() {
            }

            @Override
            public boolean add(String key) {
                log.debug("Added '" + key.toLowerCase() + "'");
                return super.add(key.toLowerCase());
            }

            public boolean contains(String key) {
                return super.contains(key.toLowerCase());
            }
        }
    }

    public static enum OutputField {
        DEFAULT,
        REMOVED,
        KEEP_MERGEFIELD,
        AS_FORMTEXT_REGULAR;

    }
}

