/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.xml.security;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.docx4j.org.apache.xml.security.c14n.Canonicalizer;
import org.docx4j.org.apache.xml.security.exceptions.XMLSecurityException;
import org.docx4j.org.apache.xml.security.transforms.Transform;
import org.docx4j.org.apache.xml.security.utils.ElementProxy;
import org.docx4j.org.apache.xml.security.utils.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Init {
    public static final String CONF_NS = "http://www.xmlsecurity.org/NS/#configuration";
    private static Logger log = LoggerFactory.getLogger(Init.class);
    private static boolean alreadyInitialized = false;

    public static final synchronized boolean isInitialized() {
        return alreadyInitialized;
    }

    public static synchronized void init() {
        if (alreadyInitialized) {
            return;
        }
        InputStream is = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                String cfile = System.getProperty("org.docx4j.org.apache.xml.security.resource.config");
                if (cfile == null) {
                    return null;
                }
                return this.getClass().getResourceAsStream(cfile);
            }
        });
        if (is == null) {
            Init.dynamicInit();
        } else {
            Init.fileInit(is);
        }
        alreadyInitialized = true;
    }

    private static void dynamicInit() {
        I18n.init("en", "US");
        if (log.isDebugEnabled()) {
            log.debug("Registering default algorithms");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws XMLSecurityException {
                    ElementProxy.registerDefaultPrefixes();
                    Transform.registerDefaultAlgorithms();
                    Canonicalizer.registerDefaultAlgorithms();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            XMLSecurityException xse = (XMLSecurityException)ex.getException();
            log.error(xse.getMessage(), xse);
        }
    }

    private static void fileInit(InputStream is) {
    }
}

