/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc.switches;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.docx4j.toc.switches.SwitchInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSwitch
implements SwitchInterface {
    private static Logger log = LoggerFactory.getLogger(AbstractSwitch.class);
    public static final String EMPTY = "";
    private static final String BACKSLASH_QUOTE_REGEX = "\\\\\"";
    private static final String BACKSLASHES_REGEX = "\\\\\\\\";
    private static final String BACKSLASHES = "\\\\";
    private static final String NUMBERS_REGEX = "[0-9]+";
    private static final String QUOTE = "\"";
    public static final String ERROR_NOT_VALID_HEADING_LEVEL = "Error! Not a valid heading level range.";
    String tSwitchSeparator = ",";
    String fieldArgument;
    int startLevel = -1;
    int endLevel = -1;
    Map<String, Integer> styleLevelMap = null;

    @Override
    public String parseFieldArgument(String fieldArgument) {
        this.fieldArgument = fieldArgument;
        return EMPTY;
    }

    @Override
    public boolean isStyleSwitch() {
        return false;
    }

    public int getStartLevel() {
        if (this.startLevel == -1 && this.fieldArgument != null) {
            this.parseStartEndLevel();
        }
        return this.startLevel;
    }

    public int getEndLevel() {
        return this.endLevel;
    }

    private void parseStartEndLevel() {
        String field = this.prepareArgument(this.fieldArgument);
        if (field.isEmpty()) {
            return;
        }
        ArrayList<Integer> levels = new ArrayList<Integer>();
        Pattern p = Pattern.compile(NUMBERS_REGEX);
        Matcher m3 = p.matcher(field);
        while (m3.find()) {
            int n = Integer.parseInt(m3.group());
            levels.add(n);
        }
        if (levels.size() != 2) {
            return;
        }
        this.startLevel = (Integer)levels.get(0);
        this.endLevel = (Integer)levels.get(1);
    }

    public Map<String, Integer> getStyleLevelMap() {
        if (this.styleLevelMap != null) {
            return this.styleLevelMap;
        }
        this.styleLevelMap = new HashMap<String, Integer>();
        if (this.fieldArgument == null) {
            return this.styleLevelMap;
        }
        String field = this.prepareArgument(this.fieldArgument);
        if (field.isEmpty()) {
            return this.styleLevelMap;
        }
        String[] styleLevels = field.split(this.tSwitchSeparator);
        int level = -1;
        for (int i = 0; i < styleLevels.length; ++i) {
            block8: {
                if (i + 1 < styleLevels.length) {
                    try {
                        level = Integer.parseInt(styleLevels[i + 1].trim());
                        break block8;
                    }
                    catch (NumberFormatException ex) {
                        log.error("TOC \t switch has invalid doublet containing '" + styleLevels[i + 1] + "'");
                        this.styleLevelMap.put(styleLevels[i].trim(), 1);
                        continue;
                    }
                }
                this.styleLevelMap.put(styleLevels[i].trim(), 1);
                break;
            }
            if (level < 1 || level > 9) {
                level = 1;
            }
            this.styleLevelMap.put(styleLevels[i].trim(), level);
            log.debug("Added " + styleLevels[i]);
            ++i;
        }
        return this.styleLevelMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String prepareArgument(String fieldArgument) {
        String tmp = fieldArgument;
        int firstQuote = fieldArgument.indexOf(QUOTE);
        int lastQuote = fieldArgument.lastIndexOf(QUOTE);
        if (firstQuote == 0) {
            if (lastQuote <= 0 || lastQuote == firstQuote) return EMPTY;
            tmp = fieldArgument.substring(1, lastQuote);
        } else if (firstQuote > 0) {
            return EMPTY;
        }
        tmp = tmp.replaceAll(BACKSLASH_QUOTE_REGEX, QUOTE);
        tmp = tmp.replaceAll(BACKSLASHES_REGEX, BACKSLASHES);
        log.debug(fieldArgument + " -->  " + tmp);
        return tmp;
    }
}

