/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.preprocess;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.utils.AbstractTraversalUtilVisitorCallback;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.P;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarkMover {
    protected static Logger log = LoggerFactory.getLogger(BookmarkMover.class);

    public static void process(WordprocessingMLPackage wmlPackage) {
        TraversalUtil.visit(wmlPackage, false, new BookmarkMoverVisitor());
    }

    protected static class BookmarkMoverVisitor
    extends AbstractTraversalUtilVisitorCallback {
        protected static final QName QNAME_BOOKMARK_START = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "bookmarkStart");
        protected static final QName QNAME_BOOKMARK_END = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "bookmarkEnd");
        protected List<Object> bookmarksStartToMove = new ArrayList<Object>();
        protected Set<BigInteger> bookmarksEndToRemove = new TreeSet<BigInteger>();
        protected P currentParagraph = null;

        protected BookmarkMoverVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void walkJAXBElements(Object parent) {
            List<Object> srcChildren = this.getChildren(XmlUtils.unwrap(parent));
            ArrayList<Object> destChildren = null;
            Object child = null;
            if (srcChildren != null && !srcChildren.isEmpty()) {
                destChildren = new ArrayList<Object>(srcChildren.size());
                for (int c = 0; c < srcChildren.size(); ++c) {
                    child = srcChildren.get(c);
                    if (this.isBookmarkStart(child)) {
                        if (this.currentParagraph == null) {
                            this.appendBookmarksToMove(child);
                            continue;
                        }
                        destChildren.add(child);
                        continue;
                    }
                    if (this.isBookmarkEnd(child)) {
                        if (this.removeBookmarkEnd(child)) continue;
                        destChildren.add(child);
                        continue;
                    }
                    destChildren.add(child);
                    if (this.isParagraph(child)) {
                        try {
                            this.currentParagraph = (P)child;
                            this.walkJAXBElements(child);
                            this.moveBookmarks(child);
                            continue;
                        }
                        finally {
                            this.currentParagraph = null;
                        }
                    }
                    this.walkJAXBElements(child);
                }
                if (destChildren.size() != srcChildren.size()) {
                    srcChildren.clear();
                    srcChildren.addAll(destChildren);
                }
            }
        }

        private boolean isBookmarkStart(Object child) {
            return child instanceof JAXBElement && ((JAXBElement)child).getName().equals(QNAME_BOOKMARK_START);
        }

        private void appendBookmarksToMove(Object child) {
            CTBookmark bm = (CTBookmark)XmlUtils.unwrap(child);
            JAXBElement<CTMarkupRange> jaxbBmEnd = null;
            CTMarkupRange bmEnd = null;
            this.bookmarksStartToMove.add(child);
            bmEnd = Context.getWmlObjectFactory().createCTMarkupRange();
            bmEnd.setId(bm.getId());
            jaxbBmEnd = Context.getWmlObjectFactory().createPBookmarkEnd(bmEnd);
            this.bookmarksStartToMove.add(jaxbBmEnd);
            this.bookmarksEndToRemove.add(bm.getId());
        }

        private boolean isBookmarkEnd(Object child) {
            return child instanceof JAXBElement && ((JAXBElement)child).getName().equals(QNAME_BOOKMARK_END);
        }

        private boolean removeBookmarkEnd(Object child) {
            CTMarkupRange bmEnd = (CTMarkupRange)XmlUtils.unwrap(child);
            if (bmEnd.getId() == null) {
                return true;
            }
            return this.bookmarksEndToRemove.remove(bmEnd.getId());
        }

        private boolean isParagraph(Object child) {
            return child instanceof P;
        }

        private void moveBookmarks(Object child) {
            P p = null;
            List<Object> content = null;
            if (!this.bookmarksStartToMove.isEmpty()) {
                p = (P)XmlUtils.unwrap(child);
                content = p.getContent();
                content.addAll(0, this.bookmarksStartToMove);
                this.bookmarksStartToMove.clear();
            }
        }

        @Override
        protected List<Object> apply(Object child, Object parent, List children) {
            return null;
        }
    }
}

