/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.wrappers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.common.ConversionSectionWrappers;
import org.docx4j.convert.out.common.preprocess.PageNumberInformation;
import org.docx4j.convert.out.common.preprocess.PageNumberInformationCollector;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.Document;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.STPageOrientation;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SectPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionSectionWrapperFactory {
    protected static Logger log = LoggerFactory.getLogger(ConversionSectionWrapperFactory.class);

    public static ConversionSectionWrappers process(WordprocessingMLPackage wmlPackage, boolean dummySections, boolean dummyPageNumbering) throws Docx4JException {
        List<ConversionSectionWrapper> conversionSections = null;
        Document document = (Document)wmlPackage.getMainDocumentPart().getContents();
        RelationshipsPart rels = wmlPackage.getMainDocumentPart().getRelationshipsPart();
        BooleanDefaultTrue evenAndOddHeaders = null;
        if (wmlPackage.getMainDocumentPart().getDocumentSettingsPart() != null && wmlPackage.getMainDocumentPart().getDocumentSettingsPart().getContents() != null) {
            evenAndOddHeaders = ((CTSettings)wmlPackage.getMainDocumentPart().getDocumentSettingsPart().getContents()).getEvenAndOddHeaders();
        }
        conversionSections = dummySections ? ConversionSectionWrapperFactory.processDummy(wmlPackage, document, rels, evenAndOddHeaders, dummyPageNumbering) : ConversionSectionWrapperFactory.processComplete(wmlPackage, document, rels, evenAndOddHeaders, dummyPageNumbering);
        return new ConversionSectionWrappers(conversionSections);
    }

    protected static List<ConversionSectionWrapper> processDummy(WordprocessingMLPackage wmlPackage, Document document, RelationshipsPart rels, BooleanDefaultTrue evenAndOddHeaders, boolean dummyPageNumbering) {
        log.debug("starting");
        ArrayList<ConversionSectionWrapper> conversionSections = new ArrayList<ConversionSectionWrapper>();
        ConversionSectionWrapper currentSectionWrapper = null;
        HeaderFooterPolicy previousHF = new HeaderFooterPolicy(document.getBody().getSectPr(), null, rels, evenAndOddHeaders);
        currentSectionWrapper = ConversionSectionWrapperFactory.createSectionWrapper(document.getBody().getSectPr(), previousHF, rels, evenAndOddHeaders, 1, document.getBody().getContent(), dummyPageNumbering);
        conversionSections.add(currentSectionWrapper);
        return conversionSections;
    }

    protected static ConversionSectionWrapper createSectionWrapper(SectPr sectPr, HeaderFooterPolicy headerFooterPolicy, RelationshipsPart rels, BooleanDefaultTrue evenAndOddHeaders, int conversionSectionIndex, List<Object> content, boolean dummyPageNumbering) {
        ConversionSectionWrapper csw = new ConversionSectionWrapper(sectPr, headerFooterPolicy, rels, evenAndOddHeaders, "s" + Integer.toString(conversionSectionIndex), content);
        PageNumberInformation pageNumberInformation = PageNumberInformationCollector.process(csw, dummyPageNumbering);
        csw.setPageNumberInformation(pageNumberInformation);
        return csw;
    }

    protected static List<ConversionSectionWrapper> processComplete(WordprocessingMLPackage wmlPackage, Document document, RelationshipsPart rels, BooleanDefaultTrue evenAndOddHeaders, boolean dummyPageNumbering) {
        log.debug("starting");
        ConversionSectionWrapperFactory.removeContentControls(document);
        List<SectPr> sectPrs = ConversionSectionWrapperFactory.getSectPrs(document);
        ArrayList<ConversionSectionWrapper> conversionSections = new ArrayList<ConversionSectionWrapper>();
        ConversionSectionWrapper currentSectionWrapper = null;
        HeaderFooterPolicy previousHF = null;
        int conversionSectionIndex = 0;
        ArrayList<Object> sectionContent = new ArrayList<Object>();
        int sectPrIndex = 0;
        for (Object o : document.getBody().getContent()) {
            PPr ppr;
            if (o instanceof P && ((P)o).getPPr() != null && (ppr = ((P)o).getPPr()).getSectPr() != null) {
                SectPr followingSectPr;
                boolean ignoreThisSection = false;
                if ((followingSectPr = sectPrs.get(++sectPrIndex)).getType() != null && followingSectPr.getType().getVal().equals("continuous")) {
                    log.info("following sectPr is continuous; this section wrapper must include its contents ");
                    ignoreThisSection = true;
                }
                if (ignoreThisSection) {
                    SectPr.PgSz pgSzNext;
                    previousHF = new HeaderFooterPolicy(ppr.getSectPr(), previousHF, rels, evenAndOddHeaders);
                    SectPr.PgSz pgSzThis = ppr.getSectPr().getPgSz();
                    if (ConversionSectionWrapperFactory.insertPageBreak(pgSzThis, pgSzNext = followingSectPr.getPgSz())) {
                        ppr.setPageBreakBefore(new BooleanDefaultTrue());
                    }
                } else {
                    currentSectionWrapper = ConversionSectionWrapperFactory.createSectionWrapper(ppr.getSectPr(), previousHF, rels, evenAndOddHeaders, ++conversionSectionIndex, sectionContent, dummyPageNumbering);
                    conversionSections.add(currentSectionWrapper);
                    previousHF = currentSectionWrapper.getHeaderFooterPolicy();
                    sectionContent = new ArrayList();
                }
            }
            sectionContent.add(o);
        }
        currentSectionWrapper = ConversionSectionWrapperFactory.createSectionWrapper(document.getBody().getSectPr(), previousHF, rels, evenAndOddHeaders, ++conversionSectionIndex, sectionContent, dummyPageNumbering);
        conversionSections.add(currentSectionWrapper);
        return conversionSections;
    }

    private static boolean insertPageBreak(SectPr.PgSz pgSzThis, SectPr.PgSz pgSzNext) {
        boolean insertPageBreak = false;
        if (pgSzThis != null && pgSzNext != null) {
            if (pgSzThis.getH().compareTo(pgSzNext.getH()) != 0) {
                insertPageBreak = true;
            }
            if (pgSzThis.getW().compareTo(pgSzNext.getW()) != 0) {
                insertPageBreak = true;
            }
            boolean portraitThis = true;
            if (pgSzThis.getOrient() != null) {
                portraitThis = pgSzThis.getOrient().equals((Object)STPageOrientation.PORTRAIT);
            }
            boolean portraitNext = true;
            if (pgSzNext.getOrient() != null) {
                portraitNext = pgSzNext.getOrient().equals((Object)STPageOrientation.PORTRAIT);
            }
            if (portraitThis != portraitNext) {
                insertPageBreak = true;
            }
        }
        return insertPageBreak;
    }

    private static void removeContentControls(Document document) {
        SdtBlockFinder sbr = new SdtBlockFinder();
        new TraversalUtil(document.getContent(), sbr);
        for (int i = sbr.sdtBlocks.size() - 1; i >= 0; --i) {
            SdtBlock sdtBlock = sbr.sdtBlocks.get(i);
            ArrayList parentList = null;
            if (sdtBlock.getParent() instanceof ArrayList) {
                parentList = (ArrayList)sdtBlock.getParent();
            } else {
                log.error("Handle " + sdtBlock.getParent().getClass().getName());
            }
            int index = parentList.indexOf(sdtBlock);
            parentList.remove(index);
            parentList.addAll(index, sdtBlock.getSdtContent().getContent());
        }
    }

    private static List<SectPr> getSectPrs(Document document) {
        ArrayList<SectPr> sectPrs = new ArrayList<SectPr>();
        for (Object o : document.getBody().getContent()) {
            PPr ppr;
            if (!(o instanceof P) || ((P)o).getPPr() == null || (ppr = ((P)o).getPPr()).getSectPr() == null) continue;
            sectPrs.add(ppr.getSectPr());
        }
        if (document.getBody().getSectPr() != null) {
            sectPrs.add(document.getBody().getSectPr());
        } else {
            log.debug("No body level sectPr in document");
            List<Object> all = document.getBody().getContent();
            Object last = null;
            if (all.size() > 0) {
                last = all.get(all.size() - 1);
            }
            if (last != null && last instanceof P && ((P)last).getPPr() != null && ((P)last).getPPr().getSectPr() != null) {
                log.debug(".. but last p contains sectPr .. move it");
                SectPr thisSectPr = ((P)last).getPPr().getSectPr();
                document.getBody().setSectPr(thisSectPr);
                ((P)last).getPPr().setSectPr(null);
                sectPrs.remove(thisSectPr);
            } else {
                document.getBody().setSectPr(Context.getWmlObjectFactory().createSectPr());
                sectPrs.add(document.getBody().getSectPr());
            }
        }
        return sectPrs;
    }

    protected static class SdtBlockFinder
    extends TraversalUtil.CallbackImpl {
        List<SdtBlock> sdtBlocks = new ArrayList<SdtBlock>();
        LinkedList<SdtBlock> ll = new LinkedList();

        protected SdtBlockFinder() {
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof P && ((P)o).getPPr() != null && ((P)o).getPPr().getSectPr() != null) {
                for (SdtBlock sdt : this.ll) {
                    if (this.sdtBlocks.contains(sdt)) continue;
                    this.sdtBlocks.add(sdt);
                }
            }
            return null;
        }

        @Override
        public void walkJAXBElements(Object parent) {
            List<Object> children = this.getChildren(parent);
            if (children != null) {
                for (Object o : children) {
                    o = XmlUtils.unwrap(o);
                    this.apply(o);
                    if (o instanceof SdtBlock) {
                        this.ll.addLast((SdtBlock)o);
                    }
                    if (this.shouldTraverse(o)) {
                        this.walkJAXBElements(o);
                    }
                    if (!(o instanceof SdtBlock)) continue;
                    this.ll.removeLast();
                }
            }
        }
    }
}

