/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields.docproperty;

import javax.xml.datatype.XMLGregorianCalendar;
import org.docx4j.XmlUtils;
import org.docx4j.docProps.core.CoreProperties;
import org.docx4j.docProps.core.dc.elements.SimpleLiteral;
import org.docx4j.docProps.custom.Properties;
import org.docx4j.docProps.extended.Properties;
import org.docx4j.jaxb.Context;
import org.docx4j.model.fields.FieldFormattingException;
import org.docx4j.model.fields.FieldValueException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocPropertyResolver {
    private static Logger log = LoggerFactory.getLogger(DocPropertyResolver.class);
    private DocPropsCustomPart docPropsCustomPart;
    private CoreProperties coreProperties;
    private Properties extendedProperties;
    private static final String BUILT_IN_FIELDS_CORE = "Author, Comments, CreateTime, LastPrinted, LastSavedBy, LastSavedTime, RevisionNumber, Subject, Title";
    private static final String BUILT_IN_FIELDS_EXTENDED = "Characters, CharactersWithSpaces, Company, Lines, NameofApplication, Pages, Paragraphs, Security, Template, TotalEditingTime, Words";
    private static final String BUILT_IN_FIELDS_UNSUPPORTED = "Bytes";

    public DocPropertyResolver(WordprocessingMLPackage wordMLPackage) {
        this.coreProperties = wordMLPackage.getDocPropsCorePart() == null ? null : (CoreProperties)wordMLPackage.getDocPropsCorePart().getJaxbElement();
        this.extendedProperties = wordMLPackage.getDocPropsExtendedPart() == null ? null : (Properties)wordMLPackage.getDocPropsExtendedPart().getJaxbElement();
        this.docPropsCustomPart = wordMLPackage.getDocPropsCustomPart();
    }

    public String getValue(String key) throws FieldFormattingException, FieldValueException {
        Object value = null;
        if (this.docPropsCustomPart != null) {
            value = this.docPropsCustomPart.getProperty(key);
        }
        if (BUILT_IN_FIELDS_CORE.contains(key)) {
            value = this.getCoreValue(key);
        } else if (BUILT_IN_FIELDS_EXTENDED.contains(key)) {
            value = this.getExtendedValue(key);
        } else if (BUILT_IN_FIELDS_UNSUPPORTED.contains(key)) {
            log.warn("No support for DOCPROPERTY field " + key);
            return null;
        }
        if (value == null) {
            throw new FieldValueException("No value found for DOCPROPERTY " + key);
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value instanceof Properties.Property) {
            Properties.Property property = (Properties.Property)value;
            if (property.getLpwstr() != null) {
                return property.getLpwstr();
            }
            if (property.getFiletime() != null) {
                XMLGregorianCalendar date = property.getFiletime();
                return date.toXMLFormat();
            }
            if (property.getDate() != null) {
                return property.getDate().toXMLFormat();
            }
            throw new FieldFormattingException(" TODO: handle " + XmlUtils.marshaltoString((Object)property, Context.jcDocPropsCustom));
        }
        throw new FieldFormattingException(key + " TODO: convert " + value.getClass().getName() + " to string");
    }

    private Object getCoreValue(String key) {
        if ("Author".equals(key)) {
            return this.getFirstValue(this.coreProperties.getCreator());
        }
        if ("Comments".equals(key)) {
            return this.getFirstValue((SimpleLiteral)this.coreProperties.getDescription().getValue());
        }
        if ("CreateTime".equals(key)) {
            return this.getFirstValue(this.coreProperties.getCreated());
        }
        if ("LastPrinted".equals(key)) {
            return this.coreProperties.getLastPrinted();
        }
        if ("LastSavedBy".equals(key)) {
            return this.getFirstValue(this.coreProperties.getModified());
        }
        if ("LastSavedTime".equals(key)) {
            return this.coreProperties.getLastModifiedBy();
        }
        if ("RevisionNumber".equals(key)) {
            return this.coreProperties.getRevision();
        }
        if ("Subject".equals(key)) {
            return this.getFirstValue(this.coreProperties.getSubject());
        }
        if ("Title".equals(key)) {
            return this.getFirstValue((SimpleLiteral)this.coreProperties.getTitle().getValue());
        }
        log.error("Handle " + key);
        return null;
    }

    private Object getExtendedValue(String key) {
        if ("Characters".equals(key)) {
            return this.extendedProperties.getCharacters();
        }
        if ("CharactersWithSpaces".equals(key)) {
            return this.extendedProperties.getCharactersWithSpaces();
        }
        if ("Company".equals(key)) {
            return this.extendedProperties.getCompany();
        }
        if ("HyperlinkBase".equals(key)) {
            return this.extendedProperties.getHyperlinkBase();
        }
        if ("Lines".equals(key)) {
            return this.extendedProperties.getLines();
        }
        if ("NameofApplication".equals(key)) {
            return this.extendedProperties.getApplication();
        }
        if ("Pages".equals(key)) {
            return this.extendedProperties.getPages();
        }
        if ("Paragraphs".equals(key)) {
            return this.extendedProperties.getParagraphs();
        }
        if ("Security".equals(key)) {
            return this.extendedProperties.getDocSecurity();
        }
        if ("Template".equals(key)) {
            return this.extendedProperties.getTemplate();
        }
        if ("TotalEditingTime".equals(key)) {
            return this.extendedProperties.getTotalTime();
        }
        if ("Words".equals(key)) {
            return this.extendedProperties.getWords();
        }
        log.error("Handle " + key);
        return null;
    }

    private String getFirstValue(SimpleLiteral simpleLiteral) {
        if (simpleLiteral.getContent().size() == 0) {
            return null;
        }
        return simpleLiteral.getContent().get(0);
    }
}

