/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.styles;

import org.docx4j.XmlUtils;
import org.docx4j.wml.Style;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokenStyleRemediator {
    protected static Logger log = LoggerFactory.getLogger(BrokenStyleRemediator.class);

    public static void remediate(Style s2) {
        if (s2.getStyleId() == null) {
            if (log.isWarnEnabled()) {
                log.warn("Style is missing ID(!)");
                log.warn(XmlUtils.marshaltoString(s2));
            }
            if (s2.getName() != null && s2.getName().getVal() != null) {
                log.warn("remediating");
                s2.setStyleId(s2.getName().getVal());
            } else {
                log.warn(".. ignoring");
                return;
            }
        }
        if (s2.getType() == null) {
            log.warn("Style is missing type");
            if (s2.getBasedOn() != null && s2.getBasedOn().getVal() != null && s2.getBasedOn().getVal().equals("Normal")) {
                log.warn("remediating");
                s2.setType("paragraph");
            } else {
                log.warn(".. ignoring");
                return;
            }
        }
    }
}

