/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.poi.hpsf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.docx4j.org.apache.poi.hpsf.ClassID;
import org.docx4j.org.apache.poi.hpsf.HPSFRuntimeException;
import org.docx4j.org.apache.poi.hpsf.Property;
import org.docx4j.org.apache.poi.hpsf.Util;
import org.docx4j.org.apache.poi.hpsf.wellknown.SectionIDMap;
import org.docx4j.org.apache.poi.util.LittleEndian;

public class Section {
    protected Map<Long, String> dictionary;
    protected ClassID formatID;
    protected long offset;
    protected int size;
    protected Property[] properties;
    private boolean wasNull;

    public ClassID getFormatID() {
        return this.formatID;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public int getPropertyCount() {
        return this.properties.length;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    protected Section() {
    }

    public Section(byte[] src, int offset) throws UnsupportedEncodingException {
        PropertyListEntry ple2;
        int i;
        int o1 = offset;
        this.formatID = new ClassID(src, o1);
        this.offset = LittleEndian.getUInt(src, o1 += 16);
        o1 = (int)this.offset;
        this.size = (int)LittleEndian.getUInt(src, o1);
        int propertyCount = (int)LittleEndian.getUInt(src, o1 += 4);
        this.properties = new Property[propertyCount];
        int pass1Offset = o1 += 4;
        ArrayList<PropertyListEntry> propertyList = new ArrayList<PropertyListEntry>(propertyCount);
        for (i = 0; i < this.properties.length; ++i) {
            ple2 = new PropertyListEntry();
            ple2.id = (int)LittleEndian.getUInt(src, pass1Offset);
            ple2.offset = (int)LittleEndian.getUInt(src, pass1Offset += 4);
            pass1Offset += 4;
            propertyList.add(ple2);
        }
        Collections.sort(propertyList);
        for (i = 0; i < propertyCount - 1; ++i) {
            PropertyListEntry ple1 = (PropertyListEntry)propertyList.get(i);
            PropertyListEntry ple2 = (PropertyListEntry)propertyList.get(i + 1);
            ple1.length = ple2.offset - ple1.offset;
        }
        if (propertyCount > 0) {
            ple2 = (PropertyListEntry)propertyList.get(propertyCount - 1);
            ple2.length = this.size - ple2.offset;
        }
        int codepage = -1;
        Iterator i2 = propertyList.iterator();
        while (codepage == -1 && i2.hasNext()) {
            ple2 = (PropertyListEntry)i2.next();
            if (ple2.id != 1) continue;
            int o = (int)(this.offset + (long)ple2.offset);
            long type = LittleEndian.getUInt(src, o);
            o += 4;
            if (type != 2L) {
                throw new HPSFRuntimeException("Value type of property ID 1 is not VT_I2 but " + type + ".");
            }
            codepage = LittleEndian.getUShort(src, o);
        }
        int i1 = 0;
        for (PropertyListEntry ple2 : propertyList) {
            Property p = new Property(ple2.id, src, this.offset + (long)ple2.offset, ple2.length, codepage);
            if (p.getID() == 1L) {
                p = new Property(p.getID(), p.getType(), codepage);
            }
            this.properties[i1++] = p;
        }
        this.dictionary = (Map)this.getProperty(0L);
    }

    public Object getProperty(long id) {
        this.wasNull = false;
        for (int i = 0; i < this.properties.length; ++i) {
            if (id != this.properties[i].getID()) continue;
            return this.properties[i].getValue();
        }
        this.wasNull = true;
        return null;
    }

    protected int getPropertyIntValue(long id) {
        Object o = this.getProperty(id);
        if (o == null) {
            return 0;
        }
        if (!(o instanceof Long) && !(o instanceof Integer)) {
            throw new HPSFRuntimeException("This property is not an integer type, but " + o.getClass().getName() + ".");
        }
        Number i = (Number)o;
        return i.intValue();
    }

    protected boolean getPropertyBooleanValue(int id) {
        Boolean b = (Boolean)this.getProperty(id);
        if (b == null) {
            return false;
        }
        return b;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getPIDString(long pid) {
        String s2 = null;
        if (this.dictionary != null) {
            s2 = this.dictionary.get(pid);
        }
        if (s2 == null) {
            s2 = SectionIDMap.getPIDString(this.getFormatID().getBytes(), pid);
        }
        if (s2 == null) {
            s2 = "[undefined]";
        }
        return s2;
    }

    public boolean equals(Object o) {
        long id;
        int i;
        if (o == null || !(o instanceof Section)) {
            return false;
        }
        Section s2 = (Section)o;
        if (!s2.getFormatID().equals(this.getFormatID())) {
            return false;
        }
        Object[] pa1 = new Property[this.getProperties().length];
        Object[] pa2 = new Property[s2.getProperties().length];
        System.arraycopy(this.getProperties(), 0, pa1, 0, pa1.length);
        System.arraycopy(s2.getProperties(), 0, pa2, 0, pa2.length);
        Property p10 = null;
        Property p20 = null;
        for (i = 0; i < pa1.length; ++i) {
            id = pa1[i].getID();
            if (id == 0L) {
                p10 = pa1[i];
                pa1 = this.remove((Property[])pa1, i);
                --i;
            }
            if (id != 1L) continue;
            pa1 = this.remove((Property[])pa1, i);
            --i;
        }
        for (i = 0; i < pa2.length; ++i) {
            id = pa2[i].getID();
            if (id == 0L) {
                p20 = pa2[i];
                pa2 = this.remove((Property[])pa2, i);
                --i;
            }
            if (id != 1L) continue;
            pa2 = this.remove((Property[])pa2, i);
            --i;
        }
        if (pa1.length != pa2.length) {
            return false;
        }
        boolean dictionaryEqual = true;
        if (p10 != null && p20 != null) {
            dictionaryEqual = p10.getValue().equals(p20.getValue());
        } else if (p10 != null || p20 != null) {
            dictionaryEqual = false;
        }
        if (dictionaryEqual) {
            return Util.equals(pa1, pa2);
        }
        return false;
    }

    private Property[] remove(Property[] pa, int i) {
        Property[] h2 = new Property[pa.length - 1];
        if (i > 0) {
            System.arraycopy(pa, 0, h2, 0, i);
        }
        System.arraycopy(pa, i + 1, h2, i, h2.length - i);
        return h2;
    }

    public int hashCode() {
        long hashCode = 0L;
        hashCode += (long)this.getFormatID().hashCode();
        Property[] pa = this.getProperties();
        for (int i = 0; i < pa.length; ++i) {
            hashCode += (long)pa[i].hashCode();
        }
        int returnHashCode = (int)(hashCode & 0xFFFFFFFFL);
        return returnHashCode;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        Property[] pa = this.getProperties();
        b.append(this.getClass().getName());
        b.append('[');
        b.append("formatID: ");
        b.append(this.getFormatID());
        b.append(", offset: ");
        b.append(this.getOffset());
        b.append(", propertyCount: ");
        b.append(this.getPropertyCount());
        b.append(", size: ");
        b.append(this.getSize());
        b.append(", properties: [\n");
        for (int i = 0; i < pa.length; ++i) {
            b.append(pa[i].toString());
            b.append(",\n");
        }
        b.append(']');
        b.append(']');
        return b.toString();
    }

    public Map<Long, String> getDictionary() {
        return this.dictionary;
    }

    public int getCodepage() {
        Integer codepage = (Integer)this.getProperty(1L);
        if (codepage == null) {
            return -1;
        }
        int cp = codepage;
        return cp;
    }

    static class PropertyListEntry
    implements Comparable<PropertyListEntry> {
        int id;
        int offset;
        int length;

        PropertyListEntry() {
        }

        @Override
        public int compareTo(PropertyListEntry o) {
            int otherOffset = o.offset;
            if (this.offset < otherOffset) {
                return -1;
            }
            if (this.offset == otherOffset) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(this.getClass().getName());
            b.append("[id=");
            b.append(this.id);
            b.append(", offset=");
            b.append(this.offset);
            b.append(", length=");
            b.append(this.length);
            b.append(']');
            return b.toString();
        }
    }
}

