/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.poi.poifs.crypt.agile;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.docx4j.com.microsoft.schemas.office.x2006.encryption.CTDataIntegrity;
import org.docx4j.com.microsoft.schemas.office.x2006.encryption.CTEncryption;
import org.docx4j.com.microsoft.schemas.office.x2006.encryption.CTKeyData;
import org.docx4j.com.microsoft.schemas.office.x2006.encryption.CTKeyEncryptor;
import org.docx4j.com.microsoft.schemas.office.x2006.encryption.CTKeyEncryptors;
import org.docx4j.com.microsoft.schemas.office.x2006.encryption.STCipherChaining;
import org.docx4j.com.microsoft.schemas.office.x2006.encryption.STHashAlgorithm;
import org.docx4j.com.microsoft.schemas.office.x2006.keyEncryptor.certificate.CTCertificateKeyEncryptor;
import org.docx4j.com.microsoft.schemas.office.x2006.keyEncryptor.password.CTPasswordKeyEncryptor;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.org.apache.poi.EncryptedDocumentException;
import org.docx4j.org.apache.poi.poifs.crypt.ChunkedCipherOutputStream;
import org.docx4j.org.apache.poi.poifs.crypt.CryptoFunctions;
import org.docx4j.org.apache.poi.poifs.crypt.DataSpaceMapUtils;
import org.docx4j.org.apache.poi.poifs.crypt.EncryptionInfo;
import org.docx4j.org.apache.poi.poifs.crypt.Encryptor;
import org.docx4j.org.apache.poi.poifs.crypt.HashAlgorithm;
import org.docx4j.org.apache.poi.poifs.crypt.agile.AgileDecryptor;
import org.docx4j.org.apache.poi.poifs.crypt.agile.AgileEncryptionHeader;
import org.docx4j.org.apache.poi.poifs.crypt.agile.AgileEncryptionInfoBuilder;
import org.docx4j.org.apache.poi.poifs.crypt.agile.AgileEncryptionVerifier;
import org.docx4j.org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import org.docx4j.org.apache.poi.poifs.filesystem.DirectoryNode;
import org.docx4j.org.apache.poi.util.LittleEndian;
import org.docx4j.org.apache.poi.util.LittleEndianByteArrayOutputStream;

public class AgileEncryptor
extends Encryptor {
    private final AgileEncryptionInfoBuilder builder;
    private byte[] integritySalt;
    private byte[] pwHash;
    static final String HTTP_SCHEMAS_MICROSOFT_COM_OFFICE_2006_KEY_ENCRYPTOR_PASSWORD = "http://schemas.microsoft.com/office/2006/keyEncryptor/password";
    static final String HTTP_SCHEMAS_MICROSOFT_COM_OFFICE_2006_KEY_ENCRYPTOR_CERTIFICATE = "http://schemas.microsoft.com/office/2006/keyEncryptor/certificate";
    private final String passwordUri = "http://schemas.microsoft.com/office/2006/keyEncryptor/password";
    private final String certificateUri = "http://schemas.microsoft.com/office/2006/keyEncryptor/certificate";

    protected AgileEncryptor(AgileEncryptionInfoBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void confirmPassword(String password) {
        SecureRandom r = new SecureRandom();
        int blockSize = this.builder.getHeader().getBlockSize();
        int keySize = this.builder.getHeader().getKeySize() / 8;
        int hashSize = this.builder.getHeader().getHashAlgorithmEx().hashSize;
        byte[] verifierSalt = new byte[blockSize];
        byte[] verifier = new byte[blockSize];
        byte[] keySalt = new byte[blockSize];
        byte[] keySpec = new byte[keySize];
        byte[] integritySalt = new byte[hashSize];
        ((Random)r).nextBytes(verifierSalt);
        ((Random)r).nextBytes(verifier);
        ((Random)r).nextBytes(keySalt);
        ((Random)r).nextBytes(keySpec);
        ((Random)r).nextBytes(integritySalt);
        this.confirmPassword(password, keySpec, keySalt, verifierSalt, verifier, integritySalt);
    }

    @Override
    public void confirmPassword(String password, byte[] keySpec, byte[] keySalt, byte[] verifier, byte[] verifierSalt, byte[] integritySalt) {
        AgileEncryptionVerifier ver = this.builder.getVerifier();
        ver.setSalt(verifierSalt);
        AgileEncryptionHeader header = this.builder.getHeader();
        header.setKeySalt(keySalt);
        HashAlgorithm hashAlgo = ver.getHashAlgorithm();
        int blockSize = header.getBlockSize();
        this.pwHash = CryptoFunctions.hashPassword(password, hashAlgo, verifierSalt, ver.getSpinCount());
        byte[] encryptedVerifier = AgileDecryptor.hashInput(this.builder, this.pwHash, AgileDecryptor.kVerifierInputBlock, verifier, 1);
        ver.setEncryptedVerifier(encryptedVerifier);
        MessageDigest hashMD = CryptoFunctions.getMessageDigest(hashAlgo);
        byte[] hashedVerifier = hashMD.digest(verifier);
        byte[] encryptedVerifierHash = AgileDecryptor.hashInput(this.builder, this.pwHash, AgileDecryptor.kHashedVerifierBlock, hashedVerifier, 1);
        ver.setEncryptedVerifierHash(encryptedVerifierHash);
        byte[] encryptedKey = AgileDecryptor.hashInput(this.builder, this.pwHash, AgileDecryptor.kCryptoKeyBlock, keySpec, 1);
        ver.setEncryptedKey(encryptedKey);
        SecretKeySpec secretKey = new SecretKeySpec(keySpec, ver.getCipherAlgorithm().jceId);
        this.setSecretKey(secretKey);
        this.integritySalt = integritySalt;
        try {
            byte[] vec = CryptoFunctions.generateIv(hashAlgo, header.getKeySalt(), AgileDecryptor.kIntegrityKeyBlock, header.getBlockSize());
            Cipher cipher = CryptoFunctions.getCipher(secretKey, ver.getCipherAlgorithm(), ver.getChainingMode(), vec, 1);
            byte[] filledSalt = CryptoFunctions.getBlock0(integritySalt, AgileDecryptor.getNextBlockSize(integritySalt.length, blockSize));
            byte[] encryptedHmacKey = cipher.doFinal(filledSalt);
            header.setEncryptedHmacKey(encryptedHmacKey);
            cipher = Cipher.getInstance("RSA");
            for (AgileEncryptionVerifier.AgileCertificateEntry ace : ver.getCertificates()) {
                cipher.init(1, ace.x509.getPublicKey());
                ace.encryptedKey = cipher.doFinal(this.getSecretKey().getEncoded());
                Mac x509Hmac = CryptoFunctions.getMac(hashAlgo);
                x509Hmac.init(this.getSecretKey());
                ace.certVerifier = x509Hmac.doFinal(ace.x509.getEncoded());
            }
        }
        catch (GeneralSecurityException e) {
            throw new EncryptedDocumentException(e);
        }
    }

    @Override
    public OutputStream getDataStream(DirectoryNode dir) throws IOException, GeneralSecurityException {
        AgileCipherOutputStream countStream = new AgileCipherOutputStream(dir);
        return countStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIntegrityHMAC(File tmpFile, int oleStreamSize) throws GeneralSecurityException, IOException {
        AgileEncryptionVerifier ver = this.builder.getVerifier();
        HashAlgorithm hashAlgo = ver.getHashAlgorithm();
        Mac integrityMD = CryptoFunctions.getMac(hashAlgo);
        integrityMD.init(new SecretKeySpec(this.integritySalt, hashAlgo.jceHmacId));
        byte[] buf = new byte[1024];
        LittleEndian.putLong(buf, 0, oleStreamSize);
        integrityMD.update(buf, 0, 8);
        try (FileInputStream fis = new FileInputStream(tmpFile);){
            int readBytes;
            while ((readBytes = ((InputStream)fis).read(buf)) != -1) {
                integrityMD.update(buf, 0, readBytes);
            }
        }
        byte[] hmacValue = integrityMD.doFinal();
        AgileEncryptionHeader header = this.builder.getHeader();
        int blockSize = header.getBlockSize();
        byte[] iv = CryptoFunctions.generateIv(header.getHashAlgorithmEx(), header.getKeySalt(), AgileDecryptor.kIntegrityValueBlock, blockSize);
        Cipher cipher = CryptoFunctions.getCipher(this.getSecretKey(), header.getCipherAlgorithm(), header.getChainingMode(), iv, 1);
        byte[] hmacValueFilled = CryptoFunctions.getBlock0(hmacValue, AgileDecryptor.getNextBlockSize(hmacValue.length, blockSize));
        byte[] encryptedHmacValue = cipher.doFinal(hmacValueFilled);
        header.setEncryptedHmacValue(encryptedHmacValue);
    }

    protected CTEncryption createEncryptionDocument() {
        AgileEncryptionVerifier ver = this.builder.getVerifier();
        AgileEncryptionHeader header = this.builder.getHeader();
        CTEncryption edRoot = new CTEncryption();
        CTKeyData keyData = new CTKeyData();
        edRoot.setKeyData(keyData);
        CTKeyEncryptors keyEncList = new CTKeyEncryptors();
        edRoot.setKeyEncryptors(keyEncList);
        CTKeyEncryptor keyEnc = new CTKeyEncryptor();
        keyEncList.getKeyEncryptor().add(keyEnc);
        keyEnc.setUri(HTTP_SCHEMAS_MICROSOFT_COM_OFFICE_2006_KEY_ENCRYPTOR_PASSWORD);
        CTPasswordKeyEncryptor keyPass = new CTPasswordKeyEncryptor();
        keyEnc.setEncryptedPasswordKey(keyPass);
        keyPass.setSpinCount(ver.getSpinCount());
        keyData.setSaltSize(header.getBlockSize());
        keyPass.setSaltSize(header.getBlockSize());
        keyData.setBlockSize(header.getBlockSize());
        keyPass.setBlockSize(header.getBlockSize());
        keyData.setKeyBits(header.getKeySize());
        keyPass.setKeyBits(header.getKeySize());
        HashAlgorithm hashAlgo = header.getHashAlgorithmEx();
        keyData.setHashSize(hashAlgo.hashSize);
        keyPass.setHashSize(hashAlgo.hashSize);
        String xmlCipherAlgo = header.getCipherAlgorithm().xmlId;
        if (xmlCipherAlgo == null) {
            throw new EncryptedDocumentException("CipherAlgorithm " + (Object)((Object)header.getCipherAlgorithm()) + " not supported.");
        }
        keyData.setCipherAlgorithm(xmlCipherAlgo);
        keyPass.setCipherAlgorithm(xmlCipherAlgo);
        switch (header.getChainingMode()) {
            case cbc: {
                keyData.setCipherChaining(STCipherChaining.CHAINING_MODE_CBC);
                keyPass.setCipherChaining(STCipherChaining.CHAINING_MODE_CBC);
                break;
            }
            case cfb: {
                keyData.setCipherChaining(STCipherChaining.CHAINING_MODE_CFB);
                keyPass.setCipherChaining(STCipherChaining.CHAINING_MODE_CFB);
                break;
            }
            default: {
                throw new EncryptedDocumentException("ChainingMode " + (Object)((Object)header.getChainingMode()) + " not supported.");
            }
        }
        STHashAlgorithm xmlHashAlgo = STHashAlgorithm.fromValue(hashAlgo.ecmaString);
        if (xmlHashAlgo == null) {
            throw new EncryptedDocumentException("HashAlgorithm " + (Object)((Object)hashAlgo) + " not supported.");
        }
        keyData.setHashAlgorithm(xmlHashAlgo);
        keyPass.setHashAlgorithm(xmlHashAlgo);
        keyData.setSaltValue(header.getKeySalt());
        keyPass.setSaltValue(ver.getSalt());
        keyPass.setEncryptedVerifierHashInput(ver.getEncryptedVerifier());
        keyPass.setEncryptedVerifierHashValue(ver.getEncryptedVerifierHash());
        keyPass.setEncryptedKeyValue(ver.getEncryptedKey());
        CTDataIntegrity hmacData = new CTDataIntegrity();
        edRoot.setDataIntegrity(hmacData);
        hmacData.setEncryptedHmacKey(header.getEncryptedHmacKey());
        hmacData.setEncryptedHmacValue(header.getEncryptedHmacValue());
        for (AgileEncryptionVerifier.AgileCertificateEntry ace : ver.getCertificates()) {
            keyEnc = new CTKeyEncryptor();
            keyEncList.getKeyEncryptor().add(keyEnc);
            keyEnc.setUri(HTTP_SCHEMAS_MICROSOFT_COM_OFFICE_2006_KEY_ENCRYPTOR_CERTIFICATE);
            CTCertificateKeyEncryptor certData = new CTCertificateKeyEncryptor();
            keyEnc.setEncryptedCertificateKey(certData);
            try {
                certData.setX509Certificate(ace.x509.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new EncryptedDocumentException(e);
            }
            certData.setEncryptedKeyValue(ace.encryptedKey);
            certData.setCertVerifier(ace.certVerifier);
        }
        return edRoot;
    }

    protected void marshallEncryptionDocument(CTEncryption ed, LittleEndianByteArrayOutputStream os) {
        try {
            Marshaller marshaller = Context.jcEncryption.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)false);
            NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            marshaller.marshal((Object)ed, (OutputStream)bos);
            os.write(bos.toByteArray());
        }
        catch (JAXBException e) {
            throw new EncryptedDocumentException("error marshalling encryption info document", e);
        }
    }

    protected void createEncryptionInfoEntry(DirectoryNode dir, File tmpFile) throws IOException, GeneralSecurityException {
        DataSpaceMapUtils.addDefaultDataSpace(dir);
        final EncryptionInfo info = this.builder.getInfo();
        EncryptionRecord er = new EncryptionRecord(){

            @Override
            public void write(LittleEndianByteArrayOutputStream bos) {
                bos.writeShort(info.getVersionMajor());
                bos.writeShort(info.getVersionMinor());
                bos.writeInt(info.getEncryptionFlags());
                AgileEncryptor.this.marshallEncryptionDocument(AgileEncryptor.this.createEncryptionDocument(), bos);
            }
        };
        DataSpaceMapUtils.createEncryptionEntry(dir, "EncryptionInfo", er);
    }

    private class AgileCipherOutputStream
    extends ChunkedCipherOutputStream {
        public AgileCipherOutputStream(DirectoryNode dir) throws IOException, GeneralSecurityException {
            super(dir, 4096);
        }

        @Override
        protected Cipher initCipherForBlock(Cipher existing, int block, boolean lastChunk) throws GeneralSecurityException {
            return AgileDecryptor.initCipherForBlock(existing, block, lastChunk, AgileEncryptor.this.builder, AgileEncryptor.this.getSecretKey(), 1);
        }

        @Override
        protected void calculateChecksum(File fileOut, int oleStreamSize) throws GeneralSecurityException, IOException {
            AgileEncryptor.this.updateIntegrityHMAC(fileOut, oleStreamSize);
        }

        @Override
        protected void createEncryptionInfoEntry(DirectoryNode dir, File tmpFile) throws IOException, GeneralSecurityException {
            AgileEncryptor.this.createEncryptionInfoEntry(dir, tmpFile);
        }
    }
}

