/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.complexscripts.scripts;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphTable;
import org.docx4j.fonts.fop.complexscripts.scripts.DefaultScriptProcessor;
import org.docx4j.fonts.fop.complexscripts.scripts.DevanagariScriptProcessor;
import org.docx4j.fonts.fop.complexscripts.scripts.GujaratiScriptProcessor;
import org.docx4j.fonts.fop.complexscripts.scripts.GurmukhiScriptProcessor;
import org.docx4j.fonts.fop.complexscripts.scripts.KhmerScriptProcessor;
import org.docx4j.fonts.fop.complexscripts.scripts.ScriptProcessor;
import org.docx4j.fonts.fop.complexscripts.scripts.TamilScriptProcessor;
import org.docx4j.fonts.fop.complexscripts.util.CharAssociation;
import org.docx4j.fonts.fop.complexscripts.util.CharScript;
import org.docx4j.fonts.fop.complexscripts.util.GlyphContextTester;
import org.docx4j.fonts.fop.complexscripts.util.GlyphSequence;
import org.docx4j.fonts.fop.complexscripts.util.ScriptContextTester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicScriptProcessor
extends DefaultScriptProcessor {
    private static final Logger log = LoggerFactory.getLogger(IndicScriptProcessor.class);
    private static final String[] GSUB_REQ_FEATURES = new String[]{"abvf", "abvs", "akhn", "blwf", "blws", "ccmp", "cjct", "clig", "half", "haln", "locl", "nukt", "pref", "pres", "pstf", "psts", "rkrf", "rphf", "vatu"};
    private static final String[] GSUB_OPT_FEATURES = new String[]{"afrc", "calt", "dlig"};
    private static final String[] GPOS_REQ_FEATURES = new String[]{"abvm", "blwm", "dist", "kern"};
    private static final String[] GPOS_OPT_FEATURES = new String[0];
    private final ScriptContextTester subContextTester = new SubstitutionScriptContextTester();
    private final ScriptContextTester posContextTester = new PositioningScriptContextTester();
    private static Set<String> basicShapingFeatures;
    private static final String[] BASIC_SHAPING_FEATURE_STRINGS;
    private static Set<String> presentationFeatures;
    private static final String[] PRESENTATION_FEATURE_STRINGS;

    public static ScriptProcessor makeProcessor(String script) {
        switch (CharScript.scriptCodeFromTag(script)) {
            case 315: 
            case 1315: {
                return new DevanagariScriptProcessor(script);
            }
            case 320: 
            case 1320: {
                return new GujaratiScriptProcessor(script);
            }
            case 310: 
            case 1310: {
                return new GurmukhiScriptProcessor(script);
            }
            case 346: 
            case 1346: {
                return new TamilScriptProcessor(script);
            }
            case 355: {
                return new KhmerScriptProcessor(script);
            }
        }
        return new IndicScriptProcessor(script);
    }

    IndicScriptProcessor(String script) {
        super(script);
    }

    @Override
    public String[] getSubstitutionFeatures() {
        return GSUB_REQ_FEATURES;
    }

    @Override
    public String[] getOptionalSubstitutionFeatures() {
        return GSUB_OPT_FEATURES;
    }

    @Override
    public ScriptContextTester getSubstitutionContextTester() {
        return this.subContextTester;
    }

    @Override
    public String[] getPositioningFeatures() {
        return GPOS_REQ_FEATURES;
    }

    @Override
    public String[] getOptionalPositioningFeatures() {
        return GPOS_OPT_FEATURES;
    }

    @Override
    public ScriptContextTester getPositioningContextTester() {
        return this.posContextTester;
    }

    @Override
    public GlyphSequence substitute(GlyphSequence gs, String script, String language, GlyphTable.UseSpec[] usa, ScriptContextTester sct) {
        assert (usa != null);
        GlyphSequence[] sa = this.syllabize(gs, script, language);
        int n = sa.length;
        for (int i = 0; i < n; ++i) {
            GlyphSequence s2 = sa[i];
            for (GlyphTable.UseSpec us : usa) {
                if (!this.isBasicShapingUse(us)) continue;
                s2.setPredications(true);
                s2 = us.substitute(s2, script, language, sct);
            }
            s2 = this.reorderPreBaseMatra(s2);
            s2 = this.reorderReph(s2);
            for (GlyphTable.UseSpec us : usa) {
                if (!this.isPresentationUse(us)) continue;
                s2.setPredications(true);
                s2 = us.substitute(s2, script, language, sct);
            }
            sa[i] = s2;
        }
        return this.unsyllabize(gs, sa);
    }

    protected Class<? extends Syllabizer> getSyllabizerClass() {
        return null;
    }

    private GlyphSequence[] syllabize(GlyphSequence gs, String script, String language) {
        return Syllabizer.getSyllabizer(script, language, this.getSyllabizerClass()).syllabize(gs);
    }

    private GlyphSequence unsyllabize(GlyphSequence gs, GlyphSequence[] sa) {
        return GlyphSequence.join(gs, sa);
    }

    private boolean isBasicShapingUse(GlyphTable.UseSpec us) {
        assert (us != null);
        if (basicShapingFeatures != null) {
            return basicShapingFeatures.contains(us.getFeature());
        }
        return false;
    }

    private boolean isPresentationUse(GlyphTable.UseSpec us) {
        assert (us != null);
        if (presentationFeatures != null) {
            return presentationFeatures.contains(us.getFeature());
        }
        return false;
    }

    private GlyphSequence reorderPreBaseMatra(GlyphSequence gs) {
        int target;
        int source = this.findPreBaseMatra(gs);
        if (source >= 0 && (target = this.findPreBaseMatraTarget(gs, source)) >= 0 && target != source) {
            gs = this.reorder(gs, source, target);
        }
        return gs;
    }

    protected int findPreBaseMatra(GlyphSequence gs) {
        return -1;
    }

    protected int findPreBaseMatraTarget(GlyphSequence gs, int source) {
        return -1;
    }

    private GlyphSequence reorderReph(GlyphSequence gs) {
        int target;
        int source = this.findReph(gs);
        if (source >= 0 && (target = this.findRephTarget(gs, source)) >= 0 && target != source) {
            gs = this.reorder(gs, source, target);
        }
        return gs;
    }

    protected int findReph(GlyphSequence gs) {
        return -1;
    }

    protected int findRephTarget(GlyphSequence gs, int source) {
        return -1;
    }

    private GlyphSequence reorder(GlyphSequence gs, int source, int target) {
        return GlyphSequence.reorder(gs, source, 1, target);
    }

    @Override
    public boolean position(GlyphSequence gs, String script, String language, int fontSize, GlyphTable.UseSpec[] usa, int[] widths, int[][] adjustments, ScriptContextTester sct) {
        boolean adjusted = super.position(gs, script, language, fontSize, usa, widths, adjustments, sct);
        return adjusted;
    }

    static {
        BASIC_SHAPING_FEATURE_STRINGS = new String[]{"abvf", "akhn", "blwf", "cjct", "half", "locl", "nukt", "pref", "pstf", "rkrf", "rphf", "vatu", "ccmp"};
        basicShapingFeatures = new HashSet<String>();
        Collections.addAll(basicShapingFeatures, BASIC_SHAPING_FEATURE_STRINGS);
        PRESENTATION_FEATURE_STRINGS = new String[]{"abvs", "blws", "calt", "haln", "pres", "psts", "clig"};
        presentationFeatures = new HashSet<String>();
        Collections.addAll(presentationFeatures, PRESENTATION_FEATURE_STRINGS);
    }

    protected static class Segment {
        static final int OTHER = 0;
        static final int SYLLABLE = 1;
        private int start;
        private int end;
        private int type;

        Segment(int start, int end, int type) {
            this.start = start;
            this.end = end;
            this.type = type;
        }

        int getStart() {
            return this.start;
        }

        int getEnd() {
            return this.end;
        }

        int getOffset() {
            return this.start;
        }

        int getCount() {
            return this.end - this.start;
        }

        int getType() {
            return this.type;
        }
    }

    protected static class DefaultSyllabizer
    extends Syllabizer {
        DefaultSyllabizer(String script, String language) {
            super(script, language);
        }

        @Override
        GlyphSequence[] syllabize(GlyphSequence gs) {
            int[] ca = gs.getCharacterArray(false);
            int nc = gs.getCharacterCount();
            if (nc == 0) {
                return new GlyphSequence[]{gs};
            }
            return this.segmentize(gs, this.segmentize(ca, nc));
        }

        protected Segment[] segmentize(int[] ca, int nc) {
            Vector<Segment> sv = new Vector<Segment>(nc);
            int s2 = 0;
            int e = nc;
            while (s2 < e) {
                int i = this.findStartOfSyllable(ca, s2, e);
                if (i < e) {
                    if (s2 < i) {
                        sv.add(new Segment(s2, i, 0));
                    }
                    s2 = i;
                } else {
                    if (s2 < e) {
                        sv.add(new Segment(s2, e, 0));
                    }
                    s2 = e;
                }
                i = this.findEndOfSyllable(ca, s2, e);
                if (i > s2) {
                    if (s2 < i) {
                        sv.add(new Segment(s2, i, 1));
                    }
                    s2 = i;
                    continue;
                }
                if (s2 < e) {
                    sv.add(new Segment(s2, e, 0));
                }
                s2 = e;
            }
            return sv.toArray(new Segment[sv.size()]);
        }

        protected GlyphSequence[] segmentize(GlyphSequence gs, Segment[] sa) {
            int ng = gs.getGlyphCount();
            int[] ga = gs.getGlyphArray(false);
            CharAssociation[] aa = gs.getAssociations(0, -1);
            Vector<GlyphSequence> nsv = new Vector<GlyphSequence>();
            for (Segment s2 : sa) {
                Vector<Integer> ngv = new Vector<Integer>(ng);
                Vector<CharAssociation> nav = new Vector<CharAssociation>(ng);
                for (int j = 0; j < ng; ++j) {
                    CharAssociation ca = aa[j];
                    if (!ca.contained(s2.getOffset(), s2.getCount())) continue;
                    ngv.add(ga[j]);
                    nav.add(ca);
                }
                if (ngv.size() <= 0) continue;
                nsv.add(new GlyphSequence(gs, null, DefaultSyllabizer.toIntArray(ngv), null, null, nav.toArray(new CharAssociation[nav.size()]), null));
            }
            if (nsv.size() > 0) {
                return nsv.toArray(new GlyphSequence[nsv.size()]);
            }
            return new GlyphSequence[]{gs};
        }

        protected int findStartOfSyllable(int[] ca, int s2, int e) {
            return e;
        }

        protected int findEndOfSyllable(int[] ca, int s2, int e) {
            return s2;
        }

        private static int[] toIntArray(Vector<Integer> iv) {
            int ni = iv.size();
            int[] ia = new int[iv.size()];
            int n = ni;
            for (int i = 0; i < n; ++i) {
                ia[i] = iv.get(i);
            }
            return ia;
        }
    }

    protected static abstract class Syllabizer
    implements Comparable {
        private String script;
        private String language;
        private static Map<String, Syllabizer> syllabizers = new HashMap<String, Syllabizer>();

        Syllabizer(String script, String language) {
            this.script = script;
            this.language = language;
        }

        abstract GlyphSequence[] syllabize(GlyphSequence var1);

        public int hashCode() {
            int hc = 0;
            hc = 7 * hc + (hc ^ this.script.hashCode());
            hc = 11 * hc + (hc ^ this.language.hashCode());
            return hc;
        }

        public boolean equals(Object o) {
            if (o instanceof Syllabizer) {
                Syllabizer s2 = (Syllabizer)o;
                if (!s2.script.equals(this.script)) {
                    return false;
                }
                return s2.language.equals(this.language);
            }
            return false;
        }

        public int compareTo(Object o) {
            int d;
            if (o instanceof Syllabizer) {
                Syllabizer s2 = (Syllabizer)o;
                d = this.script.compareTo(s2.script);
                if (d == 0) {
                    d = this.language.compareTo(s2.language);
                }
            } else {
                d = -1;
            }
            return d;
        }

        static Syllabizer getSyllabizer(String script, String language, Class<? extends Syllabizer> syllabizerClass) {
            String sid = Syllabizer.makeSyllabizerId(script, language);
            Syllabizer s2 = syllabizers.get(sid);
            if (s2 == null) {
                if (syllabizerClass == null || (s2 = Syllabizer.makeSyllabizer(script, language, syllabizerClass)) == null) {
                    log.warn("No syllabizer available for script '" + script + "', language '" + language + "', using default Indic syllabizer.");
                    s2 = new DefaultSyllabizer(script, language);
                }
                syllabizers.put(sid, s2);
            }
            return s2;
        }

        static String makeSyllabizerId(String script, String language) {
            return script + ":" + language;
        }

        static Syllabizer makeSyllabizer(String script, String language, Class<? extends Syllabizer> syllabizerClass) {
            Syllabizer s2;
            try {
                Constructor<? extends Syllabizer> cf = syllabizerClass.getDeclaredConstructor(String.class, String.class);
                s2 = cf.newInstance(script, language);
            }
            catch (NoSuchMethodException e) {
                s2 = null;
            }
            catch (InstantiationException e) {
                s2 = null;
            }
            catch (IllegalAccessException e) {
                s2 = null;
            }
            catch (InvocationTargetException e) {
                s2 = null;
            }
            return s2;
        }
    }

    private static class PositioningScriptContextTester
    implements ScriptContextTester {
        private static Map<String, GlyphContextTester> testerMap = new HashMap<String, GlyphContextTester>();

        private PositioningScriptContextTester() {
        }

        @Override
        public GlyphContextTester getTester(String feature) {
            return testerMap.get(feature);
        }
    }

    private static class SubstitutionScriptContextTester
    implements ScriptContextTester {
        private static Map<String, GlyphContextTester> testerMap = new HashMap<String, GlyphContextTester>();

        private SubstitutionScriptContextTester() {
        }

        @Override
        public GlyphContextTester getTester(String feature) {
            return testerMap.get(feature);
        }
    }
}

