/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.jaxb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JAXBImplementation;
import org.docx4j.jaxb.NamespacePrefixMapperInterface;
import org.docx4j.jaxb.NamespacePrefixMappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class NamespacePrefixMapperUtils {
    private static Logger log = LoggerFactory.getLogger(NamespacePrefixMapperUtils.class);
    private static JAXBContext testContext;
    private static Object prefixMapper;
    private static Object prefixMapperRels;
    private static boolean haveTried;
    private static final String[] EMPTY_STRING;

    public static synchronized Object getPrefixMapper() throws JAXBException {
        Class<?> c;
        if (prefixMapper != null) {
            return prefixMapper;
        }
        if (haveTried) {
            return null;
        }
        haveTried = true;
        if (testContext == null) {
            ClassLoader classLoader = NamespacePrefixMapperUtils.class.getClassLoader();
            testContext = JAXBContext.newInstance((String)"org.docx4j.relationships", (ClassLoader)classLoader);
        }
        if (testContext == null) {
            throw new JAXBException("Couldn't create context for org.docx4j.relationships.  Everything is broken!");
        }
        if (log.isDebugEnabled()) {
            log.debug("testContext: " + testContext.getClass().getName());
        }
        if (testContext.getClass().getName().equals("org.eclipse.persistence.jaxb.JAXBContext")) {
            log.info("Using MOXy NamespacePrefixMapper");
            try {
                c = Class.forName("org.docx4j.jaxb.moxy.NamespacePrefixMapper");
                prefixMapper = c.newInstance();
                return prefixMapper;
            }
            catch (Exception e) {
                throw new JAXBException("Can't create org.docx4j.jaxb.moxy.NamespacePrefixMapper", (Throwable)e);
            }
        }
        if (testContext.getClass().getName().equals("com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl")) {
            log.info("Using com.sun.xml.internal NamespacePrefixMapper");
            try {
                c = Class.forName("org.docx4j.jaxb.suninternal.NamespacePrefixMapper");
                prefixMapper = c.newInstance();
                return prefixMapper;
            }
            catch (Exception e) {
                throw new JAXBException("Can't create internal NamespacePrefixMapper", (Throwable)e);
            }
        }
        Marshaller m3 = testContext.createMarshaller();
        return NamespacePrefixMapperUtils.tryUsingRI(m3);
    }

    private static Object tryUsingRI(Marshaller m3) throws JAXBException {
        try {
            Class<?> c = Class.forName("org.docx4j.jaxb.ri.NamespacePrefixMapper");
            prefixMapper = c.newInstance();
            m3.setProperty("com.sun.xml.bind.namespacePrefixMapper", prefixMapper);
            log.info("Using ri.NamespacePrefixMapper, which is suitable for the JAXB RI");
            return prefixMapper;
        }
        catch (Exception e) {
            throw new JAXBException("JAXB: Can't instantiate JAXB Reference Implementation", (Throwable)e);
        }
    }

    public static synchronized Object getPrefixMapperRelationshipsPart() throws JAXBException {
        Class<?> c;
        if (prefixMapperRels != null) {
            return prefixMapperRels;
        }
        if (testContext == null) {
            ClassLoader classLoader = NamespacePrefixMapperUtils.class.getClassLoader();
            testContext = JAXBContext.newInstance((String)"org.docx4j.relationships", (ClassLoader)classLoader);
        }
        if (testContext == null) {
            throw new JAXBException("Couldn't create context for org.docx4j.relationships.  Everything is broken!");
        }
        if (testContext.getClass().getName().equals("org.eclipse.persistence.jaxb.JAXBContext")) {
            log.info("Using MOXy NamespacePrefixMapper");
            try {
                c = Class.forName("org.docx4j.jaxb.moxy.NamespacePrefixMapperRelationshipsPart");
                prefixMapperRels = c.newInstance();
                return prefixMapperRels;
            }
            catch (Exception e) {
                throw new JAXBException("Can't create org.docx4j.jaxb.moxy.NamespacePrefixMapper", (Throwable)e);
            }
        }
        if (testContext.getClass().getName().equals("com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl")) {
            log.info("Using com.sun.xml.internal NamespacePrefixMapper");
            try {
                c = Class.forName("org.docx4j.jaxb.suninternal.NamespacePrefixMapperRelationshipsPart");
                prefixMapperRels = c.newInstance();
                return prefixMapperRels;
            }
            catch (Exception e) {
                throw new JAXBException("Can't create internal NamespacePrefixMapperRelationshipsPart", (Throwable)e);
            }
        }
        Marshaller m3 = testContext.createMarshaller();
        return NamespacePrefixMapperUtils.tryRIforRelationshipsPart(m3);
    }

    private static Object tryRIforRelationshipsPart(Marshaller m3) throws JAXBException {
        try {
            Class<?> c = Class.forName("org.docx4j.jaxb.ri.NamespacePrefixMapperRelationshipsPart");
            prefixMapperRels = c.newInstance();
            m3.setProperty("com.sun.xml.bind.namespacePrefixMapper", prefixMapperRels);
            log.info("Using ri.NamespacePrefixMapperRelationshipsPart, which is suitable for the JAXB RI");
            return prefixMapperRels;
        }
        catch (Exception e) {
            throw new JAXBException("JAXB: Can't instantiate JAXB Reference Implementation", (Throwable)e);
        }
    }

    public static void setProperty(Marshaller marshaller, Object namespacePrefixMapper) throws JAXBException {
        if (namespacePrefixMapper == null) {
            throw new JAXBException("namespacePrefixMapper is null");
        }
        log.debug("attempting to setProperty on marshaller " + marshaller.getClass().getName());
        try {
            if (Context.getJaxbImplementation() == JAXBImplementation.ECLIPSELINK_MOXy) {
                marshaller.setProperty("eclipselink.namespace-prefix-mapper", namespacePrefixMapper);
                log.debug("setProperty: eclipselink.namespace-prefix-mapper");
            } else if (Context.getJaxbImplementation() == JAXBImplementation.REFERENCE || Context.getJaxbImplementation() == JAXBImplementation.IBM_WEBSPHERE_XLXP) {
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", namespacePrefixMapper);
                log.debug("setProperty: com.sun.xml.bind.namespacePrefixMapper");
            } else if (Context.getJaxbImplementation() == JAXBImplementation.ORACLE_JRE) {
                log.debug("attempting to setProperty: com.sun.xml.INTERNAL.bind.namespacePrefixMapper");
                marshaller.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", namespacePrefixMapper);
            } else {
                log.warn("Which NamespacePrefixMapper to use?");
            }
        }
        catch (PropertyException e) {
            log.error("Couldn't setProperty on marshaller " + marshaller.getClass().getName());
            log.error(e.getMessage(), e);
            throw e;
        }
    }

    public static String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) throws JAXBException {
        NamespacePrefixMapperInterface namespacePrefixMapper = (NamespacePrefixMapperInterface)NamespacePrefixMapperUtils.getPrefixMapper();
        return namespacePrefixMapper.getPreferredPrefix(namespaceUri, suggestion, requirePrefix);
    }

    public static String[] getPreDeclaredNamespaceUris(String mcIgnorable) {
        if (mcIgnorable == null) {
            return EMPTY_STRING;
        }
        HashSet<String> entries = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(mcIgnorable, " ");
        while (st.hasMoreTokens()) {
            String prefix = st.nextToken();
            String uri = NamespacePrefixMappings.getNamespaceURIStatic(prefix);
            if (uri == null || uri.contentEquals("")) {
                log.warn("No mapping for prefix '" + prefix + "'");
                continue;
            }
            entries.add(uri);
        }
        return entries.toArray(new String[entries.size()]);
    }

    public static Map<String, String> getPreDeclaredNamespaceMap(String mcIgnorable) {
        HashMap<String, String> entries = new HashMap<String, String>();
        if (mcIgnorable == null) {
            return entries;
        }
        StringTokenizer st = new StringTokenizer(mcIgnorable, " ");
        while (st.hasMoreTokens()) {
            String prefix = st.nextToken();
            String uri = NamespacePrefixMappings.getNamespaceURIStatic(prefix);
            if (uri == null || uri.contentEquals("")) {
                log.warn("No mapping for prefix '" + prefix + "'");
                continue;
            }
            entries.put(prefix, uri);
        }
        return entries;
    }

    public static void declareNamespaces(String mcIgnorable, Document doc) {
        if (mcIgnorable == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(mcIgnorable, " ");
        while (st.hasMoreTokens()) {
            String prefix = st.nextToken();
            String uri = NamespacePrefixMappings.getNamespaceURIStatic(prefix);
            if (uri == null || uri.contentEquals("")) {
                log.warn("No mapping for prefix '" + prefix + "'");
                continue;
            }
            doc.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        }
    }

    static {
        haveTried = false;
        EMPTY_STRING = new String[0];
    }
}

