/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.packages;

import java.io.File;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.ProtectWorkbook;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorkbookPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.docx4j.relationships.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xlsx4j.jaxb.Context;
import org.xlsx4j.sml.BookViews;
import org.xlsx4j.sml.CTBookView;
import org.xlsx4j.sml.Sheet;
import org.xlsx4j.sml.Sheets;
import org.xlsx4j.sml.Workbook;
import org.xlsx4j.sml.Worksheet;

public class SpreadsheetMLPackage
extends OpcPackage {
    protected static Logger log = LoggerFactory.getLogger(SpreadsheetMLPackage.class);
    private ProtectWorkbook workbookProtectionSettings = new ProtectWorkbook(this);
    WorkbookPart wb;

    public SpreadsheetMLPackage() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml"));
    }

    public SpreadsheetMLPackage(ContentTypeManager contentTypeManager) {
        super(contentTypeManager);
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml"));
    }

    public ProtectWorkbook getProtectionSettings() {
        return this.workbookProtectionSettings;
    }

    public WorkbookPart getWorkbookPart() {
        return this.wb;
    }

    public static SpreadsheetMLPackage load(File xlsxFile) throws Docx4JException {
        return (SpreadsheetMLPackage)OpcPackage.load(xlsxFile);
    }

    public static SpreadsheetMLPackage load(InputStream xlsxInputStream) throws Docx4JException {
        return (SpreadsheetMLPackage)OpcPackage.load(xlsxInputStream);
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties")) {
            this.docPropsCorePart = (DocPropsCorePart)part;
            log.info("Set shortcut for docPropsCorePart");
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties")) {
            this.docPropsExtendedPart = (DocPropsExtendedPart)part;
            log.info("Set shortcut for docPropsExtendedPart");
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties")) {
            this.docPropsCustomPart = (DocPropsCustomPart)part;
            log.info("Set shortcut for docPropsCustomPart");
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument")) {
            this.wb = (WorkbookPart)part;
            log.info("Set shortcut for WorkbookPart");
            return true;
        }
        return false;
    }

    public static SpreadsheetMLPackage createPackage() throws InvalidFormatException {
        SpreadsheetMLPackage xlsPack = new SpreadsheetMLPackage();
        try {
            xlsPack.wb = new WorkbookPart();
            xlsPack.wb.setJaxbElement(Context.getsmlObjectFactory().createWorkbook());
            xlsPack.addTargetPart(xlsPack.wb);
            BookViews bookview = Context.getsmlObjectFactory().createBookViews();
            CTBookView ctBookview = Context.getsmlObjectFactory().createCTBookView();
            bookview.getWorkbookView().add(ctBookview);
            ((Workbook)xlsPack.wb.getContents()).setBookViews(bookview);
            ((Workbook)xlsPack.wb.getContents()).setSheets(Context.getsmlObjectFactory().createSheets());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidFormatException("Couldn't create package", e);
        }
        return xlsPack;
    }

    public WorksheetPart createWorksheetPart(PartName partName, String sheetName, long sheetId) throws InvalidFormatException, JAXBException {
        WorksheetPart worksheetPart = new WorksheetPart(partName);
        Relationship r = this.wb.addTargetPart(worksheetPart);
        Sheets sheets = ((Workbook)this.wb.getJaxbElement()).getSheets();
        Sheet s2 = Context.getsmlObjectFactory().createSheet();
        s2.setName(sheetName);
        s2.setId(r.getId());
        s2.setSheetId(sheetId);
        sheets.getSheet().add(s2);
        Worksheet ws = Context.getsmlObjectFactory().createWorksheet();
        worksheetPart.setJaxbElement(ws);
        ws.setSheetData(Context.getsmlObjectFactory().createSheetData());
        return worksheetPart;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("reset of xlsx package not implemented yet");
    }

    public static void main(String[] args) throws Exception {
        String outputfilepath = System.getProperty("user.dir") + "/sample-docs/xlsx/test-out.xlsx";
        SpreadsheetMLPackage pkg = SpreadsheetMLPackage.createPackage();
        pkg.createWorksheetPart(new PartName("/xl/worksheets/sheet1.xml"), "Sheet1", 1L);
        SaveToZipFile saver = new SaveToZipFile(pkg);
        saver.save(outputfilepath);
        System.out.println("\n\n done .. " + outputfilepath);
    }
}

