/*
 * Decompiled with CFR 0.152.
 */
package org.pptx4j.convert.out.svginhtml;

import java.io.ByteArrayOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.AbstractConversionSettings;
import org.docx4j.convert.out.html.HtmlCssHelper;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.model.styles.Tree;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.PPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.plutext.jaxb.svg11.Line;
import org.plutext.jaxb.svg11.ObjectFactory;
import org.plutext.jaxb.svg11.Svg;
import org.pptx4j.Box;
import org.pptx4j.Point;
import org.pptx4j.convert.out.svginhtml.SvgConversionContext;
import org.pptx4j.jaxb.Context;
import org.pptx4j.model.ResolvedLayout;
import org.pptx4j.model.TextStyles;
import org.pptx4j.pml.CxnSp;
import org.pptx4j.pml.GroupShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;

public class SvgExporter {
    protected static Logger log = LoggerFactory.getLogger(SvgExporter.class);
    public static JAXBContext jcSVG;
    static ObjectFactory oFactory;
    static Templates xslt;
    private static String imageDirPath;

    public static void setImageDirPath(String _imageDirPath) {
        imageDirPath = _imageDirPath;
    }

    public static String svg(PresentationMLPackage presentationMLPackage, SlidePart slide) throws Exception {
        return SvgExporter.svg(presentationMLPackage, slide, null);
    }

    public static String svg(PresentationMLPackage presentationMLPackage, SlidePart slide, SvgSettings settings) throws Exception {
        ResolvedLayout rl = slide.getResolvedLayout();
        return SvgExporter.svg(presentationMLPackage, rl, settings);
    }

    private static String svg(PresentationMLPackage presentationMLPackage, ResolvedLayout layout, SvgSettings settings) throws Exception {
        ByteArrayOutputStream intermediate = new ByteArrayOutputStream();
        StreamResult intermediateResult = new StreamResult(intermediate);
        SvgExporter.svg(presentationMLPackage, layout, intermediateResult, settings);
        return intermediate.toString("UTF-8");
    }

    private static void svg(PresentationMLPackage presentationMLPackage, ResolvedLayout layout, Result result, SvgSettings settings) throws Exception {
        SvgConversionContext context = null;
        Document doc = XmlUtils.marshaltoW3CDomDocument(layout.getShapeTree(), Context.jcPML, "http://schemas.openxmlformats.org/presentationml/2006/main", "spTree", GroupShape.class);
        if (settings == null) {
            settings = new SvgSettings();
        }
        if (settings.getImageDirPath() == null && imageDirPath != null) {
            settings.setImageDirPath(imageDirPath);
        }
        context = new SvgConversionContext(settings, presentationMLPackage, layout);
        XmlUtils.transform(doc, xslt, context.getXsltParameters(), result);
    }

    public static boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    public static DocumentFragment createBlockForP(SvgConversionContext context, String lvl, String cNvPrName, String phType, NodeIterator childResults, NodeIterator lvlNpPr) {
        StyleTree styleTree = null;
        try {
            styleTree = context.getPmlPackage().getStyleTree();
        }
        catch (InvalidFormatException e1) {
            e1.printStackTrace();
        }
        log.debug("lvl:" + lvl);
        int level = lvl.equals("NaN") ? 1 : Integer.parseInt(lvl);
        System.out.println("cNvPrName: " + cNvPrName + "; phType: " + phType);
        String pStyleVal = cNvPrName.toLowerCase().indexOf("subtitle") > -1 || phType.toLowerCase().indexOf("subtitle") > -1 ? "Lvl" + level + "Master" + context.getResolvedLayout().getMasterNumber() + "Body" : (cNvPrName.toLowerCase().indexOf("title") > -1 || phType.toLowerCase().indexOf("title") > -1 ? "Lvl" + level + "Master" + context.getResolvedLayout().getMasterNumber() + "Title" : "Lvl" + level + "Master" + context.getResolvedLayout().getMasterNumber() + "Other");
        System.out.println("--> " + pStyleVal);
        try {
            Document document = XmlUtils.getNewDocumentBuilder().newDocument();
            Element xhtmlP = document.createElement("p");
            document.appendChild(xhtmlP);
            log.debug(pStyleVal);
            Tree<StyleTree.AugmentedStyle> pTree = styleTree.getParagraphStylesTree();
            Node<StyleTree.AugmentedStyle> asn = pTree.get(pStyleVal);
            xhtmlP.setAttribute("class", StyleTree.getHtmlClassAttributeValue(pTree, asn));
            StringBuilder inlineStyle = new StringBuilder();
            CTTextParagraphProperties lvlPPr = SvgExporter.unmarshalFormatting(lvlNpPr);
            if (lvlPPr != null) {
                log.debug("We have lvlPPr");
                log.debug(XmlUtils.marshaltoString(lvlPPr, true, true, Context.jcPML, "FIXME", "lvl1pPr", CTTextParagraphProperties.class));
                PPr pPr = TextStyles.getWmlPPr(lvlPPr);
                if (pPr != null) {
                    HtmlCssHelper.createCss(context.getPmlPackage(), pPr, inlineStyle, false, false);
                }
            }
            inlineStyle.append("margin-left:3px; margin-top:3px;");
            if (!inlineStyle.toString().equals("")) {
                xhtmlP.setAttribute("style", inlineStyle.toString());
            }
            org.w3c.dom.Node n = childResults.nextNode();
            do {
                if (n.getNodeType() == 9) {
                    log.debug("handling DOCUMENT_NODE");
                    NodeList nodes = n.getChildNodes();
                    if (nodes == null) continue;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        if (nodes.item(i).getLocalName().equals("span") && !nodes.item(i).hasChildNodes()) {
                            log.debug(".. ignoring <span/> ");
                            continue;
                        }
                        XmlUtils.treeCopy(nodes.item(i), (org.w3c.dom.Node)xhtmlP);
                    }
                } else {
                    XmlUtils.treeCopy(n, (org.w3c.dom.Node)xhtmlP);
                }
            } while ((n = childResults.nextNode()) != null);
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    private static CTTextParagraphProperties unmarshalFormatting(NodeIterator lvlNpPr) {
        try {
            Object pPr = null;
            if (lvlNpPr != null) {
                org.w3c.dom.Node n = lvlNpPr.nextNode();
                log.debug(n.getClass().getName());
                String str = XmlUtils.w3CDomNodeToString(n);
                if (!str.equals("")) {
                    return (CTTextParagraphProperties)XmlUtils.unmarshalString(str, Context.jcPML, CTTextParagraphProperties.class);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static DocumentFragment createBlockForR(SvgConversionContext context, NodeIterator rPrNodeIt, NodeIterator childResults) {
        DocumentFragment docfrag = null;
        Document d = null;
        Element span = null;
        try {
            d = XmlUtils.getNewDocumentBuilder().newDocument();
            span = d.createElement("span");
            d.appendChild(span);
            CTTextCharacterProperties textCharProps = (CTTextCharacterProperties)SvgExporter.nodeToObjectModel(rPrNodeIt.nextNode(), CTTextCharacterProperties.class);
            RPr rPr = TextStyles.getWmlRPr(textCharProps);
            StringBuilder inlineStyle = new StringBuilder();
            HtmlCssHelper.createCss(context.getPmlPackage(), rPr, inlineStyle);
            if (!inlineStyle.toString().equals("")) {
                span.setAttribute("style", inlineStyle.toString());
            }
            org.w3c.dom.Node n = childResults.nextNode();
            XmlUtils.treeCopy(n, (org.w3c.dom.Node)span);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            org.w3c.dom.Node n = childResults.nextNode();
            XmlUtils.treeCopy(n, (org.w3c.dom.Node)span);
        }
        docfrag = d.createDocumentFragment();
        docfrag.appendChild(d.getDocumentElement());
        return docfrag;
    }

    public static String getCssForStyles(SvgConversionContext context) {
        StringBuilder result = new StringBuilder();
        StyleTree styleTree = null;
        try {
            styleTree = context.getPmlPackage().getStyleTree();
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        result.append("\n /* PARAGRAPH STYLES */ \n");
        Tree<StyleTree.AugmentedStyle> pTree = styleTree.getParagraphStylesTree();
        for (Node<StyleTree.AugmentedStyle> n : pTree.toList()) {
            Style s2 = n.getData().getStyle();
            result.append("." + s2.getStyleId() + " {display:block;");
            if (s2.getPPr() == null) {
                log.debug("null pPr for style " + s2.getStyleId());
            } else {
                HtmlCssHelper.createCss(context.getPmlPackage(), s2.getPPr(), result, false, false);
            }
            if (s2.getRPr() == null) {
                log.debug("null rPr for style " + s2.getStyleId());
            } else {
                HtmlCssHelper.createCss(context.getPmlPackage(), s2.getRPr(), result);
            }
            result.append("}\n");
        }
        if (log.isDebugEnabled()) {
            return result.toString();
        }
        String debug = result.toString();
        return debug;
    }

    public static DocumentFragment shapeToSVG(SvgConversionContext context, NodeIterator shapeIt) {
        DocumentFragment docfrag = null;
        Document d = null;
        try {
            Object shape = null;
            if (shapeIt != null) {
                org.w3c.dom.Node n = shapeIt.nextNode();
                if (n == null) {
                    d = SvgExporter.makeErr("[null node?!]");
                } else {
                    log.debug("Handling " + n.getNodeName());
                    if (n.getNodeName().equals("p:cxnSp")) {
                        shape = SvgExporter.nodeToObjectModel(n, CxnSp.class);
                        d = SvgExporter.CxnSpToSVG((CxnSp)shape);
                    } else {
                        log.info("** TODO " + n.getNodeName());
                        d = SvgExporter.makeErr("[" + n.getNodeName() + "]");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            d = SvgExporter.makeErr(e.getMessage());
        }
        docfrag = d.createDocumentFragment();
        docfrag.appendChild(d.getDocumentElement());
        return docfrag;
    }

    public static Document CxnSpToSVG(CxnSp cxnSp) {
        CTTransform2D xfrm = cxnSp.getSpPr().getXfrm();
        Box b = new Box(xfrm.getOff().getX(), xfrm.getOff().getY(), xfrm.getExt().getCx(), xfrm.getExt().getCy());
        if (xfrm.getRot() != 0) {
            b.rotate(xfrm.getRot());
        }
        if (xfrm.isFlipH()) {
            b.flipH();
        }
        if (xfrm.isFlipV()) {
            b.flipV();
        }
        b.toPixels();
        Document document = XmlUtils.getNewDocumentBuilder().newDocument();
        Element xhtmlDiv = document.createElement("div");
        xhtmlDiv.setAttribute("style", "position: absolute; width:100%; height:100%; left:0px; top:0px;");
        org.w3c.dom.Node n = document.appendChild(xhtmlDiv);
        Svg svg = oFactory.createSvg();
        Line line = oFactory.createLine();
        svg.getSVGDescriptionClassOrSVGAnimationClassOrSVGStructureClass().add(line);
        line.setX1(b.getOffset().getXAsString());
        line.setY1(b.getOffset().getYAsString());
        Point otherEnd = b.getOtherCorner();
        line.setX2(otherEnd.getXAsString());
        line.setY2(otherEnd.getYAsString());
        line.setStyle("stroke:rgb(99,99,99)");
        Document d2 = XmlUtils.marshaltoW3CDomDocument(svg, jcSVG);
        XmlUtils.treeCopy(d2, n);
        return document;
    }

    private static Document makeErr(String msg) {
        Document d = XmlUtils.getNewDocumentBuilder().newDocument();
        Element span = d.createElement("span");
        span.setAttribute("style", "color:red;");
        d.appendChild(span);
        Text err = d.createTextNode(msg);
        span.appendChild(err);
        return d;
    }

    public static Object nodeToObjectModel(org.w3c.dom.Node n, Class declaredType) throws Docx4JException {
        if (n == null) {
            throw new Docx4JException("null input");
        }
        Object jaxb = null;
        try {
            jaxb = XmlUtils.unmarshal(n, Context.jcPML, declaredType);
        }
        catch (JAXBException e1) {
            throw new Docx4JException("Couldn't unmarshall " + XmlUtils.w3CDomNodeToString(n), (Exception)((Object)e1));
        }
        try {
            if (jaxb instanceof JAXBElement) {
                JAXBElement jb = (JAXBElement)jaxb;
                if (jb.getDeclaredType().getName().equals(declaredType.getName())) {
                    return jb.getValue();
                }
                log.error("UNEXPECTED " + XmlUtils.JAXBElementDebug(jb));
                throw new Docx4JException("Expected " + declaredType.getName() + " but got " + XmlUtils.JAXBElementDebug(jb));
            }
            if (jaxb.getClass().getName().equals(declaredType.getName())) {
                return jaxb;
            }
            log.error(jaxb.getClass().getName());
            throw new Docx4JException("Expected " + declaredType.getName() + " but got " + jaxb.getClass().getName());
        }
        catch (ClassCastException e) {
            throw new Docx4JException("Expected " + declaredType.getName() + " but got " + jaxb.getClass().getName(), e);
        }
    }

    static {
        try {
            jcSVG = JAXBContext.newInstance((String)"org.plutext.jaxb.svg11");
            oFactory = new ObjectFactory();
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/pptx4j/convert/out/svginhtml/pptx2svginhtml.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SvgSettings
    extends AbstractConversionSettings {
        public static final String IMAGE_TARGET_URI = "imageTargetUri";

        public void setImageTargetUri(String imageTargetUri) {
            this.settings.put(IMAGE_TARGET_URI, imageTargetUri);
        }

        public String getImageTargetUri() {
            return (String)this.settings.get(IMAGE_TARGET_URI);
        }
    }
}

