/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.events.Event;
import org.apache.fop.util.XMLResourceBundle;
import org.apache.fop.util.text.AdvancedMessageFormat;

public final class EventFormatter {
    private static final Pattern INCLUDES_PATTERN = Pattern.compile("\\{\\{.+\\}\\}");
    private static Log log = LogFactory.getLog(EventFormatter.class);

    private EventFormatter() {
    }

    private static ResourceBundle getBundle(String groupID, Locale locale) {
        ResourceBundle bundle;
        String baseName = groupID != null ? groupID : EventFormatter.class.getName();
        try {
            ClassLoader classLoader = EventFormatter.class.getClassLoader();
            bundle = XMLResourceBundle.getXMLBundle(baseName, locale, classLoader);
        }
        catch (MissingResourceException e) {
            if (log.isTraceEnabled()) {
                log.trace("No XMLResourceBundle for " + baseName + " available.");
            }
            bundle = null;
        }
        return bundle;
    }

    public static String format(Event event) {
        return EventFormatter.format(event, event.getLocale());
    }

    public static String format(Event event, Locale locale) {
        return EventFormatter.format(event, EventFormatter.getBundle(event.getEventGroupID(), locale));
    }

    private static String format(Event event, ResourceBundle bundle) {
        assert (event != null);
        String key = event.getEventKey();
        String template = bundle != null ? bundle.getString(key) : "Missing bundle. Can't lookup event key: '" + key + "'.";
        return EventFormatter.format(event, EventFormatter.processIncludes(template, bundle));
    }

    private static String processIncludes(String template, ResourceBundle bundle) {
        StringBuffer sb;
        int replacements;
        CharSequence input = template;
        do {
            sb = new StringBuffer(Math.max(16, input.length()));
            replacements = EventFormatter.processIncludesInner(input, sb, bundle);
            input = sb;
        } while (replacements > 0);
        String s2 = sb.toString();
        return s2;
    }

    private static int processIncludesInner(CharSequence template, StringBuffer sb, ResourceBundle bundle) {
        int replacements = 0;
        if (bundle != null) {
            Matcher m3 = INCLUDES_PATTERN.matcher(template);
            while (m3.find()) {
                String include = m3.group();
                include = include.substring(2, include.length() - 2);
                m3.appendReplacement(sb, bundle.getString(include));
                ++replacements;
            }
            m3.appendTail(sb);
        }
        return replacements;
    }

    public static String format(Event event, String pattern) {
        AdvancedMessageFormat format = new AdvancedMessageFormat(pattern);
        HashMap<String, Object> params = new HashMap<String, Object>(event.getParams());
        params.put("source", event.getSource());
        params.put("severity", event.getSeverity());
        params.put("groupID", event.getEventGroupID());
        params.put("locale", event.getLocale());
        return format.format(params);
    }

    public static class LookupFieldPartFactory
    implements AdvancedMessageFormat.PartFactory {
        @Override
        public AdvancedMessageFormat.Part newPart(String fieldName, String values) {
            return new LookupFieldPart(fieldName);
        }

        @Override
        public String getFormat() {
            return "lookup";
        }
    }

    private static class LookupFieldPart
    implements AdvancedMessageFormat.Part {
        private String fieldName;

        public LookupFieldPart(String fieldName) {
            this.fieldName = fieldName;
        }

        public boolean isGenerated(Map params) {
            return this.getKey(params) != null;
        }

        public void write(StringBuffer sb, Map params) {
            Locale locale;
            String groupID = (String)params.get("groupID");
            ResourceBundle bundle = EventFormatter.getBundle(groupID, locale = (Locale)params.get("locale"));
            if (bundle != null) {
                sb.append(bundle.getString(this.getKey(params)));
            }
        }

        private String getKey(Map params) {
            return (String)params.get(this.fieldName);
        }

        public String toString() {
            return "{" + this.fieldName + ", lookup}";
        }
    }
}

