/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.type1;

import java.awt.geom.Dimension2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlgraphics.java2d.Dimension2DDouble;
import org.docx4j.fonts.fop.fonts.NamedCharacter;
import org.docx4j.fonts.fop.fonts.SingleByteEncoding;
import org.docx4j.fonts.fop.fonts.type1.AFMCharMetrics;
import org.docx4j.fonts.fop.fonts.type1.AFMWritingDirectionMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AFMFile {
    private static final Logger log = LoggerFactory.getLogger(AFMFile.class);
    private String fontName;
    private String fullName;
    private String familyName;
    private String weight;
    private RectangularShape fontBBox;
    private String encodingScheme;
    private String characterSet;
    private Number capHeight;
    private Number xHeight;
    private Number ascender;
    private Number descender;
    private Number stdHW;
    private Number stdVW;
    private AFMWritingDirectionMetrics[] writingDirectionMetrics = new AFMWritingDirectionMetrics[3];
    private List<AFMCharMetrics> charMetrics = new ArrayList<AFMCharMetrics>();
    private Map<String, AFMCharMetrics> charNameToMetrics = new HashMap<String, AFMCharMetrics>();
    private int firstChar = -1;
    private int lastChar = -1;
    private Map<String, Map<String, Dimension2D>> kerningMap;

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public RectangularShape getFontBBox() {
        return this.fontBBox;
    }

    public int[] getFontBBoxAsIntArray() {
        RectangularShape rect = this.getFontBBox();
        return new int[]{(int)Math.floor(rect.getMinX()), (int)Math.floor(rect.getMinY()), (int)Math.ceil(rect.getMaxX()), (int)Math.ceil(rect.getMaxY())};
    }

    public void setFontBBox(RectangularShape fontBBox) {
        this.fontBBox = fontBBox;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public Number getCapHeight() {
        return this.capHeight;
    }

    public void setCapHeight(Number capHeight) {
        this.capHeight = capHeight;
    }

    public Number getXHeight() {
        return this.xHeight;
    }

    public void setXHeight(Number height) {
        this.xHeight = height;
    }

    public Number getAscender() {
        return this.ascender;
    }

    public void setAscender(Number ascender) {
        this.ascender = ascender;
    }

    public Number getDescender() {
        return this.descender;
    }

    public void setDescender(Number descender) {
        this.descender = descender;
    }

    public Number getStdHW() {
        return this.stdHW;
    }

    public void setStdHW(Number stdHW) {
        this.stdHW = stdHW;
    }

    public Number getStdVW() {
        return this.stdVW;
    }

    public void setStdVW(Number stdVW) {
        this.stdVW = stdVW;
    }

    public AFMWritingDirectionMetrics getWritingDirectionMetrics(int index) {
        return this.writingDirectionMetrics[index];
    }

    public void setWritingDirectionMetrics(int index, AFMWritingDirectionMetrics metrics) {
        this.writingDirectionMetrics[index] = metrics;
    }

    public void addCharMetrics(AFMCharMetrics metrics) {
        int idx;
        String name = metrics.getCharName();
        if (metrics.getUnicodeSequence() == null && name.equals(".notdef")) {
            return;
        }
        this.charMetrics.add(metrics);
        if (name != null) {
            this.charNameToMetrics.put(name, metrics);
        }
        if ((idx = metrics.getCharCode()) >= 0) {
            if (this.firstChar < 0 || idx < this.firstChar) {
                this.firstChar = idx;
            }
            if (this.lastChar < 0 || idx > this.lastChar) {
                this.lastChar = idx;
            }
        }
    }

    public int getCharCount() {
        return this.charMetrics.size();
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public AFMCharMetrics getChar(String name) {
        return this.charNameToMetrics.get(name);
    }

    public List<AFMCharMetrics> getCharMetrics() {
        return Collections.unmodifiableList(this.charMetrics);
    }

    public void addXKerning(String name1, String name2, double kx) {
        Map<String, Dimension2D> entries;
        if (this.kerningMap == null) {
            this.kerningMap = new HashMap<String, Map<String, Dimension2D>>();
        }
        if ((entries = this.kerningMap.get(name1)) == null) {
            entries = new HashMap<String, Dimension2D>();
            this.kerningMap.put(name1, entries);
        }
        entries.put(name2, new Dimension2DDouble(kx, 0.0));
    }

    public boolean hasKerning() {
        return this.kerningMap != null;
    }

    public Map<Integer, Map<Integer, Integer>> createXKerningMapEncoded() {
        if (!this.hasKerning()) {
            return null;
        }
        HashMap<Integer, Map<Integer, Integer>> m3 = new HashMap<Integer, Map<Integer, Integer>>();
        for (Map.Entry<String, Map<String, Dimension2D>> entryFrom : this.kerningMap.entrySet()) {
            String name1 = entryFrom.getKey();
            AFMCharMetrics chm1 = this.getChar(name1);
            if (chm1 == null || !chm1.hasCharCode()) continue;
            HashMap<Integer, Integer> container = null;
            Map<String, Dimension2D> entriesTo = entryFrom.getValue();
            for (Map.Entry<String, Dimension2D> entryTo : entriesTo.entrySet()) {
                Integer k1;
                String name2 = entryTo.getKey();
                AFMCharMetrics chm2 = this.getChar(name2);
                if (chm2 == null || !chm2.hasCharCode()) continue;
                if (container == null && (container = (HashMap<Integer, Integer>)m3.get(k1 = Integer.valueOf(chm1.getCharCode()))) == null) {
                    container = new HashMap<Integer, Integer>();
                    m3.put(k1, container);
                }
                Dimension2D dim = entryTo.getValue();
                container.put(chm2.getCharCode(), (int)Math.round(dim.getWidth()));
            }
        }
        return m3;
    }

    public void overridePrimaryEncoding(SingleByteEncoding encoding) {
        if (log.isDebugEnabled()) {
            log.debug("Overriding primary encoding of " + this.getFontName() + " with: " + encoding);
        }
        AFMCharMetrics[] mapped = new AFMCharMetrics[256];
        for (AFMCharMetrics cm : this.charMetrics) {
            NamedCharacter nc = cm.getCharacter();
            if (nc.hasSingleUnicodeValue()) {
                char codePoint = encoding.mapChar(nc.getSingleUnicodeValue());
                if (codePoint > '\u0000') {
                    if (mapped[codePoint] != null) {
                        if (!log.isDebugEnabled()) continue;
                        AFMCharMetrics other = mapped[codePoint];
                        String msg = "Not mapping character " + nc + " to code point " + codePoint + " (" + Integer.toHexString(codePoint) + ") in " + encoding + ". " + other + " has already been assigned that code point.";
                        msg = other.getUnicodeSequence().equals(nc.getUnicodeSequence()) ? msg + " This is a specialized glyph for the same Unicode character." : msg + " This is a similar character.";
                        if (cm.getWidthX() != other.getWidthX()) {
                            msg = msg + " They have differing widths: " + cm.getWidthX() + " vs. " + other.getWidthX();
                        }
                        log.debug(msg);
                        continue;
                    }
                    cm.setCharCode(codePoint);
                    mapped[codePoint] = cm;
                    continue;
                }
                cm.setCharCode(-1);
                continue;
            }
            cm.setCharCode(-1);
        }
    }

    public String toString() {
        return "AFM: " + this.getFullName();
    }
}

