/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage.migration;

import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import org.docx4j.customXmlProperties.DatastoreItem;
import org.docx4j.customXmlProperties.ObjectFactory;
import org.docx4j.customXmlProperties.SchemaRefs;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.opendope.ConditionsPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.wml.CTDataBinding;
import org.docx4j.wml.CTSdtContentRun;
import org.docx4j.wml.CTSdtText;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.SdtRun;
import org.docx4j.wml.Tag;
import org.docx4j.wml.Text;
import org.opendope.conditions.Conditions;
import org.opendope.xpaths.Xpaths;

public class AbstractMigrator {
    protected XPathsPart xPathsPart;
    protected ConditionsPart conditionsPart;
    protected String storeItemID;

    protected void createParts(WordprocessingMLPackage pkgOut) throws InvalidFormatException {
        this.createConditionsPart(pkgOut, new Conditions());
        this.createXPathsPart(pkgOut, new Xpaths());
    }

    protected ConditionsPart createConditionsPart(WordprocessingMLPackage pkgOut, Conditions conditions) throws InvalidFormatException {
        this.conditionsPart = new ConditionsPart(new PartName("/customXml/item1.xml"));
        pkgOut.getMainDocumentPart().addTargetPart((Part)this.conditionsPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        this.addPropertiesPart(pkgOut, this.conditionsPart, "http://opendope.org/conditions");
        this.conditionsPart.setJaxbElement(conditions);
        return this.conditionsPart;
    }

    protected XPathsPart createXPathsPart(WordprocessingMLPackage pkgOut, Xpaths xpaths) throws InvalidFormatException {
        this.xPathsPart = new XPathsPart(new PartName("/customXml/item1.xml"));
        pkgOut.getMainDocumentPart().addTargetPart((Part)this.xPathsPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        this.addPropertiesPart(pkgOut, this.xPathsPart, "http://opendope.org/xpaths");
        this.xPathsPart.setJaxbElement(xpaths);
        return this.xPathsPart;
    }

    protected String addPropertiesPart(WordprocessingMLPackage pkgOut, Part customXmlDataStoragePart, String ns) throws InvalidFormatException {
        CustomXmlDataStoragePropertiesPart part = new CustomXmlDataStoragePropertiesPart();
        ObjectFactory of = new ObjectFactory();
        DatastoreItem dsi = of.createDatastoreItem();
        String newItemId = "{" + UUID.randomUUID().toString().toUpperCase() + "}";
        dsi.setItemID(newItemId);
        if (ns != null) {
            SchemaRefs srefs = of.createSchemaRefs();
            dsi.setSchemaRefs(srefs);
            SchemaRefs.SchemaRef sref = of.createSchemaRefsSchemaRef();
            sref.setUri(ns);
            srefs.getSchemaRef().add(sref);
        }
        part.setJaxbElement(dsi);
        customXmlDataStoragePart.addTargetPart((Part)part, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        pkgOut.getCustomXmlDataStorageParts().put(newItemId.toLowerCase(), (CustomXmlPart)((Object)customXmlDataStoragePart));
        return newItemId;
    }

    protected void createContentControl(RPr rPr, List<Object> replacementContent, String key, String xpath, String prefixmappings) {
        SdtRun sdtRun = this.createSdtRun(rPr, key, xpath, prefixmappings);
        replacementContent.add(sdtRun);
    }

    protected SdtRun createSdtRun(RPr rPr, String key, String xpath, String prefixmappings) {
        SdtRun sdtRun = Context.getWmlObjectFactory().createSdtRun();
        SdtPr sdtPr = AbstractMigrator.createSdtPr(key, xpath, prefixmappings, this.storeItemID, false);
        sdtRun.setSdtPr(sdtPr);
        CTSdtText sdtText = Context.getWmlObjectFactory().createCTSdtText();
        sdtText.setMultiLine(true);
        sdtPr.getRPrOrAliasOrLock().add(Context.getWmlObjectFactory().createSdtPrText(sdtText));
        CTSdtContentRun sdtContent = Context.getWmlObjectFactory().createCTSdtContentRun();
        sdtRun.setSdtContent(sdtContent);
        R rnew = new R();
        rnew.setRPr(rPr);
        Text text = Context.getWmlObjectFactory().createText();
        text.setValue(key);
        rnew.getContent().add(text);
        sdtContent.getContent().add(rnew);
        return sdtRun;
    }

    protected static SdtPr createSdtPr(String key, String xpath, String prefixmappings, String storeItemID, boolean isRepeat) {
        SdtPr sdtPr = Context.getWmlObjectFactory().createSdtPr();
        SdtPr.Alias alias = Context.getWmlObjectFactory().createSdtPrAlias();
        alias.setVal(key);
        sdtPr.getRPrOrAliasOrLock().add(alias);
        Tag tag = Context.getWmlObjectFactory().createTag();
        if (isRepeat) {
            tag.setVal("od:repeat=" + key);
        } else {
            tag.setVal("od:xpath=" + key);
        }
        sdtPr.setTag(tag);
        sdtPr.setId();
        if (isRepeat) {
            sdtPr.getRPrOrAliasOrLock().add(new SdtPr.RichText());
        } else {
            CTDataBinding ctDataBinding = Context.getWmlObjectFactory().createCTDataBinding();
            JAXBElement<CTDataBinding> jaxbDB = Context.getWmlObjectFactory().createSdtPrDataBinding(ctDataBinding);
            sdtPr.setDataBinding(ctDataBinding);
            ctDataBinding.setXpath(xpath);
            ctDataBinding.setPrefixMappings(prefixmappings);
            ctDataBinding.setStoreItemID(storeItemID);
        }
        return sdtPr;
    }
}

