/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.documents4j.local;

import com.documents4j.api.DocumentType;
import com.documents4j.api.IConverter;
import com.documents4j.job.LocalConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.docx4j.Docx4J;
import org.docx4j.Docx4jProperties;
import org.docx4j.convert.out.Documents4jConversionSettings;
import org.docx4j.convert.out.common.Exporter;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Documents4jLocalServices
implements Exporter<Documents4jConversionSettings> {
    private static Logger log = LoggerFactory.getLogger(Documents4jLocalServices.class);
    protected static Documents4jLocalServices instance = null;
    private IConverter converter;
    private static final String TEMP_DIR_DEFAULT = "temp_documents4j_local";
    private static File tmpDir = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Exporter<Documents4jConversionSettings> getInstance() {
        if (instance != null) return instance;
        Class<Documents4jLocalServices> clazz = Documents4jLocalServices.class;
        synchronized (Documents4jLocalServices.class) {
            if (instance != null) return instance;
            instance = new Documents4jLocalServices();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Documents4jLocalServices() {
        this.setWordConversionScript();
        this.converter = ((LocalConverter.Builder)((LocalConverter.Builder)LocalConverter.builder().baseFolder(tmpDir)).workerPool(20, 25, 2L, TimeUnit.SECONDS)).processTimeout(30L, TimeUnit.SECONDS).build();
    }

    public Documents4jLocalServices(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, long timeout) {
        this.setWordConversionScript();
        this.converter = ((LocalConverter.Builder)((LocalConverter.Builder)LocalConverter.builder().baseFolder(tmpDir)).workerPool(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS)).processTimeout(30L, TimeUnit.SECONDS).build();
    }

    private void setWordConversionScript() {
        String script = System.getProperty("com.documents4j.conversion.msoffice.word_convert.vbs");
        if (script == null) {
            script = Docx4jProperties.getProperty((String)"com.documents4j.conversion.msoffice.word_convert.vbs");
            if (script == null) {
                log.info("documents4j: using default Word conversion script");
            } else {
                log.info("documents4j: using script: " + script + " from docx4j.properties");
                System.setProperty("com.documents4j.conversion.msoffice.word_convert.vbs", script);
            }
        } else {
            log.info("documents4j: using script: " + script);
            System.setProperty("com.documents4j.conversion.msoffice.word_convert.vbs", script);
        }
    }

    public void export(Documents4jConversionSettings conversionSettings, OutputStream outputStream) throws Docx4JException {
        OpcPackage pkg = conversionSettings.getOpcPackage();
        this.export(pkg, outputStream);
    }

    public void export(OpcPackage pkg, OutputStream outputStream) throws Docx4JException {
        this.export(pkg, outputStream, DocumentType.PDF);
    }

    public void export(OpcPackage pkg, OutputStream outputStream, DocumentType asDocumentType) throws Docx4JException {
        File file = null;
        if (pkg instanceof WordprocessingMLPackage) {
            try {
                file = File.createTempFile("docx_", ".docx", tmpDir);
            }
            catch (IOException e) {
                throw new Docx4JException(e.getMessage(), (Exception)e);
            }
            Docx4J.save((OpcPackage)((WordprocessingMLPackage)pkg), (File)file);
            this.export(file, outputStream, DocumentType.MS_WORD, asDocumentType);
        } else if (pkg instanceof SpreadsheetMLPackage) {
            try {
                file = File.createTempFile("xlsx_", ".xlsx", tmpDir);
            }
            catch (IOException e) {
                throw new Docx4JException(e.getMessage(), (Exception)e);
            }
            Docx4J.save((OpcPackage)((WordprocessingMLPackage)pkg), (File)file);
            this.export(file, outputStream, DocumentType.MS_EXCEL, asDocumentType);
        } else if (pkg instanceof PresentationMLPackage) {
            throw new Docx4JException("pptx export is not available via documents4j");
        }
    }

    public void export(File officeFile, OutputStream target, DocumentType documentType) throws Docx4JException {
        this.export(officeFile, target, documentType, DocumentType.PDF);
    }

    public void export(File officeFile, OutputStream target, DocumentType documentType, DocumentType asDocumentType) throws Docx4JException {
        this.converter.convert(officeFile).as(documentType).to(target).as(asDocumentType).execute();
    }

    public void updateDocx(WordprocessingMLPackage pkg, OutputStream outputStream) throws Docx4JException {
        File file = null;
        try {
            file = File.createTempFile("docx_", ".docx", tmpDir);
        }
        catch (IOException e) {
            throw new Docx4JException(e.getMessage(), (Exception)e);
        }
        Docx4J.save((OpcPackage)pkg, (File)file);
        this.updateDocx(file, outputStream);
    }

    public WordprocessingMLPackage updateDocx(WordprocessingMLPackage pkg) throws Docx4JException {
        File file = null;
        try {
            file = File.createTempFile("docx_", ".docx", tmpDir);
        }
        catch (IOException e) {
            throw new Docx4JException(e.getMessage(), (Exception)e);
        }
        Docx4J.save((OpcPackage)pkg, (File)file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.updateDocx(file, (OutputStream)baos);
        return Docx4J.load((InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }

    public void updateDocx(File officeFile, OutputStream target) throws Docx4JException {
        this.export(officeFile, target, DocumentType.MS_WORD, DocumentType.DOCX);
    }

    public void importAsDocx(File officeFile, OutputStream target) throws Docx4JException {
        this.export(officeFile, target, DocumentType.MS_WORD, DocumentType.DOCX);
    }

    public WordprocessingMLPackage importAsDocx(File officeFile) throws Docx4JException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.importAsDocx(officeFile, baos);
        return Docx4J.load((InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }

    private static File getUserHome() {
        File userDir;
        String s = System.getProperty("user.home");
        if (s != null && (userDir = new File(s)).exists()) {
            return userDir;
        }
        return null;
    }

    static {
        String tmpDirPath = Docx4jProperties.getProperty((String)"docx4j.convert.out.documents4j.local.tmpDir");
        if (tmpDirPath == null) {
            File userHome = Documents4jLocalServices.getUserHome();
            if (userHome == null) {
                log.warn("No home dir found; consider setting property 'docx4j.convert.out.documents4j.local.tmpDir'");
            } else {
                tmpDir = new File(userHome, TEMP_DIR_DEFAULT);
                tmpDir.mkdir();
            }
        } else {
            tmpDir = new File(tmpDirPath);
            if (!tmpDir.exists()) {
                log.info(tmpDirPath + " does not exist. Attempting to create..");
                tmpDir.mkdir();
            } else if (!tmpDir.isDirectory()) {
                log.info(tmpDirPath + " exists, but is not a directory!");
            }
        }
    }
}

