/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.documents4j.remote;

import com.documents4j.api.DocumentType;
import com.documents4j.api.IConverter;
import com.documents4j.job.RemoteConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.docx4j.Docx4J;
import org.docx4j.Docx4jProperties;
import org.docx4j.convert.out.Documents4jConversionSettings;
import org.docx4j.convert.out.common.Exporter;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.Docx4JRuntimeException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Documents4jRemoteServices
implements Exporter<Documents4jConversionSettings> {
    private static Logger log = LoggerFactory.getLogger(Documents4jRemoteServices.class);
    protected static Documents4jRemoteServices instance = null;
    private IConverter converter;
    private static final String TEMP_DIR_DEFAULT = "temp_documents4j_remote";
    private static File tmpDir = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Exporter<Documents4jConversionSettings> getInstance() {
        if (instance != null) return instance;
        Class<Documents4jRemoteServices> clazz = Documents4jRemoteServices.class;
        synchronized (Documents4jRemoteServices.class) {
            if (instance != null) return instance;
            instance = new Documents4jRemoteServices();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Documents4jRemoteServices() {
        this.converter = ((RemoteConverter.Builder)((RemoteConverter.Builder)RemoteConverter.builder().baseFolder(tmpDir)).workerPool(20, 25, 2L, TimeUnit.SECONDS)).requestTimeout(10L, TimeUnit.SECONDS).baseUri(this.getConverterUri()).build();
    }

    public Documents4jRemoteServices(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, long timeout) {
        this.converter = ((RemoteConverter.Builder)((RemoteConverter.Builder)RemoteConverter.builder().baseFolder(tmpDir)).workerPool(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS)).requestTimeout(timeout, TimeUnit.MILLISECONDS).baseUri(this.getConverterUri()).build();
    }

    public void export(Documents4jConversionSettings conversionSettings, OutputStream outputStream) throws Docx4JException {
        OpcPackage pkg = conversionSettings.getOpcPackage();
        this.export(pkg, outputStream);
    }

    public void export(OpcPackage pkg, OutputStream outputStream) throws Docx4JException {
        this.export(pkg, outputStream, DocumentType.PDF);
    }

    public void export(OpcPackage pkg, OutputStream outputStream, DocumentType asDocumentType) throws Docx4JException {
        if (pkg instanceof WordprocessingMLPackage) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Docx4J.save((OpcPackage)((WordprocessingMLPackage)pkg), (OutputStream)baos);
            try {
                this.export(this.outputStreamToInputStream(baos), outputStream, DocumentType.MS_WORD, asDocumentType);
            }
            catch (IOException e) {
                throw new Docx4JException(e.getMessage(), (Exception)e);
            }
        }
        if (pkg instanceof SpreadsheetMLPackage) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            pkg.save((OutputStream)baos);
            try {
                this.export(this.outputStreamToInputStream(baos), outputStream, DocumentType.MS_EXCEL, asDocumentType);
            }
            catch (IOException e) {
                throw new Docx4JException(e.getMessage(), (Exception)e);
            }
        }
        if (pkg instanceof PresentationMLPackage) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            pkg.save((OutputStream)baos);
            try {
                this.export(this.outputStreamToInputStream(baos), outputStream, DocumentType.MS_POWERPOINT, asDocumentType);
            }
            catch (IOException e) {
                throw new Docx4JException(e.getMessage(), (Exception)e);
            }
        }
    }

    private PipedInputStream outputStreamToInputStream(final ByteArrayOutputStream baos) throws IOException {
        PipedInputStream in = new PipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(in);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    baos.writeTo(out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
        }).start();
        return in;
    }

    private void export(InputStream src, OutputStream target, DocumentType documentType, DocumentType asDocumentType) throws Docx4JException {
        this.converter.convert(src).as(documentType).to(target).as(asDocumentType).execute();
    }

    public void export(File officeFile, OutputStream target, DocumentType documentType) throws Docx4JException {
        this.export(officeFile, target, documentType, DocumentType.PDF);
    }

    public void export(File officeFile, OutputStream target, DocumentType documentType, DocumentType asDocumentType) throws Docx4JException {
        this.converter.convert(officeFile).as(documentType).to(target).as(asDocumentType).execute();
    }

    public void updateDocx(WordprocessingMLPackage pkg, OutputStream outputStream) throws Docx4JException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Docx4J.save((OpcPackage)pkg, (OutputStream)baos);
        try {
            this.export(this.outputStreamToInputStream(baos), outputStream, DocumentType.MS_WORD, DocumentType.DOCX);
        }
        catch (IOException e) {
            throw new Docx4JException(e.getMessage(), (Exception)e);
        }
    }

    public WordprocessingMLPackage updateDocx(WordprocessingMLPackage pkg) throws Docx4JException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.updateDocx(pkg, (OutputStream)baos);
        return Docx4J.load((InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }

    public void updateDocx(File officeFile, OutputStream target) throws Docx4JException {
        this.export(officeFile, target, DocumentType.MS_WORD, DocumentType.DOCX);
    }

    public void importAsDocx(File officeFile, OutputStream target) throws Docx4JException {
        this.export(officeFile, target, DocumentType.MS_WORD, DocumentType.DOCX);
    }

    public WordprocessingMLPackage importAsDocx(File officeFile) throws Docx4JException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.importAsDocx(officeFile, baos);
        return Docx4J.load((InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }

    private String getConverterUri() {
        String converterUri = Docx4jProperties.getProperty((String)"docx4j.convert.out.documents4j.remote.Uri");
        if (converterUri == null) {
            throw new Docx4JRuntimeException("Converter URI not specified; set property 'docx4j.convert.out.documents4j.remote.Uri'");
        }
        return converterUri;
    }

    private static File getUserHome() {
        File userDir;
        String s = System.getProperty("user.home");
        if (s != null && (userDir = new File(s)).exists()) {
            return userDir;
        }
        return null;
    }

    static {
        String tmpDirPath = Docx4jProperties.getProperty((String)"docx4j.convert.out.documents4j.remote.tmpDir");
        if (tmpDirPath == null) {
            File userHome = Documents4jRemoteServices.getUserHome();
            if (userHome == null) {
                log.warn("No home dir found; consider setting property 'docx4j.convert.out.documents4j.remote.tmpDir'");
            } else {
                tmpDir = new File(userHome, TEMP_DIR_DEFAULT);
                tmpDir.mkdir();
            }
        } else {
            tmpDir = new File(tmpDirPath);
            if (!tmpDir.exists()) {
                log.info(tmpDirPath + " does not exist. Attempting to create..");
                tmpDir.mkdir();
            } else if (!tmpDir.isDirectory()) {
                log.info(tmpDirPath + " exists, but is not a directory!");
            }
        }
    }
}

