/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.anon;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTBlip;
import org.docx4j.dml.CTGvmlGroupShape;
import org.docx4j.dml.CTGvmlPicture;
import org.docx4j.dml.CTHyperlink;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.GraphicData;
import org.docx4j.dml.diagram.CTDataModel;
import org.docx4j.dml.diagram2008.CTDrawing;
import org.docx4j.dml.picture.Pic;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.math.CTOMathPara;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageBmpPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageGifPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageJpegPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImagePngPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageTiffPart;
import org.docx4j.vml.CTImageData;
import org.docx4j.vml.CTShape;
import org.docx4j.vml.CTShapetype;
import org.docx4j.vml.CTTextbox;
import org.docx4j.wml.CTObject;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.Pict;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmlVmlAnalyzer
extends TraversalUtil.CallbackImpl {
    private static Logger log = LoggerFactory.getLogger(DmlVmlAnalyzer.class);
    private JaxbXmlPart sourcePart;
    HashSet<Object> unsafeObjects = null;
    HashSet<Object> inventoryObjects = null;
    HashSet<String> fieldsPresent = null;
    boolean containsVML;

    public void setPart(JaxbXmlPart p) {
        this.sourcePart = p;
    }

    public void reinit() {
        this.unsafeObjects = new HashSet();
        this.inventoryObjects = new HashSet();
        this.containsVML = false;
        this.fieldsPresent = new HashSet();
    }

    public boolean shouldTraverse(Object o) {
        if (o instanceof CTOMathPara) {
            this.unsafeObjects.add(o);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Object> apply(Object o2) {
        Object o;
        if (o2 instanceof JAXBElement && ((JAXBElement)o2).getName().getLocalPart().equals("instrText")) {
            Text instr = (Text)XmlUtils.unwrap((Object)o2);
            this.fieldsPresent.add(instr.getValue());
            System.out.println(instr.getValue());
        }
        if ((o = XmlUtils.unwrap((Object)o2)) instanceof CTImageData) {
            ((CTImageData)o).setTitle("foo");
            if (((CTImageData)o).getRelid() == null) return null;
            String rId = ((CTImageData)o).getRelid();
            Part embeddedPart = this.sourcePart.getRelationshipsPart().getPart(rId);
            if (!(embeddedPart instanceof ImagePngPart) && !(embeddedPart instanceof ImageGifPart) && !(embeddedPart instanceof ImageJpegPart) && !(embeddedPart instanceof ImageBmpPart) && !(embeddedPart instanceof ImageTiffPart)) return null;
        }
        if (!(o instanceof CTOMathPara)) return null;
        this.unsafeObjects.add(o.getClass().getName());
        return null;
    }

    public List<Object> getChildren(Object o2) {
        CTNonVisualDrawingProps drawingProps;
        ArrayList<Object> artificialList;
        if (o2 == null) {
            log.warn("null passed to getChildrenImpl");
            return null;
        }
        Object o = XmlUtils.unwrap((Object)o2);
        log.debug("getting children of " + o.getClass().getName());
        if (o instanceof Text) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof ContentAccessor) {
            return ((ContentAccessor)o).getContent();
        }
        if (o instanceof SdtElement) {
            return ((SdtElement)o).getSdtContent().getContent();
        }
        if (o instanceof Anchor) {
            log.debug(this.sourcePart.getPartName().getName() + "\n" + XmlUtils.marshaltoString((Object)o, (boolean)true, (boolean)true, (JAXBContext)Context.jc, (String)"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", (String)"anchor", o.getClass()));
            Anchor anchor = (Anchor)o;
            artificialList = new ArrayList();
            drawingProps = anchor.getDocPr();
            if (drawingProps != null) {
                this.handleCTNonVisualDrawingProps(drawingProps, artificialList);
            }
            if (anchor.getGraphic() == null) {
                log.warn("TODO: Handle case of no a:graphic: " + XmlUtils.marshaltoString((Object)o, (boolean)true, (boolean)true, (JAXBContext)Context.jc, (String)"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", (String)"anchor", o.getClass()));
            } else {
                log.debug("found a:graphic");
                Graphic graphic = anchor.getGraphic();
                if (graphic.getGraphicData() == null) {
                    log.warn("TODO: Handle case of no a:graphicData: " + XmlUtils.marshaltoString((Object)o, (boolean)true, (boolean)true, (JAXBContext)Context.jc, (String)"foo", (String)"Inline", o.getClass()));
                } else {
                    List<Object> l = this.handleGraphicData(graphic.getGraphicData());
                    if (l != null) {
                        artificialList.addAll(l);
                    }
                }
            }
            if (!artificialList.isEmpty()) {
                return artificialList;
            }
        } else if (o instanceof Inline) {
            Inline inline = (Inline)o;
            artificialList = new ArrayList<Object>();
            drawingProps = inline.getDocPr();
            if (drawingProps != null) {
                this.handleCTNonVisualDrawingProps(drawingProps, artificialList);
            }
            if (inline.getGraphic() != null) {
                log.debug("found a:graphic");
                Graphic graphic = inline.getGraphic();
                if (graphic.getGraphicData() == null) {
                    log.warn("TODO: Handle case of no a:graphicData: " + XmlUtils.marshaltoString((Object)o, (boolean)true, (boolean)true, (JAXBContext)Context.jc, (String)"foo", (String)"Inline", o.getClass()));
                } else {
                    List<Object> l = this.handleGraphicData(graphic.getGraphicData());
                    if (l != null) {
                        artificialList.addAll(l);
                    }
                }
                return artificialList;
            }
            log.warn("TODO: Handle case of no a:graphic: " + XmlUtils.marshaltoString((Object)o, (boolean)true, (boolean)true, (JAXBContext)Context.jc, (String)"foo", (String)"Inline", o.getClass()));
            if (!artificialList.isEmpty()) {
                return artificialList;
            }
        } else {
            if (o instanceof Pict) {
                log.debug(XmlUtils.marshaltoString((Object)o));
                return ((Pict)o).getAnyAndAny();
            }
            if (o instanceof Pic) {
                log.warn("TODO: " + XmlUtils.marshaltoString((Object)o));
                Pic dmlPic = (Pic)o;
                if (dmlPic.getBlipFill() != null && dmlPic.getBlipFill().getBlip() != null) {
                    log.debug("found DML Blip");
                    ArrayList<Object> artificialList2 = new ArrayList<Object>();
                    artificialList2.add(dmlPic.getBlipFill().getBlip());
                    return artificialList2;
                }
                return null;
            }
            if (o instanceof CTGvmlPicture) {
                log.warn("TODO: " + XmlUtils.marshaltoString((Object)o));
                CTGvmlPicture dmlPic = (CTGvmlPicture)o;
                if (dmlPic.getBlipFill() != null && dmlPic.getBlipFill().getBlip() != null) {
                    log.debug("found DML Blip");
                    ArrayList<Object> artificialList3 = new ArrayList<Object>();
                    artificialList3.add(dmlPic.getBlipFill().getBlip());
                    return artificialList3;
                }
                return null;
            }
            if (o instanceof CTShapetype) {
                this.containsVML = true;
                log.debug(XmlUtils.marshaltoString((Object)o, (boolean)true, (boolean)true, (JAXBContext)Context.jc, (String)"http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing", (String)"shapetype", o.getClass()));
                this.inventoryObjects.add(o);
                return null;
            }
            if (o instanceof CTShape) {
                this.containsVML = true;
                log.debug(XmlUtils.marshaltoString((Object)o));
                ArrayList<Object> artificialList4 = new ArrayList<Object>();
                for (JAXBElement j : ((CTShape)o).getPathOrFormulasOrHandles()) {
                    artificialList4.add(j);
                }
                return artificialList4;
            }
            if (o instanceof CTDataModel) {
                log.warn("TODO: " + XmlUtils.marshaltoString((Object)o));
                CTDataModel dataModel = (CTDataModel)o;
                ArrayList<Object> artificialList5 = new ArrayList<Object>();
                artificialList5.addAll(dataModel.getPtLst().getPt());
                artificialList5.addAll(dataModel.getCxnLst().getCxn());
                return artificialList5;
            }
            if (o instanceof CTDrawing) {
                log.warn("TODO: " + XmlUtils.marshaltoString((Object)o));
                return ((CTDrawing)o).getSpTree().getSpOrGrpSp();
            }
            if (o instanceof CTTextbox) {
                log.debug(XmlUtils.marshaltoString((Object)o, (boolean)true, (boolean)true, (JAXBContext)Context.jc, (String)"http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing", (String)"textbox", o.getClass()));
                CTTextbox textBox = (CTTextbox)o;
                if (textBox.getTxbxContent() == null) {
                    return null;
                }
                return textBox.getTxbxContent().getEGBlockLevelElts();
            }
            if (o instanceof CTObject) {
                log.debug(XmlUtils.marshaltoString((Object)o, (boolean)true, (boolean)true, (JAXBContext)Context.jc, (String)"http://schemas.openxmlformats.org/wordprocessingml/2006/main", (String)"object", o.getClass()));
                CTObject ctObject = (CTObject)o;
                ArrayList<Object> artificialList6 = new ArrayList<Object>();
                artificialList6.addAll(ctObject.getAnyAndAny());
                if (ctObject.getControl() != null) {
                    artificialList6.add(ctObject.getControl());
                }
                return artificialList6;
            }
            if (o instanceof CTGvmlGroupShape) {
                log.warn("TODO: " + XmlUtils.marshaltoString((Object)o));
                return ((CTGvmlGroupShape)o).getTxSpOrSpOrCxnSp();
            }
            if (o instanceof FldChar) {
                FldChar fldChar = (FldChar)o;
                ArrayList<Object> artificialList7 = new ArrayList<Object>();
                artificialList7.add(fldChar.getFldCharType());
                if (fldChar.getFfData() != null) {
                    artificialList7.add(fldChar.getFfData());
                }
                if (fldChar.getFldData() != null) {
                    artificialList7.add(fldChar.getFldData());
                }
                if (fldChar.getNumberingChange() != null) {
                    artificialList7.add(fldChar.getNumberingChange());
                }
                return artificialList7;
            }
        }
        log.debug(".. looking for method which returns list ");
        try {
            Method[] methods = o.getClass().getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getReturnType().getName().equals("java.util.List")) continue;
                return (List)m.invoke(o, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.debug(".. no list member");
        return null;
    }

    private List<Object> handleGraphicData(GraphicData graphicData) {
        CTNonVisualDrawingProps picNonVisual;
        ArrayList<Object> tmpArtificialList = new ArrayList<Object>();
        if (graphicData.getPic() != null && (picNonVisual = graphicData.getPic().getNvPicPr().getCNvPr()) != null) {
            this.handleCTNonVisualDrawingProps(picNonVisual, tmpArtificialList);
        }
        if (graphicData.getPic() != null && graphicData.getPic().getBlipFill() != null && graphicData.getPic().getBlipFill().getBlip() != null) {
            CTBlip blip = graphicData.getPic().getBlipFill().getBlip();
            if (blip.getLink() != null) {
                log.debug("blip contained a link .. assumed ok");
            } else if (blip.getEmbed() != null) {
                String rId = blip.getEmbed();
                Part embeddedPart = this.sourcePart.getRelationshipsPart().getPart(rId);
                if (embeddedPart instanceof ImagePngPart || embeddedPart instanceof ImageGifPart || embeddedPart instanceof ImageJpegPart || embeddedPart instanceof ImageBmpPart || embeddedPart instanceof ImageTiffPart) {
                    // empty if block
                }
            }
            return null;
        }
        this.addUnsafe(graphicData, "http://schemas.openxmlformats.org/drawingml/2006/main", "graphicData", GraphicData.class);
        return graphicData.getAny();
    }

    private void addUnsafe(Object o, String uri, String local, Class declaredType) {
        this.unsafeObjects.add(XmlUtils.marshaltoString((Object)o, (boolean)true, (boolean)true, (JAXBContext)Context.jc, (String)uri, (String)local, (Class)declaredType));
    }

    private void handleCTNonVisualDrawingProps(CTNonVisualDrawingProps drawingProps, List<Object> artificialList) {
        if (drawingProps != null) {
            CTHyperlink docPrHyperLink;
            if (drawingProps.getDescr() != null) {
                drawingProps.setDescr(null);
            }
            if ((docPrHyperLink = drawingProps.getHlinkClick()) != null) {
                artificialList.add(docPrHyperLink);
            }
        }
    }
}

