/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.anon;

import com.thedeanda.lorem.Lorem;
import com.thedeanda.lorem.LoremIpsum;
import jakarta.xml.bind.JAXBElement;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.docx4j.TextUtils;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.anon.RunFontCharVisitorMinimal;
import org.docx4j.dml.CTRegularTextRun;
import org.docx4j.fonts.GlyphCheck;
import org.docx4j.fonts.RunFontSelector;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.vml.CTTextPath;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTFFData;
import org.docx4j.wml.CTFFName;
import org.docx4j.wml.DelText;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Text;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrambleText
extends TraversalUtil.CallbackImpl {
    private static Logger log = LoggerFactory.getLogger(ScrambleText.class);
    private static Lorem lorem = LoremIpsum.getInstance();
    private WordprocessingMLPackage pkg;
    private RunFontSelector rfs = null;
    private RunFontCharVisitorMinimal vis;
    String latinText = null;
    int beginIndex;
    Random random = new Random();
    PPr ppr = null;
    RPr rpr = null;
    boolean hasGreek = false;
    boolean hasCyrillic = false;
    boolean hasHebrew = false;
    boolean hasArabic = false;
    boolean hasHiragana = false;
    boolean hasKatakana = false;
    boolean hasCJK = false;
    int field_begin_counter = 0;
    int bookmark_start_counter = 0;
    private static final int MAX_GLYPH_RETRIES = 10;
    String font = null;

    private ScrambleText() {
    }

    public ScrambleText(WordprocessingMLPackage pkg) {
        this.pkg = pkg;
        this.vis = new RunFontCharVisitorMinimal();
        this.rfs = new RunFontSelector(pkg, (RunFontSelector.RunFontCharacterVisitor)new RunFontCharVisitorMinimal(), RunFontSelector.RunFontActionType.DISCOVERY);
    }

    public void walkJAXBElements(Object parent) {
        List children = this.getChildren(parent);
        if (children != null) {
            for (Object o2 : children) {
                Object o = XmlUtils.unwrap(o2);
                if (o instanceof Child) {
                    if (parent instanceof SdtBlock) {
                        ((Child)o).setParent((Object)((SdtBlock)parent).getSdtContent());
                    } else if (parent instanceof List) {
                        if (log.isDebugEnabled()) {
                            log.debug("Unknown parent for " + o.getClass().getName());
                        }
                    } else {
                        ((Child)o).setParent(parent);
                    }
                }
                this.apply(o2);
                if (!this.shouldTraverse(o)) continue;
                this.walkJAXBElements(o);
            }
        }
    }

    public List<Object> apply(Object o) {
        Text t;
        if (o instanceof JAXBElement && ((JAXBElement)o).getName().getLocalPart().equals("instrText")) {
            t = (Text)XmlUtils.unwrap((Object)o);
            String instr = t.getValue();
            log.debug(instr);
            if (instr.contains("MERGEFIELD")) {
                int start = instr.indexOf("MERGEFIELD") + 10;
                this.beginIndex += start;
                String toProcess = instr.substring(start);
                System.out.println(toProcess);
                int tLen = toProcess.length();
                t.setValue(instr.substring(0, start) + this.unicodeRangeToFont(toProcess, this.latinText.substring(this.beginIndex, this.beginIndex + tLen)));
                this.beginIndex += tLen;
                return null;
            }
            if (instr.contains("FORMCHECKBOX") || instr.contains("FORMTEXT") || instr.contains("PAGE")) {
                return null;
            }
            System.out.println("TO don't scramble: " + instr);
        }
        if ((o = XmlUtils.unwrap((Object)o)) instanceof FldChar) {
            FldChar fldChar = (FldChar)o;
            if (fldChar.getFldCharType().equals((Object)STFldCharType.BEGIN)) {
                ++this.field_begin_counter;
                if (fldChar.getFfData() != null) {
                    CTFFData ffData = fldChar.getFfData();
                    for (JAXBElement el : ffData.getNameOrEnabledOrCalcOnExit()) {
                        Object jObj = el.getValue();
                        if (!(jObj instanceof CTFFName)) continue;
                        String name = ((CTFFName)jObj).getVal();
                        ((CTFFName)jObj).setVal("fieldname" + this.field_begin_counter);
                    }
                }
            }
            return null;
        }
        if (o instanceof CTBookmark) {
            CTBookmark bookmarkStart = (CTBookmark)o;
            ++this.bookmark_start_counter;
            if (bookmarkStart.getName() != null) {
                bookmarkStart.setName("bm" + this.bookmark_start_counter);
            }
            return null;
        }
        if (o instanceof SdtElement) {
            SdtPr sdtPr = ((SdtElement)o).getSdtPr();
            sdtPr.setDataBinding(null);
            sdtPr.setTag(null);
            return null;
        }
        if (o instanceof P) {
            P p = (P)o;
            this.ppr = p.getPPr();
            StringWriter out = new StringWriter();
            try {
                TextUtils.extractText((Object)p, (Writer)out);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.latinText = this.generateReplacement(out.toString().length());
            this.beginIndex = 0;
            log.debug("latinText:" + this.latinText);
            return null;
        }
        if (o instanceof Text) {
            t = (Text)o;
            log.debug(t.getValue());
            int tLen = t.getValue().length();
            t.setValue(this.unicodeRangeToFont(t.getValue(), this.latinSubstring(tLen)));
            this.beginIndex += tLen;
        } else if (o instanceof DelText) {
            t = (DelText)o;
            int tLen = t.getValue().length();
            t.setValue(this.unicodeRangeToFont(t.getValue(), this.latinSubstring(tLen)));
            this.beginIndex += tLen;
        } else if (o instanceof CTRegularTextRun && ((CTRegularTextRun)o).getT() != null) {
            t = (CTRegularTextRun)o;
            int tLen = t.getT().length();
            t.setT(this.unicodeRangeToFont(t.getT(), this.latinSubstring(tLen)));
            this.beginIndex += tLen;
        } else if (o instanceof CTTextPath && (t = (CTTextPath)o).getString() != null) {
            int tLen = t.getString().length();
            String tmpLatin = this.generateReplacement(tLen);
            t.setString(this.unicodeRangeToFont(t.getString(), tmpLatin));
        }
        return null;
    }

    private String latinSubstring(int tLen) {
        if (this.beginIndex + tLen > this.latinText.length()) {
            System.out.println("Not enough characters!");
            return this.generateReplacement(tLen);
        }
        return this.latinText.substring(this.beginIndex, this.beginIndex + tLen);
    }

    private String generateReplacement(int slenRqd) {
        String latin;
        StringBuffer replacement = new StringBuffer();
        int len = 0;
        do {
            int wordsNeeded = Math.round((slenRqd - len) / 8) + 1;
            latin = lorem.getWords(wordsNeeded, wordsNeeded);
            replacement.append(latin);
        } while ((len += latin.length()) < slenRqd);
        return replacement.toString();
    }

    private char getRandom(char rangeLower, char rangeUpper) {
        char result;
        boolean glyphOK;
        int tries = 0;
        do {
            glyphOK = false;
            result = (char)(rangeLower + this.random.nextInt(rangeUpper - rangeLower));
            if (this.font == null) continue;
            try {
                glyphOK = GlyphCheck.hasChar((String)this.font, (char)result);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } while (this.font != null && !glyphOK && ++tries < 10);
        return result;
    }

    private String unicodeRangeToFont(String text, String latinText) {
        if (latinText.length() < text.length()) {
            latinText = this.generateReplacement(text.length());
        }
        this.font = null;
        this.vis.createNew();
        if (text == null) {
            log.warn("text==null; returning...");
            return null;
        }
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            log.debug(Integer.toHexString(c));
            if (Character.isHighSurrogate(c)) {
                log.info("high");
                this.vis.addCodePointToCurrent(text.codePointAt(i));
            } else if (c == ' ') {
                this.vis.addCharacterToCurrent(c);
            } else {
                if (this.font == null) {
                    this.rfs.fontSelector(this.ppr, this.rpr, String.valueOf(c));
                    this.font = this.vis.getFontname();
                    if (this.font == null) {
                        log.debug("still no font!");
                    }
                }
                log.debug("      " + c);
                if (c >= 'A' && c <= 'Z') {
                    try {
                        this.vis.addCharacterToCurrent(latinText.substring(i, i + 1).charAt(0));
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        System.out.println(latinText + "( len " + latinText.length() + ") is too short ");
                        throw e;
                    }
                } else if (c >= 'a' && c <= 'z') {
                    try {
                        this.vis.addCharacterToCurrent(latinText.substring(i, i + 1).charAt(0));
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        System.out.println(latinText + "( len " + latinText.length() + ") is too short ");
                        throw e;
                    }
                } else if (c >= '\u0000' && c <= '\u007f') {
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0080' && c <= '\u00ff') {
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0100' && c <= '\u017f') {
                    c = this.getRandom('\u0100', '\u017f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0180' && c <= '\u024f') {
                    c = this.getRandom('\u0180', '\u024f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0250' && c <= '\u02af') {
                    c = this.getRandom('\u0250', '\u02af');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u02b0' && c <= '\u02ff') {
                    c = this.getRandom('\u02b0', '\u02ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0300' && c <= '\u036f') {
                    c = this.getRandom('\u0300', '\u036f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0370' && c <= '\u03ff') {
                    c = this.getRandom('\u0370', '\u03ff');
                    this.vis.addCharacterToCurrent(c);
                    this.hasGreek = true;
                } else if (c >= '\u0400' && c <= '\u04ff') {
                    c = this.getRandom('\u0400', '\u04ff');
                    this.vis.addCharacterToCurrent(c);
                    this.hasCyrillic = true;
                } else if (c >= '\u0500' && c <= '\u052f') {
                    c = this.getRandom('\u0500', '\u052f');
                    this.vis.addCharacterToCurrent(c);
                    this.hasCyrillic = true;
                } else if (c >= '\u0530' && c <= '\u058f') {
                    c = this.getRandom('\u0530', '\u058f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0590' && c <= '\u05ff') {
                    c = this.getRandom('\u0590', '\u05ff');
                    this.vis.addCharacterToCurrent(c);
                    this.hasHebrew = true;
                } else if (c >= '\u0600' && c <= '\u06ff') {
                    c = this.getRandom('\u0600', '\u06ff');
                    this.vis.addCharacterToCurrent(c);
                    this.hasArabic = true;
                } else if (c >= '\u0700' && c <= '\u074f') {
                    c = this.getRandom('\u0700', '\u074f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0750' && c <= '\u077f') {
                    c = this.getRandom('\u0750', '\u077f');
                    this.vis.addCharacterToCurrent(c);
                    this.hasArabic = true;
                } else if (c >= '\u0780' && c <= '\u07bf') {
                    c = this.getRandom('\u0780', '\u07bf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u07c0' && c <= '\u07ff') {
                    c = this.getRandom('\u07c0', '\u07ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0800' && c <= '\u083f') {
                    c = this.getRandom('\u0800', '\u083f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0840' && c <= '\u085f') {
                    c = this.getRandom('\u0840', '\u085f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u08a0' && c <= '\u08ff') {
                    c = this.getRandom('\u08a0', '\u08ff');
                    this.vis.addCharacterToCurrent(c);
                    this.hasArabic = true;
                } else if (c >= '\u0900' && c <= '\u097f') {
                    c = this.getRandom('\u0900', '\u097f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0980' && c <= '\u09ff') {
                    c = this.getRandom('\u0980', '\u09ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0a00' && c <= '\u0a7f') {
                    c = this.getRandom('\u0a00', '\u0a7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0a80' && c <= '\u0aff') {
                    c = this.getRandom('\u0a80', '\u0aff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0b00' && c <= '\u0b7f') {
                    c = this.getRandom('\u0b00', '\u0b7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0b80' && c <= '\u0bff') {
                    c = this.getRandom('\u0b80', '\u0bff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0c00' && c <= '\u0c7f') {
                    c = this.getRandom('\u0c00', '\u0c7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0c80' && c <= '\u0cff') {
                    c = this.getRandom('\u0c80', '\u0cff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0d00' && c <= '\u0d7f') {
                    c = this.getRandom('\u0d00', '\u0d7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0d80' && c <= '\u0dff') {
                    c = this.getRandom('\u0d80', '\u0dff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0e00' && c <= '\u0e7f') {
                    c = this.getRandom('\u0e00', '\u0e7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0e80' && c <= '\u0eff') {
                    c = this.getRandom('\u0e80', '\u0eff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u0f00' && c <= '\u0fff') {
                    c = this.getRandom('\u0f00', '\u0fff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1000' && c <= '\u109f') {
                    c = this.getRandom('\u1000', '\u109f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u10a0' && c <= '\u10ff') {
                    c = this.getRandom('\u10a0', '\u10ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1100' && c <= '\u11ff') {
                    c = this.getRandom('\u1100', '\u11ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1200' && c <= '\u137f') {
                    c = this.getRandom('\u1200', '\u137f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1380' && c <= '\u139f') {
                    c = this.getRandom('\u1380', '\u139f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u13a0' && c <= '\u13ff') {
                    c = this.getRandom('\u13a0', '\u13ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1400' && c <= '\u167f') {
                    c = this.getRandom('\u1400', '\u167f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1680' && c <= '\u169f') {
                    c = this.getRandom('\u1680', '\u169f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u16a0' && c <= '\u16ff') {
                    c = this.getRandom('\u16a0', '\u16ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1700' && c <= '\u171f') {
                    c = this.getRandom('\u1700', '\u171f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1720' && c <= '\u173f') {
                    c = this.getRandom('\u1720', '\u173f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1740' && c <= '\u175f') {
                    c = this.getRandom('\u1740', '\u175f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1760' && c <= '\u177f') {
                    c = this.getRandom('\u1760', '\u177f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1780' && c <= '\u17ff') {
                    c = this.getRandom('\u1780', '\u17ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1800' && c <= '\u18af') {
                    c = this.getRandom('\u1800', '\u18af');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u18b0' && c <= '\u18ff') {
                    c = this.getRandom('\u18b0', '\u18ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1900' && c <= '\u194f') {
                    c = this.getRandom('\u1900', '\u194f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1950' && c <= '\u197f') {
                    c = this.getRandom('\u1950', '\u197f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1980' && c <= '\u19df') {
                    c = this.getRandom('\u1980', '\u19df');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u19e0' && c <= '\u19ff') {
                    c = this.getRandom('\u19e0', '\u19ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1a00' && c <= '\u1a1f') {
                    c = this.getRandom('\u1a00', '\u1a1f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1a20' && c <= '\u1aaf') {
                    c = this.getRandom('\u1a20', '\u1aaf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1ab0' && c <= '\u1aff') {
                    c = this.getRandom('\u1ab0', '\u1aff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1b00' && c <= '\u1b7f') {
                    c = this.getRandom('\u1b00', '\u1b7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1b80' && c <= '\u1bbf') {
                    c = this.getRandom('\u1b80', '\u1bbf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1bc0' && c <= '\u1bff') {
                    c = this.getRandom('\u1bc0', '\u1bff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1c00' && c <= '\u1c4f') {
                    c = this.getRandom('\u1c00', '\u1c4f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1c50' && c <= '\u1c7f') {
                    c = this.getRandom('\u1c50', '\u1c7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1cc0' && c <= '\u1ccf') {
                    c = this.getRandom('\u1cc0', '\u1ccf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1cd0' && c <= '\u1cff') {
                    c = this.getRandom('\u1cd0', '\u1cff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1d00' && c <= '\u1d7f') {
                    c = this.getRandom('\u1d00', '\u1d7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1d80' && c <= '\u1dbf') {
                    c = this.getRandom('\u1d80', '\u1dbf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1dc0' && c <= '\u1dff') {
                    c = this.getRandom('\u1dc0', '\u1dff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1e00' && c <= '\u1eff') {
                    c = this.getRandom('\u1e00', '\u1eff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u1f00' && c <= '\u1fff') {
                    c = this.getRandom('\u1f00', '\u1fff');
                    this.vis.addCharacterToCurrent(c);
                    this.hasGreek = true;
                } else if (c >= '\u2000' && c <= '\u206f') {
                    c = this.getRandom('\u2000', '\u206f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2070' && c <= '\u209f') {
                    c = this.getRandom('\u2070', '\u209f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u20a0' && c <= '\u20cf') {
                    c = this.getRandom('\u20a0', '\u20cf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u20d0' && c <= '\u20ff') {
                    c = this.getRandom('\u20d0', '\u20ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2100' && c <= '\u214f') {
                    c = this.getRandom('\u2100', '\u214f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2150' && c <= '\u218f') {
                    c = this.getRandom('\u2150', '\u218f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2190' && c <= '\u21ff') {
                    c = this.getRandom('\u2190', '\u21ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2200' && c <= '\u22ff') {
                    c = this.getRandom('\u2200', '\u22ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2300' && c <= '\u23ff') {
                    c = this.getRandom('\u2300', '\u23ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2400' && c <= '\u243f') {
                    c = this.getRandom('\u2400', '\u243f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2440' && c <= '\u245f') {
                    c = this.getRandom('\u2440', '\u245f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2460' && c <= '\u24ff') {
                    c = this.getRandom('\u2460', '\u24ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2500' && c <= '\u257f') {
                    c = this.getRandom('\u2500', '\u257f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2580' && c <= '\u259f') {
                    c = this.getRandom('\u2580', '\u259f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u25a0' && c <= '\u25ff') {
                    c = this.getRandom('\u25a0', '\u25ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2600' && c <= '\u26ff') {
                    c = this.getRandom('\u2600', '\u26ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2700' && c <= '\u27bf') {
                    c = this.getRandom('\u2700', '\u27bf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u27c0' && c <= '\u27ef') {
                    c = this.getRandom('\u27c0', '\u27ef');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u27f0' && c <= '\u27ff') {
                    c = this.getRandom('\u27f0', '\u27ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2800' && c <= '\u28ff') {
                    c = this.getRandom('\u2800', '\u28ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2900' && c <= '\u297f') {
                    c = this.getRandom('\u2900', '\u297f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2980' && c <= '\u29ff') {
                    c = this.getRandom('\u2980', '\u29ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2a00' && c <= '\u2aff') {
                    c = this.getRandom('\u2a00', '\u2aff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2b00' && c <= '\u2bff') {
                    c = this.getRandom('\u2b00', '\u2bff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2c00' && c <= '\u2c5f') {
                    c = this.getRandom('\u2c00', '\u2c5f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2c60' && c <= '\u2c7f') {
                    c = this.getRandom('\u2c60', '\u2c7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2c80' && c <= '\u2cff') {
                    c = this.getRandom('\u2c80', '\u2cff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2d00' && c <= '\u2d2f') {
                    c = this.getRandom('\u2d00', '\u2d2f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2d30' && c <= '\u2d7f') {
                    c = this.getRandom('\u2d30', '\u2d7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2d80' && c <= '\u2ddf') {
                    c = this.getRandom('\u2d80', '\u2ddf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2de0' && c <= '\u2dff') {
                    c = this.getRandom('\u2de0', '\u2dff');
                    this.vis.addCharacterToCurrent(c);
                    this.hasCyrillic = true;
                } else if (c >= '\u2e00' && c <= '\u2e7f') {
                    c = this.getRandom('\u2e00', '\u2e7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2e80' && c <= '\u2eff') {
                    c = this.getRandom('\u2e80', '\u2eff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2f00' && c <= '\u2fdf') {
                    c = this.getRandom('\u2f00', '\u2fdf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u2ff0' && c <= '\u2fff') {
                    c = this.getRandom('\u2ff0', '\u2fff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u3000' && c <= '\u303f') {
                    c = this.getRandom('\u3000', '\u303f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u3040' && c <= '\u309f') {
                    c = this.getRandom('\u3040', '\u309f');
                    this.vis.addCharacterToCurrent(c);
                    this.hasHiragana = true;
                } else if (c >= '\u30a0' && c <= '\u30ff') {
                    c = this.getRandom('\u30a0', '\u30ff');
                    this.vis.addCharacterToCurrent(c);
                    this.hasKatakana = true;
                } else if (c >= '\u3100' && c <= '\u312f') {
                    c = this.getRandom('\u3100', '\u312f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u3130' && c <= '\u318f') {
                    c = this.getRandom('\u3130', '\u318f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u3190' && c <= '\u319f') {
                    c = this.getRandom('\u3190', '\u319f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u31a0' && c <= '\u31bf') {
                    c = this.getRandom('\u31a0', '\u31bf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u31c0' && c <= '\u31ef') {
                    c = this.getRandom('\u31c0', '\u31ef');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u31f0' && c <= '\u31ff') {
                    c = this.getRandom('\u31f0', '\u31ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u3200' && c <= '\u32ff') {
                    c = this.getRandom('\u3200', '\u32ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u3300' && c <= '\u33ff') {
                    c = this.getRandom('\u3300', '\u33ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u3400' && c <= '\u4dbf') {
                    c = this.getRandom('\u3400', '\u4dbf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u4dc0' && c <= '\u4dff') {
                    c = this.getRandom('\u4dc0', '\u4dff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\u4e00' && c <= '\u9fff') {
                    c = this.getRandom('\u4e00', '\u9fff');
                    this.vis.addCharacterToCurrent(c);
                    this.hasCJK = true;
                } else if (c >= '\ua000' && c <= '\ua48f') {
                    c = this.getRandom('\ua000', '\ua48f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua490' && c <= '\ua4cf') {
                    c = this.getRandom('\ua490', '\ua4cf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua4d0' && c <= '\ua4ff') {
                    c = this.getRandom('\ua4d0', '\ua4ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua500' && c <= '\ua63f') {
                    c = this.getRandom('\ua500', '\ua63f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua640' && c <= '\ua69f') {
                    c = this.getRandom('\ua640', '\ua69f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua6a0' && c <= '\ua6ff') {
                    c = this.getRandom('\ua6a0', '\ua6ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua700' && c <= '\ua71f') {
                    c = this.getRandom('\ua700', '\ua71f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua720' && c <= '\ua7ff') {
                    c = this.getRandom('\ua720', '\ua7ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua800' && c <= '\ua82f') {
                    c = this.getRandom('\ua800', '\ua82f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua830' && c <= '\ua83f') {
                    c = this.getRandom('\ua830', '\ua83f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua840' && c <= '\ua87f') {
                    c = this.getRandom('\ua840', '\ua87f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua880' && c <= '\ua8df') {
                    c = this.getRandom('\ua880', '\ua8df');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua8e0' && c <= '\ua8ff') {
                    c = this.getRandom('\ua8e0', '\ua8ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua900' && c <= '\ua92f') {
                    c = this.getRandom('\ua900', '\ua92f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua930' && c <= '\ua95f') {
                    c = this.getRandom('\ua930', '\ua95f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua960' && c <= '\ua97f') {
                    c = this.getRandom('\ua960', '\ua97f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua980' && c <= '\ua9df') {
                    c = this.getRandom('\ua980', '\ua9df');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ua9e0' && c <= '\ua9ff') {
                    c = this.getRandom('\ua9e0', '\ua9ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\uaa00' && c <= '\uaa5f') {
                    c = this.getRandom('\uaa00', '\uaa5f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\uaa60' && c <= '\uaa7f') {
                    c = this.getRandom('\uaa60', '\uaa7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\uaa80' && c <= '\uaadf') {
                    c = this.getRandom('\uaa80', '\uaadf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\uaae0' && c <= '\uaaff') {
                    c = this.getRandom('\uaae0', '\uaaff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\uab00' && c <= '\uab2f') {
                    c = this.getRandom('\uab00', '\uab2f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\uab30' && c <= '\uab6f') {
                    c = this.getRandom('\uab30', '\uab6f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\uab70' && c <= '\uabbf') {
                    c = this.getRandom('\uab70', '\uabbf');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\uabc0' && c <= '\uabff') {
                    c = this.getRandom('\uabc0', '\uabff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\uac00' && c <= '\ud7af') {
                    c = this.getRandom('\uac00', '\ud7af');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ud7b0' && c <= '\ud7ff') {
                    c = this.getRandom('\ud7b0', '\ud7ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ud800' && c <= '\udb7f') {
                    c = this.getRandom('\ud800', '\udb7f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\udb80' && c <= '\udbff') {
                    c = this.getRandom('\udb80', '\udbff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\udc00' && c <= '\udfff') {
                    c = this.getRandom('\udc00', '\udfff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ue000' && c <= '\uf8ff') {
                    c = this.getRandom('\ue000', '\uf8ff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\uf900' && c <= '\ufaff') {
                    c = this.getRandom('\uf900', '\ufaff');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ufb00' && c <= '\ufb4f') {
                    c = this.getRandom('\ufb00', '\ufb4f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ufb50' && c <= '\ufdff') {
                    c = this.getRandom('\ufb50', '\ufdff');
                    this.vis.addCharacterToCurrent(c);
                    this.hasArabic = true;
                } else if (c >= '\ufe00' && c <= '\ufe0f') {
                    c = this.getRandom('\ufe00', '\ufe0f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ufe10' && c <= '\ufe1f') {
                    c = this.getRandom('\ufe10', '\ufe1f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ufe20' && c <= '\ufe2f') {
                    c = this.getRandom('\ufe20', '\ufe2f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ufe30' && c <= '\ufe4f') {
                    c = this.getRandom('\ufe30', '\ufe4f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ufe50' && c <= '\ufe6f') {
                    c = this.getRandom('\ufe50', '\ufe6f');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ufe70' && c <= '\ufeff') {
                    c = this.getRandom('\ufe70', '\ufeff');
                    this.vis.addCharacterToCurrent(c);
                    this.hasArabic = true;
                } else if (c >= '\uff00' && c <= '\uffef') {
                    c = this.getRandom('\uff00', '\uffef');
                    this.vis.addCharacterToCurrent(c);
                } else if (c >= '\ufff0' && c <= '\uffff') {
                    c = this.getRandom('\ufff0', '\uffff');
                    this.vis.addCharacterToCurrent(c);
                } else {
                    log.warn("TODO: handle " + Integer.toHexString(c));
                    this.vis.addCharacterToCurrent(c);
                }
            }
            i = text.offsetByCodePoints(i, 1);
        }
        return (String)this.vis.getResult();
    }
}

