/*
 * Decompiled with CFR 0.152.
 */
package org.domdrides.jpa.repository;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.domdrides.entity.Entity;
import org.domdrides.repository.Repository;
import org.springframework.orm.jpa.support.JpaDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaRepository<EntityType extends Entity<IdType>, IdType extends Serializable>
extends JpaDaoSupport
implements Repository<EntityType, IdType> {
    private final Class<EntityType> entityClass;

    protected JpaRepository(Class<EntityType> entityClass) {
        this.entityClass = entityClass;
    }

    public EntityType add(EntityType entity) {
        this.getJpaTemplate().persist(entity);
        return entity;
    }

    public boolean contains(EntityType entity) {
        return this.getById(entity.getId()) != null;
    }

    public Set<EntityType> getAll() {
        String jpaql = "select x from " + this.entityClass.getName() + " x";
        return this.queryForSet(jpaql);
    }

    private HashSet<EntityType> queryForSet(String jpaql) {
        return new HashSet(this.getJpaTemplate().find(jpaql));
    }

    public EntityType getById(IdType id) {
        return (EntityType)((Entity)this.getJpaTemplate().find(this.entityClass, id));
    }

    public void remove(EntityType entity) {
        this.getJpaTemplate().remove(entity);
    }

    public EntityType update(EntityType entity) {
        return (EntityType)((Entity)this.getJpaTemplate().merge(entity));
    }
}

