/*
 * Decompiled with CFR 0.152.
 */
package org.domdrides.jpa.repository;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.domdrides.entity.Entity;
import org.domdrides.repository.PageableRepository;
import org.springframework.orm.jpa.JpaCallback;
import org.springframework.orm.jpa.support.JpaDaoSupport;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaRepository<EntityType extends Entity<IdType>, IdType extends Serializable>
extends JpaDaoSupport
implements PageableRepository<EntityType, IdType> {
    private final Class<EntityType> entityClass;

    protected JpaRepository(Class<EntityType> entityClass) {
        this.entityClass = entityClass;
    }

    @Transactional
    public EntityType add(EntityType entity) {
        this.getJpaTemplate().persist(entity);
        return entity;
    }

    @Transactional(readOnly=true)
    public boolean contains(EntityType entity) {
        return this.getById(entity.getId()) != null;
    }

    @Transactional(readOnly=true)
    public Set<EntityType> getAll() {
        String jpaql = "select x from " + this.entityClass.getName() + " x";
        return this.queryForSet(jpaql);
    }

    @Transactional(readOnly=true)
    private HashSet<EntityType> queryForSet(String jpaql) {
        return new HashSet(this.getJpaTemplate().find(jpaql));
    }

    @Transactional(readOnly=true)
    public EntityType getById(IdType id) {
        return (EntityType)((Entity)this.getJpaTemplate().find(this.entityClass, id));
    }

    @Transactional
    public void remove(EntityType entity) {
        this.getJpaTemplate().remove(entity);
    }

    @Transactional
    public EntityType update(EntityType entity) {
        return (EntityType)((Entity)this.getJpaTemplate().merge(entity));
    }

    @Transactional(readOnly=true)
    public int size() {
        List results = this.getJpaTemplate().find("select count(*) from " + this.entityClass.getName());
        return ((Number)results.get(0)).intValue();
    }

    @Transactional(readOnly=true)
    public List<EntityType> list(final int first, final int max, final String sortProperty, final boolean ascending) {
        return this.getJpaTemplate().executeFind(new JpaCallback(){

            public Object doInJpa(EntityManager entityManager) throws PersistenceException {
                return entityManager.createQuery("select x from " + JpaRepository.this.entityClass.getName() + " x order by x." + sortProperty + (ascending ? " asc" : " desc")).setFirstResult(first).setMaxResults(max).getResultList();
            }
        });
    }
}

