/*
 * Decompiled with CFR 0.152.
 */
package org.domdrides.jpa.repository;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.domdrides.entity.Entity;
import org.domdrides.repository.PageableRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public abstract class JpaRepository<EntityType extends Entity<IdType>, IdType extends Serializable>
implements PageableRepository<EntityType, IdType> {
    @PersistenceContext
    private EntityManager entityManager;
    private final Class<EntityType> entityClass;

    protected JpaRepository(Class<EntityType> entityClass) {
        this.entityClass = entityClass;
    }

    @Transactional(readOnly=true)
    public List<EntityType> list(int first, int max, String sortProperty, boolean ascending) {
        String jpaql = "select x from " + this.entityClass.getName() + " x order by x." + sortProperty + (ascending ? " asc" : " desc");
        Query query = this.entityManager.createQuery(jpaql);
        query.setFirstResult(first).setMaxResults(max);
        return query.getResultList();
    }

    @Transactional
    public EntityType add(EntityType entity) {
        this.entityManager.persist(entity);
        return entity;
    }

    @Transactional(readOnly=true)
    public boolean contains(EntityType entity) {
        return this.getById(entity.getId()) != null;
    }

    @Transactional(readOnly=true)
    public Set<EntityType> getAll() {
        String jpaql = "select x from " + this.entityClass.getName() + " x";
        return this.queryForSet(jpaql);
    }

    @Transactional(readOnly=true)
    public EntityType getById(IdType id) {
        return (EntityType)((Entity)this.entityManager.find(this.entityClass, id));
    }

    @Transactional
    public void remove(EntityType entity) {
        this.entityManager.remove(entity);
    }

    @Transactional(readOnly=true)
    public int size() {
        List results = this.entityManager.createQuery("select count(*) from " + this.entityClass.getName()).getResultList();
        return ((Number)results.get(0)).intValue();
    }

    @Transactional
    public EntityType update(EntityType entity) {
        return (EntityType)((Entity)this.entityManager.merge(entity));
    }

    protected Class<EntityType> getEntityClass() {
        return this.entityClass;
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Transactional(readOnly=true)
    private Set<EntityType> queryForSet(String jpaql) {
        return new HashSet(this.entityManager.createQuery(jpaql).getResultList());
    }
}

