/*
 * Decompiled with CFR 0.152.
 */
package org.domdrides.jpa.repository;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.domdrides.entity.Entity;
import org.domdrides.repository.PageableRepository;

public abstract class JpaRepository<E extends Entity<I>, I extends Serializable>
implements PageableRepository<E, I> {
    @PersistenceContext
    private EntityManager entityManager;
    private final Class<E> entityClass;

    protected JpaRepository(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    public List<E> list(int first, int max, String sortProperty, boolean ascending) {
        String jpaql = "select x from " + this.entityClass.getName() + " x order by x." + sortProperty + (ascending ? " asc" : " desc");
        Query query = this.getEntityManager().createQuery(jpaql);
        query.setFirstResult(first).setMaxResults(max);
        return query.getResultList();
    }

    public E add(E entity) {
        this.getEntityManager().persist(entity);
        return entity;
    }

    public boolean contains(E entity) {
        return this.getById(entity.getId()) != null;
    }

    public Set<E> getAll() {
        String jpaql = "select x from " + this.entityClass.getName() + " x";
        return this.queryForSet(jpaql);
    }

    public E getById(I id) {
        return (E)((Entity)this.getEntityManager().find(this.entityClass, id));
    }

    public void remove(E entity) {
        this.getEntityManager().remove(entity);
    }

    public int size() {
        List results = this.getEntityManager().createQuery("select count(*) from " + this.entityClass.getName()).getResultList();
        return ((Number)results.get(0)).intValue();
    }

    public E update(E entity) {
        return (E)((Entity)this.getEntityManager().merge(entity));
    }

    protected Class<E> getEntityClass() {
        return this.entityClass;
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected Set<E> queryForSet(String jpaql) {
        return new HashSet(this.getEntityManager().createQuery(jpaql).getResultList());
    }
}

