/*
 * Decompiled with CFR 0.152.
 */
package org.domdrides.wicket.model.repeater;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import org.domdrides.entity.Entity;
import org.domdrides.repository.PageableRepository;
import org.domdrides.wicket.model.LoadableDetachableEntityModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageableRepositoryDataProvider<EntityType extends Entity<IdType>, IdType extends Serializable>
extends SortableDataProvider<EntityType> {
    private final PageableRepository<EntityType, IdType> repository;

    public PageableRepositoryDataProvider(PageableRepository<EntityType, IdType> repository, String sortProperty, boolean ascending) {
        this.repository = repository;
        this.setSort(new SortParam(sortProperty, ascending));
    }

    public PageableRepositoryDataProvider(PageableRepository<EntityType, IdType> repository, String sortProperty) {
        this.repository = repository;
        this.setSort(new SortParam(sortProperty, true));
    }

    public Iterator<? extends EntityType> iterator(int first, int max) {
        return this.repository.list(first, max, this.getSort().getProperty(), this.getSort().isAscending()).iterator();
    }

    public int size() {
        return this.repository.size();
    }

    public IModel<EntityType> model(EntityType entity) {
        return new LoadableDetachableEntityModel<EntityType, IdType>(this.repository, entity);
    }
}

