/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.service.db.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dragonli.service.db.service.DBConfig;
import org.dragonli.service.db.service.command.CommandBatchSave;
import org.dragonli.service.db.service.command.CommandCount;
import org.dragonli.service.db.service.command.CommandDelete;
import org.dragonli.service.db.service.command.CommandDeleteMulti;
import org.dragonli.service.db.service.command.CommandDeleteQuery;
import org.dragonli.service.db.service.command.CommandExec;
import org.dragonli.service.db.service.command.CommandExecBatchUpate;
import org.dragonli.service.db.service.command.CommandGet;
import org.dragonli.service.db.service.command.CommandGetMulti;
import org.dragonli.service.db.service.command.CommandList;
import org.dragonli.service.db.service.command.CommandSave;
import org.dragonli.service.db.service.command.ICommand;
import org.dragonli.service.db.service.metadata.DBhandler;
import org.dragonli.service.db.util.DbUtil;
import org.dragonli.service.db.util.IMultiGetAndSimpleListInAble;
import org.dragonli.service.db.util.RedisUtil;
import org.dragonli.service.general.interfaces.general.DbService;
import org.dragonli.tools.configuration.DataSourceConfigurationUtil;
import org.dragonli.tools.configuration.GeneralConfigurationUtil;
import org.dragonli.tools.general.DataCachePool;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DbCore
implements IMultiGetAndSimpleListInAble,
DbService {
    protected static final Logger logger = Logger.getLogger(DbCore.class);
    protected DBConfig config;
    protected String updateTableName;
    protected RedissonClient redissonClient;
    @Value(value="${service.general.db-config.redisKey}")
    String redisKey;
    @Value(value="${service.general.db-config.defaultDbName}")
    String defaultDbName;
    @Value(value="${service.general.db-config.autoUpdateTableName}")
    String autoUpdateTableName;
    @Value(value="${service.general.db-config.primaryKey}")
    String primaryKey;
    @Value(value="${service.general.db-config.versionKey}")
    String versionKey;
    @Value(value="${service.general.db-config.tableNameTag}")
    String tableNameTag;
    @Autowired
    DataSourceConfigurationUtil dataSourceConfigurationUtil;
    @Autowired
    GeneralConfigurationUtil generalConfigurationUtil;
    private String serviceVersion;

    public String getUpdateTableName() {
        return this.updateTableName;
    }

    public void setUpdateTableName(String updateTableName) {
        this.updateTableName = updateTableName;
    }

    public void iniitGenralConfig(String redisKey) {
        this.redisKey = redisKey != null ? redisKey : this.generalConfigurationUtil.getProperty("service.general.db-config.redisKey", null);
        this.redisKey = redisKey != null ? redisKey : this.generalConfigurationUtil.getProperty("service.general.db-config.redisKey", null);
    }

    public void initByConfig(RedissonClient redissonClient, String configStr, String separator) throws Exception {
        this.initByConfig(redissonClient, Arrays.asList(configStr.split(separator)));
    }

    public void initByConfig(RedissonClient redissonClient, String dataSourcesConfigPath) throws Exception {
        List dataSourcesConfigPathList = this.generalConfigurationUtil.getList(dataSourcesConfigPath);
        this.initByConfig(redissonClient, dataSourcesConfigPathList.stream().map(Object::toString).collect(Collectors.toList()));
    }

    public void initByConfig(RedissonClient redissonClient, List<String> dataSourcesConfigPathList) throws Exception {
        List<DataSource> dataSources = dataSourcesConfigPathList.stream().map(path -> this.dataSourceConfigurationUtil.getDataSource(path)).collect(Collectors.toList());
        this.init(redissonClient, dataSources);
    }

    public void init(RedissonClient redissonClient, List<DataSource> dataSources) throws Exception {
        DBConfig config;
        if (null == dataSources) {
            throw new Exception("data sources dic must not be null");
        }
        HashMap<String, DataSource> allDataSources = new HashMap<String, DataSource>();
        for (DataSource dataSource : dataSources) {
            String url = dataSource.getConnection().getMetaData().getURL();
            Matcher matcher = Pattern.compile("/([^/\\?]+)\\?").matcher(url);
            if (!matcher.find()) {
                throw new Exception("no db name found in url:" + url);
            }
            String key = matcher.group(1);
            allDataSources.put(key, dataSource);
        }
        this.redisKey = this.redisKey != null && !"".equals(this.redisKey.trim()) ? this.redisKey.trim() : null;
        this.config = config = new DBConfig(this.defaultDbName, this.redisKey, allDataSources);
        config.setTableNameTag(this.tableNameTag);
        config.setAutoUpdateTableName(this.autoUpdateTableName);
        config.setVersionKey(this.versionKey);
        config.setRedisKey(this.redisKey);
        config.setPrimaryKey(this.primaryKey);
        this.redissonClient = redissonClient;
        this.dbstart();
    }

    public String getRedisKey() {
        return this.redisKey;
    }

    public void start() {
    }

    public void dbstart() {
        logger.info((Object)"do dbcore start!");
        new Thread(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                while (true) lbl-1000:
                // 4 sources

                {
                    for (DBhandler db : allHandler = DBhandler.allHandlers()) {
                        db.checkUpdate();
                    }
                    try {
                        Thread.sleep(100L);
                        ** continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public DBConfig getConfig() {
        return this.config;
    }

    public void setConfig(DBConfig config) {
        this.config = config;
    }

    protected <T extends ICommand> T createCommand(Class<? extends T> cls, String dbName, String table, DBConfig config) throws Exception {
        ICommand command = (ICommand)DataCachePool.get(cls);
        command.init(dbName, table, config);
        return (T)command;
    }

    protected Exception logException(Exception exception) {
        logger.error((Object)exception);
        return exception;
    }

    public Map<String, Object> get(String dbName, String table, Object pk) throws Exception {
        return this.get(dbName, table, pk, null);
    }

    public Map<String, Object> get(String dbName, String table, Object pk, String ak) throws Exception {
        long t1 = System.currentTimeMillis();
        dbName = dbName == null ? this.config.getDefaultDbName() : dbName;
        Map<String, Object> r = null;
        if (this.getRedisKey() != null) {
            r = this.getFromCache(dbName, table, pk);
        }
        if (r != null) {
            return r;
        }
        CommandGet command = this.createCommand(CommandGet.class, dbName, table, this.config);
        r = command.exec(pk, ak);
        this.saveToCache(dbName, table, pk, r);
        long t2 = System.currentTimeMillis();
        logger.info((Object)("db get cost|" + (t2 - t1) + "|" + t2 + "|" + t1));
        return r;
    }

    public void saveToCache(String dbName, String table, Object pk, Map<String, Object> model) throws Exception {
        RedisUtil.saveToCache(dbName, table, pk, model, this.redissonClient, this.getRedisKey());
    }

    public Map<String, Object> getFromCache(String dbName, String table, Object pk) throws Exception {
        return this.getFromCache(dbName, table, pk, null);
    }

    public Map<String, Object> getFromCache(String dbName, String table, Object pk, RedissonClient redissonClient) throws Exception {
        return RedisUtil.getFromCache(dbName, table, pk, redissonClient, this.getRedisKey());
    }

    public void deleteFromCache(String dbName, String table, Object pk) {
        RedisUtil.deleteFromCache(dbName, table, pk, this.redissonClient, this.getRedisKey());
    }

    public Map<String, Object> save(String dbName, String table, Map<String, Object> model) throws Exception {
        return this.save(dbName, table, model, null);
    }

    public Map<String, Object> save(String dbName, String table, Map<String, Object> model, String ak) throws Exception {
        dbName = dbName == null ? this.config.getDefaultDbName() : dbName;
        model.put(this.config.getTableNameTag(), table);
        CommandSave command = this.createCommand(CommandSave.class, dbName, table, this.config);
        try {
            Map<String, Object> r = command.exec(model, ak);
            this.saveToCache(dbName, table, r.get(this.config.getPrimaryKey()), r);
            Map<String, Object> map = r;
            return map;
        }
        catch (Exception exception) {
            logger.error((Object)("dbService.err:dbService.save:" + dbName + ":" + table + ":" + JSON.toJSONString(model)));
            throw this.logException(exception);
        }
    }

    public Map<String, Object>[] list(String dbName, String table, String where, List<Object> paraList) throws Exception {
        return this.list(dbName, table, where, paraList, null);
    }

    public Map<String, Object>[] list(String dbName, String table, String where, List<Object> paraList, String ak) throws Exception {
        Object[] paras = paraList.toArray(new Object[0]);
        return this.list(dbName, table, where, paras, ak);
    }

    public Map<String, Object>[] list(String dbName, String table, String where, Object[] paras) throws Exception {
        return this.list(dbName, table, where, paras, null);
    }

    public Map<String, Object>[] list(String dbName, String table, String where, Object[] paras, String ak) throws Exception {
        dbName = dbName == null ? this.config.getDefaultDbName() : dbName;
        CommandList command = this.createCommand(CommandList.class, dbName, table, this.config);
        try {
            return command.exec(where, paras, ak);
        }
        catch (Exception exception) {
            logger.error((Object)("=====bad sql in list:table:" + table + "====sql:" + where));
            logger.error((Object)("=====dbService.err:dbService.list:" + dbName + table + ":" + where + ":" + JSON.toJSONString((Object)paras)));
            throw this.logException(exception);
        }
    }

    public Map<String, Object>[] multiGet(String dbName, String table, List<Object> paraList) throws Exception {
        Object[] pks = paraList.toArray(new Object[0]);
        return this.multiGet(dbName, table, pks);
    }

    @Override
    public Map<String, Object>[] multiGet(String dbName, String table, Object[] pks) throws Exception {
        return this.multiGet(dbName, table, pks, null);
    }

    @Override
    public Map<String, Object>[] listByOneField(String dbName, String table, String field, Object[] values) throws Exception {
        return this.listIn(dbName, table, field, values);
    }

    public Map<String, Object>[] multiGet(String dbName, String table, Object[] pks, String ak) throws Exception {
        CommandGetMulti command;
        Map<String, Object>[] all;
        dbName = dbName == null ? this.config.getDefaultDbName() : dbName;
        LinkedList<Object> queue = null;
        LinkedList<JSONObject> queue2 = new LinkedList<JSONObject>();
        if (this.redissonClient != null && this.getRedisKey() != null) {
            queue = new LinkedList<Object>();
            String rs = null;
            HashSet<String> set = new HashSet<String>();
            for (Object pk : pks) {
                set.add(pk.toString());
            }
            RMap rmap = this.redissonClient.getMap(RedisUtil.redisMapKey(this.getRedisKey(), dbName, table));
            Map response = (Map)rmap.getAllAsync(set).get();
            Object[] objectArray = pks;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object pk = objectArray[i];
                rs = (String)response.get(pk.toString());
                if (rs != null) {
                    queue2.add(JSON.parseObject((String)rs));
                    continue;
                }
                queue.add(pk);
            }
            if (queue.size() == 0) {
                return queue2.toArray(new Map[0]);
            }
            pks = queue.toArray(new Object[0]);
        }
        if ((all = (command = this.createCommand(CommandGetMulti.class, dbName, table, this.config)).exec(pks, ak)).length == 0) {
            return queue2.toArray(new Map[0]);
        }
        if (queue != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map<String, Object> m : all) {
                map.put(m.get(this.config.getPrimaryKey()).toString(), JSON.toJSONString(m));
            }
            this.redissonClient.getMap(RedisUtil.redisMapKey(this.getRedisKey(), dbName, table)).putAllAsync(map);
        }
        Map[] result = new Map[all.length + queue2.size()];
        System.arraycopy(all, 0, result, 0, all.length);
        System.arraycopy(queue2.toArray(new Map[0]), 0, result, all.length, queue2.size());
        return result;
    }

    public Map<String, Object> batchSave(String dbName, List<Map<String, Object>> paraList, String tempPkTag) throws Exception {
        return this.batchSave(dbName, paraList, tempPkTag, null);
    }

    public Map<String, Object> batchSave(String dbName, List<Map<String, Object>> paraList, String tempPkTag, String table) throws Exception {
        return this.batchSave(dbName, paraList, tempPkTag, table, null);
    }

    public Map<String, Object> batchSave(String dbName, List<Map<String, Object>> paraList, String tempPkTag, String table, String ak) throws Exception {
        Map[] models = paraList.toArray(new Map[0]);
        return this.batchSave(dbName, models, tempPkTag, table, ak);
    }

    public Map<String, Object> batchSave(String dbName, Map<String, Object>[] models, String tempPkTag) throws Exception {
        return this.batchSave(dbName, models, tempPkTag, null);
    }

    public Map<String, Object> batchSave(String dbName, Map<String, Object>[] models, String tempPkTag, String table) throws Exception {
        return this.batchSave(dbName, models, tempPkTag, table, null);
    }

    public Map<String, Object> batchSave(String dbName, Map<String, Object>[] models, String tempPkTag, String table, String ak) throws Exception {
        String string = dbName = dbName == null ? this.config.getDefaultDbName() : dbName;
        if (table != null) {
            for (Map<String, Object> o : models) {
                o.put(this.config.getTableNameTag(), table);
            }
        }
        CommandBatchSave command = this.createCommand(CommandBatchSave.class, dbName, table, this.config);
        Map<String, Object> rr = command.exec(models, tempPkTag, ak);
        if (this.getRedisKey() != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map r : (Map[])rr.get("list")) {
                map.put(r.get(this.config.getPrimaryKey()).toString(), JSON.toJSONString((Object)r));
            }
            this.redissonClient.getMap(RedisUtil.redisMapKey(this.getRedisKey(), dbName, table)).putAllAsync(map);
        }
        return rr;
    }

    public Integer delete(String dbName, String table, Object pk) throws Exception {
        CommandDelete command = this.createCommand(CommandDelete.class, dbName, table, this.config);
        try {
            this.deleteFromCache(dbName, table, pk);
            return command.exec(pk);
        }
        catch (Exception exception) {
            logger.error((Object)("dbService.err:dbService.delete:" + dbName + ":" + table + ":" + pk));
            throw this.logException(exception);
        }
    }

    public Integer multiDelete(String dbName, String table, List<Object> paras) throws Exception {
        Object[] pks = paras.toArray(new Object[0]);
        return this.multiDelete(dbName, table, pks);
    }

    public Integer multiDelete(String dbName, String table, Object[] pks) throws Exception {
        CommandDeleteMulti command = this.createCommand(CommandDeleteMulti.class, dbName, table, this.config);
        if (this.getRedisKey() != null) {
            for (Object pk : pks) {
                this.deleteFromCache(dbName, table, pk);
            }
        }
        return command.exec(pks);
    }

    public Integer queryDelete(String dbName, String table, String where, List<Object> paraList) throws Exception {
        Object[] paras = paraList.toArray(new Object[0]);
        return this.queryDelete(dbName, table, where, paras);
    }

    public Integer queryDelete(String dbName, String table, String where, Object[] paras) throws Exception {
        CommandDeleteQuery command = this.createCommand(CommandDeleteQuery.class, dbName, table, this.config);
        try {
            if (this.getRedisKey() != null) {
                // empty if block
            }
            Integer n = command.exec(where, paras);
            return n;
        }
        catch (Exception exception) {
            logger.error((Object)("dbService.err:dbService.queryDelete:" + dbName + ":" + table + ":" + where + ":" + StringUtils.join((Object[])paras, (String)",")));
            throw this.logException(exception);
        }
    }

    public Integer count(String dbName, String table, String where, List<Object> paraList) throws Exception {
        Object[] paras = paraList.toArray(new Object[0]);
        return this.count(dbName, table, where, paras);
    }

    public Integer count(String dbName, String table, String where, Object[] paras) throws Exception {
        CommandCount command = this.createCommand(CommandCount.class, dbName, table, this.config);
        try {
            return command.exec(where, paras);
        }
        catch (Exception exception) {
            logger.error((Object)("dbService.err:dbService.count:" + dbName + ":" + table + ":" + where + ":" + JSON.toJSONString((Object)paras)));
            throw this.logException(exception);
        }
    }

    public Map<String, Object>[] exec(String dbName, String sql, List<Object> paras) throws Exception {
        return this.exec(dbName, sql, paras != null ? paras.toArray(new Object[0]) : null);
    }

    public Map<String, Object>[] exec(String dbName, String sql, Object[] paras) throws Exception {
        paras = paras == null ? new Object[]{} : paras;
        CommandExec command = this.createCommand(CommandExec.class, dbName, null, this.config);
        try {
            return command.exec(sql, paras);
        }
        catch (Exception exception) {
            logger.error((Object)("dbService.err:dbService.exec:" + dbName + ":" + sql + ":" + JSON.toJSONString((Object)paras)));
            throw this.logException(exception);
        }
    }

    public Map<String, Object>[] batchUpdate(String dbName, String[] sqls) throws Exception {
        CommandExecBatchUpate command = this.createCommand(CommandExecBatchUpate.class, dbName, null, this.config);
        try {
            command.exec(sqls);
            return new Map[0];
        }
        catch (Exception exception) {
            throw this.logException(exception);
        }
    }

    public Map<String, Object>[] batchUpdate(String dbName, String sql, List<Object[]> where) throws Exception {
        CommandExecBatchUpate command = this.createCommand(CommandExecBatchUpate.class, dbName, null, this.config);
        try {
            command.exec(sql, where);
            return new Map[0];
        }
        catch (Exception exception) {
            throw this.logException(exception);
        }
    }

    public Map<String, Object> toOne(String dbName, Map<String, Object> one, Map<String, String> mapping) throws Exception {
        return this.toOne(dbName, one, mapping, null);
    }

    public Map<String, Object> toOne(String dbName, Map<String, Object> one, Map<String, String> mapping, String ak) throws Exception {
        return this.toOne(dbName, new Map[]{one}, mapping, ak)[0];
    }

    public Map<String, Object>[] toOne(String dbName, List<Object> models, Map<String, String> mapping) throws Exception {
        return this.toOne(dbName, models, mapping, null);
    }

    public Map<String, Object>[] toOne(String dbName, List<Object> models, Map<String, String> mapping, String ak) throws Exception {
        Map[] paras = models.toArray(new Map[0]);
        return this.toOne(dbName, paras, mapping, ak);
    }

    public Map<String, Object>[] toOne(String dbName, Map<String, Object>[] models, Map<String, String> mapping, String ak) throws Exception {
        return DbUtil.toOne(dbName, models, mapping, this.config.getPrimaryKey(), this);
    }

    public Map<String, Object> toMany(String dbName, Map<String, Object> one, Map<String, String> mapping) throws Exception {
        return this.toMany(dbName, new Map[]{one}, mapping)[0];
    }

    public Map<String, Object>[] toMany(String dbName, List<Object> models, Map<String, String> mapping, Map<String, Object> values) throws Exception {
        Map[] paras = models.toArray(new Map[0]);
        return this.toMany(dbName, paras, mapping, values);
    }

    public Map<String, Object>[] toMany(String dbName, Map<String, Object>[] models, Map<String, String> mapping, Map<String, Object> values) throws Exception {
        HashMap pks = new HashMap();
        Object pk = null;
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            String[] stringArray = entry.getValue().split(":");
            String key = stringArray[0] + ":" + stringArray[2] + ":" + stringArray[3] + ":" + (String)entry.getKey();
            if (!pks.containsKey(key)) {
                pks.put(key, new HashSet());
            }
            Set pkDic = (Set)pks.get(key);
            for (Map<String, Object> m : models) {
                pk = m.get(entry.getKey());
                if (pk == null) continue;
                pkDic.add(pk);
            }
        }
        HashMap query = new HashMap();
        for (Map.Entry entry : pks.entrySet()) {
            Map<String, Object>[] list;
            String[] tempArr = ((String)entry.getKey()).split(":");
            String table = tempArr[0];
            String field = tempArr[1];
            String where = tempArr[2];
            String valueKey = tempArr[3];
            Object[] allId = ((Set)entry.getValue()).toArray(new Object[0]);
            if (!query.containsKey(table)) {
                query.put(table, new HashMap());
            }
            if (!((Map)query.get(table)).containsKey(field)) {
                ((Map)query.get(table)).put(field, new HashMap());
            }
            Map dic = (Map)query.get(table);
            for (Map<String, Object> m : list = this.listIn(dbName, table, field, allId, where, ((List)values.get(valueKey)).toArray(new Object[0]))) {
                if (!((Map)dic.get(field)).containsKey(m.get(field))) {
                    ((Map)dic.get(field)).put(m.get(field), new LinkedList());
                }
                ((Queue)((Map)dic.get(field)).get(m.get(field))).add(m);
            }
        }
        Queue toOneModels = null;
        for (Map<String, Object> m : models) {
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                String field;
                String[] tempArr = entry.getValue().split(":");
                String table = tempArr[0];
                String string = field = tempArr.length == 3 ? tempArr[2] : this.config.getPrimaryKey();
                pk = m.get(entry.getKey());
                if (pk == null || (toOneModels = (Queue)((Map)((Map)query.get(table)).get(field)).get(pk)) == null) continue;
                LinkedList copy = new LinkedList();
                for (Map model : toOneModels) {
                    HashMap copyModel = new HashMap();
                    copyModel.putAll(model);
                    copy.add(copyModel);
                }
                m.put(tempArr[1], copy.toArray(new Map[0]));
            }
        }
        return models;
    }

    public Map<String, Object>[] toMany(String dbName, Map<String, Object>[] models, Map<String, String> mapping) throws Exception {
        return DbUtil.toMany(dbName, models, mapping, this.config.getPrimaryKey(), this);
    }

    public Map<String, Object>[] listBy(String dbName, String table, String field, Object v) throws Exception {
        return this.listBy(dbName, table, field, v, null, null, null);
    }

    public Map<String, Object>[] listBy(String dbName, String table, String field, Object v, String order) throws Exception {
        return this.listBy(dbName, table, field, v, order, null, null);
    }

    public Map<String, Object>[] listBy(String dbName, String table, String field, Object v, String order, Integer perPage, Integer page) throws Exception {
        return this.listBy(dbName, table, new String[]{field}, new Object[]{v}, order, perPage, page);
    }

    public Map<String, Object>[] listBy(String dbName, String table, String[] fields, Object[] v) throws Exception {
        return this.listBy(dbName, table, fields, v, null, null, null);
    }

    public Map<String, Object>[] listBy(String dbName, String table, String[] fields, Object[] v, String order) throws Exception {
        return this.listBy(dbName, table, fields, v, order, null, null);
    }

    public Map<String, Object>[] listBy(String dbName, String table, String[] fields, Object[] v, String order, Integer perPage, Integer page) throws Exception {
        LinkedList<Object> paras = new LinkedList<Object>();
        for (Object vv : v) {
            paras.add(vv);
        }
        String where = "";
        for (String field : fields) {
            where = where + " and " + field + "=?";
        }
        where = where + (order == null ? "" : " " + order);
        if (perPage != null && page != null) {
            where = " limit ?,?";
            if (page < 0) {
                paras.add(perPage);
                paras.add(-1);
            } else {
                paras.add(perPage * (page - 1));
                paras.add(perPage);
            }
        }
        return this.list(dbName, table, where, paras.toArray(new Object[0]));
    }

    public Map<String, Object>[] listIn(String dbName, String table, String field, Object[] values, String where, Object[] whereValues) throws Exception {
        Object[] arr = new String[values.length];
        Arrays.fill(arr, "?");
        where = " and " + field + " in(" + StringUtils.join((Object[])arr, (char)',') + ") " + where;
        return this.list(dbName, table, where, ArrayUtils.addAll((Object[])values, (Object[])whereValues));
    }

    public Map<String, Object>[] listIn(String dbName, String table, String field, List<Object> values) throws Exception {
        return this.listIn(dbName, table, field, values.toArray(new Object[0]));
    }

    public Map<String, Object>[] listIn(String dbName, String table, String field, Object[] values) throws Exception {
        if (values.length == 0 || field.equals("")) {
            return new Map[0];
        }
        Object[] arr = new String[values.length];
        Arrays.fill(arr, "?");
        String where = " and " + field + " in(" + StringUtils.join((Object[])arr, (char)',') + ")";
        return this.list(dbName, table, where, values);
    }

    public Map<String, Object>[] toMany(String dbName, List<Object> models, Map<String, String> mapping) throws Exception {
        Map[] paras = models.toArray(new Map[0]);
        return this.toMany(dbName, paras, mapping);
    }

    public String getServiceVersion() {
        long t1 = System.currentTimeMillis();
        Map<String, Object> map = null;
        try {
            map = this.getFromCache(this.config.getDefaultDbName(), "tbl_user", 2333);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long t2 = System.currentTimeMillis();
        logger.info((Object)("===getServiceVersion===|" + (t2 - t1) + "|" + t1 + "|" + t2 + "|" + (map == null)));
        return map != null ? JSON.toJSONString(map) : this.serviceVersion;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public static void main(String[] args) {
        System.out.println("\u674e\u6587\u5b87");
    }
}

