/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.service.db.service.metadata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.dragonli.service.db.service.DBConfig;
import org.dragonli.service.db.service.metadata.TableStructure;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;

public class DBhandler {
    public static Logger logger = Logger.getLogger(DBhandler.class);
    protected static final ConcurrentMap<String, DBhandler> handlerPools = new ConcurrentHashMap<String, DBhandler>();
    protected volatile ConcurrentMap<String, TableStructure> tableStructures = new ConcurrentHashMap<String, TableStructure>();
    private AtomicBoolean initFlag = new AtomicBoolean(false);
    private volatile int updateVersion = -1;
    private JdbcTemplate jdbcTemplate;
    private String dbName;
    private DBConfig config;

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public static DBhandler getInstanceof(String dbName, DBConfig config) {
        DBhandler handler = (DBhandler)handlerPools.get(dbName = dbName == null ? config.getDefaultDbName() : dbName);
        if (handler == null) {
            try {
                handlerPools.putIfAbsent(dbName, new DBhandler());
                handler = (DBhandler)handlerPools.get(dbName);
                handler.init(dbName, config);
            }
            catch (Exception e) {
                handlerPools.remove(dbName);
                return null;
            }
        }
        handler.init(dbName, config);
        return handler;
    }

    public static String[] allDb() {
        return handlerPools.keySet().toArray(new String[0]);
    }

    public static DBhandler[] allHandlers() {
        return handlerPools.values().toArray(new DBhandler[0]);
    }

    public String getDbName() {
        return this.dbName;
    }

    public DBConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String dbName, DBConfig config) {
        if (this.initFlag.get()) {
            return;
        }
        this.dbName = dbName == null ? config.getDefaultDbName() : dbName;
        this.config = config;
        DBhandler dBhandler = this;
        synchronized (dBhandler) {
            if (this.initFlag.get()) {
                return;
            }
            try {
                this.jdbcTemplate = new JdbcTemplate();
                this.jdbcTemplate.setDataSource(config.getDbinfos().get(dbName));
                this.initTables();
                this.checkUpdate(true);
            }
            catch (Exception e) {
                logger.error((Object)"dbhandler init error:", (Throwable)e);
            }
            this.initFlag.set(true);
        }
    }

    public TableStructure findTableStructure(String name) {
        return (TableStructure)this.tableStructures.get(name);
    }

    public void checkUpdate() {
        this.checkUpdate(false);
    }

    public void checkUpdate(boolean first) {
        if (this.config.getAutoUpdateTableName() == null) {
            return;
        }
        if (!first && !this.initFlag.get()) {
            return;
        }
        int n = 0;
        int[] values = (int[])this.jdbcTemplate.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                String sql = "select * from " + DBhandler.this.config.getAutoUpdateTableName();
                PreparedStatement ps = connection.prepareStatement(sql, 2);
                return ps;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<int[]>(){

            public int[] doInPreparedStatement(PreparedStatement pstmt) throws SQLException, DataAccessException {
                pstmt.execute();
                ResultSet rs = pstmt.getResultSet();
                if (rs.next()) {
                    return new int[]{rs.getInt(1)};
                }
                return new int[0];
            }
        });
        int[] nArray = values;
        int n2 = nArray.length;
        if (n < n2) {
            int v = nArray[n];
            if (first) {
                this.updateVersion = v;
                return;
            }
            if (this.updateVersion == v) {
                return;
            }
            logger.info((Object)(this.dbName + " \u6570\u636e\u5e93\u8868\u7ed3\u6784\u66f4\u65b0: oldVersion-" + this.updateVersion + " newVersion:" + v));
            this.updateVersion = v;
            this.initTables();
            return;
        }
    }

    public void initTables() {
        Queue names = (Queue)this.jdbcTemplate.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                String sql = "show tables ";
                PreparedStatement ps = connection.prepareStatement(sql, 2);
                return ps;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<Queue<String>>(){

            public Queue<String> doInPreparedStatement(PreparedStatement pstmt) throws SQLException, DataAccessException {
                pstmt.execute();
                ResultSet rs = pstmt.getResultSet();
                LinkedList<String> queue = new LinkedList<String>();
                while (rs.next()) {
                    queue.add(rs.getString(1));
                }
                return queue;
            }
        });
        ConcurrentHashMap<String, TableStructure> ts = new ConcurrentHashMap<String, TableStructure>();
        for (String name : names) {
            TableStructure t = new TableStructure(name, this.config);
            t.init(this.jdbcTemplate);
            ts.put(name, t);
            logger.info((Object)(this.dbName + " \u6570\u636e\u5e93\u8868\u7ed3\u6784\u66f4\u65b0-tableNmae:" + name));
        }
        this.tableStructures = ts;
    }
}

