/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.service.db.service.command;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.dragonli.service.db.service.DBConfig;
import org.dragonli.service.db.service.command.CommandResult;
import org.dragonli.service.db.service.command.ICommand;
import org.dragonli.service.db.service.metadata.DBhandler;
import org.dragonli.service.db.service.metadata.TableStructure;
import org.dragonli.tools.general.DataCachePool;
import org.dragonli.tools.general.IDataCachePool;

public abstract class CommandBase
implements ICommand,
IDataCachePool {
    protected DBhandler handler;
    protected TableStructure ts;
    protected String table;
    protected String dbName;
    protected DBConfig config;
    protected CommandResult r;
    protected final boolean autoBack = true;
    protected final ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
    protected long startTime = 0L;
    protected long endTime = 0L;
    protected String ak = null;
    protected int insertCount = 0;
    protected int updateCount = 0;
    protected int readCount = 0;
    protected int writeCount = 0;
    protected int totalnum = 0;
    public static Logger logger = Logger.getLogger(CommandBase.class);

    @Override
    public void init(String dbName, String table, DBConfig config) throws Exception {
        this.dbName = dbName = dbName == null ? config.getDefaultDbName() : dbName;
        this.table = table;
        this.config = config;
        this.r = (CommandResult)DataCachePool.get(CommandResult.class);
        if (!this.checkDbAndTable(this.r, dbName, config, table)) {
            this.backToPool(true, true);
            throw new Exception("db or table is err");
        }
    }

    @Override
    public CommandResult execute(String dbName, DBConfig config, Map<String, Object> para) throws Exception {
        return null;
    }

    @Override
    public CommandResult execute(String dbName, DBConfig config, Map<String, Object> para, boolean autoBack) throws Exception {
        return null;
    }

    protected boolean checkDb(CommandResult r, String dbName, DBConfig config) {
        return this.checkDb(r, dbName, config, null);
    }

    protected boolean checkDb(CommandResult r, String dbName, DBConfig config, Map<String, Object> para) {
        this.handler = DBhandler.getInstanceof(dbName, config);
        if (this.handler == null) {
            r.addNotExsitDb(dbName);
            return false;
        }
        return true;
    }

    protected boolean checkTable(CommandResult r, String dbName, DBConfig config, Map<String, Object> para) {
        String table = (String)para.get(config.getTableNameTag());
        return this.checkTable(r, dbName, config, table);
    }

    protected boolean checkTable(CommandResult r, String dbName, DBConfig config, String table) {
        if (!this.autoCheckTable()) {
            return true;
        }
        if (table == null || (table = table.trim()).equals("")) {
            r.addOtherErrMsg("table cant be null or empty!");
            return false;
        }
        this.ts = this.handler.findTableStructure(table);
        if (this.ts == null) {
            r.addNotExsitTable(table);
            return false;
        }
        return true;
    }

    protected boolean checkDbAndTable(CommandResult r, String dbName, DBConfig config, String table) {
        if (!this.checkDb(r, dbName, config)) {
            return false;
        }
        return this.checkTable(r, dbName, config, table);
    }

    protected boolean autoCheckTable() {
        return true;
    }

    protected boolean checkDbAndTable(CommandResult r, String dbName, DBConfig config, Map<String, Object> para) {
        if (!this.checkDb(r, dbName, config, para)) {
            return false;
        }
        return this.checkTable(r, dbName, config, para);
    }

    public void backToPool(boolean autoBack) {
        this.backToPool(autoBack, false);
    }

    public void backToPool(boolean autoBack, boolean autoClearResult) {
        this.clear();
        if (autoBack) {
            DataCachePool.back((Object)this);
        }
        if (autoClearResult && this.r != null) {
            this.r.clear();
            DataCachePool.back((Object)this.r);
        }
    }

    public void writeToDbInvokeLogger(long startTime, long endTime, String ak, int readCount, int updateCount, int insertCount) {
    }

    public void clear() {
        this.handler = null;
        this.ts = null;
        this.dbName = null;
        this.table = null;
        this.config = null;
        this.r = null;
    }
}

