/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.service.db.service.command;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import org.dragonli.tools.general.IDataCachePool;

public class CommandResult
implements IDataCachePool {
    public static final int SUCCESS = 0;
    public static final int ERR = 1;
    private int state;
    private final Queue<String> notExsitDb = new LinkedList<String>();
    private Queue<String> notExsitTable = new LinkedList<String>();
    private Queue<String> versionOldMsg = new LinkedList<String>();
    private Queue<String> otherErrMsg = new LinkedList<String>();
    private Object result;

    public void clear() {
        this.state = 0;
        this.result = null;
        this.notExsitDb.clear();
        this.notExsitTable.clear();
        this.versionOldMsg.clear();
        this.otherErrMsg.clear();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void addNotExsitDb(String msg) {
        this.state = 1;
        this.notExsitDb.add(msg);
    }

    public void addNotExsitTable(String msg) {
        this.state = 1;
        this.notExsitTable.add(msg);
    }

    public void addNotversionOldMsg(String table, int id) {
        this.state = 1;
        this.versionOldMsg.add(table + "#" + id);
    }

    public void addOtherErrMsg(String msg) {
        this.state = 1;
        this.otherErrMsg.add(msg);
    }

    public String getErrMsg() {
        if (this.state == 0) {
            return null;
        }
        String msg = "";
        if (this.notExsitDb.size() != 0) {
            msg = msg + "[some database not exsit:" + String.join((CharSequence)",", this.notExsitDb) + "];";
        }
        if (this.notExsitTable.size() != 0) {
            msg = msg + "[some table not exsit:" + String.join((CharSequence)",", this.notExsitTable) + "];";
        }
        if (this.versionOldMsg.size() != 0) {
            msg = msg + "[some record`s version is old:" + String.join((CharSequence)",", this.versionOldMsg) + "];";
        }
        if (this.otherErrMsg.size() != 0) {
            msg = msg + "[other err:" + String.join((CharSequence)",", this.otherErrMsg) + "];";
        }
        return msg;
    }

    public String toJSON() {
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("state", this.state);
        if (this.state == 1) {
            r.put("errMsg", this.getErrMsg());
        }
        if (this.result != null) {
            r.put("result", this.result);
        }
        return JSON.toJSONString(r);
    }
}

