/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.service.db.service.executor;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.dragonli.service.db.service.executor.IExcutor;
import org.dragonli.service.db.service.metadata.TableStructure;
import org.dragonli.tools.general.IDataCachePool;
import org.dragonli.tools.general.StringUtil;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class ExcutorBase<E, R>
implements IExcutor<E, R>,
IDataCachePool {
    protected JdbcTemplate jdbcTemplate;
    protected TableStructure table;
    protected R result;
    protected E para;

    protected void setDefaultValue(PreparedStatement ps, int indexKey, int indexValue) throws SQLException {
        if (this.table.getColsNullAble()[indexValue]) {
            ps.setObject(indexKey, null);
            return;
        }
        Object v = TableStructure.defaultVales.get(this.table.getColsType()[indexValue]);
        if (v instanceof Time) {
            v = new Time(System.currentTimeMillis());
        } else if (v instanceof Timestamp) {
            v = new Timestamp(System.currentTimeMillis());
        } else if (v instanceof Date) {
            v = new Date(System.currentTimeMillis());
        }
        ps.setObject(indexKey, v);
    }

    @Override
    public void init(JdbcTemplate jdbcTemplate, TableStructure table, E para) {
        this.init(jdbcTemplate, table, para, true);
    }

    @Override
    public void init(JdbcTemplate jdbcTemplate, TableStructure table, E para, boolean auto) {
        this.jdbcTemplate = jdbcTemplate;
        this.table = table;
        this.para = para;
        if (auto) {
            this.execute();
        }
    }

    public void execute() {
    }

    @Override
    public R result() {
        return this.result;
    }

    protected void formatObject(Map<String, Object> map) {
        if (map.get(this.table.getConfig().getTableNameTag()) == null) {
            map.put(this.table.getConfig().getTableNameTag(), this.table.getTableName());
        }
        if (map.get(this.table.getConfig().getVersionKey()) == null) {
            map.put(this.table.getConfig().getVersionKey(), this.table.findOptimisticLock(map.get(this.table.getConfig().getPrimaryKey())).get());
        }
    }

    protected Map<String, Object>[] listIn(Object[] arr0) {
        Object[] qms = new String[arr0.length];
        Arrays.fill(qms, "?");
        String sql = StringUtil.substitute((String)this.table.getSelectManySql(), (Object[])new Object[]{String.join((CharSequence)",", Arrays.asList(qms))});
        List sources = this.jdbcTemplate.queryForList(sql, arr0);
        return sources.toArray(new Map[0]);
    }

    @Override
    public void clear() {
        this.jdbcTemplate = null;
        this.table = null;
        this.result = null;
        this.para = null;
    }
}

